/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFlowLogsIntegrationTemplateRequest extends Ec2Request implements
        ToCopyableBuilder<GetFlowLogsIntegrationTemplateRequest.Builder, GetFlowLogsIntegrationTemplateRequest> {
    private static final SdkField<String> FLOW_LOG_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FlowLogId")
            .getter(getter(GetFlowLogsIntegrationTemplateRequest::flowLogId))
            .setter(setter(Builder::flowLogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogId")
                    .unmarshallLocationName("FlowLogId").build()).build();

    private static final SdkField<String> CONFIG_DELIVERY_S3_DESTINATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigDeliveryS3DestinationArn")
            .getter(getter(GetFlowLogsIntegrationTemplateRequest::configDeliveryS3DestinationArn))
            .setter(setter(Builder::configDeliveryS3DestinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigDeliveryS3DestinationArn")
                    .unmarshallLocationName("ConfigDeliveryS3DestinationArn").build()).build();

    private static final SdkField<IntegrateServices> INTEGRATE_SERVICES_FIELD = SdkField
            .<IntegrateServices> builder(MarshallingType.SDK_POJO)
            .memberName("IntegrateServices")
            .getter(getter(GetFlowLogsIntegrationTemplateRequest::integrateServices))
            .setter(setter(Builder::integrateServices))
            .constructor(IntegrateServices::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrateService")
                    .unmarshallLocationName("IntegrateService").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_LOG_ID_FIELD,
            CONFIG_DELIVERY_S3_DESTINATION_ARN_FIELD, INTEGRATE_SERVICES_FIELD));

    private final String flowLogId;

    private final String configDeliveryS3DestinationArn;

    private final IntegrateServices integrateServices;

    private GetFlowLogsIntegrationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.flowLogId = builder.flowLogId;
        this.configDeliveryS3DestinationArn = builder.configDeliveryS3DestinationArn;
        this.integrateServices = builder.integrateServices;
    }

    /**
     * <p>
     * The ID of the flow log.
     * </p>
     * 
     * @return The ID of the flow log.
     */
    public final String flowLogId() {
        return flowLogId;
    }

    /**
     * <p>
     * To store the CloudFormation template in Amazon S3, specify the location in Amazon S3.
     * </p>
     * 
     * @return To store the CloudFormation template in Amazon S3, specify the location in Amazon S3.
     */
    public final String configDeliveryS3DestinationArn() {
        return configDeliveryS3DestinationArn;
    }

    /**
     * <p>
     * Information about the service integration.
     * </p>
     * 
     * @return Information about the service integration.
     */
    public final IntegrateServices integrateServices() {
        return integrateServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowLogId());
        hashCode = 31 * hashCode + Objects.hashCode(configDeliveryS3DestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(integrateServices());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFlowLogsIntegrationTemplateRequest)) {
            return false;
        }
        GetFlowLogsIntegrationTemplateRequest other = (GetFlowLogsIntegrationTemplateRequest) obj;
        return Objects.equals(flowLogId(), other.flowLogId())
                && Objects.equals(configDeliveryS3DestinationArn(), other.configDeliveryS3DestinationArn())
                && Objects.equals(integrateServices(), other.integrateServices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFlowLogsIntegrationTemplateRequest").add("FlowLogId", flowLogId())
                .add("ConfigDeliveryS3DestinationArn", configDeliveryS3DestinationArn())
                .add("IntegrateServices", integrateServices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowLogId":
            return Optional.ofNullable(clazz.cast(flowLogId()));
        case "ConfigDeliveryS3DestinationArn":
            return Optional.ofNullable(clazz.cast(configDeliveryS3DestinationArn()));
        case "IntegrateServices":
            return Optional.ofNullable(clazz.cast(integrateServices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFlowLogsIntegrationTemplateRequest, T> g) {
        return obj -> g.apply((GetFlowLogsIntegrationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetFlowLogsIntegrationTemplateRequest> {
        /**
         * <p>
         * The ID of the flow log.
         * </p>
         * 
         * @param flowLogId
         *        The ID of the flow log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogId(String flowLogId);

        /**
         * <p>
         * To store the CloudFormation template in Amazon S3, specify the location in Amazon S3.
         * </p>
         * 
         * @param configDeliveryS3DestinationArn
         *        To store the CloudFormation template in Amazon S3, specify the location in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configDeliveryS3DestinationArn(String configDeliveryS3DestinationArn);

        /**
         * <p>
         * Information about the service integration.
         * </p>
         * 
         * @param integrateServices
         *        Information about the service integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrateServices(IntegrateServices integrateServices);

        /**
         * <p>
         * Information about the service integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntegrateServices.Builder} avoiding the
         * need to create one manually via {@link IntegrateServices#builder()}.
         *
         * When the {@link Consumer} completes, {@link IntegrateServices.Builder#build()} is called immediately and its
         * result is passed to {@link #integrateServices(IntegrateServices)}.
         * 
         * @param integrateServices
         *        a consumer that will call methods on {@link IntegrateServices.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrateServices(IntegrateServices)
         */
        default Builder integrateServices(Consumer<IntegrateServices.Builder> integrateServices) {
            return integrateServices(IntegrateServices.builder().applyMutation(integrateServices).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String flowLogId;

        private String configDeliveryS3DestinationArn;

        private IntegrateServices integrateServices;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFlowLogsIntegrationTemplateRequest model) {
            super(model);
            flowLogId(model.flowLogId);
            configDeliveryS3DestinationArn(model.configDeliveryS3DestinationArn);
            integrateServices(model.integrateServices);
        }

        public final String getFlowLogId() {
            return flowLogId;
        }

        public final void setFlowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
        }

        @Override
        public final Builder flowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
            return this;
        }

        public final String getConfigDeliveryS3DestinationArn() {
            return configDeliveryS3DestinationArn;
        }

        public final void setConfigDeliveryS3DestinationArn(String configDeliveryS3DestinationArn) {
            this.configDeliveryS3DestinationArn = configDeliveryS3DestinationArn;
        }

        @Override
        public final Builder configDeliveryS3DestinationArn(String configDeliveryS3DestinationArn) {
            this.configDeliveryS3DestinationArn = configDeliveryS3DestinationArn;
            return this;
        }

        public final IntegrateServices.Builder getIntegrateServices() {
            return integrateServices != null ? integrateServices.toBuilder() : null;
        }

        public final void setIntegrateServices(IntegrateServices.BuilderImpl integrateServices) {
            this.integrateServices = integrateServices != null ? integrateServices.build() : null;
        }

        @Override
        public final Builder integrateServices(IntegrateServices integrateServices) {
            this.integrateServices = integrateServices;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFlowLogsIntegrationTemplateRequest build() {
            return new GetFlowLogsIntegrationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
