/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatus;

public class DescribeMovingAddressesIterable
implements SdkIterable<DescribeMovingAddressesResponse> {
    private final Ec2Client client;
    private final DescribeMovingAddressesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMovingAddressesIterable(Ec2Client client, DescribeMovingAddressesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeMovingAddressesResponseFetcher();
    }

    public Iterator<DescribeMovingAddressesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MovingAddressStatus> movingAddressStatuses() {
        Function<DescribeMovingAddressesResponse, Iterator> getIterator = response -> {
            if (response != null && response.movingAddressStatuses() != null) {
                return response.movingAddressStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMovingAddressesResponseFetcher
    implements SyncPageFetcher<DescribeMovingAddressesResponse> {
        private DescribeMovingAddressesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMovingAddressesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMovingAddressesResponse nextPage(DescribeMovingAddressesResponse previousPage) {
            if (previousPage == null) {
                return DescribeMovingAddressesIterable.this.client.describeMovingAddresses(DescribeMovingAddressesIterable.this.firstRequest);
            }
            return DescribeMovingAddressesIterable.this.client.describeMovingAddresses((DescribeMovingAddressesRequest)((Object)DescribeMovingAddressesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

