/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeImagesRequest.Builder, DescribeImagesRequest> {
    private static final SdkField<List<String>> EXECUTABLE_USERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExecutableUsers")
            .getter(getter(DescribeImagesRequest::executableUsers))
            .setter(setter(Builder::executableUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutableBy")
                    .unmarshallLocationName("ExecutableBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ExecutableBy")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ExecutableBy").unmarshallLocationName("ExecutableBy").build())
                                            .build()).build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeImagesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> IMAGE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImageIds")
            .getter(getter(DescribeImagesRequest::imageIds))
            .setter(setter(Builder::imageIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ImageId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ImageId").unmarshallLocationName("ImageId").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> OWNERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Owners")
            .getter(getter(DescribeImagesRequest::owners))
            .setter(setter(Builder::owners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Owner")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Owner").unmarshallLocationName("Owner").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> INCLUDE_DEPRECATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeDeprecated")
            .getter(getter(DescribeImagesRequest::includeDeprecated))
            .setter(setter(Builder::includeDeprecated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDeprecated")
                    .unmarshallLocationName("IncludeDeprecated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTABLE_USERS_FIELD,
            FILTERS_FIELD, IMAGE_IDS_FIELD, OWNERS_FIELD, INCLUDE_DEPRECATED_FIELD));

    private final List<String> executableUsers;

    private final List<Filter> filters;

    private final List<String> imageIds;

    private final List<String> owners;

    private final Boolean includeDeprecated;

    private DescribeImagesRequest(BuilderImpl builder) {
        super(builder);
        this.executableUsers = builder.executableUsers;
        this.filters = builder.filters;
        this.imageIds = builder.imageIds;
        this.owners = builder.owners;
        this.includeDeprecated = builder.includeDeprecated;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutableUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutableUsers() {
        return executableUsers != null && !(executableUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Scopes the images by users with explicit launch permissions. Specify an Amazon Web Services account ID,
     * <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify an Amazon Web Services account ID that is not your own, only AMIs shared with that specific Amazon
     * Web Services account ID are returned. However, AMIs that are shared with the account’s organization or
     * organizational unit (OU) are not returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs shared with your account are
     * returned. In addition, AMIs that are shared with the organization or OU of which you are member are also
     * returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>all</code>, all public AMIs are returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutableUsers} method.
     * </p>
     * 
     * @return Scopes the images by users with explicit launch permissions. Specify an Amazon Web Services account ID,
     *         <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify an Amazon Web Services account ID that is not your own, only AMIs shared with that
     *         specific Amazon Web Services account ID are returned. However, AMIs that are shared with the account’s
     *         organization or organizational unit (OU) are not returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs shared with your
     *         account are returned. In addition, AMIs that are shared with the organization or OU of which you are
     *         member are also returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>all</code>, all public AMIs are returned.
     *         </p>
     *         </li>
     */
    public final List<String> executableUsers() {
        return executableUsers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code>
     * ).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon EBS
     * volume is deleted on instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
     * example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (<code>io1</code> |
     * <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>| <code>st1</code> |
     * <code>standard</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume is
     * encrypted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>creation-date</code> - The time when the image was created, in the ISO 8601 format in the UTC time zone
     * (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (
     * <code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>description</code> - The description of the image (provided during image creation).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>image-id</code> - The ID of the image.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>is-public</code> - A Boolean that indicates whether the image is public.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kernel-id</code> - The kernel ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manifest-location</code> - The location of the image manifest.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code> - The name of the AMI (provided during image creation).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The valid
     * aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can be
     * set using the IAM console. We recommend that you use the <b>Owner</b> request parameter instead of this filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
     * <b>Owner</b> request parameter instead of this filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code</code> - The product code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ramdisk-id</code> - The RAM disk ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     * <code>instance-store</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> | <code>failed</code>
     * ).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-code</code> - The reason code for the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-message</code> - The message for the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with the Intel
     * 82599 VF interface is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> |
     *         <code>arm64</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the
     *         Amazon EBS volume is deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
     *         (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (
     *         <code>io1</code> | <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>|
     *         <code>st1</code> | <code>standard</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume is
     *         encrypted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>creation-date</code> - The time when the image was created, in the ISO 8601 format in the UTC time
     *         zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a
     *         wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>description</code> - The description of the image (provided during image creation).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>image-id</code> - The ID of the image.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> |
     *         <code>ramdisk</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>is-public</code> - A Boolean that indicates whether the image is public.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kernel-id</code> - The kernel ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manifest-location</code> - The location of the image manifest.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code> - The name of the AMI (provided during image creation).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The
     *         valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias
     *         that can be set using the IAM console. We recommend that you use the <b>Owner</b> request parameter
     *         instead of this filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
     *         <b>Owner</b> request parameter instead of this filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code</code> - The product code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ramdisk-id</code> - The RAM disk ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-name</code> - The device name of the root device volume (for example,
     *         <code>/dev/sda1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     *         <code>instance-store</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
     *         <code>failed</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-code</code> - The reason code for the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-message</code> - The message for the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with
     *         the Intel 82599 VF interface is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageIds() {
        return imageIds != null && !(imageIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The image IDs.
     * </p>
     * <p>
     * Default: Describes all images available to you.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageIds} method.
     * </p>
     * 
     * @return The image IDs.</p>
     *         <p>
     *         Default: Describes all images available to you.
     */
    public final List<String> imageIds() {
        return imageIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Owners property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOwners() {
        return owners != null && !(owners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Scopes the results to images with the specified owners. You can specify a combination of Amazon Web Services
     * account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you omit this
     * parameter, the results include all images for which you have launch permissions, regardless of ownership.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOwners} method.
     * </p>
     * 
     * @return Scopes the results to images with the specified owners. You can specify a combination of Amazon Web
     *         Services account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you
     *         omit this parameter, the results include all images for which you have launch permissions, regardless of
     *         ownership.
     */
    public final List<String> owners() {
        return owners;
    }

    /**
     * <p>
     * If <code>true</code>, all deprecated AMIs are included in the response. If <code>false</code>, no deprecated AMIs
     * are included in the response. If no value is specified, the default value is <code>false</code>.
     * </p>
     * <note>
     * <p>
     * If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (<code>true</code>
     * or <code>false</code>) that you set for this parameter.
     * </p>
     * </note>
     * 
     * @return If <code>true</code>, all deprecated AMIs are included in the response. If <code>false</code>, no
     *         deprecated AMIs are included in the response. If no value is specified, the default value is
     *         <code>false</code>.</p> <note>
     *         <p>
     *         If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (
     *         <code>true</code> or <code>false</code>) that you set for this parameter.
     *         </p>
     */
    public final Boolean includeDeprecated() {
        return includeDeprecated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutableUsers() ? executableUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImageIds() ? imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOwners() ? owners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeDeprecated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest) obj;
        return hasExecutableUsers() == other.hasExecutableUsers() && Objects.equals(executableUsers(), other.executableUsers())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasImageIds() == other.hasImageIds() && Objects.equals(imageIds(), other.imageIds())
                && hasOwners() == other.hasOwners() && Objects.equals(owners(), other.owners())
                && Objects.equals(includeDeprecated(), other.includeDeprecated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImagesRequest").add("ExecutableUsers", hasExecutableUsers() ? executableUsers() : null)
                .add("Filters", hasFilters() ? filters() : null).add("ImageIds", hasImageIds() ? imageIds() : null)
                .add("Owners", hasOwners() ? owners() : null).add("IncludeDeprecated", includeDeprecated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutableUsers":
            return Optional.ofNullable(clazz.cast(executableUsers()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "ImageIds":
            return Optional.ofNullable(clazz.cast(imageIds()));
        case "Owners":
            return Optional.ofNullable(clazz.cast(owners()));
        case "IncludeDeprecated":
            return Optional.ofNullable(clazz.cast(includeDeprecated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesRequest, T> g) {
        return obj -> g.apply((DescribeImagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImagesRequest> {
        /**
         * <p>
         * Scopes the images by users with explicit launch permissions. Specify an Amazon Web Services account ID,
         * <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify an Amazon Web Services account ID that is not your own, only AMIs shared with that specific
         * Amazon Web Services account ID are returned. However, AMIs that are shared with the account’s organization or
         * organizational unit (OU) are not returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs shared with your account
         * are returned. In addition, AMIs that are shared with the organization or OU of which you are member are also
         * returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>all</code>, all public AMIs are returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param executableUsers
         *        Scopes the images by users with explicit launch permissions. Specify an Amazon Web Services account
         *        ID, <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify an Amazon Web Services account ID that is not your own, only AMIs shared with that
         *        specific Amazon Web Services account ID are returned. However, AMIs that are shared with the account’s
         *        organization or organizational unit (OU) are not returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs shared with your
         *        account are returned. In addition, AMIs that are shared with the organization or OU of which you are
         *        member are also returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>all</code>, all public AMIs are returned.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executableUsers(Collection<String> executableUsers);

        /**
         * <p>
         * Scopes the images by users with explicit launch permissions. Specify an Amazon Web Services account ID,
         * <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify an Amazon Web Services account ID that is not your own, only AMIs shared with that specific
         * Amazon Web Services account ID are returned. However, AMIs that are shared with the account’s organization or
         * organizational unit (OU) are not returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs shared with your account
         * are returned. In addition, AMIs that are shared with the organization or OU of which you are member are also
         * returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>all</code>, all public AMIs are returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param executableUsers
         *        Scopes the images by users with explicit launch permissions. Specify an Amazon Web Services account
         *        ID, <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify an Amazon Web Services account ID that is not your own, only AMIs shared with that
         *        specific Amazon Web Services account ID are returned. However, AMIs that are shared with the account’s
         *        organization or organizational unit (OU) are not returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs shared with your
         *        account are returned. In addition, AMIs that are shared with the organization or OU of which you are
         *        member are also returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>all</code>, all public AMIs are returned.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executableUsers(String... executableUsers);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon
         * EBS volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (<code>io1</code> |
         * <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>| <code>st1</code> |
         * <code>standard</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume is
         * encrypted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creation-date</code> - The time when the image was created, in the ISO 8601 format in the UTC time zone
         * (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (
         * <code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the image (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is-public</code> - A Boolean that indicates whether the image is public.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manifest-location</code> - The location of the image manifest.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AMI (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The valid
         * aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can
         * be set using the IAM console. We recommend that you use the <b>Owner</b> request parameter instead of this
         * filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         * <b>Owner</b> request parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - The message for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with the
         * Intel 82599 VF interface is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> |
         *        <code>arm64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the
         *        Amazon EBS volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
         *        (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (
         *        <code>io1</code> | <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>|
         *        <code>st1</code> | <code>standard</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume
         *        is encrypted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creation-date</code> - The time when the image was created, in the ISO 8601 format in the UTC
         *        time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use
         *        a wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the image (provided during image creation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> |
         *        <code>ramdisk</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>is-public</code> - A Boolean that indicates whether the image is public.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manifest-location</code> - The location of the image manifest.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the AMI (provided during image creation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The
         *        valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account
         *        alias that can be set using the IAM console. We recommend that you use the <b>Owner</b> request
         *        parameter instead of this filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         *        <b>Owner</b> request parameter instead of this filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The device name of the root device volume (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         *        <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - The message for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking
         *        with the Intel 82599 VF interface is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon
         * EBS volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (<code>io1</code> |
         * <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>| <code>st1</code> |
         * <code>standard</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume is
         * encrypted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creation-date</code> - The time when the image was created, in the ISO 8601 format in the UTC time zone
         * (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (
         * <code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the image (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is-public</code> - A Boolean that indicates whether the image is public.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manifest-location</code> - The location of the image manifest.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AMI (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The valid
         * aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can
         * be set using the IAM console. We recommend that you use the <b>Owner</b> request parameter instead of this
         * filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         * <b>Owner</b> request parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - The message for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with the
         * Intel 82599 VF interface is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> |
         *        <code>arm64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the
         *        Amazon EBS volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
         *        (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (
         *        <code>io1</code> | <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>|
         *        <code>st1</code> | <code>standard</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume
         *        is encrypted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creation-date</code> - The time when the image was created, in the ISO 8601 format in the UTC
         *        time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use
         *        a wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the image (provided during image creation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> |
         *        <code>ramdisk</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>is-public</code> - A Boolean that indicates whether the image is public.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manifest-location</code> - The location of the image manifest.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the AMI (provided during image creation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The
         *        valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account
         *        alias that can be set using the IAM console. We recommend that you use the <b>Owner</b> request
         *        parameter instead of this filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         *        <b>Owner</b> request parameter instead of this filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The device name of the root device volume (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         *        <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - The message for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking
         *        with the Intel 82599 VF interface is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon
         * EBS volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (<code>io1</code> |
         * <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>| <code>st1</code> |
         * <code>standard</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume is
         * encrypted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creation-date</code> - The time when the image was created, in the ISO 8601 format in the UTC time zone
         * (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (
         * <code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the image (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is-public</code> - A Boolean that indicates whether the image is public.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manifest-location</code> - The location of the image manifest.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AMI (provided during image creation).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The valid
         * aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can
         * be set using the IAM console. We recommend that you use the <b>Owner</b> request parameter instead of this
         * filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         * <b>Owner</b> request parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - The message for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with the
         * Intel 82599 VF interface is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The image IDs.
         * </p>
         * <p>
         * Default: Describes all images available to you.
         * </p>
         * 
         * @param imageIds
         *        The image IDs.</p>
         *        <p>
         *        Default: Describes all images available to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(Collection<String> imageIds);

        /**
         * <p>
         * The image IDs.
         * </p>
         * <p>
         * Default: Describes all images available to you.
         * </p>
         * 
         * @param imageIds
         *        The image IDs.</p>
         *        <p>
         *        Default: Describes all images available to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(String... imageIds);

        /**
         * <p>
         * Scopes the results to images with the specified owners. You can specify a combination of Amazon Web Services
         * account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you omit this
         * parameter, the results include all images for which you have launch permissions, regardless of ownership.
         * </p>
         * 
         * @param owners
         *        Scopes the results to images with the specified owners. You can specify a combination of Amazon Web
         *        Services account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you
         *        omit this parameter, the results include all images for which you have launch permissions, regardless
         *        of ownership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(Collection<String> owners);

        /**
         * <p>
         * Scopes the results to images with the specified owners. You can specify a combination of Amazon Web Services
         * account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you omit this
         * parameter, the results include all images for which you have launch permissions, regardless of ownership.
         * </p>
         * 
         * @param owners
         *        Scopes the results to images with the specified owners. You can specify a combination of Amazon Web
         *        Services account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you
         *        omit this parameter, the results include all images for which you have launch permissions, regardless
         *        of ownership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(String... owners);

        /**
         * <p>
         * If <code>true</code>, all deprecated AMIs are included in the response. If <code>false</code>, no deprecated
         * AMIs are included in the response. If no value is specified, the default value is <code>false</code>.
         * </p>
         * <note>
         * <p>
         * If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (
         * <code>true</code> or <code>false</code>) that you set for this parameter.
         * </p>
         * </note>
         * 
         * @param includeDeprecated
         *        If <code>true</code>, all deprecated AMIs are included in the response. If <code>false</code>, no
         *        deprecated AMIs are included in the response. If no value is specified, the default value is
         *        <code>false</code>.</p> <note>
         *        <p>
         *        If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (
         *        <code>true</code> or <code>false</code>) that you set for this parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDeprecated(Boolean includeDeprecated);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> executableUsers = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> imageIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> owners = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeDeprecated;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesRequest model) {
            super(model);
            executableUsers(model.executableUsers);
            filters(model.filters);
            imageIds(model.imageIds);
            owners(model.owners);
            includeDeprecated(model.includeDeprecated);
        }

        public final Collection<String> getExecutableUsers() {
            if (executableUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return executableUsers;
        }

        public final void setExecutableUsers(Collection<String> executableUsers) {
            this.executableUsers = ExecutableByStringListCopier.copy(executableUsers);
        }

        @Override
        public final Builder executableUsers(Collection<String> executableUsers) {
            this.executableUsers = ExecutableByStringListCopier.copy(executableUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executableUsers(String... executableUsers) {
            executableUsers(Arrays.asList(executableUsers));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getImageIds() {
            if (imageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return imageIds;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String... imageIds) {
            imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final Collection<String> getOwners() {
            if (owners instanceof SdkAutoConstructList) {
                return null;
            }
            return owners;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String... owners) {
            owners(Arrays.asList(owners));
            return this;
        }

        public final Boolean getIncludeDeprecated() {
            return includeDeprecated;
        }

        public final void setIncludeDeprecated(Boolean includeDeprecated) {
            this.includeDeprecated = includeDeprecated;
        }

        @Override
        public final Builder includeDeprecated(Boolean includeDeprecated) {
            this.includeDeprecated = includeDeprecated;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImagesRequest build() {
            return new DescribeImagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
