/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeSecurityGroupIngressRequest extends Ec2Request implements
        ToCopyableBuilder<RevokeSecurityGroupIngressRequest.Builder, RevokeSecurityGroupIngressRequest> {
    private static final SdkField<String> CIDR_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIp")
            .getter(getter(RevokeSecurityGroupIngressRequest::cidrIp))
            .setter(setter(Builder::cidrIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp")
                    .unmarshallLocationName("CidrIp").build()).build();

    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort")
            .getter(getter(RevokeSecurityGroupIngressRequest::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("FromPort").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(RevokeSecurityGroupIngressRequest::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("GroupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(RevokeSecurityGroupIngressRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("GroupName").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("IpPermissions")
            .getter(getter(RevokeSecurityGroupIngressRequest::ipPermissions))
            .setter(setter(Builder::ipPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions")
                    .unmarshallLocationName("IpPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpProtocol")
            .getter(getter(RevokeSecurityGroupIngressRequest::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("IpProtocol").build()).build();

    private static final SdkField<String> SOURCE_SECURITY_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceSecurityGroupName")
            .getter(getter(RevokeSecurityGroupIngressRequest::sourceSecurityGroupName))
            .setter(setter(Builder::sourceSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupName")
                    .unmarshallLocationName("SourceSecurityGroupName").build()).build();

    private static final SdkField<String> SOURCE_SECURITY_GROUP_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceSecurityGroupOwnerId")
            .getter(getter(RevokeSecurityGroupIngressRequest::sourceSecurityGroupOwnerId))
            .setter(setter(Builder::sourceSecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupOwnerId")
                    .unmarshallLocationName("SourceSecurityGroupOwnerId").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort")
            .getter(getter(RevokeSecurityGroupIngressRequest::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("ToPort").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_RULE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupRuleIds")
            .getter(getter(RevokeSecurityGroupIngressRequest::securityGroupRuleIds))
            .setter(setter(Builder::securityGroupRuleIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleId")
                    .unmarshallLocationName("SecurityGroupRuleId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CIDR_IP_FIELD, FROM_PORT_FIELD, GROUP_ID_FIELD, GROUP_NAME_FIELD,
                    IP_PERMISSIONS_FIELD, IP_PROTOCOL_FIELD, SOURCE_SECURITY_GROUP_NAME_FIELD,
                    SOURCE_SECURITY_GROUP_OWNER_ID_FIELD, TO_PORT_FIELD, SECURITY_GROUP_RULE_IDS_FIELD));

    private final String cidrIp;

    private final Integer fromPort;

    private final String groupId;

    private final String groupName;

    private final List<IpPermission> ipPermissions;

    private final String ipProtocol;

    private final String sourceSecurityGroupName;

    private final String sourceSecurityGroupOwnerId;

    private final Integer toPort;

    private final List<String> securityGroupRuleIds;

    private RevokeSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
        this.ipProtocol = builder.ipProtocol;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
        this.toPort = builder.toPort;
        this.securityGroupRuleIds = builder.securityGroupRuleIds;
    }

    /**
     * <p>
     * The CIDR IP address range. You can't specify this parameter when specifying a source security group.
     * </p>
     * 
     * @return The CIDR IP address range. You can't specify this parameter when specifying a source security group.
     */
    public final String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use
     * <code>-1</code> to specify all ICMP types.
     * </p>
     * 
     * @return The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number,
     *         use <code>-1</code> to specify all ICMP types.
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The ID of the security group. You must specify either the security group ID or the security group name in the
     * request. For security groups in a nondefault VPC, you must specify the security group ID.
     * </p>
     * 
     * @return The ID of the security group. You must specify either the security group ID or the security group name in
     *         the request. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the
     * security group name in the request.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID
     *         or the security group name in the request.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpPermissions() {
        return ipPermissions != null && !(ipPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set
     * of permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPermissions} method.
     * </p>
     * 
     * @return The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the
     *         same set of permissions.
     */
    public final List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
     * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). Use
     * <code>-1</code> to specify all.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
     *         href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). Use
     *         <code>-1</code> to specify all.
     */
    public final String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination
     * with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the
     * end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule
     * for an IP protocol and port range, use a set of IP permissions instead.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in
     *         combination with the following parameters: the CIDR IP address range, the start of the port range, the IP
     *         protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC.
     *         To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
     */
    public final String sourceSecurityGroupName() {
        return sourceSecurityGroupName;
    }

    /**
     * <p>
     * [EC2-Classic] The Amazon Web Services account ID of the source security group, if the source security group is in
     * a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP
     * address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific
     * rule for an IP protocol and port range, use a set of IP permissions instead.
     * </p>
     * 
     * @return [EC2-Classic] The Amazon Web Services account ID of the source security group, if the source security
     *         group is in a different account. You can't specify this parameter in combination with the following
     *         parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the
     *         port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions
     *         instead.
     */
    public final String sourceSecurityGroupOwnerId() {
        return sourceSecurityGroupOwnerId;
    }

    /**
     * <p>
     * The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use
     * <code>-1</code> to specify all ICMP codes for the ICMP type.
     * </p>
     * 
     * @return The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number,
     *         use <code>-1</code> to specify all ICMP codes for the ICMP type.
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupRuleIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupRuleIds() {
        return securityGroupRuleIds != null && !(securityGroupRuleIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security group rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupRuleIds} method.
     * </p>
     * 
     * @return The IDs of the security group rules.
     */
    public final List<String> securityGroupRuleIds() {
        return securityGroupRuleIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPermissions() ? ipPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupRuleIds() ? securityGroupRuleIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupIngressRequest)) {
            return false;
        }
        RevokeSecurityGroupIngressRequest other = (RevokeSecurityGroupIngressRequest) obj;
        return Objects.equals(cidrIp(), other.cidrIp()) && Objects.equals(fromPort(), other.fromPort())
                && Objects.equals(groupId(), other.groupId()) && Objects.equals(groupName(), other.groupName())
                && hasIpPermissions() == other.hasIpPermissions() && Objects.equals(ipPermissions(), other.ipPermissions())
                && Objects.equals(ipProtocol(), other.ipProtocol())
                && Objects.equals(sourceSecurityGroupName(), other.sourceSecurityGroupName())
                && Objects.equals(sourceSecurityGroupOwnerId(), other.sourceSecurityGroupOwnerId())
                && Objects.equals(toPort(), other.toPort()) && hasSecurityGroupRuleIds() == other.hasSecurityGroupRuleIds()
                && Objects.equals(securityGroupRuleIds(), other.securityGroupRuleIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeSecurityGroupIngressRequest").add("CidrIp", cidrIp()).add("FromPort", fromPort())
                .add("GroupId", groupId()).add("GroupName", groupName())
                .add("IpPermissions", hasIpPermissions() ? ipPermissions() : null).add("IpProtocol", ipProtocol())
                .add("SourceSecurityGroupName", sourceSecurityGroupName())
                .add("SourceSecurityGroupOwnerId", sourceSecurityGroupOwnerId()).add("ToPort", toPort())
                .add("SecurityGroupRuleIds", hasSecurityGroupRuleIds() ? securityGroupRuleIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIp":
            return Optional.ofNullable(clazz.cast(cidrIp()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "IpPermissions":
            return Optional.ofNullable(clazz.cast(ipPermissions()));
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "SourceSecurityGroupName":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroupName()));
        case "SourceSecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroupOwnerId()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "SecurityGroupRuleIds":
            return Optional.ofNullable(clazz.cast(securityGroupRuleIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeSecurityGroupIngressRequest, T> g) {
        return obj -> g.apply((RevokeSecurityGroupIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RevokeSecurityGroupIngressRequest> {
        /**
         * <p>
         * The CIDR IP address range. You can't specify this parameter when specifying a source security group.
         * </p>
         * 
         * @param cidrIp
         *        The CIDR IP address range. You can't specify this parameter when specifying a source security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use
         * <code>-1</code> to specify all ICMP types.
         * </p>
         * 
         * @param fromPort
         *        The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type
         *        number, use <code>-1</code> to specify all ICMP types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The ID of the security group. You must specify either the security group ID or the security group name in the
         * request. For security groups in a nondefault VPC, you must specify the security group ID.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group. You must specify either the security group ID or the security group name
         *        in the request. For security groups in a nondefault VPC, you must specify the security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or
         * the security group name in the request.
         * </p>
         * 
         * @param groupName
         *        [EC2-Classic, default VPC] The name of the security group. You must specify either the security group
         *        ID or the security group name in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same
         * set of permissions.
         * </p>
         * 
         * @param ipPermissions
         *        The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in
         *        the same set of permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same
         * set of permissions.
         * </p>
         * 
         * @param ipPermissions
         *        The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in
         *        the same set of permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same
         * set of permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissions(List<IpPermission>)}.
         * 
         * @param ipPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissions(java.util.Collection<IpPermission>)
         */
        Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions);

        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
         * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). Use
         * <code>-1</code> to specify all.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
         *        href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         *        Use <code>-1</code> to specify all.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in
         * combination with the following parameters: the CIDR IP address range, the start of the port range, the IP
         * protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To
         * revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         * </p>
         * 
         * @param sourceSecurityGroupName
         *        [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in
         *        combination with the following parameters: the CIDR IP address range, the start of the port range, the
         *        IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same
         *        VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupName(String sourceSecurityGroupName);

        /**
         * <p>
         * [EC2-Classic] The Amazon Web Services account ID of the source security group, if the source security group
         * is in a different account. You can't specify this parameter in combination with the following parameters: the
         * CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke
         * a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         * </p>
         * 
         * @param sourceSecurityGroupOwnerId
         *        [EC2-Classic] The Amazon Web Services account ID of the source security group, if the source security
         *        group is in a different account. You can't specify this parameter in combination with the following
         *        parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of
         *        the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP
         *        permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId);

        /**
         * <p>
         * The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use
         * <code>-1</code> to specify all ICMP codes for the ICMP type.
         * </p>
         * 
         * @param toPort
         *        The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number,
         *        use <code>-1</code> to specify all ICMP codes for the ICMP type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The IDs of the security group rules.
         * </p>
         * 
         * @param securityGroupRuleIds
         *        The IDs of the security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleIds(Collection<String> securityGroupRuleIds);

        /**
         * <p>
         * The IDs of the security group rules.
         * </p>
         * 
         * @param securityGroupRuleIds
         *        The IDs of the security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleIds(String... securityGroupRuleIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cidrIp;

        private Integer fromPort;

        private String groupId;

        private String groupName;

        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private String ipProtocol;

        private String sourceSecurityGroupName;

        private String sourceSecurityGroupOwnerId;

        private Integer toPort;

        private List<String> securityGroupRuleIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSecurityGroupIngressRequest model) {
            super(model);
            cidrIp(model.cidrIp);
            fromPort(model.fromPort);
            groupId(model.groupId);
            groupName(model.groupName);
            ipPermissions(model.ipPermissions);
            ipProtocol(model.ipProtocol);
            sourceSecurityGroupName(model.sourceSecurityGroupName);
            sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
            toPort(model.toPort);
            securityGroupRuleIds(model.securityGroupRuleIds);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions) {
            ipPermissions(Stream.of(ipPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final String getSourceSecurityGroupName() {
            return sourceSecurityGroupName;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return sourceSecurityGroupOwnerId;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final Collection<String> getSecurityGroupRuleIds() {
            if (securityGroupRuleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupRuleIds;
        }

        public final void setSecurityGroupRuleIds(Collection<String> securityGroupRuleIds) {
            this.securityGroupRuleIds = SecurityGroupRuleIdListCopier.copy(securityGroupRuleIds);
        }

        @Override
        public final Builder securityGroupRuleIds(Collection<String> securityGroupRuleIds) {
            this.securityGroupRuleIds = SecurityGroupRuleIdListCopier.copy(securityGroupRuleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRuleIds(String... securityGroupRuleIds) {
            securityGroupRuleIds(Arrays.asList(securityGroupRuleIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeSecurityGroupIngressRequest build() {
            return new RevokeSecurityGroupIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
