/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the disks that are available for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceStorageInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceStorageInfo.Builder, InstanceStorageInfo> {
    private static final SdkField<Long> TOTAL_SIZE_IN_GB_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalSizeInGB")
            .getter(getter(InstanceStorageInfo::totalSizeInGB))
            .setter(setter(Builder::totalSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeInGB")
                    .unmarshallLocationName("totalSizeInGB").build()).build();

    private static final SdkField<List<DiskInfo>> DISKS_FIELD = SdkField
            .<List<DiskInfo>> builder(MarshallingType.LIST)
            .memberName("Disks")
            .getter(getter(InstanceStorageInfo::disks))
            .setter(setter(Builder::disks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disks")
                    .unmarshallLocationName("disks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DiskInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DiskInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NVME_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NvmeSupport")
            .getter(getter(InstanceStorageInfo::nvmeSupportAsString))
            .setter(setter(Builder::nvmeSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NvmeSupport")
                    .unmarshallLocationName("nvmeSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_SIZE_IN_GB_FIELD,
            DISKS_FIELD, NVME_SUPPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalSizeInGB;

    private final List<DiskInfo> disks;

    private final String nvmeSupport;

    private InstanceStorageInfo(BuilderImpl builder) {
        this.totalSizeInGB = builder.totalSizeInGB;
        this.disks = builder.disks;
        this.nvmeSupport = builder.nvmeSupport;
    }

    /**
     * <p>
     * The total size of the disks, in GB.
     * </p>
     * 
     * @return The total size of the disks, in GB.
     */
    public final Long totalSizeInGB() {
        return totalSizeInGB;
    }

    /**
     * For responses, this returns true if the service returned a value for the Disks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasDisks() {
        return disks != null && !(disks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the disks that are available for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisks} method.
     * </p>
     * 
     * @return Describes the disks that are available for the instance type.
     */
    public final List<DiskInfo> disks() {
        return disks;
    }

    /**
     * <p>
     * Indicates whether non-volatile memory express (NVMe) is supported for instance store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nvmeSupport} will
     * return {@link EphemeralNvmeSupport#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nvmeSupportAsString}.
     * </p>
     * 
     * @return Indicates whether non-volatile memory express (NVMe) is supported for instance store.
     * @see EphemeralNvmeSupport
     */
    public final EphemeralNvmeSupport nvmeSupport() {
        return EphemeralNvmeSupport.fromValue(nvmeSupport);
    }

    /**
     * <p>
     * Indicates whether non-volatile memory express (NVMe) is supported for instance store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nvmeSupport} will
     * return {@link EphemeralNvmeSupport#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nvmeSupportAsString}.
     * </p>
     * 
     * @return Indicates whether non-volatile memory express (NVMe) is supported for instance store.
     * @see EphemeralNvmeSupport
     */
    public final String nvmeSupportAsString() {
        return nvmeSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(hasDisks() ? disks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nvmeSupportAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStorageInfo)) {
            return false;
        }
        InstanceStorageInfo other = (InstanceStorageInfo) obj;
        return Objects.equals(totalSizeInGB(), other.totalSizeInGB()) && hasDisks() == other.hasDisks()
                && Objects.equals(disks(), other.disks()) && Objects.equals(nvmeSupportAsString(), other.nvmeSupportAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceStorageInfo").add("TotalSizeInGB", totalSizeInGB())
                .add("Disks", hasDisks() ? disks() : null).add("NvmeSupport", nvmeSupportAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalSizeInGB":
            return Optional.ofNullable(clazz.cast(totalSizeInGB()));
        case "Disks":
            return Optional.ofNullable(clazz.cast(disks()));
        case "NvmeSupport":
            return Optional.ofNullable(clazz.cast(nvmeSupportAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStorageInfo, T> g) {
        return obj -> g.apply((InstanceStorageInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceStorageInfo> {
        /**
         * <p>
         * The total size of the disks, in GB.
         * </p>
         * 
         * @param totalSizeInGB
         *        The total size of the disks, in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSizeInGB(Long totalSizeInGB);

        /**
         * <p>
         * Describes the disks that are available for the instance type.
         * </p>
         * 
         * @param disks
         *        Describes the disks that are available for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Collection<DiskInfo> disks);

        /**
         * <p>
         * Describes the disks that are available for the instance type.
         * </p>
         * 
         * @param disks
         *        Describes the disks that are available for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(DiskInfo... disks);

        /**
         * <p>
         * Describes the disks that are available for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DiskInfo>.Builder} avoiding the need to
         * create one manually via {@link List<DiskInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DiskInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #disks(List<DiskInfo>)}.
         * 
         * @param disks
         *        a consumer that will call methods on {@link List<DiskInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disks(List<DiskInfo>)
         */
        Builder disks(Consumer<DiskInfo.Builder>... disks);

        /**
         * <p>
         * Indicates whether non-volatile memory express (NVMe) is supported for instance store.
         * </p>
         * 
         * @param nvmeSupport
         *        Indicates whether non-volatile memory express (NVMe) is supported for instance store.
         * @see EphemeralNvmeSupport
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemeralNvmeSupport
         */
        Builder nvmeSupport(String nvmeSupport);

        /**
         * <p>
         * Indicates whether non-volatile memory express (NVMe) is supported for instance store.
         * </p>
         * 
         * @param nvmeSupport
         *        Indicates whether non-volatile memory express (NVMe) is supported for instance store.
         * @see EphemeralNvmeSupport
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemeralNvmeSupport
         */
        Builder nvmeSupport(EphemeralNvmeSupport nvmeSupport);
    }

    static final class BuilderImpl implements Builder {
        private Long totalSizeInGB;

        private List<DiskInfo> disks = DefaultSdkAutoConstructList.getInstance();

        private String nvmeSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStorageInfo model) {
            totalSizeInGB(model.totalSizeInGB);
            disks(model.disks);
            nvmeSupport(model.nvmeSupport);
        }

        public final Long getTotalSizeInGB() {
            return totalSizeInGB;
        }

        public final void setTotalSizeInGB(Long totalSizeInGB) {
            this.totalSizeInGB = totalSizeInGB;
        }

        @Override
        @Transient
        public final Builder totalSizeInGB(Long totalSizeInGB) {
            this.totalSizeInGB = totalSizeInGB;
            return this;
        }

        public final List<DiskInfo.Builder> getDisks() {
            List<DiskInfo.Builder> result = DiskInfoListCopier.copyToBuilder(this.disks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisks(Collection<DiskInfo.BuilderImpl> disks) {
            this.disks = DiskInfoListCopier.copyFromBuilder(disks);
        }

        @Override
        @Transient
        public final Builder disks(Collection<DiskInfo> disks) {
            this.disks = DiskInfoListCopier.copy(disks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder disks(DiskInfo... disks) {
            disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder disks(Consumer<DiskInfo.Builder>... disks) {
            disks(Stream.of(disks).map(c -> DiskInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNvmeSupport() {
            return nvmeSupport;
        }

        public final void setNvmeSupport(String nvmeSupport) {
            this.nvmeSupport = nvmeSupport;
        }

        @Override
        @Transient
        public final Builder nvmeSupport(String nvmeSupport) {
            this.nvmeSupport = nvmeSupport;
            return this;
        }

        @Override
        @Transient
        public final Builder nvmeSupport(EphemeralNvmeSupport nvmeSupport) {
            this.nvmeSupport(nvmeSupport == null ? null : nvmeSupport.toString());
            return this;
        }

        @Override
        public InstanceStorageInfo build() {
            return new InstanceStorageInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
