/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the tag keys to register for the current Region. You can either specify individual tag keys or
 * register all tag keys in the current Region. You must specify either <code>IncludeAllTagsOfInstance</code> or
 * <code>InstanceTagKeys</code> in the request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterInstanceTagAttributeRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisterInstanceTagAttributeRequest.Builder, RegisterInstanceTagAttributeRequest> {
    private static final SdkField<Boolean> INCLUDE_ALL_TAGS_OF_INSTANCE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeAllTagsOfInstance")
            .getter(getter(RegisterInstanceTagAttributeRequest::includeAllTagsOfInstance))
            .setter(setter(Builder::includeAllTagsOfInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllTagsOfInstance")
                    .unmarshallLocationName("IncludeAllTagsOfInstance").build()).build();

    private static final SdkField<List<String>> INSTANCE_TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceTagKeys")
            .getter(getter(RegisterInstanceTagAttributeRequest::instanceTagKeys))
            .setter(setter(Builder::instanceTagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTagKey")
                    .unmarshallLocationName("InstanceTagKey").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INCLUDE_ALL_TAGS_OF_INSTANCE_FIELD, INSTANCE_TAG_KEYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean includeAllTagsOfInstance;

    private final List<String> instanceTagKeys;

    private RegisterInstanceTagAttributeRequest(BuilderImpl builder) {
        this.includeAllTagsOfInstance = builder.includeAllTagsOfInstance;
        this.instanceTagKeys = builder.instanceTagKeys;
    }

    /**
     * <p>
     * Indicates whether to register all tag keys in the current Region. Specify <code>true</code> to register all tag
     * keys.
     * </p>
     * 
     * @return Indicates whether to register all tag keys in the current Region. Specify <code>true</code> to register
     *         all tag keys.
     */
    public final Boolean includeAllTagsOfInstance() {
        return includeAllTagsOfInstance;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTagKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTagKeys() {
        return instanceTagKeys != null && !(instanceTagKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys to register.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTagKeys} method.
     * </p>
     * 
     * @return The tag keys to register.
     */
    public final List<String> instanceTagKeys() {
        return instanceTagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeAllTagsOfInstance());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTagKeys() ? instanceTagKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceTagAttributeRequest)) {
            return false;
        }
        RegisterInstanceTagAttributeRequest other = (RegisterInstanceTagAttributeRequest) obj;
        return Objects.equals(includeAllTagsOfInstance(), other.includeAllTagsOfInstance())
                && hasInstanceTagKeys() == other.hasInstanceTagKeys()
                && Objects.equals(instanceTagKeys(), other.instanceTagKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterInstanceTagAttributeRequest")
                .add("IncludeAllTagsOfInstance", includeAllTagsOfInstance())
                .add("InstanceTagKeys", hasInstanceTagKeys() ? instanceTagKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludeAllTagsOfInstance":
            return Optional.ofNullable(clazz.cast(includeAllTagsOfInstance()));
        case "InstanceTagKeys":
            return Optional.ofNullable(clazz.cast(instanceTagKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterInstanceTagAttributeRequest, T> g) {
        return obj -> g.apply((RegisterInstanceTagAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisterInstanceTagAttributeRequest> {
        /**
         * <p>
         * Indicates whether to register all tag keys in the current Region. Specify <code>true</code> to register all
         * tag keys.
         * </p>
         * 
         * @param includeAllTagsOfInstance
         *        Indicates whether to register all tag keys in the current Region. Specify <code>true</code> to
         *        register all tag keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllTagsOfInstance(Boolean includeAllTagsOfInstance);

        /**
         * <p>
         * The tag keys to register.
         * </p>
         * 
         * @param instanceTagKeys
         *        The tag keys to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTagKeys(Collection<String> instanceTagKeys);

        /**
         * <p>
         * The tag keys to register.
         * </p>
         * 
         * @param instanceTagKeys
         *        The tag keys to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTagKeys(String... instanceTagKeys);
    }

    static final class BuilderImpl implements Builder {
        private Boolean includeAllTagsOfInstance;

        private List<String> instanceTagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceTagAttributeRequest model) {
            includeAllTagsOfInstance(model.includeAllTagsOfInstance);
            instanceTagKeys(model.instanceTagKeys);
        }

        public final Boolean getIncludeAllTagsOfInstance() {
            return includeAllTagsOfInstance;
        }

        public final void setIncludeAllTagsOfInstance(Boolean includeAllTagsOfInstance) {
            this.includeAllTagsOfInstance = includeAllTagsOfInstance;
        }

        @Override
        @Transient
        public final Builder includeAllTagsOfInstance(Boolean includeAllTagsOfInstance) {
            this.includeAllTagsOfInstance = includeAllTagsOfInstance;
            return this;
        }

        public final Collection<String> getInstanceTagKeys() {
            if (instanceTagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTagKeys;
        }

        public final void setInstanceTagKeys(Collection<String> instanceTagKeys) {
            this.instanceTagKeys = InstanceTagKeySetCopier.copy(instanceTagKeys);
        }

        @Override
        @Transient
        public final Builder instanceTagKeys(Collection<String> instanceTagKeys) {
            this.instanceTagKeys = InstanceTagKeySetCopier.copy(instanceTagKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceTagKeys(String... instanceTagKeys) {
            instanceTagKeys(Arrays.asList(instanceTagKeys));
            return this;
        }

        @Override
        public RegisterInstanceTagAttributeRequest build() {
            return new RegisterInstanceTagAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
