/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot Fleet request that was successfully canceled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSpotFleetRequestsSuccessItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CancelSpotFleetRequestsSuccessItem.Builder, CancelSpotFleetRequestsSuccessItem> {
    private static final SdkField<String> CURRENT_SPOT_FLEET_REQUEST_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentSpotFleetRequestState")
            .getter(getter(CancelSpotFleetRequestsSuccessItem::currentSpotFleetRequestStateAsString))
            .setter(setter(Builder::currentSpotFleetRequestState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSpotFleetRequestState")
                    .unmarshallLocationName("currentSpotFleetRequestState").build()).build();

    private static final SdkField<String> PREVIOUS_SPOT_FLEET_REQUEST_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreviousSpotFleetRequestState")
            .getter(getter(CancelSpotFleetRequestsSuccessItem::previousSpotFleetRequestStateAsString))
            .setter(setter(Builder::previousSpotFleetRequestState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousSpotFleetRequestState")
                    .unmarshallLocationName("previousSpotFleetRequestState").build()).build();

    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotFleetRequestId")
            .getter(getter(CancelSpotFleetRequestsSuccessItem::spotFleetRequestId))
            .setter(setter(Builder::spotFleetRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CURRENT_SPOT_FLEET_REQUEST_STATE_FIELD, PREVIOUS_SPOT_FLEET_REQUEST_STATE_FIELD, SPOT_FLEET_REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currentSpotFleetRequestState;

    private final String previousSpotFleetRequestState;

    private final String spotFleetRequestId;

    private CancelSpotFleetRequestsSuccessItem(BuilderImpl builder) {
        this.currentSpotFleetRequestState = builder.currentSpotFleetRequestState;
        this.previousSpotFleetRequestState = builder.previousSpotFleetRequestState;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * <p>
     * The current state of the Spot Fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentSpotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #currentSpotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The current state of the Spot Fleet request.
     * @see BatchState
     */
    public final BatchState currentSpotFleetRequestState() {
        return BatchState.fromValue(currentSpotFleetRequestState);
    }

    /**
     * <p>
     * The current state of the Spot Fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentSpotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #currentSpotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The current state of the Spot Fleet request.
     * @see BatchState
     */
    public final String currentSpotFleetRequestStateAsString() {
        return currentSpotFleetRequestState;
    }

    /**
     * <p>
     * The previous state of the Spot Fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #previousSpotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #previousSpotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The previous state of the Spot Fleet request.
     * @see BatchState
     */
    public final BatchState previousSpotFleetRequestState() {
        return BatchState.fromValue(previousSpotFleetRequestState);
    }

    /**
     * <p>
     * The previous state of the Spot Fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #previousSpotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #previousSpotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The previous state of the Spot Fleet request.
     * @see BatchState
     */
    public final String previousSpotFleetRequestStateAsString() {
        return previousSpotFleetRequestState;
    }

    /**
     * <p>
     * The ID of the Spot Fleet request.
     * </p>
     * 
     * @return The ID of the Spot Fleet request.
     */
    public final String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentSpotFleetRequestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(previousSpotFleetRequestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsSuccessItem)) {
            return false;
        }
        CancelSpotFleetRequestsSuccessItem other = (CancelSpotFleetRequestsSuccessItem) obj;
        return Objects.equals(currentSpotFleetRequestStateAsString(), other.currentSpotFleetRequestStateAsString())
                && Objects.equals(previousSpotFleetRequestStateAsString(), other.previousSpotFleetRequestStateAsString())
                && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelSpotFleetRequestsSuccessItem")
                .add("CurrentSpotFleetRequestState", currentSpotFleetRequestStateAsString())
                .add("PreviousSpotFleetRequestState", previousSpotFleetRequestStateAsString())
                .add("SpotFleetRequestId", spotFleetRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentSpotFleetRequestState":
            return Optional.ofNullable(clazz.cast(currentSpotFleetRequestStateAsString()));
        case "PreviousSpotFleetRequestState":
            return Optional.ofNullable(clazz.cast(previousSpotFleetRequestStateAsString()));
        case "SpotFleetRequestId":
            return Optional.ofNullable(clazz.cast(spotFleetRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotFleetRequestsSuccessItem, T> g) {
        return obj -> g.apply((CancelSpotFleetRequestsSuccessItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CancelSpotFleetRequestsSuccessItem> {
        /**
         * <p>
         * The current state of the Spot Fleet request.
         * </p>
         * 
         * @param currentSpotFleetRequestState
         *        The current state of the Spot Fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder currentSpotFleetRequestState(String currentSpotFleetRequestState);

        /**
         * <p>
         * The current state of the Spot Fleet request.
         * </p>
         * 
         * @param currentSpotFleetRequestState
         *        The current state of the Spot Fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder currentSpotFleetRequestState(BatchState currentSpotFleetRequestState);

        /**
         * <p>
         * The previous state of the Spot Fleet request.
         * </p>
         * 
         * @param previousSpotFleetRequestState
         *        The previous state of the Spot Fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder previousSpotFleetRequestState(String previousSpotFleetRequestState);

        /**
         * <p>
         * The previous state of the Spot Fleet request.
         * </p>
         * 
         * @param previousSpotFleetRequestState
         *        The previous state of the Spot Fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder previousSpotFleetRequestState(BatchState previousSpotFleetRequestState);

        /**
         * <p>
         * The ID of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    static final class BuilderImpl implements Builder {
        private String currentSpotFleetRequestState;

        private String previousSpotFleetRequestState;

        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsSuccessItem model) {
            currentSpotFleetRequestState(model.currentSpotFleetRequestState);
            previousSpotFleetRequestState(model.previousSpotFleetRequestState);
            spotFleetRequestId(model.spotFleetRequestId);
        }

        public final String getCurrentSpotFleetRequestState() {
            return currentSpotFleetRequestState;
        }

        public final void setCurrentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
        }

        @Override
        @Transient
        public final Builder currentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
            return this;
        }

        @Override
        @Transient
        public final Builder currentSpotFleetRequestState(BatchState currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState(currentSpotFleetRequestState == null ? null : currentSpotFleetRequestState
                    .toString());
            return this;
        }

        public final String getPreviousSpotFleetRequestState() {
            return previousSpotFleetRequestState;
        }

        public final void setPreviousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
        }

        @Override
        @Transient
        public final Builder previousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
            return this;
        }

        @Override
        @Transient
        public final Builder previousSpotFleetRequestState(BatchState previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState(previousSpotFleetRequestState == null ? null : previousSpotFleetRequestState
                    .toString());
            return this;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        @Transient
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        @Override
        public CancelSpotFleetRequestsSuccessItem build() {
            return new CancelSpotFleetRequestsSuccessItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
