/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata options for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMetadataOptionsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMetadataOptionsResponse.Builder, InstanceMetadataOptionsResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(InstanceMetadataOptionsResponse::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpTokens")
            .getter(getter(InstanceMetadataOptionsResponse::httpTokensAsString))
            .setter(setter(Builder::httpTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens")
                    .unmarshallLocationName("httpTokens").build()).build();

    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HttpPutResponseHopLimit")
            .getter(getter(InstanceMetadataOptionsResponse::httpPutResponseHopLimit))
            .setter(setter(Builder::httpPutResponseHopLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit")
                    .unmarshallLocationName("httpPutResponseHopLimit").build()).build();

    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpEndpoint")
            .getter(getter(InstanceMetadataOptionsResponse::httpEndpointAsString))
            .setter(setter(Builder::httpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint")
                    .unmarshallLocationName("httpEndpoint").build()).build();

    private static final SdkField<String> HTTP_PROTOCOL_IPV6_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpProtocolIpv6")
            .getter(getter(InstanceMetadataOptionsResponse::httpProtocolIpv6AsString))
            .setter(setter(Builder::httpProtocolIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpProtocolIpv6")
                    .unmarshallLocationName("httpProtocolIpv6").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            HTTP_TOKENS_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_ENDPOINT_FIELD, HTTP_PROTOCOL_IPV6_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String httpTokens;

    private final Integer httpPutResponseHopLimit;

    private final String httpEndpoint;

    private final String httpProtocolIpv6;

    private InstanceMetadataOptionsResponse(BuilderImpl builder) {
        this.state = builder.state;
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpEndpoint = builder.httpEndpoint;
        this.httpProtocolIpv6 = builder.httpProtocolIpv6;
    }

    /**
     * <p>
     * The state of the metadata option changes.
     * </p>
     * <p>
     * <code>pending</code> - The metadata options are being updated and the instance is not ready to process metadata
     * traffic with the new selection.
     * </p>
     * <p>
     * <code>applied</code> - The metadata options have been successfully applied on the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceMetadataOptionsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the metadata option changes.</p>
     *         <p>
     *         <code>pending</code> - The metadata options are being updated and the instance is not ready to process
     *         metadata traffic with the new selection.
     *         </p>
     *         <p>
     *         <code>applied</code> - The metadata options have been successfully applied on the instance.
     * @see InstanceMetadataOptionsState
     */
    public final InstanceMetadataOptionsState state() {
        return InstanceMetadataOptionsState.fromValue(state);
    }

    /**
     * <p>
     * The state of the metadata option changes.
     * </p>
     * <p>
     * <code>pending</code> - The metadata options are being updated and the instance is not ready to process metadata
     * traffic with the new selection.
     * </p>
     * <p>
     * <code>applied</code> - The metadata options have been successfully applied on the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceMetadataOptionsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the metadata option changes.</p>
     *         <p>
     *         <code>pending</code> - The metadata options are being updated and the instance is not ready to process
     *         metadata traffic with the new selection.
     *         </p>
     *         <p>
     *         <code>applied</code> - The metadata options have been successfully applied on the instance.
     * @see InstanceMetadataOptionsState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The state of token usage for your instance metadata requests. If the parameter is not specified in the request,
     * the default state is <code>optional</code>.
     * </p>
     * <p>
     * If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed
     * token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role
     * credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0
     * role credentials are returned.
     * </p>
     * <p>
     * If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval
     * requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials; the
     * version 1.0 credentials are not available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTokens} will
     * return {@link HttpTokensState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpTokensAsString}.
     * </p>
     * 
     * @return The state of token usage for your instance metadata requests. If the parameter is not specified in the
     *         request, the default state is <code>optional</code>.</p>
     *         <p>
     *         If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a
     *         signed token header on your request. If you retrieve the IAM role credentials without a token, the
     *         version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed
     *         token, the version 2.0 role credentials are returned.
     *         </p>
     *         <p>
     *         If the state is <code>required</code>, you must send a signed token header with any instance metadata
     *         retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
     *         credentials; the version 1.0 credentials are not available.
     * @see HttpTokensState
     */
    public final HttpTokensState httpTokens() {
        return HttpTokensState.fromValue(httpTokens);
    }

    /**
     * <p>
     * The state of token usage for your instance metadata requests. If the parameter is not specified in the request,
     * the default state is <code>optional</code>.
     * </p>
     * <p>
     * If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed
     * token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role
     * credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0
     * role credentials are returned.
     * </p>
     * <p>
     * If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval
     * requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials; the
     * version 1.0 credentials are not available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTokens} will
     * return {@link HttpTokensState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpTokensAsString}.
     * </p>
     * 
     * @return The state of token usage for your instance metadata requests. If the parameter is not specified in the
     *         request, the default state is <code>optional</code>.</p>
     *         <p>
     *         If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a
     *         signed token header on your request. If you retrieve the IAM role credentials without a token, the
     *         version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed
     *         token, the version 2.0 role credentials are returned.
     *         </p>
     *         <p>
     *         If the state is <code>required</code>, you must send a signed token header with any instance metadata
     *         retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
     *         credentials; the version 1.0 credentials are not available.
     * @see HttpTokensState
     */
    public final String httpTokensAsString() {
        return httpTokens;
    }

    /**
     * <p>
     * The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further
     * instance metadata requests can travel.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Possible values: Integers from 1 to 64
     * </p>
     * 
     * @return The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the
     *         further instance metadata requests can travel.</p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Possible values: Integers from 1 to 64
     */
    public final Integer httpPutResponseHopLimit() {
        return httpPutResponseHopLimit;
    }

    /**
     * <p>
     * This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not
     * specified, the default state is <code>enabled</code>.
     * </p>
     * <note>
     * <p>
     * If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpEndpoint} will
     * return {@link InstanceMetadataEndpointState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpEndpointAsString}.
     * </p>
     * 
     * @return This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not
     *         specified, the default state is <code>enabled</code>.</p> <note>
     *         <p>
     *         If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.
     *         </p>
     * @see InstanceMetadataEndpointState
     */
    public final InstanceMetadataEndpointState httpEndpoint() {
        return InstanceMetadataEndpointState.fromValue(httpEndpoint);
    }

    /**
     * <p>
     * This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not
     * specified, the default state is <code>enabled</code>.
     * </p>
     * <note>
     * <p>
     * If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpEndpoint} will
     * return {@link InstanceMetadataEndpointState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpEndpointAsString}.
     * </p>
     * 
     * @return This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not
     *         specified, the default state is <code>enabled</code>.</p> <note>
     *         <p>
     *         If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.
     *         </p>
     * @see InstanceMetadataEndpointState
     */
    public final String httpEndpointAsString() {
        return httpEndpoint;
    }

    /**
     * <p>
     * Whether or not the IPv6 endpoint for the instance metadata service is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpProtocolIpv6}
     * will return {@link InstanceMetadataProtocolState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #httpProtocolIpv6AsString}.
     * </p>
     * 
     * @return Whether or not the IPv6 endpoint for the instance metadata service is enabled or disabled.
     * @see InstanceMetadataProtocolState
     */
    public final InstanceMetadataProtocolState httpProtocolIpv6() {
        return InstanceMetadataProtocolState.fromValue(httpProtocolIpv6);
    }

    /**
     * <p>
     * Whether or not the IPv6 endpoint for the instance metadata service is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpProtocolIpv6}
     * will return {@link InstanceMetadataProtocolState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #httpProtocolIpv6AsString}.
     * </p>
     * 
     * @return Whether or not the IPv6 endpoint for the instance metadata service is enabled or disabled.
     * @see InstanceMetadataProtocolState
     */
    public final String httpProtocolIpv6AsString() {
        return httpProtocolIpv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(httpProtocolIpv6AsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadataOptionsResponse)) {
            return false;
        }
        InstanceMetadataOptionsResponse other = (InstanceMetadataOptionsResponse) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(httpTokensAsString(), other.httpTokensAsString())
                && Objects.equals(httpPutResponseHopLimit(), other.httpPutResponseHopLimit())
                && Objects.equals(httpEndpointAsString(), other.httpEndpointAsString())
                && Objects.equals(httpProtocolIpv6AsString(), other.httpProtocolIpv6AsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMetadataOptionsResponse").add("State", stateAsString())
                .add("HttpTokens", httpTokensAsString()).add("HttpPutResponseHopLimit", httpPutResponseHopLimit())
                .add("HttpEndpoint", httpEndpointAsString()).add("HttpProtocolIpv6", httpProtocolIpv6AsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "HttpTokens":
            return Optional.ofNullable(clazz.cast(httpTokensAsString()));
        case "HttpPutResponseHopLimit":
            return Optional.ofNullable(clazz.cast(httpPutResponseHopLimit()));
        case "HttpEndpoint":
            return Optional.ofNullable(clazz.cast(httpEndpointAsString()));
        case "HttpProtocolIpv6":
            return Optional.ofNullable(clazz.cast(httpProtocolIpv6AsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadataOptionsResponse, T> g) {
        return obj -> g.apply((InstanceMetadataOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMetadataOptionsResponse> {
        /**
         * <p>
         * The state of the metadata option changes.
         * </p>
         * <p>
         * <code>pending</code> - The metadata options are being updated and the instance is not ready to process
         * metadata traffic with the new selection.
         * </p>
         * <p>
         * <code>applied</code> - The metadata options have been successfully applied on the instance.
         * </p>
         * 
         * @param state
         *        The state of the metadata option changes.</p>
         *        <p>
         *        <code>pending</code> - The metadata options are being updated and the instance is not ready to process
         *        metadata traffic with the new selection.
         *        </p>
         *        <p>
         *        <code>applied</code> - The metadata options have been successfully applied on the instance.
         * @see InstanceMetadataOptionsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataOptionsState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the metadata option changes.
         * </p>
         * <p>
         * <code>pending</code> - The metadata options are being updated and the instance is not ready to process
         * metadata traffic with the new selection.
         * </p>
         * <p>
         * <code>applied</code> - The metadata options have been successfully applied on the instance.
         * </p>
         * 
         * @param state
         *        The state of the metadata option changes.</p>
         *        <p>
         *        <code>pending</code> - The metadata options are being updated and the instance is not ready to process
         *        metadata traffic with the new selection.
         *        </p>
         *        <p>
         *        <code>applied</code> - The metadata options have been successfully applied on the instance.
         * @see InstanceMetadataOptionsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataOptionsState
         */
        Builder state(InstanceMetadataOptionsState state);

        /**
         * <p>
         * The state of token usage for your instance metadata requests. If the parameter is not specified in the
         * request, the default state is <code>optional</code>.
         * </p>
         * <p>
         * If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed
         * token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role
         * credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version
         * 2.0 role credentials are returned.
         * </p>
         * <p>
         * If the state is <code>required</code>, you must send a signed token header with any instance metadata
         * retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
         * credentials; the version 1.0 credentials are not available.
         * </p>
         * 
         * @param httpTokens
         *        The state of token usage for your instance metadata requests. If the parameter is not specified in the
         *        request, the default state is <code>optional</code>.</p>
         *        <p>
         *        If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a
         *        signed token header on your request. If you retrieve the IAM role credentials without a token, the
         *        version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid
         *        signed token, the version 2.0 role credentials are returned.
         *        </p>
         *        <p>
         *        If the state is <code>required</code>, you must send a signed token header with any instance metadata
         *        retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
         *        credentials; the version 1.0 credentials are not available.
         * @see HttpTokensState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpTokensState
         */
        Builder httpTokens(String httpTokens);

        /**
         * <p>
         * The state of token usage for your instance metadata requests. If the parameter is not specified in the
         * request, the default state is <code>optional</code>.
         * </p>
         * <p>
         * If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed
         * token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role
         * credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version
         * 2.0 role credentials are returned.
         * </p>
         * <p>
         * If the state is <code>required</code>, you must send a signed token header with any instance metadata
         * retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
         * credentials; the version 1.0 credentials are not available.
         * </p>
         * 
         * @param httpTokens
         *        The state of token usage for your instance metadata requests. If the parameter is not specified in the
         *        request, the default state is <code>optional</code>.</p>
         *        <p>
         *        If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a
         *        signed token header on your request. If you retrieve the IAM role credentials without a token, the
         *        version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid
         *        signed token, the version 2.0 role credentials are returned.
         *        </p>
         *        <p>
         *        If the state is <code>required</code>, you must send a signed token header with any instance metadata
         *        retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
         *        credentials; the version 1.0 credentials are not available.
         * @see HttpTokensState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpTokensState
         */
        Builder httpTokens(HttpTokensState httpTokens);

        /**
         * <p>
         * The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further
         * instance metadata requests can travel.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Possible values: Integers from 1 to 64
         * </p>
         * 
         * @param httpPutResponseHopLimit
         *        The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the
         *        further instance metadata requests can travel.</p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Possible values: Integers from 1 to 64
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit);

        /**
         * <p>
         * This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not
         * specified, the default state is <code>enabled</code>.
         * </p>
         * <note>
         * <p>
         * If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.
         * </p>
         * </note>
         * 
         * @param httpEndpoint
         *        This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is
         *        not specified, the default state is <code>enabled</code>.</p> <note>
         *        <p>
         *        If you specify a value of <code>disabled</code>, you will not be able to access your instance
         *        metadata.
         *        </p>
         * @see InstanceMetadataEndpointState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataEndpointState
         */
        Builder httpEndpoint(String httpEndpoint);

        /**
         * <p>
         * This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not
         * specified, the default state is <code>enabled</code>.
         * </p>
         * <note>
         * <p>
         * If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.
         * </p>
         * </note>
         * 
         * @param httpEndpoint
         *        This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is
         *        not specified, the default state is <code>enabled</code>.</p> <note>
         *        <p>
         *        If you specify a value of <code>disabled</code>, you will not be able to access your instance
         *        metadata.
         *        </p>
         * @see InstanceMetadataEndpointState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataEndpointState
         */
        Builder httpEndpoint(InstanceMetadataEndpointState httpEndpoint);

        /**
         * <p>
         * Whether or not the IPv6 endpoint for the instance metadata service is enabled or disabled.
         * </p>
         * 
         * @param httpProtocolIpv6
         *        Whether or not the IPv6 endpoint for the instance metadata service is enabled or disabled.
         * @see InstanceMetadataProtocolState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataProtocolState
         */
        Builder httpProtocolIpv6(String httpProtocolIpv6);

        /**
         * <p>
         * Whether or not the IPv6 endpoint for the instance metadata service is enabled or disabled.
         * </p>
         * 
         * @param httpProtocolIpv6
         *        Whether or not the IPv6 endpoint for the instance metadata service is enabled or disabled.
         * @see InstanceMetadataProtocolState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataProtocolState
         */
        Builder httpProtocolIpv6(InstanceMetadataProtocolState httpProtocolIpv6);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String httpTokens;

        private Integer httpPutResponseHopLimit;

        private String httpEndpoint;

        private String httpProtocolIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadataOptionsResponse model) {
            state(model.state);
            httpTokens(model.httpTokens);
            httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            httpEndpoint(model.httpEndpoint);
            httpProtocolIpv6(model.httpProtocolIpv6);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(InstanceMetadataOptionsState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getHttpTokens() {
            return httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        @Transient
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        @Transient
        public final Builder httpTokens(HttpTokensState httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        @Transient
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpEndpoint() {
            return httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        @Transient
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        @Transient
        public final Builder httpEndpoint(InstanceMetadataEndpointState httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final String getHttpProtocolIpv6() {
            return httpProtocolIpv6;
        }

        public final void setHttpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
        }

        @Override
        @Transient
        public final Builder httpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        @Override
        @Transient
        public final Builder httpProtocolIpv6(InstanceMetadataProtocolState httpProtocolIpv6) {
            this.httpProtocolIpv6(httpProtocolIpv6 == null ? null : httpProtocolIpv6.toString());
            return this;
        }

        @Override
        public InstanceMetadataOptionsResponse build() {
            return new InstanceMetadataOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
