/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a request to purchase Scheduled Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseRequest implements SdkPojo, Serializable, ToCopyableBuilder<PurchaseRequest.Builder, PurchaseRequest> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(PurchaseRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final SdkField<String> PURCHASE_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PurchaseToken")
            .getter(getter(PurchaseRequest::purchaseToken))
            .setter(setter(Builder::purchaseToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseToken")
                    .unmarshallLocationName("PurchaseToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            PURCHASE_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instanceCount;

    private final String purchaseToken;

    private PurchaseRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.purchaseToken = builder.purchaseToken;
    }

    /**
     * <p>
     * The number of instances.
     * </p>
     * 
     * @return The number of instances.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The purchase token.
     * </p>
     * 
     * @return The purchase token.
     */
    public final String purchaseToken() {
        return purchaseToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseRequest)) {
            return false;
        }
        PurchaseRequest other = (PurchaseRequest) obj;
        return Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(purchaseToken(), other.purchaseToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseRequest").add("InstanceCount", instanceCount()).add("PurchaseToken", purchaseToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "PurchaseToken":
            return Optional.ofNullable(clazz.cast(purchaseToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseRequest, T> g) {
        return obj -> g.apply((PurchaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PurchaseRequest> {
        /**
         * <p>
         * The number of instances.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The purchase token.
         * </p>
         * 
         * @param purchaseToken
         *        The purchase token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseToken(String purchaseToken);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String purchaseToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseRequest model) {
            instanceCount(model.instanceCount);
            purchaseToken(model.purchaseToken);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        @Transient
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getPurchaseToken() {
            return purchaseToken;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        @Override
        @Transient
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        @Override
        public PurchaseRequest build() {
            return new PurchaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
