/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelReservedInstancesListingRequest extends Ec2Request implements
        ToCopyableBuilder<CancelReservedInstancesListingRequest.Builder, CancelReservedInstancesListingRequest> {
    private static final SdkField<String> RESERVED_INSTANCES_LISTING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesListingId")
            .getter(getter(CancelReservedInstancesListingRequest::reservedInstancesListingId))
            .setter(setter(Builder::reservedInstancesListingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesListingId")
                    .unmarshallLocationName("reservedInstancesListingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESERVED_INSTANCES_LISTING_ID_FIELD));

    private final String reservedInstancesListingId;

    private CancelReservedInstancesListingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
    }

    /**
     * <p>
     * The ID of the Reserved Instance listing.
     * </p>
     * 
     * @return The ID of the Reserved Instance listing.
     */
    public final String reservedInstancesListingId() {
        return reservedInstancesListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesListingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelReservedInstancesListingRequest)) {
            return false;
        }
        CancelReservedInstancesListingRequest other = (CancelReservedInstancesListingRequest) obj;
        return Objects.equals(reservedInstancesListingId(), other.reservedInstancesListingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelReservedInstancesListingRequest")
                .add("ReservedInstancesListingId", reservedInstancesListingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesListingId":
            return Optional.ofNullable(clazz.cast(reservedInstancesListingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelReservedInstancesListingRequest, T> g) {
        return obj -> g.apply((CancelReservedInstancesListingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CancelReservedInstancesListingRequest> {
        /**
         * <p>
         * The ID of the Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListingId
         *        The ID of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListingId(String reservedInstancesListingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String reservedInstancesListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelReservedInstancesListingRequest model) {
            super(model);
            reservedInstancesListingId(model.reservedInstancesListingId);
        }

        public final String getReservedInstancesListingId() {
            return reservedInstancesListingId;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        @Override
        @Transient
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelReservedInstancesListingRequest build() {
            return new CancelReservedInstancesListingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
