/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Capacity Reservation Fleet that was successfully cancelled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationFleetCancellationState implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationFleetCancellationState.Builder, CapacityReservationFleetCancellationState> {
    private static final SdkField<String> CURRENT_FLEET_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentFleetState")
            .getter(getter(CapacityReservationFleetCancellationState::currentFleetStateAsString))
            .setter(setter(Builder::currentFleetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFleetState")
                    .unmarshallLocationName("currentFleetState").build()).build();

    private static final SdkField<String> PREVIOUS_FLEET_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreviousFleetState")
            .getter(getter(CapacityReservationFleetCancellationState::previousFleetStateAsString))
            .setter(setter(Builder::previousFleetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousFleetState")
                    .unmarshallLocationName("previousFleetState").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationFleetId")
            .getter(getter(CapacityReservationFleetCancellationState::capacityReservationFleetId))
            .setter(setter(Builder::capacityReservationFleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetId")
                    .unmarshallLocationName("capacityReservationFleetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FLEET_STATE_FIELD,
            PREVIOUS_FLEET_STATE_FIELD, CAPACITY_RESERVATION_FLEET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currentFleetState;

    private final String previousFleetState;

    private final String capacityReservationFleetId;

    private CapacityReservationFleetCancellationState(BuilderImpl builder) {
        this.currentFleetState = builder.currentFleetState;
        this.previousFleetState = builder.previousFleetState;
        this.capacityReservationFleetId = builder.capacityReservationFleetId;
    }

    /**
     * <p>
     * The current state of the Capacity Reservation Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentFleetState}
     * will return {@link CapacityReservationFleetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #currentFleetStateAsString}.
     * </p>
     * 
     * @return The current state of the Capacity Reservation Fleet.
     * @see CapacityReservationFleetState
     */
    public final CapacityReservationFleetState currentFleetState() {
        return CapacityReservationFleetState.fromValue(currentFleetState);
    }

    /**
     * <p>
     * The current state of the Capacity Reservation Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentFleetState}
     * will return {@link CapacityReservationFleetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #currentFleetStateAsString}.
     * </p>
     * 
     * @return The current state of the Capacity Reservation Fleet.
     * @see CapacityReservationFleetState
     */
    public final String currentFleetStateAsString() {
        return currentFleetState;
    }

    /**
     * <p>
     * The previous state of the Capacity Reservation Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #previousFleetState} will return {@link CapacityReservationFleetState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #previousFleetStateAsString}.
     * </p>
     * 
     * @return The previous state of the Capacity Reservation Fleet.
     * @see CapacityReservationFleetState
     */
    public final CapacityReservationFleetState previousFleetState() {
        return CapacityReservationFleetState.fromValue(previousFleetState);
    }

    /**
     * <p>
     * The previous state of the Capacity Reservation Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #previousFleetState} will return {@link CapacityReservationFleetState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #previousFleetStateAsString}.
     * </p>
     * 
     * @return The previous state of the Capacity Reservation Fleet.
     * @see CapacityReservationFleetState
     */
    public final String previousFleetStateAsString() {
        return previousFleetState;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation Fleet that was successfully cancelled.
     * </p>
     * 
     * @return The ID of the Capacity Reservation Fleet that was successfully cancelled.
     */
    public final String capacityReservationFleetId() {
        return capacityReservationFleetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(previousFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationFleetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationFleetCancellationState)) {
            return false;
        }
        CapacityReservationFleetCancellationState other = (CapacityReservationFleetCancellationState) obj;
        return Objects.equals(currentFleetStateAsString(), other.currentFleetStateAsString())
                && Objects.equals(previousFleetStateAsString(), other.previousFleetStateAsString())
                && Objects.equals(capacityReservationFleetId(), other.capacityReservationFleetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityReservationFleetCancellationState")
                .add("CurrentFleetState", currentFleetStateAsString()).add("PreviousFleetState", previousFleetStateAsString())
                .add("CapacityReservationFleetId", capacityReservationFleetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentFleetState":
            return Optional.ofNullable(clazz.cast(currentFleetStateAsString()));
        case "PreviousFleetState":
            return Optional.ofNullable(clazz.cast(previousFleetStateAsString()));
        case "CapacityReservationFleetId":
            return Optional.ofNullable(clazz.cast(capacityReservationFleetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationFleetCancellationState, T> g) {
        return obj -> g.apply((CapacityReservationFleetCancellationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationFleetCancellationState> {
        /**
         * <p>
         * The current state of the Capacity Reservation Fleet.
         * </p>
         * 
         * @param currentFleetState
         *        The current state of the Capacity Reservation Fleet.
         * @see CapacityReservationFleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationFleetState
         */
        Builder currentFleetState(String currentFleetState);

        /**
         * <p>
         * The current state of the Capacity Reservation Fleet.
         * </p>
         * 
         * @param currentFleetState
         *        The current state of the Capacity Reservation Fleet.
         * @see CapacityReservationFleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationFleetState
         */
        Builder currentFleetState(CapacityReservationFleetState currentFleetState);

        /**
         * <p>
         * The previous state of the Capacity Reservation Fleet.
         * </p>
         * 
         * @param previousFleetState
         *        The previous state of the Capacity Reservation Fleet.
         * @see CapacityReservationFleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationFleetState
         */
        Builder previousFleetState(String previousFleetState);

        /**
         * <p>
         * The previous state of the Capacity Reservation Fleet.
         * </p>
         * 
         * @param previousFleetState
         *        The previous state of the Capacity Reservation Fleet.
         * @see CapacityReservationFleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationFleetState
         */
        Builder previousFleetState(CapacityReservationFleetState previousFleetState);

        /**
         * <p>
         * The ID of the Capacity Reservation Fleet that was successfully cancelled.
         * </p>
         * 
         * @param capacityReservationFleetId
         *        The ID of the Capacity Reservation Fleet that was successfully cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationFleetId(String capacityReservationFleetId);
    }

    static final class BuilderImpl implements Builder {
        private String currentFleetState;

        private String previousFleetState;

        private String capacityReservationFleetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationFleetCancellationState model) {
            currentFleetState(model.currentFleetState);
            previousFleetState(model.previousFleetState);
            capacityReservationFleetId(model.capacityReservationFleetId);
        }

        public final String getCurrentFleetState() {
            return currentFleetState;
        }

        public final void setCurrentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
        }

        @Override
        @Transient
        public final Builder currentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
            return this;
        }

        @Override
        @Transient
        public final Builder currentFleetState(CapacityReservationFleetState currentFleetState) {
            this.currentFleetState(currentFleetState == null ? null : currentFleetState.toString());
            return this;
        }

        public final String getPreviousFleetState() {
            return previousFleetState;
        }

        public final void setPreviousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
        }

        @Override
        @Transient
        public final Builder previousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
            return this;
        }

        @Override
        @Transient
        public final Builder previousFleetState(CapacityReservationFleetState previousFleetState) {
            this.previousFleetState(previousFleetState == null ? null : previousFleetState.toString());
            return this;
        }

        public final String getCapacityReservationFleetId() {
            return capacityReservationFleetId;
        }

        public final void setCapacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
        }

        @Override
        @Transient
        public final Builder capacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
            return this;
        }

        @Override
        public CapacityReservationFleetCancellationState build() {
            return new CapacityReservationFleetCancellationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
