/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocalGatewayRouteRequest extends Ec2Request implements
        ToCopyableBuilder<CreateLocalGatewayRouteRequest.Builder, CreateLocalGatewayRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(CreateLocalGatewayRouteRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("DestinationCidrBlock").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableId")
            .getter(getter(CreateLocalGatewayRouteRequest::localGatewayRouteTableId))
            .setter(setter(Builder::localGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId")
                    .unmarshallLocationName("LocalGatewayRouteTableId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceGroupId")
            .getter(getter(CreateLocalGatewayRouteRequest::localGatewayVirtualInterfaceGroupId))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupId")
                    .unmarshallLocationName("LocalGatewayVirtualInterfaceGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD,
            LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD));

    private final String destinationCidrBlock;

    private final String localGatewayRouteTableId;

    private final String localGatewayVirtualInterfaceGroupId;

    private CreateLocalGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
    }

    /**
     * <p>
     * The CIDR range used for destination matches. Routing decisions are based on the most specific match.
     * </p>
     * 
     * @return The CIDR range used for destination matches. Routing decisions are based on the most specific match.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The ID of the local gateway route table.
     * </p>
     * 
     * @return The ID of the local gateway route table.
     */
    public final String localGatewayRouteTableId() {
        return localGatewayRouteTableId;
    }

    /**
     * <p>
     * The ID of the virtual interface group.
     * </p>
     * 
     * @return The ID of the virtual interface group.
     */
    public final String localGatewayVirtualInterfaceGroupId() {
        return localGatewayVirtualInterfaceGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocalGatewayRouteRequest)) {
            return false;
        }
        CreateLocalGatewayRouteRequest other = (CreateLocalGatewayRouteRequest) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(localGatewayRouteTableId(), other.localGatewayRouteTableId())
                && Objects.equals(localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLocalGatewayRouteRequest").add("DestinationCidrBlock", destinationCidrBlock())
                .add("LocalGatewayRouteTableId", localGatewayRouteTableId())
                .add("LocalGatewayVirtualInterfaceGroupId", localGatewayVirtualInterfaceGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "LocalGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableId()));
        case "LocalGatewayVirtualInterfaceGroupId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocalGatewayRouteRequest, T> g) {
        return obj -> g.apply((CreateLocalGatewayRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocalGatewayRouteRequest> {
        /**
         * <p>
         * The CIDR range used for destination matches. Routing decisions are based on the most specific match.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The CIDR range used for destination matches. Routing decisions are based on the most specific match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The ID of the local gateway route table.
         * </p>
         * 
         * @param localGatewayRouteTableId
         *        The ID of the local gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableId(String localGatewayRouteTableId);

        /**
         * <p>
         * The ID of the virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupId
         *        The ID of the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String localGatewayRouteTableId;

        private String localGatewayVirtualInterfaceGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocalGatewayRouteRequest model) {
            super(model);
            destinationCidrBlock(model.destinationCidrBlock);
            localGatewayRouteTableId(model.localGatewayRouteTableId);
            localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        @Transient
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        @Transient
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocalGatewayRouteRequest build() {
            return new CreateLocalGatewayRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
