/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteManagedPrefixListResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteManagedPrefixListResponse.Builder, DeleteManagedPrefixListResponse> {
    private static final SdkField<ManagedPrefixList> PREFIX_LIST_FIELD = SdkField
            .<ManagedPrefixList> builder(MarshallingType.SDK_POJO)
            .memberName("PrefixList")
            .getter(getter(DeleteManagedPrefixListResponse::prefixList))
            .setter(setter(Builder::prefixList))
            .constructor(ManagedPrefixList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixList")
                    .unmarshallLocationName("prefixList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_FIELD));

    private final ManagedPrefixList prefixList;

    private DeleteManagedPrefixListResponse(BuilderImpl builder) {
        super(builder);
        this.prefixList = builder.prefixList;
    }

    /**
     * <p>
     * Information about the prefix list.
     * </p>
     * 
     * @return Information about the prefix list.
     */
    public final ManagedPrefixList prefixList() {
        return prefixList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(prefixList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteManagedPrefixListResponse)) {
            return false;
        }
        DeleteManagedPrefixListResponse other = (DeleteManagedPrefixListResponse) obj;
        return Objects.equals(prefixList(), other.prefixList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteManagedPrefixListResponse").add("PrefixList", prefixList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrefixList":
            return Optional.ofNullable(clazz.cast(prefixList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteManagedPrefixListResponse, T> g) {
        return obj -> g.apply((DeleteManagedPrefixListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteManagedPrefixListResponse> {
        /**
         * <p>
         * Information about the prefix list.
         * </p>
         * 
         * @param prefixList
         *        Information about the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixList(ManagedPrefixList prefixList);

        /**
         * <p>
         * Information about the prefix list.
         * </p>
         * This is a convenience that creates an instance of the {@link ManagedPrefixList.Builder} avoiding the need to
         * create one manually via {@link ManagedPrefixList#builder()}.
         *
         * When the {@link Consumer} completes, {@link ManagedPrefixList.Builder#build()} is called immediately and its
         * result is passed to {@link #prefixList(ManagedPrefixList)}.
         * 
         * @param prefixList
         *        a consumer that will call methods on {@link ManagedPrefixList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixList(ManagedPrefixList)
         */
        default Builder prefixList(Consumer<ManagedPrefixList.Builder> prefixList) {
            return prefixList(ManagedPrefixList.builder().applyMutation(prefixList).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private ManagedPrefixList prefixList;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteManagedPrefixListResponse model) {
            super(model);
            prefixList(model.prefixList);
        }

        public final ManagedPrefixList.Builder getPrefixList() {
            return prefixList != null ? prefixList.toBuilder() : null;
        }

        public final void setPrefixList(ManagedPrefixList.BuilderImpl prefixList) {
            this.prefixList = prefixList != null ? prefixList.build() : null;
        }

        @Override
        @Transient
        public final Builder prefixList(ManagedPrefixList prefixList) {
            this.prefixList = prefixList;
            return this;
        }

        @Override
        public DeleteManagedPrefixListResponse build() {
            return new DeleteManagedPrefixListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
