/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcClassicLinkDnsSupportResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcClassicLinkDnsSupportResponse.Builder, DescribeVpcClassicLinkDnsSupportResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVpcClassicLinkDnsSupportResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<ClassicLinkDnsSupport>> VPCS_FIELD = SdkField
            .<List<ClassicLinkDnsSupport>> builder(MarshallingType.LIST)
            .memberName("Vpcs")
            .getter(getter(DescribeVpcClassicLinkDnsSupportResponse::vpcs))
            .setter(setter(Builder::vpcs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpcs")
                    .unmarshallLocationName("vpcs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ClassicLinkDnsSupport> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClassicLinkDnsSupport::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VPCS_FIELD));

    private final String nextToken;

    private final List<ClassicLinkDnsSupport> vpcs;

    private DescribeVpcClassicLinkDnsSupportResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vpcs = builder.vpcs;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vpcs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasVpcs() {
        return vpcs != null && !(vpcs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the ClassicLink DNS support status of the VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcs} method.
     * </p>
     * 
     * @return Information about the ClassicLink DNS support status of the VPCs.
     */
    public final List<ClassicLinkDnsSupport> vpcs() {
        return vpcs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcs() ? vpcs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkDnsSupportResponse)) {
            return false;
        }
        DescribeVpcClassicLinkDnsSupportResponse other = (DescribeVpcClassicLinkDnsSupportResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVpcs() == other.hasVpcs()
                && Objects.equals(vpcs(), other.vpcs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpcClassicLinkDnsSupportResponse").add("NextToken", nextToken())
                .add("Vpcs", hasVpcs() ? vpcs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Vpcs":
            return Optional.ofNullable(clazz.cast(vpcs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcClassicLinkDnsSupportResponse, T> g) {
        return obj -> g.apply((DescribeVpcClassicLinkDnsSupportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the ClassicLink DNS support status of the VPCs.
         * </p>
         * 
         * @param vpcs
         *        Information about the ClassicLink DNS support status of the VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(Collection<ClassicLinkDnsSupport> vpcs);

        /**
         * <p>
         * Information about the ClassicLink DNS support status of the VPCs.
         * </p>
         * 
         * @param vpcs
         *        Information about the ClassicLink DNS support status of the VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(ClassicLinkDnsSupport... vpcs);

        /**
         * <p>
         * Information about the ClassicLink DNS support status of the VPCs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClassicLinkDnsSupport>.Builder} avoiding
         * the need to create one manually via {@link List<ClassicLinkDnsSupport>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClassicLinkDnsSupport>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcs(List<ClassicLinkDnsSupport>)}.
         * 
         * @param vpcs
         *        a consumer that will call methods on {@link List<ClassicLinkDnsSupport>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcs(List<ClassicLinkDnsSupport>)
         */
        Builder vpcs(Consumer<ClassicLinkDnsSupport.Builder>... vpcs);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<ClassicLinkDnsSupport> vpcs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkDnsSupportResponse model) {
            super(model);
            nextToken(model.nextToken);
            vpcs(model.vpcs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClassicLinkDnsSupport.Builder> getVpcs() {
            List<ClassicLinkDnsSupport.Builder> result = ClassicLinkDnsSupportListCopier.copyToBuilder(this.vpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcs(Collection<ClassicLinkDnsSupport.BuilderImpl> vpcs) {
            this.vpcs = ClassicLinkDnsSupportListCopier.copyFromBuilder(vpcs);
        }

        @Override
        @Transient
        public final Builder vpcs(Collection<ClassicLinkDnsSupport> vpcs) {
            this.vpcs = ClassicLinkDnsSupportListCopier.copy(vpcs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcs(ClassicLinkDnsSupport... vpcs) {
            vpcs(Arrays.asList(vpcs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcs(Consumer<ClassicLinkDnsSupport.Builder>... vpcs) {
            vpcs(Stream.of(vpcs).map(c -> ClassicLinkDnsSupport.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVpcClassicLinkDnsSupportResponse build() {
            return new DescribeVpcClassicLinkDnsSupportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
