/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpnConnections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpnConnectionsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpnConnectionsResponse.Builder, DescribeVpnConnectionsResponse> {
    private static final SdkField<List<VpnConnection>> VPN_CONNECTIONS_FIELD = SdkField
            .<List<VpnConnection>> builder(MarshallingType.LIST)
            .memberName("VpnConnections")
            .getter(getter(DescribeVpnConnectionsResponse::vpnConnections))
            .setter(setter(Builder::vpnConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionSet")
                    .unmarshallLocationName("vpnConnectionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpnConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpnConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTIONS_FIELD));

    private final List<VpnConnection> vpnConnections;

    private DescribeVpnConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpnConnections = builder.vpnConnections;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpnConnections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpnConnections() {
        return vpnConnections != null && !(vpnConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about one or more VPN connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpnConnections} method.
     * </p>
     * 
     * @return Information about one or more VPN connections.
     */
    public final List<VpnConnection> vpnConnections() {
        return vpnConnections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpnConnections() ? vpnConnections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsResponse)) {
            return false;
        }
        DescribeVpnConnectionsResponse other = (DescribeVpnConnectionsResponse) obj;
        return hasVpnConnections() == other.hasVpnConnections() && Objects.equals(vpnConnections(), other.vpnConnections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpnConnectionsResponse")
                .add("VpnConnections", hasVpnConnections() ? vpnConnections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnections":
            return Optional.ofNullable(clazz.cast(vpnConnections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpnConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeVpnConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
        /**
         * <p>
         * Information about one or more VPN connections.
         * </p>
         * 
         * @param vpnConnections
         *        Information about one or more VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnections(Collection<VpnConnection> vpnConnections);

        /**
         * <p>
         * Information about one or more VPN connections.
         * </p>
         * 
         * @param vpnConnections
         *        Information about one or more VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnections(VpnConnection... vpnConnections);

        /**
         * <p>
         * Information about one or more VPN connections.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpnConnection>.Builder} avoiding the need
         * to create one manually via {@link List<VpnConnection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpnConnection>.Builder#build()} is called immediately and
         * its result is passed to {@link #vpnConnections(List<VpnConnection>)}.
         * 
         * @param vpnConnections
         *        a consumer that will call methods on {@link List<VpnConnection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnConnections(List<VpnConnection>)
         */
        Builder vpnConnections(Consumer<VpnConnection.Builder>... vpnConnections);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VpnConnection> vpnConnections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsResponse model) {
            super(model);
            vpnConnections(model.vpnConnections);
        }

        public final List<VpnConnection.Builder> getVpnConnections() {
            List<VpnConnection.Builder> result = VpnConnectionListCopier.copyToBuilder(this.vpnConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpnConnections(Collection<VpnConnection.BuilderImpl> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copyFromBuilder(vpnConnections);
        }

        @Override
        @Transient
        public final Builder vpnConnections(Collection<VpnConnection> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copy(vpnConnections);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpnConnections(VpnConnection... vpnConnections) {
            vpnConnections(Arrays.asList(vpnConnections));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpnConnections(Consumer<VpnConnection.Builder>... vpnConnections) {
            vpnConnections(Stream.of(vpnConnections).map(c -> VpnConnection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVpnConnectionsResponse build() {
            return new DescribeVpnConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
