/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableImageDeprecationRequest extends Ec2Request implements
        ToCopyableBuilder<EnableImageDeprecationRequest.Builder, EnableImageDeprecationRequest> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(EnableImageDeprecationRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<Instant> DEPRECATE_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeprecateAt")
            .getter(getter(EnableImageDeprecationRequest::deprecateAt))
            .setter(setter(Builder::deprecateAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecateAt")
                    .unmarshallLocationName("DeprecateAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD,
            DEPRECATE_AT_FIELD));

    private final String imageId;

    private final Instant deprecateAt;

    private EnableImageDeprecationRequest(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.deprecateAt = builder.deprecateAt;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The date and time to deprecate the AMI, in UTC, in the following format:
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z. If you specify a value for seconds, Amazon EC2
     * rounds the seconds to the nearest minute.
     * </p>
     * <p>
     * You can’t specify a date in the past. The upper limit for <code>DeprecateAt</code> is 10 years from now.
     * </p>
     * 
     * @return The date and time to deprecate the AMI, in UTC, in the following format:
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z. If you specify a value for seconds,
     *         Amazon EC2 rounds the seconds to the nearest minute.</p>
     *         <p>
     *         You can’t specify a date in the past. The upper limit for <code>DeprecateAt</code> is 10 years from now.
     */
    public final Instant deprecateAt() {
        return deprecateAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(deprecateAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableImageDeprecationRequest)) {
            return false;
        }
        EnableImageDeprecationRequest other = (EnableImageDeprecationRequest) obj;
        return Objects.equals(imageId(), other.imageId()) && Objects.equals(deprecateAt(), other.deprecateAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableImageDeprecationRequest").add("ImageId", imageId()).add("DeprecateAt", deprecateAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "DeprecateAt":
            return Optional.ofNullable(clazz.cast(deprecateAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableImageDeprecationRequest, T> g) {
        return obj -> g.apply((EnableImageDeprecationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, EnableImageDeprecationRequest> {
        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The date and time to deprecate the AMI, in UTC, in the following format:
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z. If you specify a value for seconds, Amazon
         * EC2 rounds the seconds to the nearest minute.
         * </p>
         * <p>
         * You can’t specify a date in the past. The upper limit for <code>DeprecateAt</code> is 10 years from now.
         * </p>
         * 
         * @param deprecateAt
         *        The date and time to deprecate the AMI, in UTC, in the following format:
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z. If you specify a value for seconds,
         *        Amazon EC2 rounds the seconds to the nearest minute.</p>
         *        <p>
         *        You can’t specify a date in the past. The upper limit for <code>DeprecateAt</code> is 10 years from
         *        now.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecateAt(Instant deprecateAt);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String imageId;

        private Instant deprecateAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableImageDeprecationRequest model) {
            super(model);
            imageId(model.imageId);
            deprecateAt(model.deprecateAt);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Transient
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Instant getDeprecateAt() {
            return deprecateAt;
        }

        public final void setDeprecateAt(Instant deprecateAt) {
            this.deprecateAt = deprecateAt;
        }

        @Override
        @Transient
        public final Builder deprecateAt(Instant deprecateAt) {
            this.deprecateAt = deprecateAt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableImageDeprecationRequest build() {
            return new EnableImageDeprecationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
