/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of the event window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceEventWindowStateChange implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceEventWindowStateChange.Builder, InstanceEventWindowStateChange> {
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceEventWindowId")
            .getter(getter(InstanceEventWindowStateChange::instanceEventWindowId))
            .setter(setter(Builder::instanceEventWindowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId")
                    .unmarshallLocationName("instanceEventWindowId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(InstanceEventWindowStateChange::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INSTANCE_EVENT_WINDOW_ID_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceEventWindowId;

    private final String state;

    private InstanceEventWindowStateChange(BuilderImpl builder) {
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the event window.
     * </p>
     * 
     * @return The ID of the event window.
     */
    public final String instanceEventWindowId() {
        return instanceEventWindowId;
    }

    /**
     * <p>
     * The current state of the event window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceEventWindowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the event window.
     * @see InstanceEventWindowState
     */
    public final InstanceEventWindowState state() {
        return InstanceEventWindowState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the event window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceEventWindowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the event window.
     * @see InstanceEventWindowState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEventWindowStateChange)) {
            return false;
        }
        InstanceEventWindowStateChange other = (InstanceEventWindowStateChange) obj;
        return Objects.equals(instanceEventWindowId(), other.instanceEventWindowId())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceEventWindowStateChange").add("InstanceEventWindowId", instanceEventWindowId())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceEventWindowId":
            return Optional.ofNullable(clazz.cast(instanceEventWindowId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceEventWindowStateChange, T> g) {
        return obj -> g.apply((InstanceEventWindowStateChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceEventWindowStateChange> {
        /**
         * <p>
         * The ID of the event window.
         * </p>
         * 
         * @param instanceEventWindowId
         *        The ID of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceEventWindowId(String instanceEventWindowId);

        /**
         * <p>
         * The current state of the event window.
         * </p>
         * 
         * @param state
         *        The current state of the event window.
         * @see InstanceEventWindowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceEventWindowState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the event window.
         * </p>
         * 
         * @param state
         *        The current state of the event window.
         * @see InstanceEventWindowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceEventWindowState
         */
        Builder state(InstanceEventWindowState state);
    }

    static final class BuilderImpl implements Builder {
        private String instanceEventWindowId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEventWindowStateChange model) {
            instanceEventWindowId(model.instanceEventWindowId);
            state(model.state);
        }

        public final String getInstanceEventWindowId() {
            return instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        @Transient
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(InstanceEventWindowState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public InstanceEventWindowStateChange build() {
            return new InstanceEventWindowStateChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
