/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for Spot Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotMarketOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotMarketOptions.Builder, SpotMarketOptions> {
    private static final SdkField<String> MAX_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxPrice")
            .getter(getter(SpotMarketOptions::maxPrice))
            .setter(setter(Builder::maxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice")
                    .unmarshallLocationName("MaxPrice").build()).build();

    private static final SdkField<String> SPOT_INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotInstanceType")
            .getter(getter(SpotMarketOptions::spotInstanceTypeAsString))
            .setter(setter(Builder::spotInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceType")
                    .unmarshallLocationName("SpotInstanceType").build()).build();

    private static final SdkField<Integer> BLOCK_DURATION_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockDurationMinutes")
            .getter(getter(SpotMarketOptions::blockDurationMinutes))
            .setter(setter(Builder::blockDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDurationMinutes")
                    .unmarshallLocationName("BlockDurationMinutes").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidUntil")
            .getter(getter(SpotMarketOptions::validUntil))
            .setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil")
                    .unmarshallLocationName("ValidUntil").build()).build();

    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceInterruptionBehavior")
            .getter(getter(SpotMarketOptions::instanceInterruptionBehaviorAsString))
            .setter(setter(Builder::instanceInterruptionBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior")
                    .unmarshallLocationName("InstanceInterruptionBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_PRICE_FIELD,
            SPOT_INSTANCE_TYPE_FIELD, BLOCK_DURATION_MINUTES_FIELD, VALID_UNTIL_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String maxPrice;

    private final String spotInstanceType;

    private final Integer blockDurationMinutes;

    private final Instant validUntil;

    private final String instanceInterruptionBehavior;

    private SpotMarketOptions(BuilderImpl builder) {
        this.maxPrice = builder.maxPrice;
        this.spotInstanceType = builder.spotInstanceType;
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.validUntil = builder.validUntil;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
    }

    /**
     * <p>
     * The maximum hourly price you're willing to pay for the Spot Instances. The default is the On-Demand price.
     * </p>
     * 
     * @return The maximum hourly price you're willing to pay for the Spot Instances. The default is the On-Demand
     *         price.
     */
    public final String maxPrice() {
        return maxPrice;
    }

    /**
     * <p>
     * The Spot Instance request type. For <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent Spot
     * Instance requests are only supported when the instance interruption behavior is either <code>hibernate</code> or
     * <code>stop</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spotInstanceType}
     * will return {@link SpotInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #spotInstanceTypeAsString}.
     * </p>
     * 
     * @return The Spot Instance request type. For <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>,
     *         persistent Spot Instance requests are only supported when the instance interruption behavior is either
     *         <code>hibernate</code> or <code>stop</code>.
     * @see SpotInstanceType
     */
    public final SpotInstanceType spotInstanceType() {
        return SpotInstanceType.fromValue(spotInstanceType);
    }

    /**
     * <p>
     * The Spot Instance request type. For <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent Spot
     * Instance requests are only supported when the instance interruption behavior is either <code>hibernate</code> or
     * <code>stop</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spotInstanceType}
     * will return {@link SpotInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #spotInstanceTypeAsString}.
     * </p>
     * 
     * @return The Spot Instance request type. For <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>,
     *         persistent Spot Instance requests are only supported when the instance interruption behavior is either
     *         <code>hibernate</code> or <code>stop</code>.
     * @see SpotInstanceType
     */
    public final String spotInstanceTypeAsString() {
        return spotInstanceType;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public final Integer blockDurationMinutes() {
        return blockDurationMinutes;
    }

    /**
     * <p>
     * The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * Supported only for persistent requests.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached.
     * Otherwise, the request remains active until you cancel it.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances
     * launch or you cancel the request.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The end date of the request, in UTC format
     *         (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). Supported only for persistent
     *         requests.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is
     *         reached. Otherwise, the request remains active until you cancel it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all
     *         instances launch or you cancel the request.
     *         </p>
     *         </li>
     */
    public final Instant validUntil() {
        return validUntil;
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * @see InstanceInterruptionBehavior
     */
    public final InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(instanceInterruptionBehavior);
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * @see InstanceInterruptionBehavior
     */
    public final String instanceInterruptionBehaviorAsString() {
        return instanceInterruptionBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInterruptionBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotMarketOptions)) {
            return false;
        }
        SpotMarketOptions other = (SpotMarketOptions) obj;
        return Objects.equals(maxPrice(), other.maxPrice())
                && Objects.equals(spotInstanceTypeAsString(), other.spotInstanceTypeAsString())
                && Objects.equals(blockDurationMinutes(), other.blockDurationMinutes())
                && Objects.equals(validUntil(), other.validUntil())
                && Objects.equals(instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotMarketOptions").add("MaxPrice", maxPrice())
                .add("SpotInstanceType", spotInstanceTypeAsString()).add("BlockDurationMinutes", blockDurationMinutes())
                .add("ValidUntil", validUntil()).add("InstanceInterruptionBehavior", instanceInterruptionBehaviorAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxPrice":
            return Optional.ofNullable(clazz.cast(maxPrice()));
        case "SpotInstanceType":
            return Optional.ofNullable(clazz.cast(spotInstanceTypeAsString()));
        case "BlockDurationMinutes":
            return Optional.ofNullable(clazz.cast(blockDurationMinutes()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        case "InstanceInterruptionBehavior":
            return Optional.ofNullable(clazz.cast(instanceInterruptionBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotMarketOptions, T> g) {
        return obj -> g.apply((SpotMarketOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotMarketOptions> {
        /**
         * <p>
         * The maximum hourly price you're willing to pay for the Spot Instances. The default is the On-Demand price.
         * </p>
         * 
         * @param maxPrice
         *        The maximum hourly price you're willing to pay for the Spot Instances. The default is the On-Demand
         *        price.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPrice(String maxPrice);

        /**
         * <p>
         * The Spot Instance request type. For <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent
         * Spot Instance requests are only supported when the instance interruption behavior is either
         * <code>hibernate</code> or <code>stop</code>.
         * </p>
         * 
         * @param spotInstanceType
         *        The Spot Instance request type. For <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>,
         *        persistent Spot Instance requests are only supported when the instance interruption behavior is either
         *        <code>hibernate</code> or <code>stop</code>.
         * @see SpotInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotInstanceType
         */
        Builder spotInstanceType(String spotInstanceType);

        /**
         * <p>
         * The Spot Instance request type. For <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent
         * Spot Instance requests are only supported when the instance interruption behavior is either
         * <code>hibernate</code> or <code>stop</code>.
         * </p>
         * 
         * @param spotInstanceType
         *        The Spot Instance request type. For <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>,
         *        persistent Spot Instance requests are only supported when the instance interruption behavior is either
         *        <code>hibernate</code> or <code>stop</code>.
         * @see SpotInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotInstanceType
         */
        Builder spotInstanceType(SpotInstanceType spotInstanceType);

        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param blockDurationMinutes
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDurationMinutes(Integer blockDurationMinutes);

        /**
         * <p>
         * The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * Supported only for persistent requests.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is
         * reached. Otherwise, the request remains active until you cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all
         * instances launch or you cancel the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param validUntil
         *        The end date of the request, in UTC format
         *        (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). Supported only for persistent
         *        requests.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For a persistent request, the request remains active until the <code>ValidUntil</code> date and time
         *        is reached. Otherwise, the request remains active until you cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all
         *        instances launch or you cancel the request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * @see InstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(String instanceInterruptionBehavior);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * @see InstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String maxPrice;

        private String spotInstanceType;

        private Integer blockDurationMinutes;

        private Instant validUntil;

        private String instanceInterruptionBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotMarketOptions model) {
            maxPrice(model.maxPrice);
            spotInstanceType(model.spotInstanceType);
            blockDurationMinutes(model.blockDurationMinutes);
            validUntil(model.validUntil);
            instanceInterruptionBehavior(model.instanceInterruptionBehavior);
        }

        public final String getMaxPrice() {
            return maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        @Transient
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getSpotInstanceType() {
            return spotInstanceType;
        }

        public final void setSpotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
        }

        @Override
        @Transient
        public final Builder spotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder spotInstanceType(SpotInstanceType spotInstanceType) {
            this.spotInstanceType(spotInstanceType == null ? null : spotInstanceType.toString());
            return this;
        }

        public final Integer getBlockDurationMinutes() {
            return blockDurationMinutes;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        @Override
        @Transient
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        @Transient
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final String getInstanceInterruptionBehavior() {
            return instanceInterruptionBehavior;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        @Override
        @Transient
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior == null ? null : instanceInterruptionBehavior
                    .toString());
            return this;
        }

        @Override
        public SpotMarketOptions build() {
            return new SpotMarketOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
