/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv4 CIDR block associated with a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcCidrBlockAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcCidrBlockAssociation.Builder, VpcCidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationId")
            .getter(getter(VpcCidrBlockAssociation::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("associationId").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(VpcCidrBlockAssociation::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("cidrBlock").build()).build();

    private static final SdkField<VpcCidrBlockState> CIDR_BLOCK_STATE_FIELD = SdkField
            .<VpcCidrBlockState> builder(MarshallingType.SDK_POJO)
            .memberName("CidrBlockState")
            .getter(getter(VpcCidrBlockAssociation::cidrBlockState))
            .setter(setter(Builder::cidrBlockState))
            .constructor(VpcCidrBlockState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockState")
                    .unmarshallLocationName("cidrBlockState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            CIDR_BLOCK_FIELD, CIDR_BLOCK_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String cidrBlock;

    private final VpcCidrBlockState cidrBlockState;

    private VpcCidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.cidrBlock = builder.cidrBlock;
        this.cidrBlockState = builder.cidrBlockState;
    }

    /**
     * <p>
     * The association ID for the IPv4 CIDR block.
     * </p>
     * 
     * @return The association ID for the IPv4 CIDR block.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The IPv4 CIDR block.
     * </p>
     * 
     * @return The IPv4 CIDR block.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Information about the state of the CIDR block.
     * </p>
     * 
     * @return Information about the state of the CIDR block.
     */
    public final VpcCidrBlockState cidrBlockState() {
        return cidrBlockState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlockState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcCidrBlockAssociation)) {
            return false;
        }
        VpcCidrBlockAssociation other = (VpcCidrBlockAssociation) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(cidrBlock(), other.cidrBlock())
                && Objects.equals(cidrBlockState(), other.cidrBlockState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcCidrBlockAssociation").add("AssociationId", associationId()).add("CidrBlock", cidrBlock())
                .add("CidrBlockState", cidrBlockState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "CidrBlockState":
            return Optional.ofNullable(clazz.cast(cidrBlockState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcCidrBlockAssociation, T> g) {
        return obj -> g.apply((VpcCidrBlockAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcCidrBlockAssociation> {
        /**
         * <p>
         * The association ID for the IPv4 CIDR block.
         * </p>
         * 
         * @param associationId
         *        The association ID for the IPv4 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The IPv4 CIDR block.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Information about the state of the CIDR block.
         * </p>
         * 
         * @param cidrBlockState
         *        Information about the state of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockState(VpcCidrBlockState cidrBlockState);

        /**
         * <p>
         * Information about the state of the CIDR block.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcCidrBlockState.Builder} avoiding the need to
         * create one manually via {@link VpcCidrBlockState#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcCidrBlockState.Builder#build()} is called immediately and its
         * result is passed to {@link #cidrBlockState(VpcCidrBlockState)}.
         * 
         * @param cidrBlockState
         *        a consumer that will call methods on {@link VpcCidrBlockState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlockState(VpcCidrBlockState)
         */
        default Builder cidrBlockState(Consumer<VpcCidrBlockState.Builder> cidrBlockState) {
            return cidrBlockState(VpcCidrBlockState.builder().applyMutation(cidrBlockState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String cidrBlock;

        private VpcCidrBlockState cidrBlockState;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcCidrBlockAssociation model) {
            associationId(model.associationId);
            cidrBlock(model.cidrBlock);
            cidrBlockState(model.cidrBlockState);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        @Transient
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final VpcCidrBlockState.Builder getCidrBlockState() {
            return cidrBlockState != null ? cidrBlockState.toBuilder() : null;
        }

        public final void setCidrBlockState(VpcCidrBlockState.BuilderImpl cidrBlockState) {
            this.cidrBlockState = cidrBlockState != null ? cidrBlockState.build() : null;
        }

        @Override
        @Transient
        public final Builder cidrBlockState(VpcCidrBlockState cidrBlockState) {
            this.cidrBlockState = cidrBlockState;
            return this;
        }

        @Override
        public VpcCidrBlockAssociation build() {
            return new VpcCidrBlockAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
