/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyFleetRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyFleetRequest.Builder, ModifyFleetRequest> {
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExcessCapacityTerminationPolicy")
            .getter(getter(ModifyFleetRequest::excessCapacityTerminationPolicyAsString))
            .setter(setter(Builder::excessCapacityTerminationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy")
                    .unmarshallLocationName("ExcessCapacityTerminationPolicy").build()).build();

    private static final SdkField<List<FleetLaunchTemplateConfigRequest>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField
            .<List<FleetLaunchTemplateConfigRequest>> builder(MarshallingType.LIST)
            .memberName("LaunchTemplateConfigs")
            .getter(getter(ModifyFleetRequest::launchTemplateConfigs))
            .setter(setter(Builder::launchTemplateConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfig")
                    .unmarshallLocationName("LaunchTemplateConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<FleetLaunchTemplateConfigRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetLaunchTemplateConfigRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FleetId")
            .getter(getter(ModifyFleetRequest::fleetId))
            .setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("FleetId").build()).build();

    private static final SdkField<TargetCapacitySpecificationRequest> TARGET_CAPACITY_SPECIFICATION_FIELD = SdkField
            .<TargetCapacitySpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("TargetCapacitySpecification")
            .getter(getter(ModifyFleetRequest::targetCapacitySpecification))
            .setter(setter(Builder::targetCapacitySpecification))
            .constructor(TargetCapacitySpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacitySpecification")
                    .unmarshallLocationName("TargetCapacitySpecification").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Context")
            .getter(getter(ModifyFleetRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context")
                    .unmarshallLocationName("Context").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, LAUNCH_TEMPLATE_CONFIGS_FIELD, FLEET_ID_FIELD,
            TARGET_CAPACITY_SPECIFICATION_FIELD, CONTEXT_FIELD));

    private final String excessCapacityTerminationPolicy;

    private final List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs;

    private final String fleetId;

    private final TargetCapacitySpecificationRequest targetCapacitySpecification;

    private final String context;

    private ModifyFleetRequest(BuilderImpl builder) {
        super(builder);
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.fleetId = builder.fleetId;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
        this.context = builder.context;
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     * decreased below the current size of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link FleetExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     *         decreased below the current size of the EC2 Fleet.
     * @see FleetExcessCapacityTerminationPolicy
     */
    public final FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     * decreased below the current size of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link FleetExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     *         decreased below the current size of the EC2 Fleet.
     * @see FleetExcessCapacityTerminationPolicy
     */
    public final String excessCapacityTerminationPolicyAsString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * Returns true if the LaunchTemplateConfigs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLaunchTemplateConfigs() {
        return launchTemplateConfigs != null && !(launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The launch template and overrides.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchTemplateConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The launch template and overrides.
     */
    public final List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs() {
        return launchTemplateConfigs;
    }

    /**
     * <p>
     * The ID of the EC2 Fleet.
     * </p>
     * 
     * @return The ID of the EC2 Fleet.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The size of the EC2 Fleet.
     * </p>
     * 
     * @return The size of the EC2 Fleet.
     */
    public final TargetCapacitySpecificationRequest targetCapacitySpecification() {
        return targetCapacitySpecification;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String context() {
        return context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchTemplateConfigs() ? launchTemplateConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFleetRequest)) {
            return false;
        }
        ModifyFleetRequest other = (ModifyFleetRequest) obj;
        return Objects.equals(excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString())
                && hasLaunchTemplateConfigs() == other.hasLaunchTemplateConfigs()
                && Objects.equals(launchTemplateConfigs(), other.launchTemplateConfigs())
                && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(targetCapacitySpecification(), other.targetCapacitySpecification())
                && Objects.equals(context(), other.context());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyFleetRequest")
                .add("ExcessCapacityTerminationPolicy", excessCapacityTerminationPolicyAsString())
                .add("LaunchTemplateConfigs", hasLaunchTemplateConfigs() ? launchTemplateConfigs() : null)
                .add("FleetId", fleetId()).add("TargetCapacitySpecification", targetCapacitySpecification())
                .add("Context", context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcessCapacityTerminationPolicy":
            return Optional.ofNullable(clazz.cast(excessCapacityTerminationPolicyAsString()));
        case "LaunchTemplateConfigs":
            return Optional.ofNullable(clazz.cast(launchTemplateConfigs()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "TargetCapacitySpecification":
            return Optional.ofNullable(clazz.cast(targetCapacitySpecification()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyFleetRequest, T> g) {
        return obj -> g.apply((ModifyFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyFleetRequest> {
        /**
         * <p>
         * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
         * decreased below the current size of the EC2 Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet
         *        is decreased below the current size of the EC2 Fleet.
         * @see FleetExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
         * decreased below the current size of the EC2 Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet
         *        is decreased below the current size of the EC2 Fleet.
         * @see FleetExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The launch template and overrides.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(FleetLaunchTemplateConfigRequest... launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FleetLaunchTemplateConfigRequest>.Builder}
         * avoiding the need to create one manually via {@link List<FleetLaunchTemplateConfigRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FleetLaunchTemplateConfigRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #launchTemplateConfigs(List<FleetLaunchTemplateConfigRequest>)}.
         * 
         * @param launchTemplateConfigs
         *        a consumer that will call methods on {@link List<FleetLaunchTemplateConfigRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateConfigs(List<FleetLaunchTemplateConfigRequest>)
         */
        Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfigRequest.Builder>... launchTemplateConfigs);

        /**
         * <p>
         * The ID of the EC2 Fleet.
         * </p>
         * 
         * @param fleetId
         *        The ID of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The size of the EC2 Fleet.
         * </p>
         * 
         * @param targetCapacitySpecification
         *        The size of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification);

        /**
         * <p>
         * The size of the EC2 Fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetCapacitySpecificationRequest.Builder}
         * avoiding the need to create one manually via {@link TargetCapacitySpecificationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetCapacitySpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #targetCapacitySpecification(TargetCapacitySpecificationRequest)}.
         * 
         * @param targetCapacitySpecification
         *        a consumer that will call methods on {@link TargetCapacitySpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetCapacitySpecification(TargetCapacitySpecificationRequest)
         */
        default Builder targetCapacitySpecification(
                Consumer<TargetCapacitySpecificationRequest.Builder> targetCapacitySpecification) {
            return targetCapacitySpecification(TargetCapacitySpecificationRequest.builder()
                    .applyMutation(targetCapacitySpecification).build());
        }

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param context
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String excessCapacityTerminationPolicy;

        private List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();

        private String fleetId;

        private TargetCapacitySpecificationRequest targetCapacitySpecification;

        private String context;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyFleetRequest model) {
            super(model);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            launchTemplateConfigs(model.launchTemplateConfigs);
            fleetId(model.fleetId);
            targetCapacitySpecification(model.targetCapacitySpecification);
            context(model.context);
        }

        public final String getExcessCapacityTerminationPolicy() {
            return excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy
                    .toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final List<FleetLaunchTemplateConfigRequest.Builder> getLaunchTemplateConfigs() {
            List<FleetLaunchTemplateConfigRequest.Builder> result = FleetLaunchTemplateConfigListRequestCopier
                    .copyToBuilder(this.launchTemplateConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListRequestCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(FleetLaunchTemplateConfigRequest... launchTemplateConfigs) {
            launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfigRequest.Builder>... launchTemplateConfigs) {
            launchTemplateConfigs(Stream.of(launchTemplateConfigs)
                    .map(c -> FleetLaunchTemplateConfigRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListRequestCopier.copyFromBuilder(launchTemplateConfigs);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final TargetCapacitySpecificationRequest.Builder getTargetCapacitySpecification() {
            return targetCapacitySpecification != null ? targetCapacitySpecification.toBuilder() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final void setTargetCapacitySpecification(
                TargetCapacitySpecificationRequest.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        public final String getContext() {
            return context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyFleetRequest build() {
            return new ModifyFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
