/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<NetworkInterfaceAssociation> ASSOCIATION_FIELD = SdkField
            .<NetworkInterfaceAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("Association")
            .getter(getter(NetworkInterface::association))
            .setter(setter(Builder::association))
            .constructor(NetworkInterfaceAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association")
                    .unmarshallLocationName("association").build()).build();

    private static final SdkField<NetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField
            .<NetworkInterfaceAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment")
            .getter(getter(NetworkInterface::attachment))
            .setter(setter(Builder::attachment))
            .constructor(NetworkInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment")
                    .unmarshallLocationName("attachment").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(NetworkInterface::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(NetworkInterface::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField
            .<List<GroupIdentifier>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(NetworkInterface::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType")
            .getter(getter(NetworkInterface::interfaceTypeAsString))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType")
                    .unmarshallLocationName("interfaceType").build()).build();

    private static final SdkField<List<NetworkInterfaceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<NetworkInterfaceIpv6Address>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(NetworkInterface::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesSet")
                    .unmarshallLocationName("ipv6AddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkInterfaceIpv6Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterfaceIpv6Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MacAddress")
            .getter(getter(NetworkInterface::macAddress))
            .setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress")
                    .unmarshallLocationName("macAddress").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(NetworkInterface::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(NetworkInterface::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(NetworkInterface::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName")
            .getter(getter(NetworkInterface::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("privateDnsName").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(NetworkInterface::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<List<NetworkInterfacePrivateIpAddress>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<NetworkInterfacePrivateIpAddress>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(NetworkInterface::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressesSet")
                    .unmarshallLocationName("privateIpAddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkInterfacePrivateIpAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterfacePrivateIpAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Ipv4PrefixSpecification>> IPV4_PREFIXES_FIELD = SdkField
            .<List<Ipv4PrefixSpecification>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(NetworkInterface::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixSet")
                    .unmarshallLocationName("ipv4PrefixSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv4PrefixSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv4PrefixSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Ipv6PrefixSpecification>> IPV6_PREFIXES_FIELD = SdkField
            .<List<Ipv6PrefixSpecification>> builder(MarshallingType.LIST)
            .memberName("Ipv6Prefixes")
            .getter(getter(NetworkInterface::ipv6Prefixes))
            .setter(setter(Builder::ipv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixSet")
                    .unmarshallLocationName("ipv6PrefixSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6PrefixSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6PrefixSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> REQUESTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequesterId")
            .getter(getter(NetworkInterface::requesterId))
            .setter(setter(Builder::requesterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterId")
                    .unmarshallLocationName("requesterId").build()).build();

    private static final SdkField<Boolean> REQUESTER_MANAGED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequesterManaged")
            .getter(getter(NetworkInterface::requesterManaged))
            .setter(setter(Builder::requesterManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterManaged")
                    .unmarshallLocationName("requesterManaged").build()).build();

    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SourceDestCheck")
            .getter(getter(NetworkInterface::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(NetworkInterface::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(NetworkInterface::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<List<Tag>> TAG_SET_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagSet")
            .getter(getter(NetworkInterface::tagSet))
            .setter(setter(Builder::tagSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(NetworkInterface::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<Boolean> DENY_ALL_IGW_TRAFFIC_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DenyAllIgwTraffic")
            .getter(getter(NetworkInterface::denyAllIgwTraffic))
            .setter(setter(Builder::denyAllIgwTraffic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DenyAllIgwTraffic")
                    .unmarshallLocationName("denyAllIgwTraffic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD,
            ATTACHMENT_FIELD, AVAILABILITY_ZONE_FIELD, DESCRIPTION_FIELD, GROUPS_FIELD, INTERFACE_TYPE_FIELD,
            IPV6_ADDRESSES_FIELD, MAC_ADDRESS_FIELD, NETWORK_INTERFACE_ID_FIELD, OUTPOST_ARN_FIELD, OWNER_ID_FIELD,
            PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, IPV4_PREFIXES_FIELD,
            IPV6_PREFIXES_FIELD, REQUESTER_ID_FIELD, REQUESTER_MANAGED_FIELD, SOURCE_DEST_CHECK_FIELD, STATUS_FIELD,
            SUBNET_ID_FIELD, TAG_SET_FIELD, VPC_ID_FIELD, DENY_ALL_IGW_TRAFFIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final NetworkInterfaceAssociation association;

    private final NetworkInterfaceAttachment attachment;

    private final String availabilityZone;

    private final String description;

    private final List<GroupIdentifier> groups;

    private final String interfaceType;

    private final List<NetworkInterfaceIpv6Address> ipv6Addresses;

    private final String macAddress;

    private final String networkInterfaceId;

    private final String outpostArn;

    private final String ownerId;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<NetworkInterfacePrivateIpAddress> privateIpAddresses;

    private final List<Ipv4PrefixSpecification> ipv4Prefixes;

    private final List<Ipv6PrefixSpecification> ipv6Prefixes;

    private final String requesterId;

    private final Boolean requesterManaged;

    private final Boolean sourceDestCheck;

    private final String status;

    private final String subnetId;

    private final List<Tag> tagSet;

    private final String vpcId;

    private final Boolean denyAllIgwTraffic;

    private NetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.outpostArn = builder.outpostArn;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.requesterId = builder.requesterId;
        this.requesterManaged = builder.requesterManaged;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tagSet = builder.tagSet;
        this.vpcId = builder.vpcId;
        this.denyAllIgwTraffic = builder.denyAllIgwTraffic;
    }

    /**
     * <p>
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     * </p>
     * 
     * @return The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    public final NetworkInterfaceAssociation association() {
        return association;
    }

    /**
     * <p>
     * The network interface attachment.
     * </p>
     * 
     * @return The network interface attachment.
     */
    public final NetworkInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A description.
     * </p>
     * 
     * @return A description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any security groups for the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return Any security groups for the network interface.
     */
    public final List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link NetworkInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of network interface.
     * @see NetworkInterfaceType
     */
    public final NetworkInterfaceType interfaceType() {
        return NetworkInterfaceType.fromValue(interfaceType);
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link NetworkInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of network interface.
     * @see NetworkInterfaceType
     */
    public final String interfaceTypeAsString() {
        return interfaceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return The IPv6 addresses associated with the network interface.
     */
    public final List<NetworkInterfaceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The MAC address.
     * </p>
     * 
     * @return The MAC address.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the network interface.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the network interface.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The private DNS name.
     * </p>
     * 
     * @return The private DNS name.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The IPv4 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv4 address of the network interface within the subnet.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private IPv4 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return The private IPv4 addresses associated with the network interface.
     */
    public final List<NetworkInterfacePrivateIpAddress> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 prefixes that are assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4Prefixes} method.
     * </p>
     * 
     * @return The IPv4 prefixes that are assigned to the network interface.
     */
    public final List<Ipv4PrefixSpecification> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Prefixes() {
        return ipv6Prefixes != null && !(ipv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 prefixes that are assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Prefixes} method.
     * </p>
     * 
     * @return The IPv6 prefixes that are assigned to the network interface.
     */
    public final List<Ipv6PrefixSpecification> ipv6Prefixes() {
        return ipv6Prefixes;
    }

    /**
     * <p>
     * The alias or Amazon Web Services account ID of the principal or service that created the network interface.
     * </p>
     * 
     * @return The alias or Amazon Web Services account ID of the principal or service that created the network
     *         interface.
     */
    public final String requesterId() {
        return requesterId;
    }

    /**
     * <p>
     * Indicates whether the network interface is being managed by Amazon Web Services.
     * </p>
     * 
     * @return Indicates whether the network interface is being managed by Amazon Web Services.
     */
    public final Boolean requesterManaged() {
        return requesterManaged;
    }

    /**
     * <p>
     * Indicates whether source/destination checking is enabled.
     * </p>
     * 
     * @return Indicates whether source/destination checking is enabled.
     */
    public final Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The status of the network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network interface.
     * @see NetworkInterfaceStatus
     */
    public final NetworkInterfaceStatus status() {
        return NetworkInterfaceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network interface.
     * @see NetworkInterfaceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagSet() {
        return tagSet != null && !(tagSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSet} method.
     * </p>
     * 
     * @return Any tags assigned to the network interface.
     */
    public final List<Tag> tagSet() {
        return tagSet;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Indicates whether a network interface with an IPv6 address is unreachable from the public internet. If the value
     * is <code>true</code>, inbound traffic from the internet is dropped and you cannot assign an elastic IP address to
     * the network interface. The network interface is reachable from peered VPCs and resources connected through a
     * transit gateway, including on-premises networks.
     * </p>
     * 
     * @return Indicates whether a network interface with an IPv6 address is unreachable from the public internet. If
     *         the value is <code>true</code>, inbound traffic from the internet is dropped and you cannot assign an
     *         elastic IP address to the network interface. The network interface is reachable from peered VPCs and
     *         resources connected through a transit gateway, including on-premises networks.
     */
    public final Boolean denyAllIgwTraffic() {
        return denyAllIgwTraffic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(association());
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(interfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Prefixes() ? ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterManaged());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSet() ? tagSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(denyAllIgwTraffic());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return Objects.equals(association(), other.association()) && Objects.equals(attachment(), other.attachment())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(description(), other.description()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups())
                && Objects.equals(interfaceTypeAsString(), other.interfaceTypeAsString())
                && hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && hasIpv6Prefixes() == other.hasIpv6Prefixes() && Objects.equals(ipv6Prefixes(), other.ipv6Prefixes())
                && Objects.equals(requesterId(), other.requesterId())
                && Objects.equals(requesterManaged(), other.requesterManaged())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(subnetId(), other.subnetId())
                && hasTagSet() == other.hasTagSet() && Objects.equals(tagSet(), other.tagSet())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(denyAllIgwTraffic(), other.denyAllIgwTraffic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterface").add("Association", association()).add("Attachment", attachment())
                .add("AvailabilityZone", availabilityZone()).add("Description", description())
                .add("Groups", hasGroups() ? groups() : null).add("InterfaceType", interfaceTypeAsString())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null).add("MacAddress", macAddress())
                .add("NetworkInterfaceId", networkInterfaceId()).add("OutpostArn", outpostArn()).add("OwnerId", ownerId())
                .add("PrivateDnsName", privateDnsName()).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null)
                .add("Ipv6Prefixes", hasIpv6Prefixes() ? ipv6Prefixes() : null).add("RequesterId", requesterId())
                .add("RequesterManaged", requesterManaged()).add("SourceDestCheck", sourceDestCheck())
                .add("Status", statusAsString()).add("SubnetId", subnetId()).add("TagSet", hasTagSet() ? tagSet() : null)
                .add("VpcId", vpcId()).add("DenyAllIgwTraffic", denyAllIgwTraffic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceTypeAsString()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "Ipv6Prefixes":
            return Optional.ofNullable(clazz.cast(ipv6Prefixes()));
        case "RequesterId":
            return Optional.ofNullable(clazz.cast(requesterId()));
        case "RequesterManaged":
            return Optional.ofNullable(clazz.cast(requesterManaged()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "TagSet":
            return Optional.ofNullable(clazz.cast(tagSet()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "DenyAllIgwTraffic":
            return Optional.ofNullable(clazz.cast(denyAllIgwTraffic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * 
         * @param association
         *        The association information for an Elastic IP address (IPv4) associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(NetworkInterfaceAssociation association);

        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfaceAssociation.Builder} avoiding
         * the need to create one manually via {@link NetworkInterfaceAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfaceAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #association(NetworkInterfaceAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link NetworkInterfaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(NetworkInterfaceAssociation)
         */
        default Builder association(Consumer<NetworkInterfaceAssociation.Builder> association) {
            return association(NetworkInterfaceAssociation.builder().applyMutation(association).build());
        }

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * 
         * @param attachment
         *        The network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(NetworkInterfaceAttachment attachment);

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfaceAttachment.Builder} avoiding the
         * need to create one manually via {@link NetworkInterfaceAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfaceAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #attachment(NetworkInterfaceAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link NetworkInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(NetworkInterfaceAttachment)
         */
        default Builder attachment(Consumer<NetworkInterfaceAttachment.Builder> attachment) {
            return attachment(NetworkInterfaceAttachment.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A description.
         * </p>
         * 
         * @param description
         *        A description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Any security groups for the network interface.
         * </p>
         * 
         * @param groups
         *        Any security groups for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * Any security groups for the network interface.
         * </p>
         * 
         * @param groups
         *        Any security groups for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * Any security groups for the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<GroupIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupIdentifier>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<GroupIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<GroupIdentifier>)
         */
        Builder groups(Consumer<GroupIdentifier.Builder>... groups);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface.
         * @see NetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceType
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface.
         * @see NetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceType
         */
        Builder interfaceType(NetworkInterfaceType interfaceType);

        /**
         * <p>
         * The IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(NetworkInterfaceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkInterfaceIpv6Address>.Builder}
         * avoiding the need to create one manually via {@link List<NetworkInterfaceIpv6Address>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkInterfaceIpv6Address>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Addresses(List<NetworkInterfaceIpv6Address>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on {@link List<NetworkInterfaceIpv6Address>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(List<NetworkInterfaceIpv6Address>)
         */
        Builder ipv6Addresses(Consumer<NetworkInterfaceIpv6Address.Builder>... ipv6Addresses);

        /**
         * <p>
         * The MAC address.
         * </p>
         * 
         * @param macAddress
         *        The MAC address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the network interface.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account ID of the owner of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The private DNS name.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The IPv4 address of the network interface within the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(NetworkInterfacePrivateIpAddress... privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkInterfacePrivateIpAddress>.Builder}
         * avoiding the need to create one manually via {@link List<NetworkInterfacePrivateIpAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkInterfacePrivateIpAddress>.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<NetworkInterfacePrivateIpAddress>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on {@link List<NetworkInterfacePrivateIpAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(List<NetworkInterfacePrivateIpAddress>)
         */
        Builder privateIpAddresses(Consumer<NetworkInterfacePrivateIpAddress.Builder>... privateIpAddresses);

        /**
         * <p>
         * The IPv4 prefixes that are assigned to the network interface.
         * </p>
         * 
         * @param ipv4Prefixes
         *        The IPv4 prefixes that are assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<Ipv4PrefixSpecification> ipv4Prefixes);

        /**
         * <p>
         * The IPv4 prefixes that are assigned to the network interface.
         * </p>
         * 
         * @param ipv4Prefixes
         *        The IPv4 prefixes that are assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Ipv4PrefixSpecification... ipv4Prefixes);

        /**
         * <p>
         * The IPv4 prefixes that are assigned to the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv4PrefixSpecification>.Builder} avoiding
         * the need to create one manually via {@link List<Ipv4PrefixSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv4PrefixSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv4Prefixes(List<Ipv4PrefixSpecification>)}.
         * 
         * @param ipv4Prefixes
         *        a consumer that will call methods on {@link List<Ipv4PrefixSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4Prefixes(List<Ipv4PrefixSpecification>)
         */
        Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecification.Builder>... ipv4Prefixes);

        /**
         * <p>
         * The IPv6 prefixes that are assigned to the network interface.
         * </p>
         * 
         * @param ipv6Prefixes
         *        The IPv6 prefixes that are assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Collection<Ipv6PrefixSpecification> ipv6Prefixes);

        /**
         * <p>
         * The IPv6 prefixes that are assigned to the network interface.
         * </p>
         * 
         * @param ipv6Prefixes
         *        The IPv6 prefixes that are assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Ipv6PrefixSpecification... ipv6Prefixes);

        /**
         * <p>
         * The IPv6 prefixes that are assigned to the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv6PrefixSpecification>.Builder} avoiding
         * the need to create one manually via {@link List<Ipv6PrefixSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv6PrefixSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Prefixes(List<Ipv6PrefixSpecification>)}.
         * 
         * @param ipv6Prefixes
         *        a consumer that will call methods on {@link List<Ipv6PrefixSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Prefixes(List<Ipv6PrefixSpecification>)
         */
        Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecification.Builder>... ipv6Prefixes);

        /**
         * <p>
         * The alias or Amazon Web Services account ID of the principal or service that created the network interface.
         * </p>
         * 
         * @param requesterId
         *        The alias or Amazon Web Services account ID of the principal or service that created the network
         *        interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterId(String requesterId);

        /**
         * <p>
         * Indicates whether the network interface is being managed by Amazon Web Services.
         * </p>
         * 
         * @param requesterManaged
         *        Indicates whether the network interface is being managed by Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterManaged(Boolean requesterManaged);

        /**
         * <p>
         * Indicates whether source/destination checking is enabled.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether source/destination checking is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(NetworkInterfaceStatus status);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Any tags assigned to the network interface.
         * </p>
         * 
         * @param tagSet
         *        Any tags assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Collection<Tag> tagSet);

        /**
         * <p>
         * Any tags assigned to the network interface.
         * </p>
         * 
         * @param tagSet
         *        Any tags assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Tag... tagSet);

        /**
         * <p>
         * Any tags assigned to the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagSet(List<Tag>)}.
         * 
         * @param tagSet
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSet(List<Tag>)
         */
        Builder tagSet(Consumer<Tag.Builder>... tagSet);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Indicates whether a network interface with an IPv6 address is unreachable from the public internet. If the
         * value is <code>true</code>, inbound traffic from the internet is dropped and you cannot assign an elastic IP
         * address to the network interface. The network interface is reachable from peered VPCs and resources connected
         * through a transit gateway, including on-premises networks.
         * </p>
         * 
         * @param denyAllIgwTraffic
         *        Indicates whether a network interface with an IPv6 address is unreachable from the public internet. If
         *        the value is <code>true</code>, inbound traffic from the internet is dropped and you cannot assign an
         *        elastic IP address to the network interface. The network interface is reachable from peered VPCs and
         *        resources connected through a transit gateway, including on-premises networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder denyAllIgwTraffic(Boolean denyAllIgwTraffic);
    }

    static final class BuilderImpl implements Builder {
        private NetworkInterfaceAssociation association;

        private NetworkInterfaceAttachment attachment;

        private String availabilityZone;

        private String description;

        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();

        private String interfaceType;

        private List<NetworkInterfaceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String macAddress;

        private String networkInterfaceId;

        private String outpostArn;

        private String ownerId;

        private String privateDnsName;

        private String privateIpAddress;

        private List<NetworkInterfacePrivateIpAddress> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<Ipv4PrefixSpecification> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private List<Ipv6PrefixSpecification> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private String requesterId;

        private Boolean requesterManaged;

        private Boolean sourceDestCheck;

        private String status;

        private String subnetId;

        private List<Tag> tagSet = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private Boolean denyAllIgwTraffic;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            association(model.association);
            attachment(model.attachment);
            availabilityZone(model.availabilityZone);
            description(model.description);
            groups(model.groups);
            interfaceType(model.interfaceType);
            ipv6Addresses(model.ipv6Addresses);
            macAddress(model.macAddress);
            networkInterfaceId(model.networkInterfaceId);
            outpostArn(model.outpostArn);
            ownerId(model.ownerId);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            ipv4Prefixes(model.ipv4Prefixes);
            ipv6Prefixes(model.ipv6Prefixes);
            requesterId(model.requesterId);
            requesterManaged(model.requesterManaged);
            sourceDestCheck(model.sourceDestCheck);
            status(model.status);
            subnetId(model.subnetId);
            tagSet(model.tagSet);
            vpcId(model.vpcId);
            denyAllIgwTraffic(model.denyAllIgwTraffic);
        }

        public final NetworkInterfaceAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        public final void setAssociation(NetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        @Transient
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final NetworkInterfaceAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        @Transient
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<GroupIdentifier.Builder> getGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        @Override
        @Transient
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        @Transient
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        @Transient
        public final Builder interfaceType(NetworkInterfaceType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public final List<NetworkInterfaceIpv6Address.Builder> getIpv6Addresses() {
            List<NetworkInterfaceIpv6Address.Builder> result = NetworkInterfaceIpv6AddressesListCopier
                    .copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<NetworkInterfaceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        @Transient
        public final Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(NetworkInterfaceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<NetworkInterfaceIpv6Address.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> NetworkInterfaceIpv6Address.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        @Transient
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        @Transient
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        @Transient
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        @Transient
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<NetworkInterfacePrivateIpAddress.Builder> getPrivateIpAddresses() {
            List<NetworkInterfacePrivateIpAddress.Builder> result = NetworkInterfacePrivateIpAddressListCopier
                    .copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        @Transient
        public final Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateIpAddresses(NetworkInterfacePrivateIpAddress... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<NetworkInterfacePrivateIpAddress.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> NetworkInterfacePrivateIpAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Ipv4PrefixSpecification.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecification.Builder> result = Ipv4PrefixesListCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecification.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixesListCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        @Transient
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecification> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixesListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecification... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecification.Builder>... ipv4Prefixes) {
            ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> Ipv4PrefixSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Ipv6PrefixSpecification.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecification.Builder> result = Ipv6PrefixesListCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecification.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixesListCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        @Transient
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecification> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixesListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecification... ipv6Prefixes) {
            ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecification.Builder>... ipv6Prefixes) {
            ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> Ipv6PrefixSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRequesterId() {
            return requesterId;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        @Override
        @Transient
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final Boolean getRequesterManaged() {
            return requesterManaged;
        }

        public final void setRequesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
        }

        @Override
        @Transient
        public final Builder requesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        @Transient
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final List<Tag.Builder> getTagSet() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSet(Collection<Tag.BuilderImpl> tagSet) {
            this.tagSet = TagListCopier.copyFromBuilder(tagSet);
        }

        @Override
        @Transient
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagListCopier.copy(tagSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSet(Tag... tagSet) {
            tagSet(Arrays.asList(tagSet));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSet(Consumer<Tag.Builder>... tagSet) {
            tagSet(Stream.of(tagSet).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Boolean getDenyAllIgwTraffic() {
            return denyAllIgwTraffic;
        }

        public final void setDenyAllIgwTraffic(Boolean denyAllIgwTraffic) {
            this.denyAllIgwTraffic = denyAllIgwTraffic;
        }

        @Override
        @Transient
        public final Builder denyAllIgwTraffic(Boolean denyAllIgwTraffic) {
            this.denyAllIgwTraffic = denyAllIgwTraffic;
            return this;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
