/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The architecture type, virtualization type, and other attributes for the instance types. When you specify instance
 * attributes, Amazon EC2 will identify instance types with those attributes.
 * </p>
 * <p>
 * If you specify <code>InstanceRequirementsWithMetadataRequest</code>, you can't specify <code>InstanceTypes</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceRequirementsWithMetadataRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceRequirementsWithMetadataRequest.Builder, InstanceRequirementsWithMetadataRequest> {
    private static final SdkField<List<String>> ARCHITECTURE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ArchitectureTypes")
            .getter(getter(InstanceRequirementsWithMetadataRequest::architectureTypesAsStrings))
            .setter(setter(Builder::architectureTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitectureType")
                    .unmarshallLocationName("ArchitectureType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> VIRTUALIZATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VirtualizationTypes")
            .getter(getter(InstanceRequirementsWithMetadataRequest::virtualizationTypesAsStrings))
            .setter(setter(Builder::virtualizationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType")
                    .unmarshallLocationName("VirtualizationType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<InstanceRequirementsRequest> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirementsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceRequirements")
            .getter(getter(InstanceRequirementsWithMetadataRequest::instanceRequirements))
            .setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirementsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements")
                    .unmarshallLocationName("InstanceRequirements").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_TYPES_FIELD,
            VIRTUALIZATION_TYPES_FIELD, INSTANCE_REQUIREMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> architectureTypes;

    private final List<String> virtualizationTypes;

    private final InstanceRequirementsRequest instanceRequirements;

    private InstanceRequirementsWithMetadataRequest(BuilderImpl builder) {
        this.architectureTypes = builder.architectureTypes;
        this.virtualizationTypes = builder.virtualizationTypes;
        this.instanceRequirements = builder.instanceRequirements;
    }

    /**
     * <p>
     * The architecture type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectureTypes} method.
     * </p>
     * 
     * @return The architecture type.
     */
    public final List<ArchitectureType> architectureTypes() {
        return ArchitectureTypeSetCopier.copyStringToEnum(architectureTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ArchitectureTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchitectureTypes() {
        return architectureTypes != null && !(architectureTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The architecture type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectureTypes} method.
     * </p>
     * 
     * @return The architecture type.
     */
    public final List<String> architectureTypesAsStrings() {
        return architectureTypes;
    }

    /**
     * <p>
     * The virtualization type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVirtualizationTypes} method.
     * </p>
     * 
     * @return The virtualization type.
     */
    public final List<VirtualizationType> virtualizationTypes() {
        return VirtualizationTypeSetCopier.copyStringToEnum(virtualizationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the VirtualizationTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVirtualizationTypes() {
        return virtualizationTypes != null && !(virtualizationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The virtualization type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVirtualizationTypes} method.
     * </p>
     * 
     * @return The virtualization type.
     */
    public final List<String> virtualizationTypesAsStrings() {
        return virtualizationTypes;
    }

    /**
     * <p>
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance
     * types with those attributes.
     * </p>
     * 
     * @return The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
     *         instance types with those attributes.
     */
    public final InstanceRequirementsRequest instanceRequirements() {
        return instanceRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitectureTypes() ? architectureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualizationTypes() ? virtualizationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRequirementsWithMetadataRequest)) {
            return false;
        }
        InstanceRequirementsWithMetadataRequest other = (InstanceRequirementsWithMetadataRequest) obj;
        return hasArchitectureTypes() == other.hasArchitectureTypes()
                && Objects.equals(architectureTypesAsStrings(), other.architectureTypesAsStrings())
                && hasVirtualizationTypes() == other.hasVirtualizationTypes()
                && Objects.equals(virtualizationTypesAsStrings(), other.virtualizationTypesAsStrings())
                && Objects.equals(instanceRequirements(), other.instanceRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceRequirementsWithMetadataRequest")
                .add("ArchitectureTypes", hasArchitectureTypes() ? architectureTypesAsStrings() : null)
                .add("VirtualizationTypes", hasVirtualizationTypes() ? virtualizationTypesAsStrings() : null)
                .add("InstanceRequirements", instanceRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchitectureTypes":
            return Optional.ofNullable(clazz.cast(architectureTypesAsStrings()));
        case "VirtualizationTypes":
            return Optional.ofNullable(clazz.cast(virtualizationTypesAsStrings()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRequirementsWithMetadataRequest, T> g) {
        return obj -> g.apply((InstanceRequirementsWithMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceRequirementsWithMetadataRequest> {
        /**
         * <p>
         * The architecture type.
         * </p>
         * 
         * @param architectureTypes
         *        The architecture type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectureTypesWithStrings(Collection<String> architectureTypes);

        /**
         * <p>
         * The architecture type.
         * </p>
         * 
         * @param architectureTypes
         *        The architecture type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectureTypesWithStrings(String... architectureTypes);

        /**
         * <p>
         * The architecture type.
         * </p>
         * 
         * @param architectureTypes
         *        The architecture type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectureTypes(Collection<ArchitectureType> architectureTypes);

        /**
         * <p>
         * The architecture type.
         * </p>
         * 
         * @param architectureTypes
         *        The architecture type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectureTypes(ArchitectureType... architectureTypes);

        /**
         * <p>
         * The virtualization type.
         * </p>
         * 
         * @param virtualizationTypes
         *        The virtualization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationTypesWithStrings(Collection<String> virtualizationTypes);

        /**
         * <p>
         * The virtualization type.
         * </p>
         * 
         * @param virtualizationTypes
         *        The virtualization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationTypesWithStrings(String... virtualizationTypes);

        /**
         * <p>
         * The virtualization type.
         * </p>
         * 
         * @param virtualizationTypes
         *        The virtualization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationTypes(Collection<VirtualizationType> virtualizationTypes);

        /**
         * <p>
         * The virtualization type.
         * </p>
         * 
         * @param virtualizationTypes
         *        The virtualization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationTypes(VirtualizationType... virtualizationTypes);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with those attributes.
         * </p>
         * 
         * @param instanceRequirements
         *        The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         *        instance types with those attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with those attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceRequirementsRequest.Builder} avoiding
         * the need to create one manually via {@link InstanceRequirementsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceRequirementsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceRequirements(InstanceRequirementsRequest)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirementsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirementsRequest)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirementsRequest.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirementsRequest.builder().applyMutation(instanceRequirements).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> architectureTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> virtualizationTypes = DefaultSdkAutoConstructList.getInstance();

        private InstanceRequirementsRequest instanceRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRequirementsWithMetadataRequest model) {
            architectureTypesWithStrings(model.architectureTypes);
            virtualizationTypesWithStrings(model.virtualizationTypes);
            instanceRequirements(model.instanceRequirements);
        }

        public final Collection<String> getArchitectureTypes() {
            if (architectureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return architectureTypes;
        }

        public final void setArchitectureTypes(Collection<String> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copy(architectureTypes);
        }

        @Override
        @Transient
        public final Builder architectureTypesWithStrings(Collection<String> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copy(architectureTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architectureTypesWithStrings(String... architectureTypes) {
            architectureTypesWithStrings(Arrays.asList(architectureTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder architectureTypes(Collection<ArchitectureType> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copyEnumToString(architectureTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architectureTypes(ArchitectureType... architectureTypes) {
            architectureTypes(Arrays.asList(architectureTypes));
            return this;
        }

        public final Collection<String> getVirtualizationTypes() {
            if (virtualizationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return virtualizationTypes;
        }

        public final void setVirtualizationTypes(Collection<String> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copy(virtualizationTypes);
        }

        @Override
        @Transient
        public final Builder virtualizationTypesWithStrings(Collection<String> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copy(virtualizationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder virtualizationTypesWithStrings(String... virtualizationTypes) {
            virtualizationTypesWithStrings(Arrays.asList(virtualizationTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder virtualizationTypes(Collection<VirtualizationType> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copyEnumToString(virtualizationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder virtualizationTypes(VirtualizationType... virtualizationTypes) {
            virtualizationTypes(Arrays.asList(virtualizationTypes));
            return this;
        }

        public final InstanceRequirementsRequest.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirementsRequest.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        @Override
        public InstanceRequirementsWithMetadataRequest build() {
            return new InstanceRequirementsWithMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
