/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for one or more Spot Instances. If you include On-Demand capacity in your fleet
 * request or want to specify an EFA network device, you can't use <code>SpotFleetLaunchSpecification</code>; you must
 * use <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotFleetLaunchSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotFleetLaunchSpecification.Builder, SpotFleetLaunchSpecification> {
    private static final SdkField<List<GroupIdentifier>> SECURITY_GROUPS_FIELD = SdkField
            .<List<GroupIdentifier>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(SpotFleetLaunchSpecification::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> ADDRESSING_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AddressingType")
            .getter(getter(SpotFleetLaunchSpecification::addressingType))
            .setter(setter(Builder::addressingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressingType")
                    .unmarshallLocationName("addressingType").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(SpotFleetLaunchSpecification::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(SpotFleetLaunchSpecification::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<IamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<IamInstanceProfileSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfile")
            .getter(getter(SpotFleetLaunchSpecification::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(IamInstanceProfileSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("iamInstanceProfile").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(SpotFleetLaunchSpecification::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(SpotFleetLaunchSpecification::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(SpotFleetLaunchSpecification::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("kernelId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyName")
            .getter(getter(SpotFleetLaunchSpecification::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("keyName").build()).build();

    private static final SdkField<SpotFleetMonitoring> MONITORING_FIELD = SdkField
            .<SpotFleetMonitoring> builder(MarshallingType.SDK_POJO)
            .memberName("Monitoring")
            .getter(getter(SpotFleetLaunchSpecification::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(SpotFleetMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("monitoring").build()).build();

    private static final SdkField<List<InstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<InstanceNetworkInterfaceSpecification>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(SpotFleetLaunchSpecification::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet")
                    .unmarshallLocationName("networkInterfaceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceNetworkInterfaceSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceNetworkInterfaceSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<SpotPlacement> PLACEMENT_FIELD = SdkField
            .<SpotPlacement> builder(MarshallingType.SDK_POJO)
            .memberName("Placement")
            .getter(getter(SpotFleetLaunchSpecification::placement))
            .setter(setter(Builder::placement))
            .constructor(SpotPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("placement").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId")
            .getter(getter(SpotFleetLaunchSpecification::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("ramdiskId").build()).build();

    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotPrice")
            .getter(getter(SpotFleetLaunchSpecification::spotPrice))
            .setter(setter(Builder::spotPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice")
                    .unmarshallLocationName("spotPrice").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(SpotFleetLaunchSpecification::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserData")
            .getter(getter(SpotFleetLaunchSpecification::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("userData").build()).build();

    private static final SdkField<Double> WEIGHTED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("WeightedCapacity")
            .getter(getter(SpotFleetLaunchSpecification::weightedCapacity))
            .setter(setter(Builder::weightedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity")
                    .unmarshallLocationName("weightedCapacity").build()).build();

    private static final SdkField<List<SpotFleetTagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<SpotFleetTagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(SpotFleetLaunchSpecification::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecificationSet")
                    .unmarshallLocationName("tagSpecificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SpotFleetTagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpotFleetTagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceRequirements")
            .getter(getter(SpotFleetLaunchSpecification::instanceRequirements))
            .setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements")
                    .unmarshallLocationName("instanceRequirements").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUPS_FIELD,
            ADDRESSING_TYPE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD,
            INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, NETWORK_INTERFACES_FIELD, PLACEMENT_FIELD,
            RAMDISK_ID_FIELD, SPOT_PRICE_FIELD, SUBNET_ID_FIELD, USER_DATA_FIELD, WEIGHTED_CAPACITY_FIELD,
            TAG_SPECIFICATIONS_FIELD, INSTANCE_REQUIREMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<GroupIdentifier> securityGroups;

    private final String addressingType;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final Boolean ebsOptimized;

    private final IamInstanceProfileSpecification iamInstanceProfile;

    private final String imageId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final SpotFleetMonitoring monitoring;

    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;

    private final SpotPlacement placement;

    private final String ramdiskId;

    private final String spotPrice;

    private final String subnetId;

    private final String userData;

    private final Double weightedCapacity;

    private final List<SpotFleetTagSpecification> tagSpecifications;

    private final InstanceRequirements instanceRequirements;

    private SpotFleetLaunchSpecification(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.spotPrice = builder.spotPrice;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.weightedCapacity = builder.weightedCapacity;
        this.tagSpecifications = builder.tagSpecifications;
        this.instanceRequirements = builder.instanceRequirements;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups.
     * When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
     *         groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
     *         groups.
     */
    public final List<GroupIdentifier> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public final String addressingType() {
        return addressingType;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID and an
     * encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for
     * a volume, it is not blank and its encryption status is used for the volume encryption status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID and
     *         an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is
     *         the basis for a volume, it is not blank and its encryption status is used for the volume encryption
     *         status.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
     *         This optimization isn't available with all instance types. Additional usage charges apply when using an
     *         EBS Optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public final IamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Enable or disable monitoring for the instances.
     * </p>
     * 
     * @return Enable or disable monitoring for the instances.
     */
    public final SpotFleetMonitoring monitoring() {
        return monitoring;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
     * group IDs using the network interface.
     * </p>
     * <note>
     * <p>
     * <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To specify an
     * EFA, you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">
     * LaunchTemplateConfig</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaces} method.
     * </p>
     * 
     * @return One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
     *         security group IDs using the network interface.</p> <note>
     *         <p>
     *         <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To
     *         specify an EFA, you must use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html"
     *         >LaunchTemplateConfig</a>.
     *         </p>
     */
    public final List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The placement information.
     * </p>
     * 
     * @return The placement information.
     */
    public final SpotPlacement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel requirements for
     * information about whether you need to specify a RAM disk. To find kernel requirements, refer to the Amazon Web
     * Services Resource Center and search for the kernel ID.
     * </p>
     * 
     * @return The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel requirements
     *         for information about whether you need to specify a RAM disk. To find kernel requirements, refer to the
     *         Amazon Web Services Resource Center and search for the kernel ID.
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The maximum price per unit hour that you are willing to pay for a Spot Instance. If this value is not specified,
     * the default is the Spot price specified for the fleet. To determine the Spot price per unit hour, divide the Spot
     * price by the value of <code>WeightedCapacity</code>.
     * </p>
     * 
     * @return The maximum price per unit hour that you are willing to pay for a Spot Instance. If this value is not
     *         specified, the default is the Spot price specified for the fleet. To determine the Spot price per unit
     *         hour, divide the Spot price by the value of <code>WeightedCapacity</code>.
     */
    public final String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate them using commas;
     * for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
     * </p>
     * 
     * @return The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate them using
     *         commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The Base64-encoded user data that instances use when starting up.
     * </p>
     * 
     * @return The Base64-encoded user data that instances use when starting up.
     */
    public final String userData() {
        return userData;
    }

    /**
     * <p>
     * The number of units provided by the specified instance type. These are the same units that you chose to set the
     * target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
     * </p>
     * <p>
     * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to
     * the next whole number. If this value is not specified, the default is 1.
     * </p>
     * 
     * @return The number of units provided by the specified instance type. These are the same units that you chose to
     *         set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or
     *         I/O.</p>
     *         <p>
     *         If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of
     *         instances to the next whole number. If this value is not specified, the default is 1.
     */
    public final Double weightedCapacity() {
        return weightedCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply during creation.
     */
    public final List<SpotFleetTagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance
     * types with those attributes.
     * </p>
     * <note>
     * <p>
     * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceTypes</code>.
     * </p>
     * </note>
     * 
     * @return The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
     *         instance types with those attributes.</p> <note>
     *         <p>
     *         If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceTypes</code>.
     *         </p>
     */
    public final InstanceRequirements instanceRequirements() {
        return instanceRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(addressingType());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetLaunchSpecification)) {
            return false;
        }
        SpotFleetLaunchSpecification other = (SpotFleetLaunchSpecification) obj;
        return hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(addressingType(), other.addressingType())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(monitoring(), other.monitoring()) && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(spotPrice(), other.spotPrice()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(userData(), other.userData()) && Objects.equals(weightedCapacity(), other.weightedCapacity())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(instanceRequirements(), other.instanceRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotFleetLaunchSpecification")
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("AddressingType", addressingType())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("EbsOptimized", ebsOptimized()).add("IamInstanceProfile", iamInstanceProfile()).add("ImageId", imageId())
                .add("InstanceType", instanceTypeAsString()).add("KernelId", kernelId()).add("KeyName", keyName())
                .add("Monitoring", monitoring()).add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null)
                .add("Placement", placement()).add("RamdiskId", ramdiskId()).add("SpotPrice", spotPrice())
                .add("SubnetId", subnetId()).add("UserData", userData()).add("WeightedCapacity", weightedCapacity())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("InstanceRequirements", instanceRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "AddressingType":
            return Optional.ofNullable(clazz.cast(addressingType()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "SpotPrice":
            return Optional.ofNullable(clazz.cast(spotPrice()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "WeightedCapacity":
            return Optional.ofNullable(clazz.cast(weightedCapacity()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotFleetLaunchSpecification, T> g) {
        return obj -> g.apply((SpotFleetLaunchSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotFleetLaunchSpecification> {
        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups. When requesting instances in a VPC, you must specify the IDs of the
         *        security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the
         *        security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<GroupIdentifier> securityGroups);

        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups. When requesting instances in a VPC, you must specify the IDs of the
         *        security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the
         *        security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(GroupIdentifier... securityGroups);

        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<GroupIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #securityGroups(List<GroupIdentifier>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on {@link List<GroupIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(List<GroupIdentifier>)
         */
        Builder securityGroups(Consumer<GroupIdentifier.Builder>... securityGroups);

        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param addressingType
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressingType(String addressingType);

        /**
         * <p>
         * One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID and an
         * encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis
         * for a volume, it is not blank and its encryption status is used for the volume encryption status.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID
         *        and an encryption value. This is because only blank volumes can be encrypted on creation. If a
         *        snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume
         *        encryption status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID and an
         * encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis
         * for a volume, it is not blank and its encryption status is used for the volume encryption status.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID
         *        and an encryption value. This is because only blank volumes can be encrypted on creation. If a
         *        snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume
         *        encryption status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID and an
         * encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis
         * for a volume, it is not blank and its encryption status is used for the volume encryption status.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BlockDeviceMapping>.Builder} avoiding the
         * need to create one manually via {@link List<BlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockDeviceMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<BlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS Optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link IamInstanceProfileSpecification.Builder}
         * avoiding the need to create one manually via {@link IamInstanceProfileSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link IamInstanceProfileSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfile(IamInstanceProfileSpecification)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfileSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfileSpecification)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Enable or disable monitoring for the instances.
         * </p>
         * 
         * @param monitoring
         *        Enable or disable monitoring for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(SpotFleetMonitoring monitoring);

        /**
         * <p>
         * Enable or disable monitoring for the instances.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotFleetMonitoring.Builder} avoiding the need
         * to create one manually via {@link SpotFleetMonitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotFleetMonitoring.Builder#build()} is called immediately and
         * its result is passed to {@link #monitoring(SpotFleetMonitoring)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link SpotFleetMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(SpotFleetMonitoring)
         */
        default Builder monitoring(Consumer<SpotFleetMonitoring.Builder> monitoring) {
            return monitoring(SpotFleetMonitoring.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * <note>
         * <p>
         * <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To specify
         * an EFA, you must use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html"
         * >LaunchTemplateConfig</a>.
         * </p>
         * </note>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
         *        security group IDs using the network interface.</p> <note>
         *        <p>
         *        <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To
         *        specify an EFA, you must use <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html"
         *        >LaunchTemplateConfig</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * <note>
         * <p>
         * <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To specify
         * an EFA, you must use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html"
         * >LaunchTemplateConfig</a>.
         * </p>
         * </note>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
         *        security group IDs using the network interface.</p> <note>
         *        <p>
         *        <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To
         *        specify an EFA, you must use <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html"
         *        >LaunchTemplateConfig</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * <note>
         * <p>
         * <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To specify
         * an EFA, you must use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html"
         * >LaunchTemplateConfig</a>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List
         * <InstanceNetworkInterfaceSpecification>.Builder} avoiding the need to create one manually via {@link List
         * <InstanceNetworkInterfaceSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceNetworkInterfaceSpecification>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #networkInterfaces(List<InstanceNetworkInterfaceSpecification>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on {@link List<InstanceNetworkInterfaceSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(List<InstanceNetworkInterfaceSpecification>)
         */
        Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder>... networkInterfaces);

        /**
         * <p>
         * The placement information.
         * </p>
         * 
         * @param placement
         *        The placement information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(SpotPlacement placement);

        /**
         * <p>
         * The placement information.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotPlacement.Builder} avoiding the need to
         * create one manually via {@link SpotPlacement#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotPlacement.Builder#build()} is called immediately and its
         * result is passed to {@link #placement(SpotPlacement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link SpotPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(SpotPlacement)
         */
        default Builder placement(Consumer<SpotPlacement.Builder> placement) {
            return placement(SpotPlacement.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel requirements for
         * information about whether you need to specify a RAM disk. To find kernel requirements, refer to the Amazon
         * Web Services Resource Center and search for the kernel ID.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel
         *        requirements for information about whether you need to specify a RAM disk. To find kernel
         *        requirements, refer to the Amazon Web Services Resource Center and search for the kernel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The maximum price per unit hour that you are willing to pay for a Spot Instance. If this value is not
         * specified, the default is the Spot price specified for the fleet. To determine the Spot price per unit hour,
         * divide the Spot price by the value of <code>WeightedCapacity</code>.
         * </p>
         * 
         * @param spotPrice
         *        The maximum price per unit hour that you are willing to pay for a Spot Instance. If this value is not
         *        specified, the default is the Spot price specified for the fleet. To determine the Spot price per unit
         *        hour, divide the Spot price by the value of <code>WeightedCapacity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate them using
         * commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
         * </p>
         * 
         * @param subnetId
         *        The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate them
         *        using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The Base64-encoded user data that instances use when starting up.
         * </p>
         * 
         * @param userData
         *        The Base64-encoded user data that instances use when starting up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The number of units provided by the specified instance type. These are the same units that you chose to set
         * the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
         * </p>
         * <p>
         * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances
         * to the next whole number. If this value is not specified, the default is 1.
         * </p>
         * 
         * @param weightedCapacity
         *        The number of units provided by the specified instance type. These are the same units that you chose
         *        to set the target capacity in terms of instances, or a performance characteristic such as vCPUs,
         *        memory, or I/O.</p>
         *        <p>
         *        If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of
         *        instances to the next whole number. If this value is not specified, the default is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedCapacity(Double weightedCapacity);

        /**
         * <p>
         * The tags to apply during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<SpotFleetTagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(SpotFleetTagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply during creation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SpotFleetTagSpecification>.Builder}
         * avoiding the need to create one manually via {@link List<SpotFleetTagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SpotFleetTagSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #tagSpecifications(List<SpotFleetTagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<SpotFleetTagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<SpotFleetTagSpecification>)
         */
        Builder tagSpecifications(Consumer<SpotFleetTagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with those attributes.
         * </p>
         * <note>
         * <p>
         * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceTypes</code>.
         * </p>
         * </note>
         * 
         * @param instanceRequirements
         *        The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         *        instance types with those attributes.</p> <note>
         *        <p>
         *        If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceTypes</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirements instanceRequirements);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with those attributes.
         * </p>
         * <note>
         * <p>
         * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceTypes</code>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link InstanceRequirements.Builder} avoiding
         * the need to create one manually via {@link InstanceRequirements#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceRequirements.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceRequirements(InstanceRequirements)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirements)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirements.builder().applyMutation(instanceRequirements).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<GroupIdentifier> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String addressingType;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private Boolean ebsOptimized;

        private IamInstanceProfileSpecification iamInstanceProfile;

        private String imageId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private SpotFleetMonitoring monitoring;

        private List<InstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private SpotPlacement placement;

        private String ramdiskId;

        private String spotPrice;

        private String subnetId;

        private String userData;

        private Double weightedCapacity;

        private List<SpotFleetTagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private InstanceRequirements instanceRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetLaunchSpecification model) {
            securityGroups(model.securityGroups);
            addressingType(model.addressingType);
            blockDeviceMappings(model.blockDeviceMappings);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            imageId(model.imageId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            monitoring(model.monitoring);
            networkInterfaces(model.networkInterfaces);
            placement(model.placement);
            ramdiskId(model.ramdiskId);
            spotPrice(model.spotPrice);
            subnetId(model.subnetId);
            userData(model.userData);
            weightedCapacity(model.weightedCapacity);
            tagSpecifications(model.tagSpecifications);
            instanceRequirements(model.instanceRequirements);
        }

        public final List<GroupIdentifier.Builder> getSecurityGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(Consumer<GroupIdentifier.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> GroupIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAddressingType() {
            return addressingType;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        @Override
        @Transient
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        @Transient
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        @Transient
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Transient
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        @Transient
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        @Transient
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final SpotFleetMonitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        public final void setMonitoring(SpotFleetMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoring(SpotFleetMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final List<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterfaceSpecification.Builder> result = InstanceNetworkInterfaceSpecificationListCopier
                    .copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        @Transient
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> InstanceNetworkInterfaceSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SpotPlacement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(SpotPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        @Transient
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        @Transient
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        @Transient
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        @Transient
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final Double getWeightedCapacity() {
            return weightedCapacity;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        @Transient
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final List<SpotFleetTagSpecification.Builder> getTagSpecifications() {
            List<SpotFleetTagSpecification.Builder> result = SpotFleetTagSpecificationListCopier
                    .copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<SpotFleetTagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = SpotFleetTagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        @Transient
        public final Builder tagSpecifications(Collection<SpotFleetTagSpecification> tagSpecifications) {
            this.tagSpecifications = SpotFleetTagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(SpotFleetTagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<SpotFleetTagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> SpotFleetTagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        @Override
        public SpotFleetLaunchSpecification build() {
            return new SpotFleetLaunchSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
