/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Phase2DHGroupNumbersRequestListCopier {
    static List<Phase2DHGroupNumbersRequestListValue> copy(
            Collection<? extends Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbersRequestListParam) {
        List<Phase2DHGroupNumbersRequestListValue> list;
        if (phase2DHGroupNumbersRequestListParam == null || phase2DHGroupNumbersRequestListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2DHGroupNumbersRequestListValue> modifiableList = new ArrayList<>();
            phase2DHGroupNumbersRequestListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Phase2DHGroupNumbersRequestListValue> copyFromBuilder(
            Collection<? extends Phase2DHGroupNumbersRequestListValue.Builder> phase2DHGroupNumbersRequestListParam) {
        List<Phase2DHGroupNumbersRequestListValue> list;
        if (phase2DHGroupNumbersRequestListParam == null || phase2DHGroupNumbersRequestListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2DHGroupNumbersRequestListValue> modifiableList = new ArrayList<>();
            phase2DHGroupNumbersRequestListParam.forEach(entry -> {
                Phase2DHGroupNumbersRequestListValue member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Phase2DHGroupNumbersRequestListValue.Builder> copyToBuilder(
            Collection<? extends Phase2DHGroupNumbersRequestListValue> phase2DHGroupNumbersRequestListParam) {
        List<Phase2DHGroupNumbersRequestListValue.Builder> list;
        if (phase2DHGroupNumbersRequestListParam == null || phase2DHGroupNumbersRequestListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2DHGroupNumbersRequestListValue.Builder> modifiableList = new ArrayList<>();
            phase2DHGroupNumbersRequestListParam.forEach(entry -> {
                Phase2DHGroupNumbersRequestListValue.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
