/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeReservedInstancesModifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedInstancesModificationsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeReservedInstancesModificationsResponse.Builder, DescribeReservedInstancesModificationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeReservedInstancesModificationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<ReservedInstancesModification>> RESERVED_INSTANCES_MODIFICATIONS_FIELD = SdkField
            .<List<ReservedInstancesModification>> builder(MarshallingType.LIST)
            .memberName("ReservedInstancesModifications")
            .getter(getter(DescribeReservedInstancesModificationsResponse::reservedInstancesModifications))
            .setter(setter(Builder::reservedInstancesModifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesModificationsSet")
                    .unmarshallLocationName("reservedInstancesModificationsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstancesModification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstancesModification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVED_INSTANCES_MODIFICATIONS_FIELD));

    private final String nextToken;

    private final List<ReservedInstancesModification> reservedInstancesModifications;

    private DescribeReservedInstancesModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedInstancesModifications = builder.reservedInstancesModifications;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the ReservedInstancesModifications property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasReservedInstancesModifications() {
        return reservedInstancesModifications != null && !(reservedInstancesModifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Reserved Instance modification information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservedInstancesModifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Reserved Instance modification information.
     */
    public final List<ReservedInstancesModification> reservedInstancesModifications() {
        return reservedInstancesModifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReservedInstancesModifications() ? reservedInstancesModifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesModificationsResponse)) {
            return false;
        }
        DescribeReservedInstancesModificationsResponse other = (DescribeReservedInstancesModificationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasReservedInstancesModifications() == other.hasReservedInstancesModifications()
                && Objects.equals(reservedInstancesModifications(), other.reservedInstancesModifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeReservedInstancesModificationsResponse")
                .add("NextToken", nextToken())
                .add("ReservedInstancesModifications",
                        hasReservedInstancesModifications() ? reservedInstancesModifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ReservedInstancesModifications":
            return Optional.ofNullable(clazz.cast(reservedInstancesModifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesModificationsResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstancesModificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedInstancesModificationsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Reserved Instance modification information.
         * </p>
         * 
         * @param reservedInstancesModifications
         *        The Reserved Instance modification information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModifications(Collection<ReservedInstancesModification> reservedInstancesModifications);

        /**
         * <p>
         * The Reserved Instance modification information.
         * </p>
         * 
         * @param reservedInstancesModifications
         *        The Reserved Instance modification information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModifications(ReservedInstancesModification... reservedInstancesModifications);

        /**
         * <p>
         * The Reserved Instance modification information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedInstancesModification>.Builder}
         * avoiding the need to create one manually via {@link List<ReservedInstancesModification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstancesModification>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #reservedInstancesModifications(List<ReservedInstancesModification>)}.
         * 
         * @param reservedInstancesModifications
         *        a consumer that will call methods on {@link List<ReservedInstancesModification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstancesModifications(List<ReservedInstancesModification>)
         */
        Builder reservedInstancesModifications(Consumer<ReservedInstancesModification.Builder>... reservedInstancesModifications);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<ReservedInstancesModification> reservedInstancesModifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesModificationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservedInstancesModifications(model.reservedInstancesModifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<ReservedInstancesModification.Builder> getReservedInstancesModifications() {
            List<ReservedInstancesModification.Builder> result = ReservedInstancesModificationListCopier
                    .copyToBuilder(this.reservedInstancesModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder reservedInstancesModifications(
                Collection<ReservedInstancesModification> reservedInstancesModifications) {
            this.reservedInstancesModifications = ReservedInstancesModificationListCopier.copy(reservedInstancesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModifications(ReservedInstancesModification... reservedInstancesModifications) {
            reservedInstancesModifications(Arrays.asList(reservedInstancesModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModifications(
                Consumer<ReservedInstancesModification.Builder>... reservedInstancesModifications) {
            reservedInstancesModifications(Stream.of(reservedInstancesModifications)
                    .map(c -> ReservedInstancesModification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstancesModifications(
                Collection<ReservedInstancesModification.BuilderImpl> reservedInstancesModifications) {
            this.reservedInstancesModifications = ReservedInstancesModificationListCopier
                    .copyFromBuilder(reservedInstancesModifications);
        }

        @Override
        public DescribeReservedInstancesModificationsResponse build() {
            return new DescribeReservedInstancesModificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
