/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecurityGroupRulesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSecurityGroupRulesResponse.Builder, DescribeSecurityGroupRulesResponse> {
    private static final SdkField<List<SecurityGroupRule>> SECURITY_GROUP_RULES_FIELD = SdkField
            .<List<SecurityGroupRule>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupRules")
            .getter(getter(DescribeSecurityGroupRulesResponse::securityGroupRules))
            .setter(setter(Builder::securityGroupRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleSet")
                    .unmarshallLocationName("securityGroupRuleSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSecurityGroupRulesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_RULES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SecurityGroupRule> securityGroupRules;

    private final String nextToken;

    private DescribeSecurityGroupRulesResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroupRules = builder.securityGroupRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SecurityGroupRules property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupRules() {
        return securityGroupRules != null && !(securityGroupRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about security group rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about security group rules.
     */
    public final List<SecurityGroupRule> securityGroupRules() {
        return securityGroupRules;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupRules() ? securityGroupRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupRulesResponse)) {
            return false;
        }
        DescribeSecurityGroupRulesResponse other = (DescribeSecurityGroupRulesResponse) obj;
        return hasSecurityGroupRules() == other.hasSecurityGroupRules()
                && Objects.equals(securityGroupRules(), other.securityGroupRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSecurityGroupRulesResponse")
                .add("SecurityGroupRules", hasSecurityGroupRules() ? securityGroupRules() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupRules":
            return Optional.ofNullable(clazz.cast(securityGroupRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityGroupRulesResponse, T> g) {
        return obj -> g.apply((DescribeSecurityGroupRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSecurityGroupRulesResponse> {
        /**
         * <p>
         * Information about security group rules.
         * </p>
         * 
         * @param securityGroupRules
         *        Information about security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRules(Collection<SecurityGroupRule> securityGroupRules);

        /**
         * <p>
         * Information about security group rules.
         * </p>
         * 
         * @param securityGroupRules
         *        Information about security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRules(SecurityGroupRule... securityGroupRules);

        /**
         * <p>
         * Information about security group rules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityGroupRule>.Builder} avoiding the
         * need to create one manually via {@link List<SecurityGroupRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityGroupRule>.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroupRules(List<SecurityGroupRule>)}.
         * 
         * @param securityGroupRules
         *        a consumer that will call methods on {@link List<SecurityGroupRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupRules(List<SecurityGroupRule>)
         */
        Builder securityGroupRules(Consumer<SecurityGroupRule.Builder>... securityGroupRules);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SecurityGroupRule> securityGroupRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupRulesResponse model) {
            super(model);
            securityGroupRules(model.securityGroupRules);
            nextToken(model.nextToken);
        }

        public final List<SecurityGroupRule.Builder> getSecurityGroupRules() {
            List<SecurityGroupRule.Builder> result = SecurityGroupRuleListCopier.copyToBuilder(this.securityGroupRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder securityGroupRules(Collection<SecurityGroupRule> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleListCopier.copy(securityGroupRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRules(SecurityGroupRule... securityGroupRules) {
            securityGroupRules(Arrays.asList(securityGroupRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRules(Consumer<SecurityGroupRule.Builder>... securityGroupRules) {
            securityGroupRules(Stream.of(securityGroupRules).map(c -> SecurityGroupRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroupRules(Collection<SecurityGroupRule.BuilderImpl> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleListCopier.copyFromBuilder(securityGroupRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSecurityGroupRulesResponse build() {
            return new DescribeSecurityGroupRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
