/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkAcl implements SdkPojo, Serializable, ToCopyableBuilder<NetworkAcl.Builder, NetworkAcl> {
    private static final SdkField<List<NetworkAclAssociation>> ASSOCIATIONS_FIELD = SdkField
            .<List<NetworkAclAssociation>> builder(MarshallingType.LIST)
            .memberName("Associations")
            .getter(getter(NetworkAcl::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSet")
                    .unmarshallLocationName("associationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkAclAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkAclAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<NetworkAclEntry>> ENTRIES_FIELD = SdkField
            .<List<NetworkAclEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(NetworkAcl::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntrySet")
                    .unmarshallLocationName("entrySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkAclEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkAclEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault")
            .getter(getter(NetworkAcl::isDefault))
            .setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Default")
                    .unmarshallLocationName("default").build()).build();

    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkAclId")
            .getter(getter(NetworkAcl::networkAclId))
            .setter(setter(Builder::networkAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId")
                    .unmarshallLocationName("networkAclId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(NetworkAcl::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(NetworkAcl::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(NetworkAcl::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD,
            ENTRIES_FIELD, IS_DEFAULT_FIELD, NETWORK_ACL_ID_FIELD, TAGS_FIELD, VPC_ID_FIELD, OWNER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<NetworkAclAssociation> associations;

    private final List<NetworkAclEntry> entries;

    private final Boolean isDefault;

    private final String networkAclId;

    private final List<Tag> tags;

    private final String vpcId;

    private final String ownerId;

    private NetworkAcl(BuilderImpl builder) {
        this.associations = builder.associations;
        this.entries = builder.entries;
        this.isDefault = builder.isDefault;
        this.networkAclId = builder.networkAclId;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
        this.ownerId = builder.ownerId;
    }

    /**
     * Returns true if the Associations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any associations between the network ACL and one or more subnets
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any associations between the network ACL and one or more subnets
     */
    public final List<NetworkAclAssociation> associations() {
        return associations;
    }

    /**
     * Returns true if the Entries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more entries (rules) in the network ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more entries (rules) in the network ACL.
     */
    public final List<NetworkAclEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * Indicates whether this is the default network ACL for the VPC.
     * </p>
     * 
     * @return Indicates whether this is the default network ACL for the VPC.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public final String networkAclId() {
        return networkAclId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the network ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the network ACL.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC for the network ACL.
     * </p>
     * 
     * @return The ID of the VPC for the network ACL.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the network ACL.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the network ACL.
     */
    public final String ownerId() {
        return ownerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAcl)) {
            return false;
        }
        NetworkAcl other = (NetworkAcl) obj;
        return hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries())
                && Objects.equals(isDefault(), other.isDefault()) && Objects.equals(networkAclId(), other.networkAclId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(ownerId(), other.ownerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkAcl").add("Associations", hasAssociations() ? associations() : null)
                .add("Entries", hasEntries() ? entries() : null).add("IsDefault", isDefault())
                .add("NetworkAclId", networkAclId()).add("Tags", hasTags() ? tags() : null).add("VpcId", vpcId())
                .add("OwnerId", ownerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "NetworkAclId":
            return Optional.ofNullable(clazz.cast(networkAclId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkAcl, T> g) {
        return obj -> g.apply((NetworkAcl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkAcl> {
        /**
         * <p>
         * Any associations between the network ACL and one or more subnets
         * </p>
         * 
         * @param associations
         *        Any associations between the network ACL and one or more subnets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<NetworkAclAssociation> associations);

        /**
         * <p>
         * Any associations between the network ACL and one or more subnets
         * </p>
         * 
         * @param associations
         *        Any associations between the network ACL and one or more subnets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(NetworkAclAssociation... associations);

        /**
         * <p>
         * Any associations between the network ACL and one or more subnets
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkAclAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<NetworkAclAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkAclAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #associations(List<NetworkAclAssociation>)}.
         * 
         * @param associations
         *        a consumer that will call methods on {@link List<NetworkAclAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(List<NetworkAclAssociation>)
         */
        Builder associations(Consumer<NetworkAclAssociation.Builder>... associations);

        /**
         * <p>
         * One or more entries (rules) in the network ACL.
         * </p>
         * 
         * @param entries
         *        One or more entries (rules) in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<NetworkAclEntry> entries);

        /**
         * <p>
         * One or more entries (rules) in the network ACL.
         * </p>
         * 
         * @param entries
         *        One or more entries (rules) in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(NetworkAclEntry... entries);

        /**
         * <p>
         * One or more entries (rules) in the network ACL.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkAclEntry>.Builder} avoiding the need
         * to create one manually via {@link List<NetworkAclEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkAclEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #entries(List<NetworkAclEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<NetworkAclEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<NetworkAclEntry>)
         */
        Builder entries(Consumer<NetworkAclEntry.Builder>... entries);

        /**
         * <p>
         * Indicates whether this is the default network ACL for the VPC.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether this is the default network ACL for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * Any tags assigned to the network ACL.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the network ACL.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the network ACL.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the VPC for the network ACL.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the network ACL.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);
    }

    static final class BuilderImpl implements Builder {
        private List<NetworkAclAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private List<NetworkAclEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private Boolean isDefault;

        private String networkAclId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private String ownerId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAcl model) {
            associations(model.associations);
            entries(model.entries);
            isDefault(model.isDefault);
            networkAclId(model.networkAclId);
            tags(model.tags);
            vpcId(model.vpcId);
            ownerId(model.ownerId);
        }

        public final List<NetworkAclAssociation.Builder> getAssociations() {
            List<NetworkAclAssociation.Builder> result = NetworkAclAssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder associations(Collection<NetworkAclAssociation> associations) {
            this.associations = NetworkAclAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(NetworkAclAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<NetworkAclAssociation.Builder>... associations) {
            associations(Stream.of(associations).map(c -> NetworkAclAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssociations(Collection<NetworkAclAssociation.BuilderImpl> associations) {
            this.associations = NetworkAclAssociationListCopier.copyFromBuilder(associations);
        }

        public final List<NetworkAclEntry.Builder> getEntries() {
            List<NetworkAclEntry.Builder> result = NetworkAclEntryListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder entries(Collection<NetworkAclEntry> entries) {
            this.entries = NetworkAclEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(NetworkAclEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<NetworkAclEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> NetworkAclEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<NetworkAclEntry.BuilderImpl> entries) {
            this.entries = NetworkAclEntryListCopier.copyFromBuilder(entries);
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public NetworkAcl build() {
            return new NetworkAcl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
