/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTransitGatewayMulticastGroupsResponse extends Ec2Response implements
        ToCopyableBuilder<SearchTransitGatewayMulticastGroupsResponse.Builder, SearchTransitGatewayMulticastGroupsResponse> {
    private static final SdkField<List<TransitGatewayMulticastGroup>> MULTICAST_GROUPS_FIELD = SdkField
            .<List<TransitGatewayMulticastGroup>> builder(MarshallingType.LIST)
            .memberName("MulticastGroups")
            .getter(getter(SearchTransitGatewayMulticastGroupsResponse::multicastGroups))
            .setter(setter(Builder::multicastGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroups")
                    .unmarshallLocationName("multicastGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayMulticastGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayMulticastGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(SearchTransitGatewayMulticastGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTICAST_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TransitGatewayMulticastGroup> multicastGroups;

    private final String nextToken;

    private SearchTransitGatewayMulticastGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.multicastGroups = builder.multicastGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the MulticastGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMulticastGroups() {
        return multicastGroups != null && !(multicastGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the transit gateway multicast group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMulticastGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the transit gateway multicast group.
     */
    public final List<TransitGatewayMulticastGroup> multicastGroups() {
        return multicastGroups;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMulticastGroups() ? multicastGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTransitGatewayMulticastGroupsResponse)) {
            return false;
        }
        SearchTransitGatewayMulticastGroupsResponse other = (SearchTransitGatewayMulticastGroupsResponse) obj;
        return hasMulticastGroups() == other.hasMulticastGroups() && Objects.equals(multicastGroups(), other.multicastGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTransitGatewayMulticastGroupsResponse")
                .add("MulticastGroups", hasMulticastGroups() ? multicastGroups() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MulticastGroups":
            return Optional.ofNullable(clazz.cast(multicastGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTransitGatewayMulticastGroupsResponse, T> g) {
        return obj -> g.apply((SearchTransitGatewayMulticastGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchTransitGatewayMulticastGroupsResponse> {
        /**
         * <p>
         * Information about the transit gateway multicast group.
         * </p>
         * 
         * @param multicastGroups
         *        Information about the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroups(Collection<TransitGatewayMulticastGroup> multicastGroups);

        /**
         * <p>
         * Information about the transit gateway multicast group.
         * </p>
         * 
         * @param multicastGroups
         *        Information about the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroups(TransitGatewayMulticastGroup... multicastGroups);

        /**
         * <p>
         * Information about the transit gateway multicast group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TransitGatewayMulticastGroup>.Builder}
         * avoiding the need to create one manually via {@link List<TransitGatewayMulticastGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransitGatewayMulticastGroup>.Builder#build()} is called
         * immediately and its result is passed to {@link #multicastGroups(List<TransitGatewayMulticastGroup>)}.
         * 
         * @param multicastGroups
         *        a consumer that will call methods on {@link List<TransitGatewayMulticastGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multicastGroups(List<TransitGatewayMulticastGroup>)
         */
        Builder multicastGroups(Consumer<TransitGatewayMulticastGroup.Builder>... multicastGroups);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TransitGatewayMulticastGroup> multicastGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTransitGatewayMulticastGroupsResponse model) {
            super(model);
            multicastGroups(model.multicastGroups);
            nextToken(model.nextToken);
        }

        public final List<TransitGatewayMulticastGroup.Builder> getMulticastGroups() {
            List<TransitGatewayMulticastGroup.Builder> result = TransitGatewayMulticastGroupListCopier
                    .copyToBuilder(this.multicastGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder multicastGroups(Collection<TransitGatewayMulticastGroup> multicastGroups) {
            this.multicastGroups = TransitGatewayMulticastGroupListCopier.copy(multicastGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroups(TransitGatewayMulticastGroup... multicastGroups) {
            multicastGroups(Arrays.asList(multicastGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroups(Consumer<TransitGatewayMulticastGroup.Builder>... multicastGroups) {
            multicastGroups(Stream.of(multicastGroups).map(c -> TransitGatewayMulticastGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMulticastGroups(Collection<TransitGatewayMulticastGroup.BuilderImpl> multicastGroups) {
            this.multicastGroups = TransitGatewayMulticastGroupListCopier.copyFromBuilder(multicastGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchTransitGatewayMulticastGroupsResponse build() {
            return new SearchTransitGatewayMulticastGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
