/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayPrefixListReferenceResponse extends Ec2Response
        implements
        ToCopyableBuilder<CreateTransitGatewayPrefixListReferenceResponse.Builder, CreateTransitGatewayPrefixListReferenceResponse> {
    private static final SdkField<TransitGatewayPrefixListReference> TRANSIT_GATEWAY_PREFIX_LIST_REFERENCE_FIELD = SdkField
            .<TransitGatewayPrefixListReference> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayPrefixListReference")
            .getter(getter(CreateTransitGatewayPrefixListReferenceResponse::transitGatewayPrefixListReference))
            .setter(setter(Builder::transitGatewayPrefixListReference))
            .constructor(TransitGatewayPrefixListReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPrefixListReference")
                    .unmarshallLocationName("transitGatewayPrefixListReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_PREFIX_LIST_REFERENCE_FIELD));

    private final TransitGatewayPrefixListReference transitGatewayPrefixListReference;

    private CreateTransitGatewayPrefixListReferenceResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayPrefixListReference = builder.transitGatewayPrefixListReference;
    }

    /**
     * <p>
     * Information about the prefix list reference.
     * </p>
     * 
     * @return Information about the prefix list reference.
     */
    public final TransitGatewayPrefixListReference transitGatewayPrefixListReference() {
        return transitGatewayPrefixListReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayPrefixListReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayPrefixListReferenceResponse)) {
            return false;
        }
        CreateTransitGatewayPrefixListReferenceResponse other = (CreateTransitGatewayPrefixListReferenceResponse) obj;
        return Objects.equals(transitGatewayPrefixListReference(), other.transitGatewayPrefixListReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayPrefixListReferenceResponse")
                .add("TransitGatewayPrefixListReference", transitGatewayPrefixListReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayPrefixListReference":
            return Optional.ofNullable(clazz.cast(transitGatewayPrefixListReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayPrefixListReferenceResponse, T> g) {
        return obj -> g.apply((CreateTransitGatewayPrefixListReferenceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayPrefixListReferenceResponse> {
        /**
         * <p>
         * Information about the prefix list reference.
         * </p>
         * 
         * @param transitGatewayPrefixListReference
         *        Information about the prefix list reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayPrefixListReference(TransitGatewayPrefixListReference transitGatewayPrefixListReference);

        /**
         * <p>
         * Information about the prefix list reference.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayPrefixListReference.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayPrefixListReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayPrefixListReference.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #transitGatewayPrefixListReference(TransitGatewayPrefixListReference)}.
         * 
         * @param transitGatewayPrefixListReference
         *        a consumer that will call methods on {@link TransitGatewayPrefixListReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayPrefixListReference(TransitGatewayPrefixListReference)
         */
        default Builder transitGatewayPrefixListReference(
                Consumer<TransitGatewayPrefixListReference.Builder> transitGatewayPrefixListReference) {
            return transitGatewayPrefixListReference(TransitGatewayPrefixListReference.builder()
                    .applyMutation(transitGatewayPrefixListReference).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayPrefixListReference transitGatewayPrefixListReference;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayPrefixListReferenceResponse model) {
            super(model);
            transitGatewayPrefixListReference(model.transitGatewayPrefixListReference);
        }

        public final TransitGatewayPrefixListReference.Builder getTransitGatewayPrefixListReference() {
            return transitGatewayPrefixListReference != null ? transitGatewayPrefixListReference.toBuilder() : null;
        }

        public final void setTransitGatewayPrefixListReference(
                TransitGatewayPrefixListReference.BuilderImpl transitGatewayPrefixListReference) {
            this.transitGatewayPrefixListReference = transitGatewayPrefixListReference != null ? transitGatewayPrefixListReference
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder transitGatewayPrefixListReference(TransitGatewayPrefixListReference transitGatewayPrefixListReference) {
            this.transitGatewayPrefixListReference = transitGatewayPrefixListReference;
            return this;
        }

        @Override
        public CreateTransitGatewayPrefixListReferenceResponse build() {
            return new CreateTransitGatewayPrefixListReferenceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
