/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpnConnectionOptionsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpnConnectionOptionsRequest.Builder, ModifyVpnConnectionOptionsRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnConnectionId")
            .getter(getter(ModifyVpnConnectionOptionsRequest::vpnConnectionId))
            .setter(setter(Builder::vpnConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId")
                    .unmarshallLocationName("VpnConnectionId").build()).build();

    private static final SdkField<String> LOCAL_IPV4_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalIpv4NetworkCidr")
            .getter(getter(ModifyVpnConnectionOptionsRequest::localIpv4NetworkCidr))
            .setter(setter(Builder::localIpv4NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv4NetworkCidr")
                    .unmarshallLocationName("LocalIpv4NetworkCidr").build()).build();

    private static final SdkField<String> REMOTE_IPV4_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RemoteIpv4NetworkCidr")
            .getter(getter(ModifyVpnConnectionOptionsRequest::remoteIpv4NetworkCidr))
            .setter(setter(Builder::remoteIpv4NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv4NetworkCidr")
                    .unmarshallLocationName("RemoteIpv4NetworkCidr").build()).build();

    private static final SdkField<String> LOCAL_IPV6_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalIpv6NetworkCidr")
            .getter(getter(ModifyVpnConnectionOptionsRequest::localIpv6NetworkCidr))
            .setter(setter(Builder::localIpv6NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv6NetworkCidr")
                    .unmarshallLocationName("LocalIpv6NetworkCidr").build()).build();

    private static final SdkField<String> REMOTE_IPV6_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RemoteIpv6NetworkCidr")
            .getter(getter(ModifyVpnConnectionOptionsRequest::remoteIpv6NetworkCidr))
            .setter(setter(Builder::remoteIpv6NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv6NetworkCidr")
                    .unmarshallLocationName("RemoteIpv6NetworkCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD,
            LOCAL_IPV4_NETWORK_CIDR_FIELD, REMOTE_IPV4_NETWORK_CIDR_FIELD, LOCAL_IPV6_NETWORK_CIDR_FIELD,
            REMOTE_IPV6_NETWORK_CIDR_FIELD));

    private final String vpnConnectionId;

    private final String localIpv4NetworkCidr;

    private final String remoteIpv4NetworkCidr;

    private final String localIpv6NetworkCidr;

    private final String remoteIpv6NetworkCidr;

    private ModifyVpnConnectionOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.localIpv4NetworkCidr = builder.localIpv4NetworkCidr;
        this.remoteIpv4NetworkCidr = builder.remoteIpv4NetworkCidr;
        this.localIpv6NetworkCidr = builder.localIpv6NetworkCidr;
        this.remoteIpv6NetworkCidr = builder.remoteIpv6NetworkCidr;
    }

    /**
     * <p>
     * The ID of the Site-to-Site VPN connection.
     * </p>
     * 
     * @return The ID of the Site-to-Site VPN connection.
     */
    public final String vpnConnectionId() {
        return vpnConnectionId;
    }

    /**
     * <p>
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * </p>
     * <p>
     * Default: <code>0.0.0.0/0</code>
     * </p>
     * 
     * @return The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     *         <p>
     *         Default: <code>0.0.0.0/0</code>
     */
    public final String localIpv4NetworkCidr() {
        return localIpv4NetworkCidr;
    }

    /**
     * <p>
     * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
     * </p>
     * <p>
     * Default: <code>0.0.0.0/0</code>
     * </p>
     * 
     * @return The IPv4 CIDR on the Amazon Web Services side of the VPN connection.</p>
     *         <p>
     *         Default: <code>0.0.0.0/0</code>
     */
    public final String remoteIpv4NetworkCidr() {
        return remoteIpv4NetworkCidr;
    }

    /**
     * <p>
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * </p>
     * <p>
     * Default: <code>::/0</code>
     * </p>
     * 
     * @return The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     *         <p>
     *         Default: <code>::/0</code>
     */
    public final String localIpv6NetworkCidr() {
        return localIpv6NetworkCidr;
    }

    /**
     * <p>
     * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
     * </p>
     * <p>
     * Default: <code>::/0</code>
     * </p>
     * 
     * @return The IPv6 CIDR on the Amazon Web Services side of the VPN connection.</p>
     *         <p>
     *         Default: <code>::/0</code>
     */
    public final String remoteIpv6NetworkCidr() {
        return remoteIpv6NetworkCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(localIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(localIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpv6NetworkCidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpnConnectionOptionsRequest)) {
            return false;
        }
        ModifyVpnConnectionOptionsRequest other = (ModifyVpnConnectionOptionsRequest) obj;
        return Objects.equals(vpnConnectionId(), other.vpnConnectionId())
                && Objects.equals(localIpv4NetworkCidr(), other.localIpv4NetworkCidr())
                && Objects.equals(remoteIpv4NetworkCidr(), other.remoteIpv4NetworkCidr())
                && Objects.equals(localIpv6NetworkCidr(), other.localIpv6NetworkCidr())
                && Objects.equals(remoteIpv6NetworkCidr(), other.remoteIpv6NetworkCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpnConnectionOptionsRequest").add("VpnConnectionId", vpnConnectionId())
                .add("LocalIpv4NetworkCidr", localIpv4NetworkCidr()).add("RemoteIpv4NetworkCidr", remoteIpv4NetworkCidr())
                .add("LocalIpv6NetworkCidr", localIpv6NetworkCidr()).add("RemoteIpv6NetworkCidr", remoteIpv6NetworkCidr())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnectionId":
            return Optional.ofNullable(clazz.cast(vpnConnectionId()));
        case "LocalIpv4NetworkCidr":
            return Optional.ofNullable(clazz.cast(localIpv4NetworkCidr()));
        case "RemoteIpv4NetworkCidr":
            return Optional.ofNullable(clazz.cast(remoteIpv4NetworkCidr()));
        case "LocalIpv6NetworkCidr":
            return Optional.ofNullable(clazz.cast(localIpv6NetworkCidr()));
        case "RemoteIpv6NetworkCidr":
            return Optional.ofNullable(clazz.cast(remoteIpv6NetworkCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpnConnectionOptionsRequest, T> g) {
        return obj -> g.apply((ModifyVpnConnectionOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpnConnectionOptionsRequest> {
        /**
         * <p>
         * The ID of the Site-to-Site VPN connection.
         * </p>
         * 
         * @param vpnConnectionId
         *        The ID of the Site-to-Site VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        /**
         * <p>
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * </p>
         * <p>
         * Default: <code>0.0.0.0/0</code>
         * </p>
         * 
         * @param localIpv4NetworkCidr
         *        The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
         *        <p>
         *        Default: <code>0.0.0.0/0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpv4NetworkCidr(String localIpv4NetworkCidr);

        /**
         * <p>
         * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
         * </p>
         * <p>
         * Default: <code>0.0.0.0/0</code>
         * </p>
         * 
         * @param remoteIpv4NetworkCidr
         *        The IPv4 CIDR on the Amazon Web Services side of the VPN connection.</p>
         *        <p>
         *        Default: <code>0.0.0.0/0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr);

        /**
         * <p>
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * </p>
         * <p>
         * Default: <code>::/0</code>
         * </p>
         * 
         * @param localIpv6NetworkCidr
         *        The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
         *        <p>
         *        Default: <code>::/0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpv6NetworkCidr(String localIpv6NetworkCidr);

        /**
         * <p>
         * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
         * </p>
         * <p>
         * Default: <code>::/0</code>
         * </p>
         * 
         * @param remoteIpv6NetworkCidr
         *        The IPv6 CIDR on the Amazon Web Services side of the VPN connection.</p>
         *        <p>
         *        Default: <code>::/0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String vpnConnectionId;

        private String localIpv4NetworkCidr;

        private String remoteIpv4NetworkCidr;

        private String localIpv6NetworkCidr;

        private String remoteIpv6NetworkCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpnConnectionOptionsRequest model) {
            super(model);
            vpnConnectionId(model.vpnConnectionId);
            localIpv4NetworkCidr(model.localIpv4NetworkCidr);
            remoteIpv4NetworkCidr(model.remoteIpv4NetworkCidr);
            localIpv6NetworkCidr(model.localIpv6NetworkCidr);
            remoteIpv6NetworkCidr(model.remoteIpv6NetworkCidr);
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        @Transient
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getLocalIpv4NetworkCidr() {
            return localIpv4NetworkCidr;
        }

        public final void setLocalIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
        }

        @Override
        @Transient
        public final Builder localIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
            return this;
        }

        public final String getRemoteIpv4NetworkCidr() {
            return remoteIpv4NetworkCidr;
        }

        public final void setRemoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
        }

        @Override
        @Transient
        public final Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
            return this;
        }

        public final String getLocalIpv6NetworkCidr() {
            return localIpv6NetworkCidr;
        }

        public final void setLocalIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
        }

        @Override
        @Transient
        public final Builder localIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
            return this;
        }

        public final String getRemoteIpv6NetworkCidr() {
            return remoteIpv6NetworkCidr;
        }

        public final void setRemoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
        }

        @Override
        @Transient
        public final Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpnConnectionOptionsRequest build() {
            return new ModifyVpnConnectionOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
