/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance to export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceExportDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceExportDetails.Builder, InstanceExportDetails> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(InstanceExportDetails::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> TARGET_ENVIRONMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetEnvironment")
            .getter(getter(InstanceExportDetails::targetEnvironmentAsString))
            .setter(setter(Builder::targetEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEnvironment")
                    .unmarshallLocationName("targetEnvironment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            TARGET_ENVIRONMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String targetEnvironment;

    private InstanceExportDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
    }

    /**
     * <p>
     * The ID of the resource being exported.
     * </p>
     * 
     * @return The ID of the resource being exported.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The target virtualization environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetEnvironment}
     * will return {@link ExportEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetEnvironmentAsString}.
     * </p>
     * 
     * @return The target virtualization environment.
     * @see ExportEnvironment
     */
    public final ExportEnvironment targetEnvironment() {
        return ExportEnvironment.fromValue(targetEnvironment);
    }

    /**
     * <p>
     * The target virtualization environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetEnvironment}
     * will return {@link ExportEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetEnvironmentAsString}.
     * </p>
     * 
     * @return The target virtualization environment.
     * @see ExportEnvironment
     */
    public final String targetEnvironmentAsString() {
        return targetEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(targetEnvironmentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceExportDetails)) {
            return false;
        }
        InstanceExportDetails other = (InstanceExportDetails) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(targetEnvironmentAsString(), other.targetEnvironmentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceExportDetails").add("InstanceId", instanceId())
                .add("TargetEnvironment", targetEnvironmentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "TargetEnvironment":
            return Optional.ofNullable(clazz.cast(targetEnvironmentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceExportDetails, T> g) {
        return obj -> g.apply((InstanceExportDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceExportDetails> {
        /**
         * <p>
         * The ID of the resource being exported.
         * </p>
         * 
         * @param instanceId
         *        The ID of the resource being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The target virtualization environment.
         * </p>
         * 
         * @param targetEnvironment
         *        The target virtualization environment.
         * @see ExportEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportEnvironment
         */
        Builder targetEnvironment(String targetEnvironment);

        /**
         * <p>
         * The target virtualization environment.
         * </p>
         * 
         * @param targetEnvironment
         *        The target virtualization environment.
         * @see ExportEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportEnvironment
         */
        Builder targetEnvironment(ExportEnvironment targetEnvironment);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String targetEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceExportDetails model) {
            instanceId(model.instanceId);
            targetEnvironment(model.targetEnvironment);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTargetEnvironment() {
            return targetEnvironment;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        @Override
        @Transient
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        @Transient
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment == null ? null : targetEnvironment.toString());
            return this;
        }

        @Override
        public InstanceExportDetails build() {
            return new InstanceExportDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
