/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLocalGatewayRouteTableVpcAssociationRequest extends Ec2Request
        implements
        ToCopyableBuilder<DeleteLocalGatewayRouteTableVpcAssociationRequest.Builder, DeleteLocalGatewayRouteTableVpcAssociationRequest> {
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableVpcAssociationId")
            .getter(getter(DeleteLocalGatewayRouteTableVpcAssociationRequest::localGatewayRouteTableVpcAssociationId))
            .setter(setter(Builder::localGatewayRouteTableVpcAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayRouteTableVpcAssociationId")
                    .unmarshallLocationName("LocalGatewayRouteTableVpcAssociationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION_ID_FIELD));

    private final String localGatewayRouteTableVpcAssociationId;

    private DeleteLocalGatewayRouteTableVpcAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTableVpcAssociationId = builder.localGatewayRouteTableVpcAssociationId;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String localGatewayRouteTableVpcAssociationId() {
        return localGatewayRouteTableVpcAssociationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableVpcAssociationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLocalGatewayRouteTableVpcAssociationRequest)) {
            return false;
        }
        DeleteLocalGatewayRouteTableVpcAssociationRequest other = (DeleteLocalGatewayRouteTableVpcAssociationRequest) obj;
        return Objects.equals(localGatewayRouteTableVpcAssociationId(), other.localGatewayRouteTableVpcAssociationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLocalGatewayRouteTableVpcAssociationRequest")
                .add("LocalGatewayRouteTableVpcAssociationId", localGatewayRouteTableVpcAssociationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTableVpcAssociationId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableVpcAssociationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLocalGatewayRouteTableVpcAssociationRequest, T> g) {
        return obj -> g.apply((DeleteLocalGatewayRouteTableVpcAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteLocalGatewayRouteTableVpcAssociationRequest> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param localGatewayRouteTableVpcAssociationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableVpcAssociationId(String localGatewayRouteTableVpcAssociationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String localGatewayRouteTableVpcAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLocalGatewayRouteTableVpcAssociationRequest model) {
            super(model);
            localGatewayRouteTableVpcAssociationId(model.localGatewayRouteTableVpcAssociationId);
        }

        public final String getLocalGatewayRouteTableVpcAssociationId() {
            return localGatewayRouteTableVpcAssociationId;
        }

        public final void setLocalGatewayRouteTableVpcAssociationId(String localGatewayRouteTableVpcAssociationId) {
            this.localGatewayRouteTableVpcAssociationId = localGatewayRouteTableVpcAssociationId;
        }

        @Override
        @Transient
        public final Builder localGatewayRouteTableVpcAssociationId(String localGatewayRouteTableVpcAssociationId) {
            this.localGatewayRouteTableVpcAssociationId = localGatewayRouteTableVpcAssociationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLocalGatewayRouteTableVpcAssociationRequest build() {
            return new DeleteLocalGatewayRouteTableVpcAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
