/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIdentityIdFormatRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIdentityIdFormatRequest.Builder, ModifyIdentityIdFormatRequest> {
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrincipalArn")
            .getter(getter(ModifyIdentityIdFormatRequest::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalArn")
                    .unmarshallLocationName("principalArn").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Resource")
            .getter(getter(ModifyIdentityIdFormatRequest::resource))
            .setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource")
                    .unmarshallLocationName("resource").build()).build();

    private static final SdkField<Boolean> USE_LONG_IDS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLongIds")
            .getter(getter(ModifyIdentityIdFormatRequest::useLongIds))
            .setter(setter(Builder::useLongIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLongIds")
                    .unmarshallLocationName("useLongIds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ARN_FIELD,
            RESOURCE_FIELD, USE_LONG_IDS_FIELD));

    private final String principalArn;

    private final String resource;

    private final Boolean useLongIds;

    private ModifyIdentityIdFormatRequest(BuilderImpl builder) {
        super(builder);
        this.principalArn = builder.principalArn;
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    /**
     * <p>
     * The ARN of the principal, which can be an IAM user, IAM role, or the root user. Specify <code>all</code> to
     * modify the ID format for all IAM users, IAM roles, and the root user of the account.
     * </p>
     * 
     * @return The ARN of the principal, which can be an IAM user, IAM role, or the root user. Specify <code>all</code>
     *         to modify the ID format for all IAM users, IAM roles, and the root user of the account.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> |
     * <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     * <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
     * <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> |
     * <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> |
     * <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
     * <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <p>
     * Alternatively, use the <code>all-current</code> option to include all resource types that are currently within
     * their opt-in period for longer IDs.
     * </p>
     * 
     * @return The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code>
     *         | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     *         <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
     *         <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> |
     *         <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> |
     *         <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
     *         <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> |
     *         <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code>
     *         | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p>
     *         <p>
     *         Alternatively, use the <code>all-current</code> option to include all resource types that are currently
     *         within their opt-in period for longer IDs.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * Indicates whether the resource should use longer IDs (17-character IDs)
     * </p>
     * 
     * @return Indicates whether the resource should use longer IDs (17-character IDs)
     */
    public final Boolean useLongIds() {
        return useLongIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(useLongIds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIdentityIdFormatRequest)) {
            return false;
        }
        ModifyIdentityIdFormatRequest other = (ModifyIdentityIdFormatRequest) obj;
        return Objects.equals(principalArn(), other.principalArn()) && Objects.equals(resource(), other.resource())
                && Objects.equals(useLongIds(), other.useLongIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIdentityIdFormatRequest").add("PrincipalArn", principalArn()).add("Resource", resource())
                .add("UseLongIds", useLongIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrincipalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "UseLongIds":
            return Optional.ofNullable(clazz.cast(useLongIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIdentityIdFormatRequest, T> g) {
        return obj -> g.apply((ModifyIdentityIdFormatRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIdentityIdFormatRequest> {
        /**
         * <p>
         * The ARN of the principal, which can be an IAM user, IAM role, or the root user. Specify <code>all</code> to
         * modify the ID format for all IAM users, IAM roles, and the root user of the account.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the principal, which can be an IAM user, IAM role, or the root user. Specify
         *        <code>all</code> to modify the ID format for all IAM users, IAM roles, and the root user of the
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> |
         * <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
         * <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
         * <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> |
         * <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> |
         * <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
         * <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> |
         * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
         * <code>vpn-connection</code> | <code>vpn-gateway</code>.
         * </p>
         * <p>
         * Alternatively, use the <code>all-current</code> option to include all resource types that are currently
         * within their opt-in period for longer IDs.
         * </p>
         * 
         * @param resource
         *        The type of resource: <code>bundle</code> | <code>conversion-task</code> |
         *        <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
         *        <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> |
         *        <code>image</code> | <code>import-task</code> | <code>internet-gateway</code> |
         *        <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> |
         *        <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>route-table</code> |
         *        <code>route-table-association</code> | <code>security-group</code> | <code>subnet</code> |
         *        <code>subnet-cidr-block-association</code> | <code>vpc</code> |
         *        <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> |
         *        <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p>
         *        <p>
         *        Alternatively, use the <code>all-current</code> option to include all resource types that are
         *        currently within their opt-in period for longer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * Indicates whether the resource should use longer IDs (17-character IDs)
         * </p>
         * 
         * @param useLongIds
         *        Indicates whether the resource should use longer IDs (17-character IDs)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLongIds(Boolean useLongIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String principalArn;

        private String resource;

        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIdentityIdFormatRequest model) {
            super(model);
            principalArn(model.principalArn);
            resource(model.resource);
            useLongIds(model.useLongIds);
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        @Transient
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        @Transient
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final Boolean getUseLongIds() {
            return useLongIds;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        @Override
        @Transient
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIdentityIdFormatRequest build() {
            return new ModifyIdentityIdFormatRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
