/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ManagedPrefixList;
import software.amazon.awssdk.services.ec2.model.ManagedPrefixListSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeManagedPrefixListsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeManagedPrefixListsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeManagedPrefixListsResponse.getter(DescribeManagedPrefixListsResponse::nextToken)).setter(DescribeManagedPrefixListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<ManagedPrefixList>> PREFIX_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrefixLists").getter(DescribeManagedPrefixListsResponse.getter(DescribeManagedPrefixListsResponse::prefixLists)).setter(DescribeManagedPrefixListsResponse.setter(Builder::prefixLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListSet").unmarshallLocationName("prefixListSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedPrefixList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PREFIX_LISTS_FIELD));
    private final String nextToken;
    private final List<ManagedPrefixList> prefixLists;

    private DescribeManagedPrefixListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.prefixLists = builder.prefixLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPrefixLists() {
        return this.prefixLists != null && !(this.prefixLists instanceof SdkAutoConstructList);
    }

    public final List<ManagedPrefixList> prefixLists() {
        return this.prefixLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrefixLists() ? this.prefixLists() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedPrefixListsResponse)) {
            return false;
        }
        DescribeManagedPrefixListsResponse other = (DescribeManagedPrefixListsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPrefixLists() == other.hasPrefixLists() && Objects.equals(this.prefixLists(), other.prefixLists());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeManagedPrefixListsResponse").add("NextToken", (Object)this.nextToken()).add("PrefixLists", this.hasPrefixLists() ? this.prefixLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PrefixLists": {
                return Optional.ofNullable(clazz.cast(this.prefixLists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedPrefixListsResponse, T> g) {
        return obj -> g.apply((DescribeManagedPrefixListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ManagedPrefixList> prefixLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedPrefixListsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.prefixLists(model.prefixLists);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ManagedPrefixList.Builder> getPrefixLists() {
            List<ManagedPrefixList.Builder> result = ManagedPrefixListSetCopier.copyToBuilder(this.prefixLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrefixLists(Collection<ManagedPrefixList.BuilderImpl> prefixLists) {
            this.prefixLists = ManagedPrefixListSetCopier.copyFromBuilder(prefixLists);
        }

        @Override
        @Transient
        public final Builder prefixLists(Collection<ManagedPrefixList> prefixLists) {
            this.prefixLists = ManagedPrefixListSetCopier.copy(prefixLists);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder prefixLists(ManagedPrefixList ... prefixLists) {
            this.prefixLists(Arrays.asList(prefixLists));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder prefixLists(Consumer<ManagedPrefixList.Builder> ... prefixLists) {
            this.prefixLists(Stream.of(prefixLists).map(c -> (ManagedPrefixList)((ManagedPrefixList.Builder)ManagedPrefixList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeManagedPrefixListsResponse build() {
            return new DescribeManagedPrefixListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeManagedPrefixListsResponse> {
        public Builder nextToken(String var1);

        public Builder prefixLists(Collection<ManagedPrefixList> var1);

        public Builder prefixLists(ManagedPrefixList ... var1);

        public Builder prefixLists(Consumer<ManagedPrefixList.Builder> ... var1);
    }
}

