/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHostsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeHostsRequest.Builder, DescribeHostsRequest> {
    private static final SdkField<List<Filter>> FILTER_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filter")
            .getter(getter(DescribeHostsRequest::filter))
            .setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> HOST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HostIds")
            .getter(getter(DescribeHostsRequest::hostIds))
            .setter(setter(Builder::hostIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId")
                    .unmarshallLocationName("hostId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeHostsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeHostsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, HOST_IDS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Filter> filter;

    private final List<String> hostIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeHostsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.hostIds = builder.hostIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> | <code>off</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the host.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client-token</code> - The idempotency token that you provided when you allocated the host.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> |
     * <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
     * <code>released-permanent-failure</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
     *         <code>off</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the host.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client-token</code> - The idempotency token that you provided when you allocated the host.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> |
     *         <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
     *         <code>released-permanent-failure</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     */
    public final List<Filter> filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the HostIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHostIds() {
        return hostIds != null && !(hostIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHostIds} method.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
     */
    public final List<String> hostIds() {
        return hostIds;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If
     * <code>maxResults</code> is given a larger value than 500, you receive an error.
     * </p>
     * <p>
     * You cannot specify this parameter and the host IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>nextToken</code> value. This value can be between
     *         5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
     *         <p>
     *         You cannot specify this parameter and the host IDs parameter in the same request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHostIds() ? hostIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsRequest)) {
            return false;
        }
        DescribeHostsRequest other = (DescribeHostsRequest) obj;
        return hasFilter() == other.hasFilter() && Objects.equals(filter(), other.filter()) && hasHostIds() == other.hasHostIds()
                && Objects.equals(hostIds(), other.hostIds()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHostsRequest").add("Filter", hasFilter() ? filter() : null)
                .add("HostIds", hasHostIds() ? hostIds() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "HostIds":
            return Optional.ofNullable(clazz.cast(hostIds()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostsRequest, T> g) {
        return obj -> g.apply((DescribeHostsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHostsRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         * <code>off</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token that you provided when you allocated the host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> |
         * <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         * <code>released-permanent-failure</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         *        <code>off</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token that you provided when you allocated the host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> |
         *        <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         *        <code>released-permanent-failure</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         * <code>off</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token that you provided when you allocated the host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> |
         * <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         * <code>released-permanent-failure</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         *        <code>off</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token that you provided when you allocated the host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> |
         *        <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         *        <code>released-permanent-failure</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         * <code>off</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token that you provided when you allocated the host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> |
         * <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         * <code>released-permanent-failure</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(List<Filter>)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(List<Filter>)
         */
        Builder filter(Consumer<Filter.Builder>... filter);

        /**
         * <p>
         * The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         * </p>
         * 
         * @param hostIds
         *        The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(Collection<String> hostIds);

        /**
         * <p>
         * The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         * </p>
         * 
         * @param hostIds
         *        The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(String... hostIds);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and
         * 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.
         * </p>
         * <p>
         * You cannot specify this parameter and the host IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>nextToken</code> value. This value can be
         *        between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an
         *        error.</p>
         *        <p>
         *        You cannot specify this parameter and the host IDs parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filter = DefaultSdkAutoConstructList.getInstance();

        private List<String> hostIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostsRequest model) {
            super(model);
            filter(model.filter);
            hostIds(model.hostIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<Filter.Builder> getFilter() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filter);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        @Override
        @Transient
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filter(Consumer<Filter.Builder>... filter) {
            filter(Stream.of(filter).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getHostIds() {
            if (hostIds instanceof SdkAutoConstructList) {
                return null;
            }
            return hostIds;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @Override
        @Transient
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hostIds(String... hostIds) {
            hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHostsRequest build() {
            return new DescribeHostsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
