/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceRouteRequest extends Ec2Request implements
        ToCopyableBuilder<ReplaceRouteRequest.Builder, ReplaceRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(ReplaceRouteRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("destinationCidrBlock").build()).build();

    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationIpv6CidrBlock")
            .getter(getter(ReplaceRouteRequest::destinationIpv6CidrBlock))
            .setter(setter(Builder::destinationIpv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock")
                    .unmarshallLocationName("destinationIpv6CidrBlock").build()).build();

    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationPrefixListId")
            .getter(getter(ReplaceRouteRequest::destinationPrefixListId))
            .setter(setter(Builder::destinationPrefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId")
                    .unmarshallLocationName("DestinationPrefixListId").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId")
            .getter(getter(ReplaceRouteRequest::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId")
                    .unmarshallLocationName("VpcEndpointId").build()).build();

    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EgressOnlyInternetGatewayId")
            .getter(getter(ReplaceRouteRequest::egressOnlyInternetGatewayId))
            .setter(setter(Builder::egressOnlyInternetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId")
                    .unmarshallLocationName("egressOnlyInternetGatewayId").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GatewayId")
            .getter(getter(ReplaceRouteRequest::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId")
                    .unmarshallLocationName("gatewayId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ReplaceRouteRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<Boolean> LOCAL_TARGET_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LocalTarget")
            .getter(getter(ReplaceRouteRequest::localTarget))
            .setter(setter(Builder::localTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalTarget")
                    .unmarshallLocationName("LocalTarget").build()).build();

    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId")
            .getter(getter(ReplaceRouteRequest::natGatewayId))
            .setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId")
                    .unmarshallLocationName("natGatewayId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(ReplaceRouteRequest::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("TransitGatewayId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId")
            .getter(getter(ReplaceRouteRequest::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("LocalGatewayId").build()).build();

    private static final SdkField<String> CARRIER_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CarrierGatewayId")
            .getter(getter(ReplaceRouteRequest::carrierGatewayId))
            .setter(setter(Builder::carrierGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewayId")
                    .unmarshallLocationName("CarrierGatewayId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(ReplaceRouteRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId")
            .getter(getter(ReplaceRouteRequest::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("routeTableId").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId")
            .getter(getter(ReplaceRouteRequest::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId")
                    .unmarshallLocationName("vpcPeeringConnectionId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkArn")
            .getter(getter(ReplaceRouteRequest::coreNetworkArn))
            .setter(setter(Builder::coreNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn")
                    .unmarshallLocationName("CoreNetworkArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD,
            DESTINATION_IPV6_CIDR_BLOCK_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD, VPC_ENDPOINT_ID_FIELD,
            EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, INSTANCE_ID_FIELD, LOCAL_TARGET_FIELD, NAT_GATEWAY_ID_FIELD,
            TRANSIT_GATEWAY_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, CARRIER_GATEWAY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD,
            ROUTE_TABLE_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD, CORE_NETWORK_ARN_FIELD));

    private final String destinationCidrBlock;

    private final String destinationIpv6CidrBlock;

    private final String destinationPrefixListId;

    private final String vpcEndpointId;

    private final String egressOnlyInternetGatewayId;

    private final String gatewayId;

    private final String instanceId;

    private final Boolean localTarget;

    private final String natGatewayId;

    private final String transitGatewayId;

    private final String localGatewayId;

    private final String carrierGatewayId;

    private final String networkInterfaceId;

    private final String routeTableId;

    private final String vpcPeeringConnectionId;

    private final String coreNetworkArn;

    private ReplaceRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.localTarget = builder.localTarget;
        this.natGatewayId = builder.natGatewayId;
        this.transitGatewayId = builder.transitGatewayId;
        this.localGatewayId = builder.localGatewayId;
        this.carrierGatewayId = builder.carrierGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.routeTableId = builder.routeTableId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.coreNetworkArn = builder.coreNetworkArn;
    }

    /**
     * <p>
     * The IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an
     * existing route in the table.
     * </p>
     * 
     * @return The IPv4 CIDR address block used for the destination match. The value that you provide must match the
     *         CIDR of an existing route in the table.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an
     * existing route in the table.
     * </p>
     * 
     * @return The IPv6 CIDR address block used for the destination match. The value that you provide must match the
     *         CIDR of an existing route in the table.
     */
    public final String destinationIpv6CidrBlock() {
        return destinationIpv6CidrBlock;
    }

    /**
     * <p>
     * The ID of the prefix list for the route.
     * </p>
     * 
     * @return The ID of the prefix list for the route.
     */
    public final String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    /**
     * <p>
     * The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.
     * </p>
     * 
     * @return The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * [IPv6 traffic only] The ID of an egress-only internet gateway.
     * </p>
     * 
     * @return [IPv6 traffic only] The ID of an egress-only internet gateway.
     */
    public final String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of an internet gateway or virtual private gateway.
     * </p>
     * 
     * @return The ID of an internet gateway or virtual private gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of a NAT instance in your VPC.
     * </p>
     * 
     * @return The ID of a NAT instance in your VPC.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Specifies whether to reset the local route to its default target (<code>local</code>).
     * </p>
     * 
     * @return Specifies whether to reset the local route to its default target (<code>local</code>).
     */
    public final Boolean localTarget() {
        return localTarget;
    }

    /**
     * <p>
     * [IPv4 traffic only] The ID of a NAT gateway.
     * </p>
     * 
     * @return [IPv4 traffic only] The ID of a NAT gateway.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The ID of a transit gateway.
     * </p>
     * 
     * @return The ID of a transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public final String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * [IPv4 traffic only] The ID of a carrier gateway.
     * </p>
     * 
     * @return [IPv4 traffic only] The ID of a carrier gateway.
     */
    public final String carrierGatewayId() {
        return carrierGatewayId;
    }

    /**
     * <p>
     * The ID of a network interface.
     * </p>
     * 
     * @return The ID of a network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The ID of a VPC peering connection.
     * </p>
     * 
     * @return The ID of a VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the core network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the core network.
     */
    public final String coreNetworkArn() {
        return coreNetworkArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(localTarget());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(carrierGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceRouteRequest)) {
            return false;
        }
        ReplaceRouteRequest other = (ReplaceRouteRequest) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock())
                && Objects.equals(destinationPrefixListId(), other.destinationPrefixListId())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId())
                && Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(localTarget(), other.localTarget()) && Objects.equals(natGatewayId(), other.natGatewayId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(localGatewayId(), other.localGatewayId())
                && Objects.equals(carrierGatewayId(), other.carrierGatewayId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(routeTableId(), other.routeTableId())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId())
                && Objects.equals(coreNetworkArn(), other.coreNetworkArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplaceRouteRequest").add("DestinationCidrBlock", destinationCidrBlock())
                .add("DestinationIpv6CidrBlock", destinationIpv6CidrBlock())
                .add("DestinationPrefixListId", destinationPrefixListId()).add("VpcEndpointId", vpcEndpointId())
                .add("EgressOnlyInternetGatewayId", egressOnlyInternetGatewayId()).add("GatewayId", gatewayId())
                .add("InstanceId", instanceId()).add("LocalTarget", localTarget()).add("NatGatewayId", natGatewayId())
                .add("TransitGatewayId", transitGatewayId()).add("LocalGatewayId", localGatewayId())
                .add("CarrierGatewayId", carrierGatewayId()).add("NetworkInterfaceId", networkInterfaceId())
                .add("RouteTableId", routeTableId()).add("VpcPeeringConnectionId", vpcPeeringConnectionId())
                .add("CoreNetworkArn", coreNetworkArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "DestinationIpv6CidrBlock":
            return Optional.ofNullable(clazz.cast(destinationIpv6CidrBlock()));
        case "DestinationPrefixListId":
            return Optional.ofNullable(clazz.cast(destinationPrefixListId()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "EgressOnlyInternetGatewayId":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGatewayId()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "LocalTarget":
            return Optional.ofNullable(clazz.cast(localTarget()));
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "CarrierGatewayId":
            return Optional.ofNullable(clazz.cast(carrierGatewayId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        case "CoreNetworkArn":
            return Optional.ofNullable(clazz.cast(coreNetworkArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceRouteRequest, T> g) {
        return obj -> g.apply((ReplaceRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ReplaceRouteRequest> {
        /**
         * <p>
         * The IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of
         * an existing route in the table.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The IPv4 CIDR address block used for the destination match. The value that you provide must match the
         *        CIDR of an existing route in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of
         * an existing route in the table.
         * </p>
         * 
         * @param destinationIpv6CidrBlock
         *        The IPv6 CIDR address block used for the destination match. The value that you provide must match the
         *        CIDR of an existing route in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock);

        /**
         * <p>
         * The ID of the prefix list for the route.
         * </p>
         * 
         * @param destinationPrefixListId
         *        The ID of the prefix list for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        /**
         * <p>
         * The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * [IPv6 traffic only] The ID of an egress-only internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        [IPv6 traffic only] The ID of an egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The ID of an internet gateway or virtual private gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of an internet gateway or virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of a NAT instance in your VPC.
         * </p>
         * 
         * @param instanceId
         *        The ID of a NAT instance in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Specifies whether to reset the local route to its default target (<code>local</code>).
         * </p>
         * 
         * @param localTarget
         *        Specifies whether to reset the local route to its default target (<code>local</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localTarget(Boolean localTarget);

        /**
         * <p>
         * [IPv4 traffic only] The ID of a NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        [IPv4 traffic only] The ID of a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The ID of a transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of a transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * [IPv4 traffic only] The ID of a carrier gateway.
         * </p>
         * 
         * @param carrierGatewayId
         *        [IPv4 traffic only] The ID of a carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierGatewayId(String carrierGatewayId);

        /**
         * <p>
         * The ID of a network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of a network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The ID of a VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of a VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the core network.
         * </p>
         * 
         * @param coreNetworkArn
         *        The Amazon Resource Name (ARN) of the core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkArn(String coreNetworkArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String destinationIpv6CidrBlock;

        private String destinationPrefixListId;

        private String vpcEndpointId;

        private String egressOnlyInternetGatewayId;

        private String gatewayId;

        private String instanceId;

        private Boolean localTarget;

        private String natGatewayId;

        private String transitGatewayId;

        private String localGatewayId;

        private String carrierGatewayId;

        private String networkInterfaceId;

        private String routeTableId;

        private String vpcPeeringConnectionId;

        private String coreNetworkArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceRouteRequest model) {
            super(model);
            destinationCidrBlock(model.destinationCidrBlock);
            destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            destinationPrefixListId(model.destinationPrefixListId);
            vpcEndpointId(model.vpcEndpointId);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            gatewayId(model.gatewayId);
            instanceId(model.instanceId);
            localTarget(model.localTarget);
            natGatewayId(model.natGatewayId);
            transitGatewayId(model.transitGatewayId);
            localGatewayId(model.localGatewayId);
            carrierGatewayId(model.carrierGatewayId);
            networkInterfaceId(model.networkInterfaceId);
            routeTableId(model.routeTableId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            coreNetworkArn(model.coreNetworkArn);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationIpv6CidrBlock() {
            return destinationIpv6CidrBlock;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        @Transient
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        @Transient
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        @Override
        @Transient
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        @Transient
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Boolean getLocalTarget() {
            return localTarget;
        }

        public final void setLocalTarget(Boolean localTarget) {
            this.localTarget = localTarget;
        }

        @Override
        @Transient
        public final Builder localTarget(Boolean localTarget) {
            this.localTarget = localTarget;
            return this;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        @Transient
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        @Transient
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        @Transient
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getCarrierGatewayId() {
            return carrierGatewayId;
        }

        public final void setCarrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
        }

        @Override
        @Transient
        public final Builder carrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        @Transient
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        @Transient
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        @Transient
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceRouteRequest build() {
            return new ReplaceRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
