/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCoipPoolsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeCoipPoolsResponse.Builder, DescribeCoipPoolsResponse> {
    private static final SdkField<List<CoipPool>> COIP_POOLS_FIELD = SdkField
            .<List<CoipPool>> builder(MarshallingType.LIST)
            .memberName("CoipPools")
            .getter(getter(DescribeCoipPoolsResponse::coipPools))
            .setter(setter(Builder::coipPools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipPoolSet")
                    .unmarshallLocationName("coipPoolSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CoipPool> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoipPool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCoipPoolsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COIP_POOLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CoipPool> coipPools;

    private final String nextToken;

    private DescribeCoipPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.coipPools = builder.coipPools;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CoipPools property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCoipPools() {
        return coipPools != null && !(coipPools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the address pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCoipPools} method.
     * </p>
     * 
     * @return Information about the address pools.
     */
    public final List<CoipPool> coipPools() {
        return coipPools;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCoipPools() ? coipPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCoipPoolsResponse)) {
            return false;
        }
        DescribeCoipPoolsResponse other = (DescribeCoipPoolsResponse) obj;
        return hasCoipPools() == other.hasCoipPools() && Objects.equals(coipPools(), other.coipPools())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCoipPoolsResponse").add("CoipPools", hasCoipPools() ? coipPools() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoipPools":
            return Optional.ofNullable(clazz.cast(coipPools()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCoipPoolsResponse, T> g) {
        return obj -> g.apply((DescribeCoipPoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCoipPoolsResponse> {
        /**
         * <p>
         * Information about the address pools.
         * </p>
         * 
         * @param coipPools
         *        Information about the address pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipPools(Collection<CoipPool> coipPools);

        /**
         * <p>
         * Information about the address pools.
         * </p>
         * 
         * @param coipPools
         *        Information about the address pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipPools(CoipPool... coipPools);

        /**
         * <p>
         * Information about the address pools.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CoipPool.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.CoipPool#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CoipPool.Builder#build()} is called immediately and its
         * result is passed to {@link #coipPools(List<CoipPool>)}.
         * 
         * @param coipPools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CoipPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coipPools(java.util.Collection<CoipPool>)
         */
        Builder coipPools(Consumer<CoipPool.Builder>... coipPools);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CoipPool> coipPools = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCoipPoolsResponse model) {
            super(model);
            coipPools(model.coipPools);
            nextToken(model.nextToken);
        }

        public final List<CoipPool.Builder> getCoipPools() {
            List<CoipPool.Builder> result = CoipPoolSetCopier.copyToBuilder(this.coipPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoipPools(Collection<CoipPool.BuilderImpl> coipPools) {
            this.coipPools = CoipPoolSetCopier.copyFromBuilder(coipPools);
        }

        @Override
        public final Builder coipPools(Collection<CoipPool> coipPools) {
            this.coipPools = CoipPoolSetCopier.copy(coipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipPools(CoipPool... coipPools) {
            coipPools(Arrays.asList(coipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipPools(Consumer<CoipPool.Builder>... coipPools) {
            coipPools(Stream.of(coipPools).map(c -> CoipPool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCoipPoolsResponse build() {
            return new DescribeCoipPoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
