/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RegisterImage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterImageRequest extends Ec2Request implements
        ToCopyableBuilder<RegisterImageRequest.Builder, RegisterImageRequest> {
    private static final SdkField<String> IMAGE_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageLocation")
            .getter(getter(RegisterImageRequest::imageLocation))
            .setter(setter(Builder::imageLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageLocation")
                    .unmarshallLocationName("ImageLocation").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Architecture")
            .getter(getter(RegisterImageRequest::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture")
                    .unmarshallLocationName("architecture").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(RegisterImageRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("BlockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BlockDeviceMapping")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BlockDeviceMapping")
                                                    .unmarshallLocationName("BlockDeviceMapping").build()).build()).build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(RegisterImageRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> ENA_SUPPORT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnaSupport")
            .getter(getter(RegisterImageRequest::enaSupport))
            .setter(setter(Builder::enaSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport")
                    .unmarshallLocationName("enaSupport").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(RegisterImageRequest::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("kernelId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(RegisterImageRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<List<String>> BILLING_PRODUCTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BillingProducts")
            .getter(getter(RegisterImageRequest::billingProducts))
            .setter(setter(Builder::billingProducts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingProduct")
                    .unmarshallLocationName("BillingProduct").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId")
            .getter(getter(RegisterImageRequest::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("ramdiskId").build()).build();

    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RootDeviceName")
            .getter(getter(RegisterImageRequest::rootDeviceName))
            .setter(setter(Builder::rootDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName")
                    .unmarshallLocationName("rootDeviceName").build()).build();

    private static final SdkField<String> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SriovNetSupport")
            .getter(getter(RegisterImageRequest::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VirtualizationType")
            .getter(getter(RegisterImageRequest::virtualizationType))
            .setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType")
                    .unmarshallLocationName("virtualizationType").build()).build();

    private static final SdkField<String> BOOT_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootMode")
            .getter(getter(RegisterImageRequest::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode")
                    .unmarshallLocationName("BootMode").build()).build();

    private static final SdkField<String> TPM_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TpmSupport")
            .getter(getter(RegisterImageRequest::tpmSupportAsString))
            .setter(setter(Builder::tpmSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TpmSupport")
                    .unmarshallLocationName("TpmSupport").build()).build();

    private static final SdkField<String> UEFI_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UefiData")
            .getter(getter(RegisterImageRequest::uefiData))
            .setter(setter(Builder::uefiData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UefiData")
                    .unmarshallLocationName("UefiData").build()).build();

    private static final SdkField<String> IMDS_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImdsSupport")
            .getter(getter(RegisterImageRequest::imdsSupportAsString))
            .setter(setter(Builder::imdsSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImdsSupport")
                    .unmarshallLocationName("ImdsSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_LOCATION_FIELD,
            ARCHITECTURE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, DESCRIPTION_FIELD, ENA_SUPPORT_FIELD, KERNEL_ID_FIELD, NAME_FIELD,
            BILLING_PRODUCTS_FIELD, RAMDISK_ID_FIELD, ROOT_DEVICE_NAME_FIELD, SRIOV_NET_SUPPORT_FIELD, VIRTUALIZATION_TYPE_FIELD,
            BOOT_MODE_FIELD, TPM_SUPPORT_FIELD, UEFI_DATA_FIELD, IMDS_SUPPORT_FIELD));

    private final String imageLocation;

    private final String architecture;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String description;

    private final Boolean enaSupport;

    private final String kernelId;

    private final String name;

    private final List<String> billingProducts;

    private final String ramdiskId;

    private final String rootDeviceName;

    private final String sriovNetSupport;

    private final String virtualizationType;

    private final String bootMode;

    private final String tpmSupport;

    private final String uefiData;

    private final String imdsSupport;

    private RegisterImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageLocation = builder.imageLocation;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.kernelId = builder.kernelId;
        this.name = builder.name;
        this.billingProducts = builder.billingProducts;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.virtualizationType = builder.virtualizationType;
        this.bootMode = builder.bootMode;
        this.tpmSupport = builder.tpmSupport;
        this.uefiData = builder.uefiData;
        this.imdsSupport = builder.imdsSupport;
    }

    /**
     * <p>
     * The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the
     * <code>aws-exec-read</code> canned access control list (ACL) to ensure that it can be accessed by Amazon EC2. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACLs</a> in the
     * <i>Amazon S3 Service Developer Guide</i>.
     * </p>
     * 
     * @return The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the
     *         <code>aws-exec-read</code> canned access control list (ACL) to ensure that it can be accessed by Amazon
     *         EC2. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACLs</a> in
     *         the <i>Amazon S3 Service Developer Guide</i>.
     */
    public final String imageLocation() {
        return imageLocation;
    }

    /**
     * <p>
     * The architecture of the AMI.
     * </p>
     * <p>
     * Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
     * specified in the manifest file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the AMI.</p>
     *         <p>
     *         Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
     *         specified in the manifest file.
     * @see ArchitectureValues
     */
    public final ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the AMI.
     * </p>
     * <p>
     * Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
     * specified in the manifest file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the AMI.</p>
     *         <p>
     *         Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
     *         specified in the manifest file.
     * @see ArchitectureValues
     */
    public final String architectureAsString() {
        return architecture;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping entries.
     * </p>
     * <p>
     * If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the encryption
     * state of the volume.
     * </p>
     * <p>
     * If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region of
     * that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same Outpost
     * only. For more information, <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local
     * snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return The block device mapping entries.</p>
     *         <p>
     *         If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the
     *         encryption state of the volume.
     *         </p>
     *         <p>
     *         If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the
     *         Region of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances
     *         on the same Outpost only. For more information, <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local
     *         snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * A description for your AMI.
     * </p>
     * 
     * @return A description for your AMI.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you launch
     * from the AMI.
     * </p>
     * <p>
     * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from
     * the AMI unreachable.
     * </p>
     * 
     * @return Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you
     *         launch from the AMI.</p>
     *         <p>
     *         This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances
     *         launched from the AMI unreachable.
     */
    public final Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * A name for your AMI.
     * </p>
     * <p>
     * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
     * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     * </p>
     * 
     * @return A name for your AMI.</p>
     *         <p>
     *         Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods
     *         (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the BillingProducts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBillingProducts() {
        return billingProducts != null && !(billingProducts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise, you can
     * use the Amazon Web Services Marketplace to bill for the use of an AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBillingProducts} method.
     * </p>
     * 
     * @return The billing product codes. Your account must be authorized to specify billing product codes. Otherwise,
     *         you can use the Amazon Web Services Marketplace to bill for the use of an AMI.
     */
    public final List<String> billingProducts() {
        return billingProducts;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public final String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the
     * AMI and any instances that you launch from the AMI.
     * </p>
     * <p>
     * There is no way to disable <code>sriovNetSupport</code> at this time.
     * </p>
     * <p>
     * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from
     * the AMI unreachable.
     * </p>
     * 
     * @return Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface
     *         for the AMI and any instances that you launch from the AMI.</p>
     *         <p>
     *         There is no way to disable <code>sriovNetSupport</code> at this time.
     *         </p>
     *         <p>
     *         This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances
     *         launched from the AMI unreachable.
     */
    public final String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The type of virtualization (<code>hvm</code> | <code>paravirtual</code>).
     * </p>
     * <p>
     * Default: <code>paravirtual</code>
     * </p>
     * 
     * @return The type of virtualization (<code>hvm</code> | <code>paravirtual</code>).</p>
     *         <p>
     *         Default: <code>paravirtual</code>
     */
    public final String virtualizationType() {
        return virtualizationType;
    }

    /**
     * <p>
     * The boot mode of the AMI. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon Elastic
     * Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode of the AMI. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon
     *         Elastic Compute Cloud User Guide</i>.
     * @see BootModeValues
     */
    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(bootMode);
    }

    /**
     * <p>
     * The boot mode of the AMI. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon Elastic
     * Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode of the AMI. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon
     *         Elastic Compute Cloud User Guide</i>.
     * @see BootModeValues
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    /**
     * <p>
     * Set to <code>v2.0</code> to enable Trusted Platform Module (TPM) support. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon Elastic
     * Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tpmSupport} will
     * return {@link TpmSupportValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tpmSupportAsString}.
     * </p>
     * 
     * @return Set to <code>v2.0</code> to enable Trusted Platform Module (TPM) support. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon
     *         Elastic Compute Cloud User Guide</i>.
     * @see TpmSupportValues
     */
    public final TpmSupportValues tpmSupport() {
        return TpmSupportValues.fromValue(tpmSupport);
    }

    /**
     * <p>
     * Set to <code>v2.0</code> to enable Trusted Platform Module (TPM) support. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon Elastic
     * Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tpmSupport} will
     * return {@link TpmSupportValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tpmSupportAsString}.
     * </p>
     * 
     * @return Set to <code>v2.0</code> to enable Trusted Platform Module (TPM) support. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon
     *         Elastic Compute Cloud User Guide</i>.
     * @see TpmSupportValues
     */
    public final String tpmSupportAsString() {
        return tpmSupport;
    }

    /**
     * <p>
     * Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a>
     * command. You can inspect and modify the UEFI data by using the <a
     * href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
     *         href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a>
     *         command. You can inspect and modify the UEFI data by using the <a
     *         href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more
     *         information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI
     *         Secure Boot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final String uefiData() {
        return uefiData;
    }

    /**
     * <p>
     * Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this AMI will
     * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
     * requires that IMDSv2 is used when requesting instance metadata. In addition, <code>HttpPutResponseHopLimit</code>
     * is set to <code>2</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     * >Configure the AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <note>
     * <p>
     * If you set the value to <code>v2.0</code>, make sure that your AMI software can support IMDSv2.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imdsSupport} will
     * return {@link ImdsSupportValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imdsSupportAsString}.
     * </p>
     * 
     * @return Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this
     *         AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
     *         instance requires that IMDSv2 is used when requesting instance metadata. In addition,
     *         <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     *         >Configure the AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <note>
     *         <p>
     *         If you set the value to <code>v2.0</code>, make sure that your AMI software can support IMDSv2.
     *         </p>
     * @see ImdsSupportValues
     */
    public final ImdsSupportValues imdsSupport() {
        return ImdsSupportValues.fromValue(imdsSupport);
    }

    /**
     * <p>
     * Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this AMI will
     * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
     * requires that IMDSv2 is used when requesting instance metadata. In addition, <code>HttpPutResponseHopLimit</code>
     * is set to <code>2</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     * >Configure the AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <note>
     * <p>
     * If you set the value to <code>v2.0</code>, make sure that your AMI software can support IMDSv2.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imdsSupport} will
     * return {@link ImdsSupportValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imdsSupportAsString}.
     * </p>
     * 
     * @return Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this
     *         AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
     *         instance requires that IMDSv2 is used when requesting instance metadata. In addition,
     *         <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     *         >Configure the AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <note>
     *         <p>
     *         If you set the value to <code>v2.0</code>, make sure that your AMI software can support IMDSv2.
     *         </p>
     * @see ImdsSupportValues
     */
    public final String imdsSupportAsString() {
        return imdsSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasBillingProducts() ? billingProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationType());
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tpmSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uefiData());
        hashCode = 31 * hashCode + Objects.hashCode(imdsSupportAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterImageRequest)) {
            return false;
        }
        RegisterImageRequest other = (RegisterImageRequest) obj;
        return Objects.equals(imageLocation(), other.imageLocation())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(description(), other.description()) && Objects.equals(enaSupport(), other.enaSupport())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(name(), other.name())
                && hasBillingProducts() == other.hasBillingProducts()
                && Objects.equals(billingProducts(), other.billingProducts()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(virtualizationType(), other.virtualizationType())
                && Objects.equals(bootModeAsString(), other.bootModeAsString())
                && Objects.equals(tpmSupportAsString(), other.tpmSupportAsString())
                && Objects.equals(uefiData(), other.uefiData())
                && Objects.equals(imdsSupportAsString(), other.imdsSupportAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterImageRequest").add("ImageLocation", imageLocation())
                .add("Architecture", architectureAsString())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("Description", description()).add("EnaSupport", enaSupport()).add("KernelId", kernelId())
                .add("Name", name()).add("BillingProducts", hasBillingProducts() ? billingProducts() : null)
                .add("RamdiskId", ramdiskId()).add("RootDeviceName", rootDeviceName()).add("SriovNetSupport", sriovNetSupport())
                .add("VirtualizationType", virtualizationType()).add("BootMode", bootModeAsString())
                .add("TpmSupport", tpmSupportAsString()).add("UefiData", uefiData()).add("ImdsSupport", imdsSupportAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageLocation":
            return Optional.ofNullable(clazz.cast(imageLocation()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EnaSupport":
            return Optional.ofNullable(clazz.cast(enaSupport()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "BillingProducts":
            return Optional.ofNullable(clazz.cast(billingProducts()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "RootDeviceName":
            return Optional.ofNullable(clazz.cast(rootDeviceName()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationType()));
        case "BootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        case "TpmSupport":
            return Optional.ofNullable(clazz.cast(tpmSupportAsString()));
        case "UefiData":
            return Optional.ofNullable(clazz.cast(uefiData()));
        case "ImdsSupport":
            return Optional.ofNullable(clazz.cast(imdsSupportAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterImageRequest, T> g) {
        return obj -> g.apply((RegisterImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RegisterImageRequest> {
        /**
         * <p>
         * The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the
         * <code>aws-exec-read</code> canned access control list (ACL) to ensure that it can be accessed by Amazon EC2.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACLs</a> in the
         * <i>Amazon S3 Service Developer Guide</i>.
         * </p>
         * 
         * @param imageLocation
         *        The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the
         *        <code>aws-exec-read</code> canned access control list (ACL) to ensure that it can be accessed by
         *        Amazon EC2. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACLs</a> in
         *        the <i>Amazon S3 Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageLocation(String imageLocation);

        /**
         * <p>
         * The architecture of the AMI.
         * </p>
         * <p>
         * Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
         * specified in the manifest file.
         * </p>
         * 
         * @param architecture
         *        The architecture of the AMI.</p>
         *        <p>
         *        Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the
         *        architecture specified in the manifest file.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the AMI.
         * </p>
         * <p>
         * Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture
         * specified in the manifest file.
         * </p>
         * 
         * @param architecture
         *        The architecture of the AMI.</p>
         *        <p>
         *        Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the
         *        architecture specified in the manifest file.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * <p>
         * If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the encryption
         * state of the volume.
         * </p>
         * <p>
         * If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region
         * of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same
         * Outpost only. For more information, <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local
         * snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.</p>
         *        <p>
         *        If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the
         *        encryption state of the volume.
         *        </p>
         *        <p>
         *        If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the
         *        Region of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch
         *        instances on the same Outpost only. For more information, <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS
         *        local snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * <p>
         * If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the encryption
         * state of the volume.
         * </p>
         * <p>
         * If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region
         * of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same
         * Outpost only. For more information, <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local
         * snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.</p>
         *        <p>
         *        If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the
         *        encryption state of the volume.
         *        </p>
         *        <p>
         *        If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the
         *        Region of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch
         *        instances on the same Outpost only. For more information, <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS
         *        local snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * <p>
         * If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the encryption
         * state of the volume.
         * </p>
         * <p>
         * If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region
         * of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same
         * Outpost only. For more information, <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local
         * snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * A description for your AMI.
         * </p>
         * 
         * @param description
         *        A description for your AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you launch
         * from the AMI.
         * </p>
         * <p>
         * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched
         * from the AMI unreachable.
         * </p>
         * 
         * @param enaSupport
         *        Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you
         *        launch from the AMI.</p>
         *        <p>
         *        This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances
         *        launched from the AMI unreachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * A name for your AMI.
         * </p>
         * <p>
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
         * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * </p>
         * 
         * @param name
         *        A name for your AMI.</p>
         *        <p>
         *        Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ),
         *        periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise, you
         * can use the Amazon Web Services Marketplace to bill for the use of an AMI.
         * </p>
         * 
         * @param billingProducts
         *        The billing product codes. Your account must be authorized to specify billing product codes.
         *        Otherwise, you can use the Amazon Web Services Marketplace to bill for the use of an AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingProducts(Collection<String> billingProducts);

        /**
         * <p>
         * The billing product codes. Your account must be authorized to specify billing product codes. Otherwise, you
         * can use the Amazon Web Services Marketplace to bill for the use of an AMI.
         * </p>
         * 
         * @param billingProducts
         *        The billing product codes. Your account must be authorized to specify billing product codes.
         *        Otherwise, you can use the Amazon Web Services Marketplace to bill for the use of an AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingProducts(String... billingProducts);

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for
         * the AMI and any instances that you launch from the AMI.
         * </p>
         * <p>
         * There is no way to disable <code>sriovNetSupport</code> at this time.
         * </p>
         * <p>
         * This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched
         * from the AMI unreachable.
         * </p>
         * 
         * @param sriovNetSupport
         *        Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function
         *        interface for the AMI and any instances that you launch from the AMI.</p>
         *        <p>
         *        There is no way to disable <code>sriovNetSupport</code> at this time.
         *        </p>
         *        <p>
         *        This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances
         *        launched from the AMI unreachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The type of virtualization (<code>hvm</code> | <code>paravirtual</code>).
         * </p>
         * <p>
         * Default: <code>paravirtual</code>
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization (<code>hvm</code> | <code>paravirtual</code>).</p>
         *        <p>
         *        Default: <code>paravirtual</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The boot mode of the AMI. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon
         * Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param bootMode
         *        The boot mode of the AMI. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * The boot mode of the AMI. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon
         * Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param bootMode
         *        The boot mode of the AMI. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(BootModeValues bootMode);

        /**
         * <p>
         * Set to <code>v2.0</code> to enable Trusted Platform Module (TPM) support. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon
         * Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param tpmSupport
         *        Set to <code>v2.0</code> to enable Trusted Platform Module (TPM) support. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon
         *        Elastic Compute Cloud User Guide</i>.
         * @see TpmSupportValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TpmSupportValues
         */
        Builder tpmSupport(String tpmSupport);

        /**
         * <p>
         * Set to <code>v2.0</code> to enable Trusted Platform Module (TPM) support. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon
         * Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param tpmSupport
         *        Set to <code>v2.0</code> to enable Trusted Platform Module (TPM) support. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon
         *        Elastic Compute Cloud User Guide</i>.
         * @see TpmSupportValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TpmSupportValues
         */
        Builder tpmSupport(TpmSupportValues tpmSupport);

        /**
         * <p>
         * Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a>
         * command. You can inspect and modify the UEFI data by using the <a
         * href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a>
         * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param uefiData
         *        Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
         *        href
         *        ="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData
         *        </a> command. You can inspect and modify the UEFI data by using the <a
         *        href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uefiData(String uefiData);

        /**
         * <p>
         * Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this AMI
         * will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
         * instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         * <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         * >Configure the AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If you set the value to <code>v2.0</code>, make sure that your AMI software can support IMDSv2.
         * </p>
         * </note>
         * 
         * @param imdsSupport
         *        Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this
         *        AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default,
         *        the instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         *        <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         *        >Configure the AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <note>
         *        <p>
         *        If you set the value to <code>v2.0</code>, make sure that your AMI software can support IMDSv2.
         *        </p>
         * @see ImdsSupportValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImdsSupportValues
         */
        Builder imdsSupport(String imdsSupport);

        /**
         * <p>
         * Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this AMI
         * will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
         * instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         * <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         * >Configure the AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If you set the value to <code>v2.0</code>, make sure that your AMI software can support IMDSv2.
         * </p>
         * </note>
         * 
         * @param imdsSupport
         *        Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this
         *        AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default,
         *        the instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         *        <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         *        >Configure the AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <note>
         *        <p>
         *        If you set the value to <code>v2.0</code>, make sure that your AMI software can support IMDSv2.
         *        </p>
         * @see ImdsSupportValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImdsSupportValues
         */
        Builder imdsSupport(ImdsSupportValues imdsSupport);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String imageLocation;

        private String architecture;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean enaSupport;

        private String kernelId;

        private String name;

        private List<String> billingProducts = DefaultSdkAutoConstructList.getInstance();

        private String ramdiskId;

        private String rootDeviceName;

        private String sriovNetSupport;

        private String virtualizationType;

        private String bootMode;

        private String tpmSupport;

        private String uefiData;

        private String imdsSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterImageRequest model) {
            super(model);
            imageLocation(model.imageLocation);
            architecture(model.architecture);
            blockDeviceMappings(model.blockDeviceMappings);
            description(model.description);
            enaSupport(model.enaSupport);
            kernelId(model.kernelId);
            name(model.name);
            billingProducts(model.billingProducts);
            ramdiskId(model.ramdiskId);
            rootDeviceName(model.rootDeviceName);
            sriovNetSupport(model.sriovNetSupport);
            virtualizationType(model.virtualizationType);
            bootMode(model.bootMode);
            tpmSupport(model.tpmSupport);
            uefiData(model.uefiData);
            imdsSupport(model.imdsSupport);
        }

        public final String getImageLocation() {
            return imageLocation;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingRequestListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getBillingProducts() {
            if (billingProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return billingProducts;
        }

        public final void setBillingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
        }

        @Override
        public final Builder billingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingProducts(String... billingProducts) {
            billingProducts(Arrays.asList(billingProducts));
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final String getTpmSupport() {
            return tpmSupport;
        }

        public final void setTpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
        }

        @Override
        public final Builder tpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
            return this;
        }

        @Override
        public final Builder tpmSupport(TpmSupportValues tpmSupport) {
            this.tpmSupport(tpmSupport == null ? null : tpmSupport.toString());
            return this;
        }

        public final String getUefiData() {
            return uefiData;
        }

        public final void setUefiData(String uefiData) {
            this.uefiData = uefiData;
        }

        @Override
        public final Builder uefiData(String uefiData) {
            this.uefiData = uefiData;
            return this;
        }

        public final String getImdsSupport() {
            return imdsSupport;
        }

        public final void setImdsSupport(String imdsSupport) {
            this.imdsSupport = imdsSupport;
        }

        @Override
        public final Builder imdsSupport(String imdsSupport) {
            this.imdsSupport = imdsSupport;
            return this;
        }

        @Override
        public final Builder imdsSupport(ImdsSupportValues imdsSupport) {
            this.imdsSupport(imdsSupport == null ? null : imdsSupport.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterImageRequest build() {
            return new RegisterImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
