/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a Spot Fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotFleetRequestConfigData implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotFleetRequestConfigData.Builder, SpotFleetRequestConfigData> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationStrategy")
            .getter(getter(SpotFleetRequestConfigData::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy")
                    .unmarshallLocationName("allocationStrategy").build()).build();

    private static final SdkField<String> ON_DEMAND_ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OnDemandAllocationStrategy")
            .getter(getter(SpotFleetRequestConfigData::onDemandAllocationStrategyAsString))
            .setter(setter(Builder::onDemandAllocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandAllocationStrategy")
                    .unmarshallLocationName("onDemandAllocationStrategy").build()).build();

    private static final SdkField<SpotMaintenanceStrategies> SPOT_MAINTENANCE_STRATEGIES_FIELD = SdkField
            .<SpotMaintenanceStrategies> builder(MarshallingType.SDK_POJO)
            .memberName("SpotMaintenanceStrategies")
            .getter(getter(SpotFleetRequestConfigData::spotMaintenanceStrategies))
            .setter(setter(Builder::spotMaintenanceStrategies))
            .constructor(SpotMaintenanceStrategies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotMaintenanceStrategies")
                    .unmarshallLocationName("spotMaintenanceStrategies").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(SpotFleetRequestConfigData::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExcessCapacityTerminationPolicy")
            .getter(getter(SpotFleetRequestConfigData::excessCapacityTerminationPolicyAsString))
            .setter(setter(Builder::excessCapacityTerminationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy")
                    .unmarshallLocationName("excessCapacityTerminationPolicy").build()).build();

    private static final SdkField<Double> FULFILLED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("FulfilledCapacity")
            .getter(getter(SpotFleetRequestConfigData::fulfilledCapacity))
            .setter(setter(Builder::fulfilledCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledCapacity")
                    .unmarshallLocationName("fulfilledCapacity").build()).build();

    private static final SdkField<Double> ON_DEMAND_FULFILLED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("OnDemandFulfilledCapacity")
            .getter(getter(SpotFleetRequestConfigData::onDemandFulfilledCapacity))
            .setter(setter(Builder::onDemandFulfilledCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandFulfilledCapacity")
                    .unmarshallLocationName("onDemandFulfilledCapacity").build()).build();

    private static final SdkField<String> IAM_FLEET_ROLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IamFleetRole")
            .getter(getter(SpotFleetRequestConfigData::iamFleetRole))
            .setter(setter(Builder::iamFleetRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamFleetRole")
                    .unmarshallLocationName("iamFleetRole").build()).build();

    private static final SdkField<List<SpotFleetLaunchSpecification>> LAUNCH_SPECIFICATIONS_FIELD = SdkField
            .<List<SpotFleetLaunchSpecification>> builder(MarshallingType.LIST)
            .memberName("LaunchSpecifications")
            .getter(getter(SpotFleetRequestConfigData::launchSpecifications))
            .setter(setter(Builder::launchSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecifications")
                    .unmarshallLocationName("launchSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SpotFleetLaunchSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpotFleetLaunchSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<LaunchTemplateConfig>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField
            .<List<LaunchTemplateConfig>> builder(MarshallingType.LIST)
            .memberName("LaunchTemplateConfigs")
            .getter(getter(SpotFleetRequestConfigData::launchTemplateConfigs))
            .setter(setter(Builder::launchTemplateConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfigs")
                    .unmarshallLocationName("launchTemplateConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotPrice")
            .getter(getter(SpotFleetRequestConfigData::spotPrice))
            .setter(setter(Builder::spotPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice")
                    .unmarshallLocationName("spotPrice").build()).build();

    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetCapacity")
            .getter(getter(SpotFleetRequestConfigData::targetCapacity))
            .setter(setter(Builder::targetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacity")
                    .unmarshallLocationName("targetCapacity").build()).build();

    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandTargetCapacity")
            .getter(getter(SpotFleetRequestConfigData::onDemandTargetCapacity))
            .setter(setter(Builder::onDemandTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity")
                    .unmarshallLocationName("onDemandTargetCapacity").build()).build();

    private static final SdkField<String> ON_DEMAND_MAX_TOTAL_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OnDemandMaxTotalPrice")
            .getter(getter(SpotFleetRequestConfigData::onDemandMaxTotalPrice))
            .setter(setter(Builder::onDemandMaxTotalPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandMaxTotalPrice")
                    .unmarshallLocationName("onDemandMaxTotalPrice").build()).build();

    private static final SdkField<String> SPOT_MAX_TOTAL_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotMaxTotalPrice")
            .getter(getter(SpotFleetRequestConfigData::spotMaxTotalPrice))
            .setter(setter(Builder::spotMaxTotalPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotMaxTotalPrice")
                    .unmarshallLocationName("spotMaxTotalPrice").build()).build();

    private static final SdkField<Boolean> TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminateInstancesWithExpiration")
            .getter(getter(SpotFleetRequestConfigData::terminateInstancesWithExpiration))
            .setter(setter(Builder::terminateInstancesWithExpiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstancesWithExpiration")
                    .unmarshallLocationName("terminateInstancesWithExpiration").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(SpotFleetRequestConfigData::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidFrom")
            .getter(getter(SpotFleetRequestConfigData::validFrom))
            .setter(setter(Builder::validFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom")
                    .unmarshallLocationName("validFrom").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidUntil")
            .getter(getter(SpotFleetRequestConfigData::validUntil))
            .setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil")
                    .unmarshallLocationName("validUntil").build()).build();

    private static final SdkField<Boolean> REPLACE_UNHEALTHY_INSTANCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReplaceUnhealthyInstances")
            .getter(getter(SpotFleetRequestConfigData::replaceUnhealthyInstances))
            .setter(setter(Builder::replaceUnhealthyInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceUnhealthyInstances")
                    .unmarshallLocationName("replaceUnhealthyInstances").build()).build();

    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceInterruptionBehavior")
            .getter(getter(SpotFleetRequestConfigData::instanceInterruptionBehaviorAsString))
            .setter(setter(Builder::instanceInterruptionBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior")
                    .unmarshallLocationName("instanceInterruptionBehavior").build()).build();

    private static final SdkField<LoadBalancersConfig> LOAD_BALANCERS_CONFIG_FIELD = SdkField
            .<LoadBalancersConfig> builder(MarshallingType.SDK_POJO)
            .memberName("LoadBalancersConfig")
            .getter(getter(SpotFleetRequestConfigData::loadBalancersConfig))
            .setter(setter(Builder::loadBalancersConfig))
            .constructor(LoadBalancersConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancersConfig")
                    .unmarshallLocationName("loadBalancersConfig").build()).build();

    private static final SdkField<Integer> INSTANCE_POOLS_TO_USE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstancePoolsToUseCount")
            .getter(getter(SpotFleetRequestConfigData::instancePoolsToUseCount))
            .setter(setter(Builder::instancePoolsToUseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePoolsToUseCount")
                    .unmarshallLocationName("instancePoolsToUseCount").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Context")
            .getter(getter(SpotFleetRequestConfigData::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context")
                    .unmarshallLocationName("context").build()).build();

    private static final SdkField<String> TARGET_CAPACITY_UNIT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetCapacityUnitType")
            .getter(getter(SpotFleetRequestConfigData::targetCapacityUnitTypeAsString))
            .setter(setter(Builder::targetCapacityUnitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacityUnitType")
                    .unmarshallLocationName("targetCapacityUnitType").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(SpotFleetRequestConfigData::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD,
            ON_DEMAND_ALLOCATION_STRATEGY_FIELD, SPOT_MAINTENANCE_STRATEGIES_FIELD, CLIENT_TOKEN_FIELD,
            EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, FULFILLED_CAPACITY_FIELD, ON_DEMAND_FULFILLED_CAPACITY_FIELD,
            IAM_FLEET_ROLE_FIELD, LAUNCH_SPECIFICATIONS_FIELD, LAUNCH_TEMPLATE_CONFIGS_FIELD, SPOT_PRICE_FIELD,
            TARGET_CAPACITY_FIELD, ON_DEMAND_TARGET_CAPACITY_FIELD, ON_DEMAND_MAX_TOTAL_PRICE_FIELD, SPOT_MAX_TOTAL_PRICE_FIELD,
            TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD, TYPE_FIELD, VALID_FROM_FIELD, VALID_UNTIL_FIELD,
            REPLACE_UNHEALTHY_INSTANCES_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, LOAD_BALANCERS_CONFIG_FIELD,
            INSTANCE_POOLS_TO_USE_COUNT_FIELD, CONTEXT_FIELD, TARGET_CAPACITY_UNIT_TYPE_FIELD, TAG_SPECIFICATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationStrategy;

    private final String onDemandAllocationStrategy;

    private final SpotMaintenanceStrategies spotMaintenanceStrategies;

    private final String clientToken;

    private final String excessCapacityTerminationPolicy;

    private final Double fulfilledCapacity;

    private final Double onDemandFulfilledCapacity;

    private final String iamFleetRole;

    private final List<SpotFleetLaunchSpecification> launchSpecifications;

    private final List<LaunchTemplateConfig> launchTemplateConfigs;

    private final String spotPrice;

    private final Integer targetCapacity;

    private final Integer onDemandTargetCapacity;

    private final String onDemandMaxTotalPrice;

    private final String spotMaxTotalPrice;

    private final Boolean terminateInstancesWithExpiration;

    private final String type;

    private final Instant validFrom;

    private final Instant validUntil;

    private final Boolean replaceUnhealthyInstances;

    private final String instanceInterruptionBehavior;

    private final LoadBalancersConfig loadBalancersConfig;

    private final Integer instancePoolsToUseCount;

    private final String context;

    private final String targetCapacityUnitType;

    private final List<TagSpecification> tagSpecifications;

    private SpotFleetRequestConfigData(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.onDemandAllocationStrategy = builder.onDemandAllocationStrategy;
        this.spotMaintenanceStrategies = builder.spotMaintenanceStrategies;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.onDemandFulfilledCapacity = builder.onDemandFulfilledCapacity;
        this.iamFleetRole = builder.iamFleetRole;
        this.launchSpecifications = builder.launchSpecifications;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.spotPrice = builder.spotPrice;
        this.targetCapacity = builder.targetCapacity;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
        this.onDemandMaxTotalPrice = builder.onDemandMaxTotalPrice;
        this.spotMaxTotalPrice = builder.spotMaxTotalPrice;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.loadBalancersConfig = builder.loadBalancersConfig;
        this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
        this.context = builder.context;
        this.targetCapacityUnitType = builder.targetCapacityUnitType;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance pools
     * specified by the Spot Fleet launch configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Allocation
     * strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <dl>
     * <dt>priceCapacityOptimized (recommended)</dt>
     * <dd>
     * <p>
     * Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are
     * launching. This means that we will request Spot Instances from the pools that we believe have the lowest chance
     * of interruption in the near term. Spot Fleet then requests Spot Instances from the lowest priced of these pools.
     * </p>
     * </dd>
     * <dt>capacityOptimized</dt>
     * <dd>
     * <p>
     * Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are
     * launching. This means that we will request Spot Instances from the pools that we believe have the lowest chance
     * of interruption in the near term. To give certain instance types a higher chance of launching first, use
     * <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type by using the
     * <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign the same priority to
     * different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on a best-effort basis, but
     * optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is supported only if your Spot Fleet uses
     * a launch template. Note that if the <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>,
     * the same priority is applied when fulfilling On-Demand capacity.
     * </p>
     * </dd>
     * <dt>diversified</dt>
     * <dd>
     * <p>
     * Spot Fleet requests instances from all of the Spot Instance pools that you specify.
     * </p>
     * </dd>
     * <dt>lowestPrice</dt>
     * <dd>
     * <p>
     * Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity. If the
     * lowest priced pool doesn't have available capacity, the Spot Instances come from the next lowest priced pool that
     * has available capacity. If a pool runs out of capacity before fulfilling your desired capacity, Spot Fleet will
     * continue to fulfill your request by drawing from the next lowest priced pool. To ensure that your desired
     * capacity is met, you might receive Spot Instances from several pools. Because this strategy only considers
     * instance price and not capacity availability, it might lead to high interruption rates.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Default: <code>lowestPrice</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance
     *         pools specified by the Spot Fleet launch configuration. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Allocation
     *         strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <dl>
     *         <dt>priceCapacityOptimized (recommended)</dt>
     *         <dd>
     *         <p>
     *         Spot Fleet identifies the pools with the highest capacity availability for the number of instances that
     *         are launching. This means that we will request Spot Instances from the pools that we believe have the
     *         lowest chance of interruption in the near term. Spot Fleet then requests Spot Instances from the lowest
     *         priced of these pools.
     *         </p>
     *         </dd>
     *         <dt>capacityOptimized</dt>
     *         <dd>
     *         <p>
     *         Spot Fleet identifies the pools with the highest capacity availability for the number of instances that
     *         are launching. This means that we will request Spot Instances from the pools that we believe have the
     *         lowest chance of interruption in the near term. To give certain instance types a higher chance of
     *         launching first, use <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type by
     *         using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign the
     *         same priority to different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on a
     *         best-effort basis, but optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is
     *         supported only if your Spot Fleet uses a launch template. Note that if the
     *         <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>, the same priority is applied
     *         when fulfilling On-Demand capacity.
     *         </p>
     *         </dd>
     *         <dt>diversified</dt>
     *         <dd>
     *         <p>
     *         Spot Fleet requests instances from all of the Spot Instance pools that you specify.
     *         </p>
     *         </dd>
     *         <dt>lowestPrice</dt>
     *         <dd>
     *         <p>
     *         Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity. If
     *         the lowest priced pool doesn't have available capacity, the Spot Instances come from the next lowest
     *         priced pool that has available capacity. If a pool runs out of capacity before fulfilling your desired
     *         capacity, Spot Fleet will continue to fulfill your request by drawing from the next lowest priced pool.
     *         To ensure that your desired capacity is met, you might receive Spot Instances from several pools. Because
     *         this strategy only considers instance price and not capacity availability, it might lead to high
     *         interruption rates.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         Default: <code>lowestPrice</code>
     * @see AllocationStrategy
     */
    public final AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance pools
     * specified by the Spot Fleet launch configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Allocation
     * strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <dl>
     * <dt>priceCapacityOptimized (recommended)</dt>
     * <dd>
     * <p>
     * Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are
     * launching. This means that we will request Spot Instances from the pools that we believe have the lowest chance
     * of interruption in the near term. Spot Fleet then requests Spot Instances from the lowest priced of these pools.
     * </p>
     * </dd>
     * <dt>capacityOptimized</dt>
     * <dd>
     * <p>
     * Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are
     * launching. This means that we will request Spot Instances from the pools that we believe have the lowest chance
     * of interruption in the near term. To give certain instance types a higher chance of launching first, use
     * <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type by using the
     * <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign the same priority to
     * different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on a best-effort basis, but
     * optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is supported only if your Spot Fleet uses
     * a launch template. Note that if the <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>,
     * the same priority is applied when fulfilling On-Demand capacity.
     * </p>
     * </dd>
     * <dt>diversified</dt>
     * <dd>
     * <p>
     * Spot Fleet requests instances from all of the Spot Instance pools that you specify.
     * </p>
     * </dd>
     * <dt>lowestPrice</dt>
     * <dd>
     * <p>
     * Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity. If the
     * lowest priced pool doesn't have available capacity, the Spot Instances come from the next lowest priced pool that
     * has available capacity. If a pool runs out of capacity before fulfilling your desired capacity, Spot Fleet will
     * continue to fulfill your request by drawing from the next lowest priced pool. To ensure that your desired
     * capacity is met, you might receive Spot Instances from several pools. Because this strategy only considers
     * instance price and not capacity availability, it might lead to high interruption rates.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Default: <code>lowestPrice</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance
     *         pools specified by the Spot Fleet launch configuration. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Allocation
     *         strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <dl>
     *         <dt>priceCapacityOptimized (recommended)</dt>
     *         <dd>
     *         <p>
     *         Spot Fleet identifies the pools with the highest capacity availability for the number of instances that
     *         are launching. This means that we will request Spot Instances from the pools that we believe have the
     *         lowest chance of interruption in the near term. Spot Fleet then requests Spot Instances from the lowest
     *         priced of these pools.
     *         </p>
     *         </dd>
     *         <dt>capacityOptimized</dt>
     *         <dd>
     *         <p>
     *         Spot Fleet identifies the pools with the highest capacity availability for the number of instances that
     *         are launching. This means that we will request Spot Instances from the pools that we believe have the
     *         lowest chance of interruption in the near term. To give certain instance types a higher chance of
     *         launching first, use <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type by
     *         using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign the
     *         same priority to different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on a
     *         best-effort basis, but optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is
     *         supported only if your Spot Fleet uses a launch template. Note that if the
     *         <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>, the same priority is applied
     *         when fulfilling On-Demand capacity.
     *         </p>
     *         </dd>
     *         <dt>diversified</dt>
     *         <dd>
     *         <p>
     *         Spot Fleet requests instances from all of the Spot Instance pools that you specify.
     *         </p>
     *         </dd>
     *         <dt>lowestPrice</dt>
     *         <dd>
     *         <p>
     *         Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity. If
     *         the lowest priced pool doesn't have available capacity, the Spot Instances come from the next lowest
     *         priced pool that has available capacity. If a pool runs out of capacity before fulfilling your desired
     *         capacity, Spot Fleet will continue to fulfill your request by drawing from the next lowest priced pool.
     *         To ensure that your desired capacity is met, you might receive Spot Instances from several pools. Because
     *         this strategy only considers instance price and not capacity availability, it might lead to high
     *         interruption rates.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         Default: <code>lowestPrice</code>
     * @see AllocationStrategy
     */
    public final String allocationStrategyAsString() {
        return allocationStrategy;
    }

    /**
     * <p>
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     * <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If you
     * specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch template
     * override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults to
     * <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onDemandAllocationStrategy} will return {@link OnDemandAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #onDemandAllocationStrategyAsString}.
     * </p>
     * 
     * @return The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     *         <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first.
     *         If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet
     *         launch template override, launching the highest priority first. If you do not specify a value, Spot Fleet
     *         defaults to <code>lowestPrice</code>.
     * @see OnDemandAllocationStrategy
     */
    public final OnDemandAllocationStrategy onDemandAllocationStrategy() {
        return OnDemandAllocationStrategy.fromValue(onDemandAllocationStrategy);
    }

    /**
     * <p>
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     * <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If you
     * specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch template
     * override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults to
     * <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onDemandAllocationStrategy} will return {@link OnDemandAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #onDemandAllocationStrategyAsString}.
     * </p>
     * 
     * @return The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     *         <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first.
     *         If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet
     *         launch template override, launching the highest priority first. If you do not specify a value, Spot Fleet
     *         defaults to <code>lowestPrice</code>.
     * @see OnDemandAllocationStrategy
     */
    public final String onDemandAllocationStrategyAsString() {
        return onDemandAllocationStrategy;
    }

    /**
     * <p>
     * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
     * </p>
     * 
     * @return The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
     */
    public final SpotMaintenanceStrategies spotMaintenanceStrategies() {
        return spotMaintenanceStrategies;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of your listings. This helps to
     * avoid duplicate listings. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of your listings. This
     *         helps to avoid duplicate listings. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the Spot
     * Fleet request below the current size of the Spot Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the
     *         Spot Fleet request below the current size of the Spot Fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public final ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the Spot
     * Fleet request below the current size of the Spot Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the
     *         Spot Fleet request below the current size of the Spot Fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public final String excessCapacityTerminationPolicyAsString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * <p>
     * The number of units fulfilled by this request compared to the set target capacity. You cannot set this value.
     * </p>
     * 
     * @return The number of units fulfilled by this request compared to the set target capacity. You cannot set this
     *         value.
     */
    public final Double fulfilledCapacity() {
        return fulfilledCapacity;
    }

    /**
     * <p>
     * The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.
     * </p>
     * 
     * @return The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.
     */
    public final Double onDemandFulfilledCapacity() {
        return onDemandFulfilledCapacity;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that grants the Spot Fleet the
     * permission to request, launch, terminate, and tag instances on your behalf. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites">Spot
     * Fleet prerequisites</a> in the <i>Amazon EC2 User Guide</i>. Spot Fleet can terminate Spot Instances on your
     * behalf when you cancel its Spot Fleet request using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests"
     * >CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
     * <code>TerminateInstancesWithExpiration</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that grants the Spot Fleet
     *         the permission to request, launch, terminate, and tag instances on your behalf. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites"
     *         >Spot Fleet prerequisites</a> in the <i>Amazon EC2 User Guide</i>. Spot Fleet can terminate Spot
     *         Instances on your behalf when you cancel its Spot Fleet request using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests"
     *         >CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
     *         <code>TerminateInstancesWithExpiration</code>.
     */
    public final String iamFleetRole() {
        return iamFleetRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the LaunchSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLaunchSpecifications() {
        return launchSpecifications != null && !(launchSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you can't
     * specify <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your request, you must use
     * <code>LaunchTemplateConfigs</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLaunchSpecifications} method.
     * </p>
     * 
     * @return The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>,
     *         you can't specify <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your request,
     *         you must use <code>LaunchTemplateConfigs</code>.
     */
    public final List<SpotFleetLaunchSpecification> launchSpecifications() {
        return launchSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the LaunchTemplateConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLaunchTemplateConfigs() {
        return launchTemplateConfigs != null && !(launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
     * <code>LaunchSpecifications</code>. If you include On-Demand capacity in your request, you must use
     * <code>LaunchTemplateConfigs</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLaunchTemplateConfigs} method.
     * </p>
     * 
     * @return The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
     *         <code>LaunchSpecifications</code>. If you include On-Demand capacity in your request, you must use
     *         <code>LaunchTemplateConfigs</code>.
     */
    public final List<LaunchTemplateConfig> launchTemplateConfigs() {
        return launchTemplateConfigs;
    }

    /**
     * <p>
     * The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend using this
     * parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the
     * current Spot price.
     * </p>
     * <important>
     * <p>
     * If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify
     * this parameter.
     * </p>
     * </important>
     * 
     * @return The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend
     *         using this parameter because it can lead to increased interruptions. If you do not specify this
     *         parameter, you will pay the current Spot price.</p> <important>
     *         <p>
     *         If you specify a maximum price, your instances will be interrupted more frequently than if you do not
     *         specify this parameter.
     *         </p>
     */
    public final String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The number of units to request for the Spot Fleet. You can choose to set the target capacity in terms of
     * instances or a performance characteristic that is important to your application workload, such as vCPUs, memory,
     * or I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity
     * later.
     * </p>
     * 
     * @return The number of units to request for the Spot Fleet. You can choose to set the target capacity in terms of
     *         instances or a performance characteristic that is important to your application workload, such as vCPUs,
     *         memory, or I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and
     *         add capacity later.
     */
    public final Integer targetCapacity() {
        return targetCapacity;
    }

    /**
     * <p>
     * The number of On-Demand units to request. You can choose to set the target capacity in terms of instances or a
     * performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the
     * request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
     * </p>
     * 
     * @return The number of On-Demand units to request. You can choose to set the target capacity in terms of instances
     *         or a performance characteristic that is important to your application workload, such as vCPUs, memory, or
     *         I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add
     *         capacity later.
     */
    public final Integer onDemandTargetCapacity() {
        return onDemandTargetCapacity;
    }

    /**
     * <p>
     * The maximum amount per hour for On-Demand Instances that you're willing to pay. You can use the
     * <code>onDemandMaxTotalPrice</code> parameter, the <code>spotMaxTotalPrice</code> parameter, or both parameters to
     * ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour for the On-Demand
     * Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the maximum
     * amount you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching
     * instances even if it hasn’t met the target capacity.
     * </p>
     * 
     * @return The maximum amount per hour for On-Demand Instances that you're willing to pay. You can use the
     *         <code>onDemandMaxTotalPrice</code> parameter, the <code>spotMaxTotalPrice</code> parameter, or both
     *         parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per
     *         hour for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances
     *         until it reaches the maximum amount you're willing to pay. When the maximum amount you're willing to pay
     *         is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
     */
    public final String onDemandMaxTotalPrice() {
        return onDemandMaxTotalPrice;
    }

    /**
     * <p>
     * The maximum amount per hour for Spot Instances that you're willing to pay. You can use the
     * <code>spotdMaxTotalPrice</code> parameter, the <code>onDemandMaxTotalPrice</code> parameter, or both parameters
     * to ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour for the On-Demand
     * Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the maximum
     * amount you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching
     * instances even if it hasn’t met the target capacity.
     * </p>
     * 
     * @return The maximum amount per hour for Spot Instances that you're willing to pay. You can use the
     *         <code>spotdMaxTotalPrice</code> parameter, the <code>onDemandMaxTotalPrice</code> parameter, or both
     *         parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per
     *         hour for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances
     *         until it reaches the maximum amount you're willing to pay. When the maximum amount you're willing to pay
     *         is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
     */
    public final String spotMaxTotalPrice() {
        return spotMaxTotalPrice;
    }

    /**
     * <p>
     * Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.
     * </p>
     * 
     * @return Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.
     */
    public final Boolean terminateInstancesWithExpiration() {
        return terminateInstancesWithExpiration;
    }

    /**
     * <p>
     * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to
     * maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It does
     * not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in alternative
     * Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet maintains the
     * target capacity. The Spot Fleet places the required requests to meet capacity and automatically replenishes any
     * interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is not used by Spot
     * Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts
     *         to maintain it. When this value is <code>request</code>, the Spot Fleet only places the required
     *         requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit
     *         requests in alternative Spot pools if capacity is not available. When this value is <code>maintain</code>
     *         , the Spot Fleet maintains the target capacity. The Spot Fleet places the required requests to meet
     *         capacity and automatically replenishes any interrupted instances. Default: <code>maintain</code>.
     *         <code>instant</code> is listed but is not used by Spot Fleet.
     * @see FleetType
     */
    public final FleetType type() {
        return FleetType.fromValue(type);
    }

    /**
     * <p>
     * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to
     * maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It does
     * not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in alternative
     * Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet maintains the
     * target capacity. The Spot Fleet places the required requests to meet capacity and automatically replenishes any
     * interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is not used by Spot
     * Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts
     *         to maintain it. When this value is <code>request</code>, the Spot Fleet only places the required
     *         requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit
     *         requests in alternative Spot pools if capacity is not available. When this value is <code>maintain</code>
     *         , the Spot Fleet maintains the target capacity. The Spot Fleet places the required requests to meet
     *         capacity and automatically replenishes any interrupted instances. Default: <code>maintain</code>.
     *         <code>instant</code> is listed but is not used by Spot Fleet.
     * @see FleetType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The start date and time of the request, in UTC format
     * (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). By default, Amazon EC2 starts fulfilling the
     * request immediately.
     * </p>
     * 
     * @return The start date and time of the request, in UTC format
     *         (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). By default, Amazon EC2 starts
     *         fulfilling the request immediately.
     */
    public final Instant validFrom() {
        return validFrom;
    }

    /**
     * <p>
     * The end date and time of the request, in UTC format
     * (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). After the end date and time, no new Spot
     * Instance requests are placed or able to fulfill the request. If no value is specified, the Spot Fleet request
     * remains until you cancel it.
     * </p>
     * 
     * @return The end date and time of the request, in UTC format
     *         (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). After the end date and time, no new
     *         Spot Instance requests are placed or able to fulfill the request. If no value is specified, the Spot
     *         Fleet request remains until you cancel it.
     */
    public final Instant validUntil() {
        return validUntil;
    }

    /**
     * <p>
     * Indicates whether Spot Fleet should replace unhealthy instances.
     * </p>
     * 
     * @return Indicates whether Spot Fleet should replace unhealthy instances.
     */
    public final Boolean replaceUnhealthyInstances() {
        return replaceUnhealthyInstances;
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * @see InstanceInterruptionBehavior
     */
    public final InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(instanceInterruptionBehavior);
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * @see InstanceInterruptionBehavior
     */
    public final String instanceInterruptionBehaviorAsString() {
        return instanceInterruptionBehavior;
    }

    /**
     * <p>
     * One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet registers
     * the running Spot Instances with the specified Classic Load Balancers and target groups.
     * </p>
     * <p>
     * With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1,
     * CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
     * </p>
     * 
     * @return One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet
     *         registers the running Spot Instances with the specified Classic Load Balancers and target groups.</p>
     *         <p>
     *         With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types:
     *         C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
     */
    public final LoadBalancersConfig loadBalancersConfig() {
        return loadBalancersConfig;
    }

    /**
     * <p>
     * The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
     * <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot pools and
     * evenly allocates your target Spot capacity across the number of Spot pools that you specify.
     * </p>
     * <p>
     * Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort
     * basis. If a pool runs out of Spot capacity before fulfilling your target capacity, Spot Fleet will continue to
     * fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you
     * might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the
     * pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that
     * you specified.
     * </p>
     * 
     * @return The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
     *         <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot pools
     *         and evenly allocates your target Spot capacity across the number of Spot pools that you specify.</p>
     *         <p>
     *         Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a best
     *         effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, Spot Fleet will
     *         continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target
     *         capacity is met, you might receive Spot Instances from more than the number of pools that you specified.
     *         Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from
     *         fewer than the number of pools that you specified.
     */
    public final Integer instancePoolsToUseCount() {
        return instancePoolsToUseCount;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * The unit for the target capacity. <code>TargetCapacityUnitType</code> can only be specified when
     * <code>InstanceRequirements</code> is specified.
     * </p>
     * <p>
     * Default: <code>units</code> (translates to number of instances)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCapacityUnitType} will return {@link TargetCapacityUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCapacityUnitTypeAsString}.
     * </p>
     * 
     * @return The unit for the target capacity. <code>TargetCapacityUnitType</code> can only be specified when
     *         <code>InstanceRequirements</code> is specified.</p>
     *         <p>
     *         Default: <code>units</code> (translates to number of instances)
     * @see TargetCapacityUnitType
     */
    public final TargetCapacityUnitType targetCapacityUnitType() {
        return TargetCapacityUnitType.fromValue(targetCapacityUnitType);
    }

    /**
     * <p>
     * The unit for the target capacity. <code>TargetCapacityUnitType</code> can only be specified when
     * <code>InstanceRequirements</code> is specified.
     * </p>
     * <p>
     * Default: <code>units</code> (translates to number of instances)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCapacityUnitType} will return {@link TargetCapacityUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCapacityUnitTypeAsString}.
     * </p>
     * 
     * @return The unit for the target capacity. <code>TargetCapacityUnitType</code> can only be specified when
     *         <code>InstanceRequirements</code> is specified.</p>
     *         <p>
     *         Default: <code>units</code> (translates to number of instances)
     * @see TargetCapacityUnitType
     */
    public final String targetCapacityUnitTypeAsString() {
        return targetCapacityUnitType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pair for tagging the Spot Fleet request on creation. The value for <code>ResourceType</code> must
     * be <code>spot-fleet-request</code>, otherwise the Spot Fleet request fails. To tag instances at launch, specify
     * the tags in the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
     * >launch template</a> (valid only if you use <code>LaunchTemplateConfigs</code>) or in the
     * <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">SpotFleetTagSpecification</a> </code>
     * (valid only if you use <code>LaunchSpecifications</code>). For information about tagging after launch, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
     * Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The key-value pair for tagging the Spot Fleet request on creation. The value for
     *         <code>ResourceType</code> must be <code>spot-fleet-request</code>, otherwise the Spot Fleet request
     *         fails. To tag instances at launch, specify the tags in the <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
     *         >launch template</a> (valid only if you use <code>LaunchTemplateConfigs</code>) or in the
     *         <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">SpotFleetTagSpecification</a> </code>
     *         (valid only if you use <code>LaunchSpecifications</code>). For information about tagging after launch,
     *         see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging
     *         Your Resources</a>.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandAllocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spotMaintenanceStrategies());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandFulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(iamFleetRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchSpecifications() ? launchSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchTemplateConfigs() ? launchTemplateConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandMaxTotalPrice());
        hashCode = 31 * hashCode + Objects.hashCode(spotMaxTotalPrice());
        hashCode = 31 * hashCode + Objects.hashCode(terminateInstancesWithExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(replaceUnhealthyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(instancePoolsToUseCount());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacityUnitTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData) obj;
        return Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString())
                && Objects.equals(onDemandAllocationStrategyAsString(), other.onDemandAllocationStrategyAsString())
                && Objects.equals(spotMaintenanceStrategies(), other.spotMaintenanceStrategies())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString())
                && Objects.equals(fulfilledCapacity(), other.fulfilledCapacity())
                && Objects.equals(onDemandFulfilledCapacity(), other.onDemandFulfilledCapacity())
                && Objects.equals(iamFleetRole(), other.iamFleetRole())
                && hasLaunchSpecifications() == other.hasLaunchSpecifications()
                && Objects.equals(launchSpecifications(), other.launchSpecifications())
                && hasLaunchTemplateConfigs() == other.hasLaunchTemplateConfigs()
                && Objects.equals(launchTemplateConfigs(), other.launchTemplateConfigs())
                && Objects.equals(spotPrice(), other.spotPrice()) && Objects.equals(targetCapacity(), other.targetCapacity())
                && Objects.equals(onDemandTargetCapacity(), other.onDemandTargetCapacity())
                && Objects.equals(onDemandMaxTotalPrice(), other.onDemandMaxTotalPrice())
                && Objects.equals(spotMaxTotalPrice(), other.spotMaxTotalPrice())
                && Objects.equals(terminateInstancesWithExpiration(), other.terminateInstancesWithExpiration())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(validFrom(), other.validFrom())
                && Objects.equals(validUntil(), other.validUntil())
                && Objects.equals(replaceUnhealthyInstances(), other.replaceUnhealthyInstances())
                && Objects.equals(instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString())
                && Objects.equals(loadBalancersConfig(), other.loadBalancersConfig())
                && Objects.equals(instancePoolsToUseCount(), other.instancePoolsToUseCount())
                && Objects.equals(context(), other.context())
                && Objects.equals(targetCapacityUnitTypeAsString(), other.targetCapacityUnitTypeAsString())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotFleetRequestConfigData").add("AllocationStrategy", allocationStrategyAsString())
                .add("OnDemandAllocationStrategy", onDemandAllocationStrategyAsString())
                .add("SpotMaintenanceStrategies", spotMaintenanceStrategies()).add("ClientToken", clientToken())
                .add("ExcessCapacityTerminationPolicy", excessCapacityTerminationPolicyAsString())
                .add("FulfilledCapacity", fulfilledCapacity()).add("OnDemandFulfilledCapacity", onDemandFulfilledCapacity())
                .add("IamFleetRole", iamFleetRole())
                .add("LaunchSpecifications", hasLaunchSpecifications() ? launchSpecifications() : null)
                .add("LaunchTemplateConfigs", hasLaunchTemplateConfigs() ? launchTemplateConfigs() : null)
                .add("SpotPrice", spotPrice()).add("TargetCapacity", targetCapacity())
                .add("OnDemandTargetCapacity", onDemandTargetCapacity()).add("OnDemandMaxTotalPrice", onDemandMaxTotalPrice())
                .add("SpotMaxTotalPrice", spotMaxTotalPrice())
                .add("TerminateInstancesWithExpiration", terminateInstancesWithExpiration()).add("Type", typeAsString())
                .add("ValidFrom", validFrom()).add("ValidUntil", validUntil())
                .add("ReplaceUnhealthyInstances", replaceUnhealthyInstances())
                .add("InstanceInterruptionBehavior", instanceInterruptionBehaviorAsString())
                .add("LoadBalancersConfig", loadBalancersConfig()).add("InstancePoolsToUseCount", instancePoolsToUseCount())
                .add("Context", context()).add("TargetCapacityUnitType", targetCapacityUnitTypeAsString())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        case "OnDemandAllocationStrategy":
            return Optional.ofNullable(clazz.cast(onDemandAllocationStrategyAsString()));
        case "SpotMaintenanceStrategies":
            return Optional.ofNullable(clazz.cast(spotMaintenanceStrategies()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ExcessCapacityTerminationPolicy":
            return Optional.ofNullable(clazz.cast(excessCapacityTerminationPolicyAsString()));
        case "FulfilledCapacity":
            return Optional.ofNullable(clazz.cast(fulfilledCapacity()));
        case "OnDemandFulfilledCapacity":
            return Optional.ofNullable(clazz.cast(onDemandFulfilledCapacity()));
        case "IamFleetRole":
            return Optional.ofNullable(clazz.cast(iamFleetRole()));
        case "LaunchSpecifications":
            return Optional.ofNullable(clazz.cast(launchSpecifications()));
        case "LaunchTemplateConfigs":
            return Optional.ofNullable(clazz.cast(launchTemplateConfigs()));
        case "SpotPrice":
            return Optional.ofNullable(clazz.cast(spotPrice()));
        case "TargetCapacity":
            return Optional.ofNullable(clazz.cast(targetCapacity()));
        case "OnDemandTargetCapacity":
            return Optional.ofNullable(clazz.cast(onDemandTargetCapacity()));
        case "OnDemandMaxTotalPrice":
            return Optional.ofNullable(clazz.cast(onDemandMaxTotalPrice()));
        case "SpotMaxTotalPrice":
            return Optional.ofNullable(clazz.cast(spotMaxTotalPrice()));
        case "TerminateInstancesWithExpiration":
            return Optional.ofNullable(clazz.cast(terminateInstancesWithExpiration()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ValidFrom":
            return Optional.ofNullable(clazz.cast(validFrom()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        case "ReplaceUnhealthyInstances":
            return Optional.ofNullable(clazz.cast(replaceUnhealthyInstances()));
        case "InstanceInterruptionBehavior":
            return Optional.ofNullable(clazz.cast(instanceInterruptionBehaviorAsString()));
        case "LoadBalancersConfig":
            return Optional.ofNullable(clazz.cast(loadBalancersConfig()));
        case "InstancePoolsToUseCount":
            return Optional.ofNullable(clazz.cast(instancePoolsToUseCount()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "TargetCapacityUnitType":
            return Optional.ofNullable(clazz.cast(targetCapacityUnitTypeAsString()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotFleetRequestConfigData, T> g) {
        return obj -> g.apply((SpotFleetRequestConfigData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotFleetRequestConfigData> {
        /**
         * <p>
         * The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance pools
         * specified by the Spot Fleet launch configuration. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Allocation
         * strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <dl>
         * <dt>priceCapacityOptimized (recommended)</dt>
         * <dd>
         * <p>
         * Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are
         * launching. This means that we will request Spot Instances from the pools that we believe have the lowest
         * chance of interruption in the near term. Spot Fleet then requests Spot Instances from the lowest priced of
         * these pools.
         * </p>
         * </dd>
         * <dt>capacityOptimized</dt>
         * <dd>
         * <p>
         * Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are
         * launching. This means that we will request Spot Instances from the pools that we believe have the lowest
         * chance of interruption in the near term. To give certain instance types a higher chance of launching first,
         * use <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type by using the
         * <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign the same priority to
         * different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on a best-effort basis, but
         * optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is supported only if your Spot Fleet
         * uses a launch template. Note that if the <code>OnDemandAllocationStrategy</code> is set to
         * <code>prioritized</code>, the same priority is applied when fulfilling On-Demand capacity.
         * </p>
         * </dd>
         * <dt>diversified</dt>
         * <dd>
         * <p>
         * Spot Fleet requests instances from all of the Spot Instance pools that you specify.
         * </p>
         * </dd>
         * <dt>lowestPrice</dt>
         * <dd>
         * <p>
         * Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity. If the
         * lowest priced pool doesn't have available capacity, the Spot Instances come from the next lowest priced pool
         * that has available capacity. If a pool runs out of capacity before fulfilling your desired capacity, Spot
         * Fleet will continue to fulfill your request by drawing from the next lowest priced pool. To ensure that your
         * desired capacity is met, you might receive Spot Instances from several pools. Because this strategy only
         * considers instance price and not capacity availability, it might lead to high interruption rates.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * Default: <code>lowestPrice</code>
         * </p>
         * 
         * @param allocationStrategy
         *        The strategy that determines how to allocate the target Spot Instance capacity across the Spot
         *        Instance pools specified by the Spot Fleet launch configuration. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html"
         *        >Allocation strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <dl>
         *        <dt>priceCapacityOptimized (recommended)</dt>
         *        <dd>
         *        <p>
         *        Spot Fleet identifies the pools with the highest capacity availability for the number of instances
         *        that are launching. This means that we will request Spot Instances from the pools that we believe have
         *        the lowest chance of interruption in the near term. Spot Fleet then requests Spot Instances from the
         *        lowest priced of these pools.
         *        </p>
         *        </dd>
         *        <dt>capacityOptimized</dt>
         *        <dd>
         *        <p>
         *        Spot Fleet identifies the pools with the highest capacity availability for the number of instances
         *        that are launching. This means that we will request Spot Instances from the pools that we believe have
         *        the lowest chance of interruption in the near term. To give certain instance types a higher chance of
         *        launching first, use <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type
         *        by using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign
         *        the same priority to different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on
         *        a best-effort basis, but optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is
         *        supported only if your Spot Fleet uses a launch template. Note that if the
         *        <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>, the same priority is
         *        applied when fulfilling On-Demand capacity.
         *        </p>
         *        </dd>
         *        <dt>diversified</dt>
         *        <dd>
         *        <p>
         *        Spot Fleet requests instances from all of the Spot Instance pools that you specify.
         *        </p>
         *        </dd>
         *        <dt>lowestPrice</dt>
         *        <dd>
         *        <p>
         *        Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity.
         *        If the lowest priced pool doesn't have available capacity, the Spot Instances come from the next
         *        lowest priced pool that has available capacity. If a pool runs out of capacity before fulfilling your
         *        desired capacity, Spot Fleet will continue to fulfill your request by drawing from the next lowest
         *        priced pool. To ensure that your desired capacity is met, you might receive Spot Instances from
         *        several pools. Because this strategy only considers instance price and not capacity availability, it
         *        might lead to high interruption rates.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        Default: <code>lowestPrice</code>
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance pools
         * specified by the Spot Fleet launch configuration. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Allocation
         * strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <dl>
         * <dt>priceCapacityOptimized (recommended)</dt>
         * <dd>
         * <p>
         * Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are
         * launching. This means that we will request Spot Instances from the pools that we believe have the lowest
         * chance of interruption in the near term. Spot Fleet then requests Spot Instances from the lowest priced of
         * these pools.
         * </p>
         * </dd>
         * <dt>capacityOptimized</dt>
         * <dd>
         * <p>
         * Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are
         * launching. This means that we will request Spot Instances from the pools that we believe have the lowest
         * chance of interruption in the near term. To give certain instance types a higher chance of launching first,
         * use <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type by using the
         * <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign the same priority to
         * different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on a best-effort basis, but
         * optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is supported only if your Spot Fleet
         * uses a launch template. Note that if the <code>OnDemandAllocationStrategy</code> is set to
         * <code>prioritized</code>, the same priority is applied when fulfilling On-Demand capacity.
         * </p>
         * </dd>
         * <dt>diversified</dt>
         * <dd>
         * <p>
         * Spot Fleet requests instances from all of the Spot Instance pools that you specify.
         * </p>
         * </dd>
         * <dt>lowestPrice</dt>
         * <dd>
         * <p>
         * Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity. If the
         * lowest priced pool doesn't have available capacity, the Spot Instances come from the next lowest priced pool
         * that has available capacity. If a pool runs out of capacity before fulfilling your desired capacity, Spot
         * Fleet will continue to fulfill your request by drawing from the next lowest priced pool. To ensure that your
         * desired capacity is met, you might receive Spot Instances from several pools. Because this strategy only
         * considers instance price and not capacity availability, it might lead to high interruption rates.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * Default: <code>lowestPrice</code>
         * </p>
         * 
         * @param allocationStrategy
         *        The strategy that determines how to allocate the target Spot Instance capacity across the Spot
         *        Instance pools specified by the Spot Fleet launch configuration. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html"
         *        >Allocation strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <dl>
         *        <dt>priceCapacityOptimized (recommended)</dt>
         *        <dd>
         *        <p>
         *        Spot Fleet identifies the pools with the highest capacity availability for the number of instances
         *        that are launching. This means that we will request Spot Instances from the pools that we believe have
         *        the lowest chance of interruption in the near term. Spot Fleet then requests Spot Instances from the
         *        lowest priced of these pools.
         *        </p>
         *        </dd>
         *        <dt>capacityOptimized</dt>
         *        <dd>
         *        <p>
         *        Spot Fleet identifies the pools with the highest capacity availability for the number of instances
         *        that are launching. This means that we will request Spot Instances from the pools that we believe have
         *        the lowest chance of interruption in the near term. To give certain instance types a higher chance of
         *        launching first, use <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type
         *        by using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign
         *        the same priority to different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on
         *        a best-effort basis, but optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is
         *        supported only if your Spot Fleet uses a launch template. Note that if the
         *        <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>, the same priority is
         *        applied when fulfilling On-Demand capacity.
         *        </p>
         *        </dd>
         *        <dt>diversified</dt>
         *        <dd>
         *        <p>
         *        Spot Fleet requests instances from all of the Spot Instance pools that you specify.
         *        </p>
         *        </dd>
         *        <dt>lowestPrice</dt>
         *        <dd>
         *        <p>
         *        Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity.
         *        If the lowest priced pool doesn't have available capacity, the Spot Instances come from the next
         *        lowest priced pool that has available capacity. If a pool runs out of capacity before fulfilling your
         *        desired capacity, Spot Fleet will continue to fulfill your request by drawing from the next lowest
         *        priced pool. To ensure that your desired capacity is met, you might receive Spot Instances from
         *        several pools. Because this strategy only considers instance price and not capacity availability, it
         *        might lead to high interruption rates.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        Default: <code>lowestPrice</code>
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(AllocationStrategy allocationStrategy);

        /**
         * <p>
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         * <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If
         * you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch
         * template override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults
         * to <code>lowestPrice</code>.
         * </p>
         * 
         * @param onDemandAllocationStrategy
         *        The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         *        <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price
         *        first. If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each
         *        Spot Fleet launch template override, launching the highest priority first. If you do not specify a
         *        value, Spot Fleet defaults to <code>lowestPrice</code>.
         * @see OnDemandAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandAllocationStrategy
         */
        Builder onDemandAllocationStrategy(String onDemandAllocationStrategy);

        /**
         * <p>
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         * <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If
         * you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch
         * template override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults
         * to <code>lowestPrice</code>.
         * </p>
         * 
         * @param onDemandAllocationStrategy
         *        The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         *        <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price
         *        first. If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each
         *        Spot Fleet launch template override, launching the highest priority first. If you do not specify a
         *        value, Spot Fleet defaults to <code>lowestPrice</code>.
         * @see OnDemandAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandAllocationStrategy
         */
        Builder onDemandAllocationStrategy(OnDemandAllocationStrategy onDemandAllocationStrategy);

        /**
         * <p>
         * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
         * </p>
         * 
         * @param spotMaintenanceStrategies
         *        The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotMaintenanceStrategies(SpotMaintenanceStrategies spotMaintenanceStrategies);

        /**
         * <p>
         * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpotMaintenanceStrategies.Builder}
         * avoiding the need to create one manually via {@link SpotMaintenanceStrategies#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpotMaintenanceStrategies.Builder#build()} is called immediately
         * and its result is passed to {@link #spotMaintenanceStrategies(SpotMaintenanceStrategies)}.
         * 
         * @param spotMaintenanceStrategies
         *        a consumer that will call methods on {@link SpotMaintenanceStrategies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotMaintenanceStrategies(SpotMaintenanceStrategies)
         */
        default Builder spotMaintenanceStrategies(Consumer<SpotMaintenanceStrategies.Builder> spotMaintenanceStrategies) {
            return spotMaintenanceStrategies(SpotMaintenanceStrategies.builder().applyMutation(spotMaintenanceStrategies).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of your listings. This helps
         * to avoid duplicate listings. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of your listings. This
         *        helps to avoid duplicate listings. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the Spot
         * Fleet request below the current size of the Spot Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot Instances should be terminated if you decrease the target capacity of
         *        the Spot Fleet request below the current size of the Spot Fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the Spot
         * Fleet request below the current size of the Spot Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot Instances should be terminated if you decrease the target capacity of
         *        the Spot Fleet request below the current size of the Spot Fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The number of units fulfilled by this request compared to the set target capacity. You cannot set this value.
         * </p>
         * 
         * @param fulfilledCapacity
         *        The number of units fulfilled by this request compared to the set target capacity. You cannot set this
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfilledCapacity(Double fulfilledCapacity);

        /**
         * <p>
         * The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.
         * </p>
         * 
         * @param onDemandFulfilledCapacity
         *        The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandFulfilledCapacity(Double onDemandFulfilledCapacity);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that grants the Spot Fleet the
         * permission to request, launch, terminate, and tag instances on your behalf. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites">Spot
         * Fleet prerequisites</a> in the <i>Amazon EC2 User Guide</i>. Spot Fleet can terminate Spot Instances on your
         * behalf when you cancel its Spot Fleet request using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests"
         * >CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
         * <code>TerminateInstancesWithExpiration</code>.
         * </p>
         * 
         * @param iamFleetRole
         *        The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that grants the Spot
         *        Fleet the permission to request, launch, terminate, and tag instances on your behalf. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites"
         *        >Spot Fleet prerequisites</a> in the <i>Amazon EC2 User Guide</i>. Spot Fleet can terminate Spot
         *        Instances on your behalf when you cancel its Spot Fleet request using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests"
         *        >CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
         *        <code>TerminateInstancesWithExpiration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamFleetRole(String iamFleetRole);

        /**
         * <p>
         * The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you
         * can't specify <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your request, you must
         * use <code>LaunchTemplateConfigs</code>.
         * </p>
         * 
         * @param launchSpecifications
         *        The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>
         *        , you can't specify <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your
         *        request, you must use <code>LaunchTemplateConfigs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications);

        /**
         * <p>
         * The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you
         * can't specify <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your request, you must
         * use <code>LaunchTemplateConfigs</code>.
         * </p>
         * 
         * @param launchSpecifications
         *        The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>
         *        , you can't specify <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your
         *        request, you must use <code>LaunchTemplateConfigs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecifications(SpotFleetLaunchSpecification... launchSpecifications);

        /**
         * <p>
         * The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you
         * can't specify <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your request, you must
         * use <code>LaunchTemplateConfigs</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchSpecifications(List<SpotFleetLaunchSpecification>)}.
         * 
         * @param launchSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchSpecifications(java.util.Collection<SpotFleetLaunchSpecification>)
         */
        Builder launchSpecifications(Consumer<SpotFleetLaunchSpecification.Builder>... launchSpecifications);

        /**
         * <p>
         * The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
         * <code>LaunchSpecifications</code>. If you include On-Demand capacity in your request, you must use
         * <code>LaunchTemplateConfigs</code>.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't
         *        specify <code>LaunchSpecifications</code>. If you include On-Demand capacity in your request, you must
         *        use <code>LaunchTemplateConfigs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
         * <code>LaunchSpecifications</code>. If you include On-Demand capacity in your request, you must use
         * <code>LaunchTemplateConfigs</code>.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't
         *        specify <code>LaunchSpecifications</code>. If you include On-Demand capacity in your request, you must
         *        use <code>LaunchTemplateConfigs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(LaunchTemplateConfig... launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
         * <code>LaunchSpecifications</code>. If you include On-Demand capacity in your request, you must use
         * <code>LaunchTemplateConfigs</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #launchTemplateConfigs(List<LaunchTemplateConfig>)}.
         * 
         * @param launchTemplateConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateConfigs(java.util.Collection<LaunchTemplateConfig>)
         */
        Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder>... launchTemplateConfigs);

        /**
         * <p>
         * The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend using
         * this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will
         * pay the current Spot price.
         * </p>
         * <important>
         * <p>
         * If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify
         * this parameter.
         * </p>
         * </important>
         * 
         * @param spotPrice
         *        The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend
         *        using this parameter because it can lead to increased interruptions. If you do not specify this
         *        parameter, you will pay the current Spot price.</p> <important>
         *        <p>
         *        If you specify a maximum price, your instances will be interrupted more frequently than if you do not
         *        specify this parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The number of units to request for the Spot Fleet. You can choose to set the target capacity in terms of
         * instances or a performance characteristic that is important to your application workload, such as vCPUs,
         * memory, or I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add
         * capacity later.
         * </p>
         * 
         * @param targetCapacity
         *        The number of units to request for the Spot Fleet. You can choose to set the target capacity in terms
         *        of instances or a performance characteristic that is important to your application workload, such as
         *        vCPUs, memory, or I/O. If the request type is <code>maintain</code>, you can specify a target capacity
         *        of 0 and add capacity later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacity(Integer targetCapacity);

        /**
         * <p>
         * The number of On-Demand units to request. You can choose to set the target capacity in terms of instances or
         * a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O.
         * If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
         * </p>
         * 
         * @param onDemandTargetCapacity
         *        The number of On-Demand units to request. You can choose to set the target capacity in terms of
         *        instances or a performance characteristic that is important to your application workload, such as
         *        vCPUs, memory, or I/O. If the request type is <code>maintain</code>, you can specify a target capacity
         *        of 0 and add capacity later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandTargetCapacity(Integer onDemandTargetCapacity);

        /**
         * <p>
         * The maximum amount per hour for On-Demand Instances that you're willing to pay. You can use the
         * <code>onDemandMaxTotalPrice</code> parameter, the <code>spotMaxTotalPrice</code> parameter, or both
         * parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour
         * for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it
         * reaches the maximum amount you're willing to pay. When the maximum amount you're willing to pay is reached,
         * the fleet stops launching instances even if it hasn’t met the target capacity.
         * </p>
         * 
         * @param onDemandMaxTotalPrice
         *        The maximum amount per hour for On-Demand Instances that you're willing to pay. You can use the
         *        <code>onDemandMaxTotalPrice</code> parameter, the <code>spotMaxTotalPrice</code> parameter, or both
         *        parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per
         *        hour for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances
         *        until it reaches the maximum amount you're willing to pay. When the maximum amount you're willing to
         *        pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandMaxTotalPrice(String onDemandMaxTotalPrice);

        /**
         * <p>
         * The maximum amount per hour for Spot Instances that you're willing to pay. You can use the
         * <code>spotdMaxTotalPrice</code> parameter, the <code>onDemandMaxTotalPrice</code> parameter, or both
         * parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour
         * for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it
         * reaches the maximum amount you're willing to pay. When the maximum amount you're willing to pay is reached,
         * the fleet stops launching instances even if it hasn’t met the target capacity.
         * </p>
         * 
         * @param spotMaxTotalPrice
         *        The maximum amount per hour for Spot Instances that you're willing to pay. You can use the
         *        <code>spotdMaxTotalPrice</code> parameter, the <code>onDemandMaxTotalPrice</code> parameter, or both
         *        parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per
         *        hour for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances
         *        until it reaches the maximum amount you're willing to pay. When the maximum amount you're willing to
         *        pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotMaxTotalPrice(String spotMaxTotalPrice);

        /**
         * <p>
         * Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.
         * </p>
         * 
         * @param terminateInstancesWithExpiration
         *        Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration);

        /**
         * <p>
         * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to
         * maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It
         * does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in
         * alternative Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet
         * maintains the target capacity. The Spot Fleet places the required requests to meet capacity and automatically
         * replenishes any interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is
         * not used by Spot Fleet.
         * </p>
         * 
         * @param type
         *        The type of request. Indicates whether the Spot Fleet only requests the target capacity or also
         *        attempts to maintain it. When this value is <code>request</code>, the Spot Fleet only places the
         *        required requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does
         *        it submit requests in alternative Spot pools if capacity is not available. When this value is
         *        <code>maintain</code>, the Spot Fleet maintains the target capacity. The Spot Fleet places the
         *        required requests to meet capacity and automatically replenishes any interrupted instances. Default:
         *        <code>maintain</code>. <code>instant</code> is listed but is not used by Spot Fleet.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to
         * maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It
         * does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in
         * alternative Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet
         * maintains the target capacity. The Spot Fleet places the required requests to meet capacity and automatically
         * replenishes any interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is
         * not used by Spot Fleet.
         * </p>
         * 
         * @param type
         *        The type of request. Indicates whether the Spot Fleet only requests the target capacity or also
         *        attempts to maintain it. When this value is <code>request</code>, the Spot Fleet only places the
         *        required requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does
         *        it submit requests in alternative Spot pools if capacity is not available. When this value is
         *        <code>maintain</code>, the Spot Fleet maintains the target capacity. The Spot Fleet places the
         *        required requests to meet capacity and automatically replenishes any interrupted instances. Default:
         *        <code>maintain</code>. <code>instant</code> is listed but is not used by Spot Fleet.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(FleetType type);

        /**
         * <p>
         * The start date and time of the request, in UTC format
         * (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). By default, Amazon EC2 starts fulfilling
         * the request immediately.
         * </p>
         * 
         * @param validFrom
         *        The start date and time of the request, in UTC format
         *        (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). By default, Amazon EC2 starts
         *        fulfilling the request immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validFrom(Instant validFrom);

        /**
         * <p>
         * The end date and time of the request, in UTC format
         * (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). After the end date and time, no new Spot
         * Instance requests are placed or able to fulfill the request. If no value is specified, the Spot Fleet request
         * remains until you cancel it.
         * </p>
         * 
         * @param validUntil
         *        The end date and time of the request, in UTC format
         *        (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). After the end date and time, no new
         *        Spot Instance requests are placed or able to fulfill the request. If no value is specified, the Spot
         *        Fleet request remains until you cancel it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);

        /**
         * <p>
         * Indicates whether Spot Fleet should replace unhealthy instances.
         * </p>
         * 
         * @param replaceUnhealthyInstances
         *        Indicates whether Spot Fleet should replace unhealthy instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * @see InstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(String instanceInterruptionBehavior);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * @see InstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior);

        /**
         * <p>
         * One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet
         * registers the running Spot Instances with the specified Classic Load Balancers and target groups.
         * </p>
         * <p>
         * With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1,
         * CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
         * </p>
         * 
         * @param loadBalancersConfig
         *        One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet
         *        registers the running Spot Instances with the specified Classic Load Balancers and target groups.</p>
         *        <p>
         *        With Network Load Balancers, Spot Fleet cannot register instances that have the following instance
         *        types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancersConfig(LoadBalancersConfig loadBalancersConfig);

        /**
         * <p>
         * One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet
         * registers the running Spot Instances with the specified Classic Load Balancers and target groups.
         * </p>
         * <p>
         * With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1,
         * CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoadBalancersConfig.Builder} avoiding the
         * need to create one manually via {@link LoadBalancersConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoadBalancersConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #loadBalancersConfig(LoadBalancersConfig)}.
         * 
         * @param loadBalancersConfig
         *        a consumer that will call methods on {@link LoadBalancersConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancersConfig(LoadBalancersConfig)
         */
        default Builder loadBalancersConfig(Consumer<LoadBalancersConfig.Builder> loadBalancersConfig) {
            return loadBalancersConfig(LoadBalancersConfig.builder().applyMutation(loadBalancersConfig).build());
        }

        /**
         * <p>
         * The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
         * <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot pools and
         * evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         * </p>
         * <p>
         * Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a best
         * effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, Spot Fleet will
         * continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity
         * is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if
         * most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the
         * number of pools that you specified.
         * </p>
         * 
         * @param instancePoolsToUseCount
         *        The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
         *        <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot
         *        pools and evenly allocates your target Spot capacity across the number of Spot pools that you
         *        specify.</p>
         *        <p>
         *        Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a
         *        best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, Spot
         *        Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that
         *        your target capacity is met, you might receive Spot Instances from more than the number of pools that
         *        you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full
         *        target capacity from fewer than the number of pools that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePoolsToUseCount(Integer instancePoolsToUseCount);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param context
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * The unit for the target capacity. <code>TargetCapacityUnitType</code> can only be specified when
         * <code>InstanceRequirements</code> is specified.
         * </p>
         * <p>
         * Default: <code>units</code> (translates to number of instances)
         * </p>
         * 
         * @param targetCapacityUnitType
         *        The unit for the target capacity. <code>TargetCapacityUnitType</code> can only be specified when
         *        <code>InstanceRequirements</code> is specified.</p>
         *        <p>
         *        Default: <code>units</code> (translates to number of instances)
         * @see TargetCapacityUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCapacityUnitType
         */
        Builder targetCapacityUnitType(String targetCapacityUnitType);

        /**
         * <p>
         * The unit for the target capacity. <code>TargetCapacityUnitType</code> can only be specified when
         * <code>InstanceRequirements</code> is specified.
         * </p>
         * <p>
         * Default: <code>units</code> (translates to number of instances)
         * </p>
         * 
         * @param targetCapacityUnitType
         *        The unit for the target capacity. <code>TargetCapacityUnitType</code> can only be specified when
         *        <code>InstanceRequirements</code> is specified.</p>
         *        <p>
         *        Default: <code>units</code> (translates to number of instances)
         * @see TargetCapacityUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCapacityUnitType
         */
        Builder targetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType);

        /**
         * <p>
         * The key-value pair for tagging the Spot Fleet request on creation. The value for <code>ResourceType</code>
         * must be <code>spot-fleet-request</code>, otherwise the Spot Fleet request fails. To tag instances at launch,
         * specify the tags in the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         * >launch template</a> (valid only if you use <code>LaunchTemplateConfigs</code>) or in the
         * <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">SpotFleetTagSpecification</a> </code>
         * (valid only if you use <code>LaunchSpecifications</code>). For information about tagging after launch, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         * Resources</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The key-value pair for tagging the Spot Fleet request on creation. The value for
         *        <code>ResourceType</code> must be <code>spot-fleet-request</code>, otherwise the Spot Fleet request
         *        fails. To tag instances at launch, specify the tags in the <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         *        >launch template</a> (valid only if you use <code>LaunchTemplateConfigs</code>) or in the
         *        <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">SpotFleetTagSpecification</a> </code>
         *        (valid only if you use <code>LaunchSpecifications</code>). For information about tagging after launch,
         *        see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The key-value pair for tagging the Spot Fleet request on creation. The value for <code>ResourceType</code>
         * must be <code>spot-fleet-request</code>, otherwise the Spot Fleet request fails. To tag instances at launch,
         * specify the tags in the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         * >launch template</a> (valid only if you use <code>LaunchTemplateConfigs</code>) or in the
         * <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">SpotFleetTagSpecification</a> </code>
         * (valid only if you use <code>LaunchSpecifications</code>). For information about tagging after launch, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         * Resources</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The key-value pair for tagging the Spot Fleet request on creation. The value for
         *        <code>ResourceType</code> must be <code>spot-fleet-request</code>, otherwise the Spot Fleet request
         *        fails. To tag instances at launch, specify the tags in the <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         *        >launch template</a> (valid only if you use <code>LaunchTemplateConfigs</code>) or in the
         *        <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">SpotFleetTagSpecification</a> </code>
         *        (valid only if you use <code>LaunchSpecifications</code>). For information about tagging after launch,
         *        see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The key-value pair for tagging the Spot Fleet request on creation. The value for <code>ResourceType</code>
         * must be <code>spot-fleet-request</code>, otherwise the Spot Fleet request fails. To tag instances at launch,
         * specify the tags in the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template"
         * >launch template</a> (valid only if you use <code>LaunchTemplateConfigs</code>) or in the
         * <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">SpotFleetTagSpecification</a> </code>
         * (valid only if you use <code>LaunchSpecifications</code>). For information about tagging after launch, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your
         * Resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);
    }

    static final class BuilderImpl implements Builder {
        private String allocationStrategy;

        private String onDemandAllocationStrategy;

        private SpotMaintenanceStrategies spotMaintenanceStrategies;

        private String clientToken;

        private String excessCapacityTerminationPolicy;

        private Double fulfilledCapacity;

        private Double onDemandFulfilledCapacity;

        private String iamFleetRole;

        private List<SpotFleetLaunchSpecification> launchSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateConfig> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();

        private String spotPrice;

        private Integer targetCapacity;

        private Integer onDemandTargetCapacity;

        private String onDemandMaxTotalPrice;

        private String spotMaxTotalPrice;

        private Boolean terminateInstancesWithExpiration;

        private String type;

        private Instant validFrom;

        private Instant validUntil;

        private Boolean replaceUnhealthyInstances;

        private String instanceInterruptionBehavior;

        private LoadBalancersConfig loadBalancersConfig;

        private Integer instancePoolsToUseCount;

        private String context;

        private String targetCapacityUnitType;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfigData model) {
            allocationStrategy(model.allocationStrategy);
            onDemandAllocationStrategy(model.onDemandAllocationStrategy);
            spotMaintenanceStrategies(model.spotMaintenanceStrategies);
            clientToken(model.clientToken);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            fulfilledCapacity(model.fulfilledCapacity);
            onDemandFulfilledCapacity(model.onDemandFulfilledCapacity);
            iamFleetRole(model.iamFleetRole);
            launchSpecifications(model.launchSpecifications);
            launchTemplateConfigs(model.launchTemplateConfigs);
            spotPrice(model.spotPrice);
            targetCapacity(model.targetCapacity);
            onDemandTargetCapacity(model.onDemandTargetCapacity);
            onDemandMaxTotalPrice(model.onDemandMaxTotalPrice);
            spotMaxTotalPrice(model.spotMaxTotalPrice);
            terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            type(model.type);
            validFrom(model.validFrom);
            validUntil(model.validUntil);
            replaceUnhealthyInstances(model.replaceUnhealthyInstances);
            instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            loadBalancersConfig(model.loadBalancersConfig);
            instancePoolsToUseCount(model.instancePoolsToUseCount);
            context(model.context);
            targetCapacityUnitType(model.targetCapacityUnitType);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final String getOnDemandAllocationStrategy() {
            return onDemandAllocationStrategy;
        }

        public final void setOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
        }

        @Override
        public final Builder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
            return this;
        }

        @Override
        public final Builder onDemandAllocationStrategy(OnDemandAllocationStrategy onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy(onDemandAllocationStrategy == null ? null : onDemandAllocationStrategy.toString());
            return this;
        }

        public final SpotMaintenanceStrategies.Builder getSpotMaintenanceStrategies() {
            return spotMaintenanceStrategies != null ? spotMaintenanceStrategies.toBuilder() : null;
        }

        public final void setSpotMaintenanceStrategies(SpotMaintenanceStrategies.BuilderImpl spotMaintenanceStrategies) {
            this.spotMaintenanceStrategies = spotMaintenanceStrategies != null ? spotMaintenanceStrategies.build() : null;
        }

        @Override
        public final Builder spotMaintenanceStrategies(SpotMaintenanceStrategies spotMaintenanceStrategies) {
            this.spotMaintenanceStrategies = spotMaintenanceStrategies;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return excessCapacityTerminationPolicy;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy
                    .toString());
            return this;
        }

        public final Double getFulfilledCapacity() {
            return fulfilledCapacity;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final Double getOnDemandFulfilledCapacity() {
            return onDemandFulfilledCapacity;
        }

        public final void setOnDemandFulfilledCapacity(Double onDemandFulfilledCapacity) {
            this.onDemandFulfilledCapacity = onDemandFulfilledCapacity;
        }

        @Override
        public final Builder onDemandFulfilledCapacity(Double onDemandFulfilledCapacity) {
            this.onDemandFulfilledCapacity = onDemandFulfilledCapacity;
            return this;
        }

        public final String getIamFleetRole() {
            return iamFleetRole;
        }

        public final void setIamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
        }

        @Override
        public final Builder iamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
            return this;
        }

        public final List<SpotFleetLaunchSpecification.Builder> getLaunchSpecifications() {
            List<SpotFleetLaunchSpecification.Builder> result = LaunchSpecsListCopier.copyToBuilder(this.launchSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification.BuilderImpl> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copyFromBuilder(launchSpecifications);
        }

        @Override
        public final Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copy(launchSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(SpotFleetLaunchSpecification... launchSpecifications) {
            launchSpecifications(Arrays.asList(launchSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(Consumer<SpotFleetLaunchSpecification.Builder>... launchSpecifications) {
            launchSpecifications(Stream.of(launchSpecifications)
                    .map(c -> SpotFleetLaunchSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LaunchTemplateConfig.Builder> getLaunchTemplateConfigs() {
            List<LaunchTemplateConfig.Builder> result = LaunchTemplateConfigListCopier.copyToBuilder(this.launchTemplateConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchTemplateConfigs(Collection<LaunchTemplateConfig.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copyFromBuilder(launchTemplateConfigs);
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(LaunchTemplateConfig... launchTemplateConfigs) {
            launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder>... launchTemplateConfigs) {
            launchTemplateConfigs(Stream.of(launchTemplateConfigs)
                    .map(c -> LaunchTemplateConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final Integer getTargetCapacity() {
            return targetCapacity;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final Integer getOnDemandTargetCapacity() {
            return onDemandTargetCapacity;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        @Override
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final String getOnDemandMaxTotalPrice() {
            return onDemandMaxTotalPrice;
        }

        public final void setOnDemandMaxTotalPrice(String onDemandMaxTotalPrice) {
            this.onDemandMaxTotalPrice = onDemandMaxTotalPrice;
        }

        @Override
        public final Builder onDemandMaxTotalPrice(String onDemandMaxTotalPrice) {
            this.onDemandMaxTotalPrice = onDemandMaxTotalPrice;
            return this;
        }

        public final String getSpotMaxTotalPrice() {
            return spotMaxTotalPrice;
        }

        public final void setSpotMaxTotalPrice(String spotMaxTotalPrice) {
            this.spotMaxTotalPrice = spotMaxTotalPrice;
        }

        @Override
        public final Builder spotMaxTotalPrice(String spotMaxTotalPrice) {
            this.spotMaxTotalPrice = spotMaxTotalPrice;
            return this;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return terminateInstancesWithExpiration;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getValidFrom() {
            return validFrom;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return replaceUnhealthyInstances;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final String getInstanceInterruptionBehavior() {
            return instanceInterruptionBehavior;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior == null ? null : instanceInterruptionBehavior
                    .toString());
            return this;
        }

        public final LoadBalancersConfig.Builder getLoadBalancersConfig() {
            return loadBalancersConfig != null ? loadBalancersConfig.toBuilder() : null;
        }

        public final void setLoadBalancersConfig(LoadBalancersConfig.BuilderImpl loadBalancersConfig) {
            this.loadBalancersConfig = loadBalancersConfig != null ? loadBalancersConfig.build() : null;
        }

        @Override
        public final Builder loadBalancersConfig(LoadBalancersConfig loadBalancersConfig) {
            this.loadBalancersConfig = loadBalancersConfig;
            return this;
        }

        public final Integer getInstancePoolsToUseCount() {
            return instancePoolsToUseCount;
        }

        public final void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
        }

        @Override
        public final Builder instancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getTargetCapacityUnitType() {
            return targetCapacityUnitType;
        }

        public final void setTargetCapacityUnitType(String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
        }

        @Override
        public final Builder targetCapacityUnitType(String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
            return this;
        }

        @Override
        public final Builder targetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType) {
            this.targetCapacityUnitType(targetCapacityUnitType == null ? null : targetCapacityUnitType.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SpotFleetRequestConfigData build() {
            return new SpotFleetRequestConfigData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
