/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFastLaunchResponse extends Ec2Response implements
        ToCopyableBuilder<EnableFastLaunchResponse.Builder, EnableFastLaunchResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(EnableFastLaunchResponse::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(EnableFastLaunchResponse::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<FastLaunchSnapshotConfigurationResponse> SNAPSHOT_CONFIGURATION_FIELD = SdkField
            .<FastLaunchSnapshotConfigurationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("SnapshotConfiguration")
            .getter(getter(EnableFastLaunchResponse::snapshotConfiguration))
            .setter(setter(Builder::snapshotConfiguration))
            .constructor(FastLaunchSnapshotConfigurationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotConfiguration")
                    .unmarshallLocationName("snapshotConfiguration").build()).build();

    private static final SdkField<FastLaunchLaunchTemplateSpecificationResponse> LAUNCH_TEMPLATE_FIELD = SdkField
            .<FastLaunchLaunchTemplateSpecificationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplate")
            .getter(getter(EnableFastLaunchResponse::launchTemplate))
            .setter(setter(Builder::launchTemplate))
            .constructor(FastLaunchLaunchTemplateSpecificationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate")
                    .unmarshallLocationName("launchTemplate").build()).build();

    private static final SdkField<Integer> MAX_PARALLEL_LAUNCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxParallelLaunches")
            .getter(getter(EnableFastLaunchResponse::maxParallelLaunches))
            .setter(setter(Builder::maxParallelLaunches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxParallelLaunches")
                    .unmarshallLocationName("maxParallelLaunches").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(EnableFastLaunchResponse::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(EnableFastLaunchResponse::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateTransitionReason")
            .getter(getter(EnableFastLaunchResponse::stateTransitionReason))
            .setter(setter(Builder::stateTransitionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason")
                    .unmarshallLocationName("stateTransitionReason").build()).build();

    private static final SdkField<Instant> STATE_TRANSITION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StateTransitionTime")
            .getter(getter(EnableFastLaunchResponse::stateTransitionTime))
            .setter(setter(Builder::stateTransitionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionTime")
                    .unmarshallLocationName("stateTransitionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD,
            RESOURCE_TYPE_FIELD, SNAPSHOT_CONFIGURATION_FIELD, LAUNCH_TEMPLATE_FIELD, MAX_PARALLEL_LAUNCHES_FIELD,
            OWNER_ID_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, STATE_TRANSITION_TIME_FIELD));

    private final String imageId;

    private final String resourceType;

    private final FastLaunchSnapshotConfigurationResponse snapshotConfiguration;

    private final FastLaunchLaunchTemplateSpecificationResponse launchTemplate;

    private final Integer maxParallelLaunches;

    private final String ownerId;

    private final String state;

    private final String stateTransitionReason;

    private final Instant stateTransitionTime;

    private EnableFastLaunchResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.resourceType = builder.resourceType;
        this.snapshotConfiguration = builder.snapshotConfiguration;
        this.launchTemplate = builder.launchTemplate;
        this.maxParallelLaunches = builder.maxParallelLaunches;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.stateTransitionTime = builder.stateTransitionTime;
    }

    /**
     * <p>
     * The image ID that identifies the Windows AMI for which faster launching was enabled.
     * </p>
     * 
     * @return The image ID that identifies the Windows AMI for which faster launching was enabled.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The type of resource that was defined for pre-provisioning the Windows AMI for faster launching.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link FastLaunchResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that was defined for pre-provisioning the Windows AMI for faster launching.
     * @see FastLaunchResourceType
     */
    public final FastLaunchResourceType resourceType() {
        return FastLaunchResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource that was defined for pre-provisioning the Windows AMI for faster launching.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link FastLaunchResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that was defined for pre-provisioning the Windows AMI for faster launching.
     * @see FastLaunchResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The configuration settings that were defined for creating and managing the pre-provisioned snapshots for faster
     * launching of the Windows AMI. This property is returned when the associated <code>resourceType</code> is
     * <code>snapshot</code>.
     * </p>
     * 
     * @return The configuration settings that were defined for creating and managing the pre-provisioned snapshots for
     *         faster launching of the Windows AMI. This property is returned when the associated
     *         <code>resourceType</code> is <code>snapshot</code>.
     */
    public final FastLaunchSnapshotConfigurationResponse snapshotConfiguration() {
        return snapshotConfiguration;
    }

    /**
     * <p>
     * The launch template that is used when launching Windows instances from pre-provisioned snapshots.
     * </p>
     * 
     * @return The launch template that is used when launching Windows instances from pre-provisioned snapshots.
     */
    public final FastLaunchLaunchTemplateSpecificationResponse launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * The maximum number of parallel instances to launch for creating resources.
     * </p>
     * 
     * @return The maximum number of parallel instances to launch for creating resources.
     */
    public final Integer maxParallelLaunches() {
        return maxParallelLaunches;
    }

    /**
     * <p>
     * The owner ID for the Windows AMI for which faster launching was enabled.
     * </p>
     * 
     * @return The owner ID for the Windows AMI for which faster launching was enabled.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The current state of faster launching for the specified Windows AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FastLaunchStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of faster launching for the specified Windows AMI.
     * @see FastLaunchStateCode
     */
    public final FastLaunchStateCode state() {
        return FastLaunchStateCode.fromValue(state);
    }

    /**
     * <p>
     * The current state of faster launching for the specified Windows AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FastLaunchStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of faster launching for the specified Windows AMI.
     * @see FastLaunchStateCode
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason that the state changed for faster launching for the Windows AMI.
     * </p>
     * 
     * @return The reason that the state changed for faster launching for the Windows AMI.
     */
    public final String stateTransitionReason() {
        return stateTransitionReason;
    }

    /**
     * <p>
     * The time that the state changed for faster launching for the Windows AMI.
     * </p>
     * 
     * @return The time that the state changed for faster launching for the Windows AMI.
     */
    public final Instant stateTransitionTime() {
        return stateTransitionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(maxParallelLaunches());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastLaunchResponse)) {
            return false;
        }
        EnableFastLaunchResponse other = (EnableFastLaunchResponse) obj;
        return Objects.equals(imageId(), other.imageId()) && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(snapshotConfiguration(), other.snapshotConfiguration())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(maxParallelLaunches(), other.maxParallelLaunches())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateTransitionReason(), other.stateTransitionReason())
                && Objects.equals(stateTransitionTime(), other.stateTransitionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableFastLaunchResponse").add("ImageId", imageId()).add("ResourceType", resourceTypeAsString())
                .add("SnapshotConfiguration", snapshotConfiguration()).add("LaunchTemplate", launchTemplate())
                .add("MaxParallelLaunches", maxParallelLaunches()).add("OwnerId", ownerId()).add("State", stateAsString())
                .add("StateTransitionReason", stateTransitionReason()).add("StateTransitionTime", stateTransitionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "SnapshotConfiguration":
            return Optional.ofNullable(clazz.cast(snapshotConfiguration()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "MaxParallelLaunches":
            return Optional.ofNullable(clazz.cast(maxParallelLaunches()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateTransitionReason":
            return Optional.ofNullable(clazz.cast(stateTransitionReason()));
        case "StateTransitionTime":
            return Optional.ofNullable(clazz.cast(stateTransitionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastLaunchResponse, T> g) {
        return obj -> g.apply((EnableFastLaunchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, EnableFastLaunchResponse> {
        /**
         * <p>
         * The image ID that identifies the Windows AMI for which faster launching was enabled.
         * </p>
         * 
         * @param imageId
         *        The image ID that identifies the Windows AMI for which faster launching was enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The type of resource that was defined for pre-provisioning the Windows AMI for faster launching.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that was defined for pre-provisioning the Windows AMI for faster launching.
         * @see FastLaunchResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FastLaunchResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource that was defined for pre-provisioning the Windows AMI for faster launching.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that was defined for pre-provisioning the Windows AMI for faster launching.
         * @see FastLaunchResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FastLaunchResourceType
         */
        Builder resourceType(FastLaunchResourceType resourceType);

        /**
         * <p>
         * The configuration settings that were defined for creating and managing the pre-provisioned snapshots for
         * faster launching of the Windows AMI. This property is returned when the associated <code>resourceType</code>
         * is <code>snapshot</code>.
         * </p>
         * 
         * @param snapshotConfiguration
         *        The configuration settings that were defined for creating and managing the pre-provisioned snapshots
         *        for faster launching of the Windows AMI. This property is returned when the associated
         *        <code>resourceType</code> is <code>snapshot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotConfiguration(FastLaunchSnapshotConfigurationResponse snapshotConfiguration);

        /**
         * <p>
         * The configuration settings that were defined for creating and managing the pre-provisioned snapshots for
         * faster launching of the Windows AMI. This property is returned when the associated <code>resourceType</code>
         * is <code>snapshot</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FastLaunchSnapshotConfigurationResponse.Builder} avoiding the need to create one manually via
         * {@link FastLaunchSnapshotConfigurationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FastLaunchSnapshotConfigurationResponse.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #snapshotConfiguration(FastLaunchSnapshotConfigurationResponse)}.
         * 
         * @param snapshotConfiguration
         *        a consumer that will call methods on {@link FastLaunchSnapshotConfigurationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotConfiguration(FastLaunchSnapshotConfigurationResponse)
         */
        default Builder snapshotConfiguration(Consumer<FastLaunchSnapshotConfigurationResponse.Builder> snapshotConfiguration) {
            return snapshotConfiguration(FastLaunchSnapshotConfigurationResponse.builder().applyMutation(snapshotConfiguration)
                    .build());
        }

        /**
         * <p>
         * The launch template that is used when launching Windows instances from pre-provisioned snapshots.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template that is used when launching Windows instances from pre-provisioned snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(FastLaunchLaunchTemplateSpecificationResponse launchTemplate);

        /**
         * <p>
         * The launch template that is used when launching Windows instances from pre-provisioned snapshots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FastLaunchLaunchTemplateSpecificationResponse.Builder} avoiding the need to create one manually via
         * {@link FastLaunchLaunchTemplateSpecificationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FastLaunchLaunchTemplateSpecificationResponse.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #launchTemplate(FastLaunchLaunchTemplateSpecificationResponse)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link FastLaunchLaunchTemplateSpecificationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(FastLaunchLaunchTemplateSpecificationResponse)
         */
        default Builder launchTemplate(Consumer<FastLaunchLaunchTemplateSpecificationResponse.Builder> launchTemplate) {
            return launchTemplate(FastLaunchLaunchTemplateSpecificationResponse.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The maximum number of parallel instances to launch for creating resources.
         * </p>
         * 
         * @param maxParallelLaunches
         *        The maximum number of parallel instances to launch for creating resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParallelLaunches(Integer maxParallelLaunches);

        /**
         * <p>
         * The owner ID for the Windows AMI for which faster launching was enabled.
         * </p>
         * 
         * @param ownerId
         *        The owner ID for the Windows AMI for which faster launching was enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The current state of faster launching for the specified Windows AMI.
         * </p>
         * 
         * @param state
         *        The current state of faster launching for the specified Windows AMI.
         * @see FastLaunchStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FastLaunchStateCode
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of faster launching for the specified Windows AMI.
         * </p>
         * 
         * @param state
         *        The current state of faster launching for the specified Windows AMI.
         * @see FastLaunchStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FastLaunchStateCode
         */
        Builder state(FastLaunchStateCode state);

        /**
         * <p>
         * The reason that the state changed for faster launching for the Windows AMI.
         * </p>
         * 
         * @param stateTransitionReason
         *        The reason that the state changed for faster launching for the Windows AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);

        /**
         * <p>
         * The time that the state changed for faster launching for the Windows AMI.
         * </p>
         * 
         * @param stateTransitionTime
         *        The time that the state changed for faster launching for the Windows AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionTime(Instant stateTransitionTime);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String imageId;

        private String resourceType;

        private FastLaunchSnapshotConfigurationResponse snapshotConfiguration;

        private FastLaunchLaunchTemplateSpecificationResponse launchTemplate;

        private Integer maxParallelLaunches;

        private String ownerId;

        private String state;

        private String stateTransitionReason;

        private Instant stateTransitionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastLaunchResponse model) {
            super(model);
            imageId(model.imageId);
            resourceType(model.resourceType);
            snapshotConfiguration(model.snapshotConfiguration);
            launchTemplate(model.launchTemplate);
            maxParallelLaunches(model.maxParallelLaunches);
            ownerId(model.ownerId);
            state(model.state);
            stateTransitionReason(model.stateTransitionReason);
            stateTransitionTime(model.stateTransitionTime);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FastLaunchResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final FastLaunchSnapshotConfigurationResponse.Builder getSnapshotConfiguration() {
            return snapshotConfiguration != null ? snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(FastLaunchSnapshotConfigurationResponse.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotConfiguration(FastLaunchSnapshotConfigurationResponse snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        public final FastLaunchLaunchTemplateSpecificationResponse.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(FastLaunchLaunchTemplateSpecificationResponse.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(FastLaunchLaunchTemplateSpecificationResponse launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Integer getMaxParallelLaunches() {
            return maxParallelLaunches;
        }

        public final void setMaxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
        }

        @Override
        public final Builder maxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FastLaunchStateCode state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final Instant getStateTransitionTime() {
            return stateTransitionTime;
        }

        public final void setStateTransitionTime(Instant stateTransitionTime) {
            this.stateTransitionTime = stateTransitionTime;
        }

        @Override
        public final Builder stateTransitionTime(Instant stateTransitionTime) {
            this.stateTransitionTime = stateTransitionTime;
            return this;
        }

        @Override
        public EnableFastLaunchResponse build() {
            return new EnableFastLaunchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
