/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIpamPoolAllocationsResponse extends Ec2Response implements
        ToCopyableBuilder<GetIpamPoolAllocationsResponse.Builder, GetIpamPoolAllocationsResponse> {
    private static final SdkField<List<IpamPoolAllocation>> IPAM_POOL_ALLOCATIONS_FIELD = SdkField
            .<List<IpamPoolAllocation>> builder(MarshallingType.LIST)
            .memberName("IpamPoolAllocations")
            .getter(getter(GetIpamPoolAllocationsResponse::ipamPoolAllocations))
            .setter(setter(Builder::ipamPoolAllocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolAllocationSet")
                    .unmarshallLocationName("ipamPoolAllocationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamPoolAllocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamPoolAllocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetIpamPoolAllocationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_ALLOCATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<IpamPoolAllocation> ipamPoolAllocations;

    private final String nextToken;

    private GetIpamPoolAllocationsResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPoolAllocations = builder.ipamPoolAllocations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpamPoolAllocations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpamPoolAllocations() {
        return ipamPoolAllocations != null && !(ipamPoolAllocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPAM pool allocations you want information on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpamPoolAllocations} method.
     * </p>
     * 
     * @return The IPAM pool allocations you want information on.
     */
    public final List<IpamPoolAllocation> ipamPoolAllocations() {
        return ipamPoolAllocations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpamPoolAllocations() ? ipamPoolAllocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamPoolAllocationsResponse)) {
            return false;
        }
        GetIpamPoolAllocationsResponse other = (GetIpamPoolAllocationsResponse) obj;
        return hasIpamPoolAllocations() == other.hasIpamPoolAllocations()
                && Objects.equals(ipamPoolAllocations(), other.ipamPoolAllocations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIpamPoolAllocationsResponse")
                .add("IpamPoolAllocations", hasIpamPoolAllocations() ? ipamPoolAllocations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPoolAllocations":
            return Optional.ofNullable(clazz.cast(ipamPoolAllocations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIpamPoolAllocationsResponse, T> g) {
        return obj -> g.apply((GetIpamPoolAllocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetIpamPoolAllocationsResponse> {
        /**
         * <p>
         * The IPAM pool allocations you want information on.
         * </p>
         * 
         * @param ipamPoolAllocations
         *        The IPAM pool allocations you want information on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolAllocations(Collection<IpamPoolAllocation> ipamPoolAllocations);

        /**
         * <p>
         * The IPAM pool allocations you want information on.
         * </p>
         * 
         * @param ipamPoolAllocations
         *        The IPAM pool allocations you want information on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolAllocations(IpamPoolAllocation... ipamPoolAllocations);

        /**
         * <p>
         * The IPAM pool allocations you want information on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamPoolAllocation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.IpamPoolAllocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamPoolAllocation.Builder#build()} is called immediately
         * and its result is passed to {@link #ipamPoolAllocations(List<IpamPoolAllocation>)}.
         * 
         * @param ipamPoolAllocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamPoolAllocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPoolAllocations(java.util.Collection<IpamPoolAllocation>)
         */
        Builder ipamPoolAllocations(Consumer<IpamPoolAllocation.Builder>... ipamPoolAllocations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<IpamPoolAllocation> ipamPoolAllocations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamPoolAllocationsResponse model) {
            super(model);
            ipamPoolAllocations(model.ipamPoolAllocations);
            nextToken(model.nextToken);
        }

        public final List<IpamPoolAllocation.Builder> getIpamPoolAllocations() {
            List<IpamPoolAllocation.Builder> result = IpamPoolAllocationSetCopier.copyToBuilder(this.ipamPoolAllocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamPoolAllocations(Collection<IpamPoolAllocation.BuilderImpl> ipamPoolAllocations) {
            this.ipamPoolAllocations = IpamPoolAllocationSetCopier.copyFromBuilder(ipamPoolAllocations);
        }

        @Override
        public final Builder ipamPoolAllocations(Collection<IpamPoolAllocation> ipamPoolAllocations) {
            this.ipamPoolAllocations = IpamPoolAllocationSetCopier.copy(ipamPoolAllocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPoolAllocations(IpamPoolAllocation... ipamPoolAllocations) {
            ipamPoolAllocations(Arrays.asList(ipamPoolAllocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPoolAllocations(Consumer<IpamPoolAllocation.Builder>... ipamPoolAllocations) {
            ipamPoolAllocations(Stream.of(ipamPoolAllocations).map(c -> IpamPoolAllocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamPoolAllocationsResponse build() {
            return new GetIpamPoolAllocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
