/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Ipv4PrefixListCopier {
    static List<Ipv4PrefixSpecificationRequest> copy(Collection<? extends Ipv4PrefixSpecificationRequest> ipv4PrefixListParam) {
        List<Ipv4PrefixSpecificationRequest> list;
        if (ipv4PrefixListParam == null || ipv4PrefixListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ipv4PrefixSpecificationRequest> modifiableList = new ArrayList<>();
            ipv4PrefixListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ipv4PrefixSpecificationRequest> copyFromBuilder(
            Collection<? extends Ipv4PrefixSpecificationRequest.Builder> ipv4PrefixListParam) {
        List<Ipv4PrefixSpecificationRequest> list;
        if (ipv4PrefixListParam == null || ipv4PrefixListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ipv4PrefixSpecificationRequest> modifiableList = new ArrayList<>();
            ipv4PrefixListParam.forEach(entry -> {
                Ipv4PrefixSpecificationRequest member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ipv4PrefixSpecificationRequest.Builder> copyToBuilder(
            Collection<? extends Ipv4PrefixSpecificationRequest> ipv4PrefixListParam) {
        List<Ipv4PrefixSpecificationRequest.Builder> list;
        if (ipv4PrefixListParam == null || ipv4PrefixListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ipv4PrefixSpecificationRequest.Builder> modifiableList = new ArrayList<>();
            ipv4PrefixListParam.forEach(entry -> {
                Ipv4PrefixSpecificationRequest.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
