/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVerifiedAccessGroupsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVerifiedAccessGroupsResponse.Builder, DescribeVerifiedAccessGroupsResponse> {
    private static final SdkField<List<VerifiedAccessGroup>> VERIFIED_ACCESS_GROUPS_FIELD = SdkField
            .<List<VerifiedAccessGroup>> builder(MarshallingType.LIST)
            .memberName("VerifiedAccessGroups")
            .getter(getter(DescribeVerifiedAccessGroupsResponse::verifiedAccessGroups))
            .setter(setter(Builder::verifiedAccessGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupSet")
                    .unmarshallLocationName("verifiedAccessGroupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VerifiedAccessGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(VerifiedAccessGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVerifiedAccessGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<VerifiedAccessGroup> verifiedAccessGroups;

    private final String nextToken;

    private DescribeVerifiedAccessGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessGroups = builder.verifiedAccessGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VerifiedAccessGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVerifiedAccessGroups() {
        return verifiedAccessGroups != null && !(verifiedAccessGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Verified Access group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVerifiedAccessGroups} method.
     * </p>
     * 
     * @return The ID of the Verified Access group.
     */
    public final List<VerifiedAccessGroup> verifiedAccessGroups() {
        return verifiedAccessGroups;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVerifiedAccessGroups() ? verifiedAccessGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedAccessGroupsResponse)) {
            return false;
        }
        DescribeVerifiedAccessGroupsResponse other = (DescribeVerifiedAccessGroupsResponse) obj;
        return hasVerifiedAccessGroups() == other.hasVerifiedAccessGroups()
                && Objects.equals(verifiedAccessGroups(), other.verifiedAccessGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVerifiedAccessGroupsResponse")
                .add("VerifiedAccessGroups", hasVerifiedAccessGroups() ? verifiedAccessGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessGroups":
            return Optional.ofNullable(clazz.cast(verifiedAccessGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedAccessGroupsResponse, T> g) {
        return obj -> g.apply((DescribeVerifiedAccessGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVerifiedAccessGroupsResponse> {
        /**
         * <p>
         * The ID of the Verified Access group.
         * </p>
         * 
         * @param verifiedAccessGroups
         *        The ID of the Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessGroups(Collection<VerifiedAccessGroup> verifiedAccessGroups);

        /**
         * <p>
         * The ID of the Verified Access group.
         * </p>
         * 
         * @param verifiedAccessGroups
         *        The ID of the Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessGroups(VerifiedAccessGroup... verifiedAccessGroups);

        /**
         * <p>
         * The ID of the Verified Access group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #verifiedAccessGroups(List<VerifiedAccessGroup>)}.
         * 
         * @param verifiedAccessGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifiedAccessGroups(java.util.Collection<VerifiedAccessGroup>)
         */
        Builder verifiedAccessGroups(Consumer<VerifiedAccessGroup.Builder>... verifiedAccessGroups);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VerifiedAccessGroup> verifiedAccessGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedAccessGroupsResponse model) {
            super(model);
            verifiedAccessGroups(model.verifiedAccessGroups);
            nextToken(model.nextToken);
        }

        public final List<VerifiedAccessGroup.Builder> getVerifiedAccessGroups() {
            List<VerifiedAccessGroup.Builder> result = VerifiedAccessGroupListCopier.copyToBuilder(this.verifiedAccessGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerifiedAccessGroups(Collection<VerifiedAccessGroup.BuilderImpl> verifiedAccessGroups) {
            this.verifiedAccessGroups = VerifiedAccessGroupListCopier.copyFromBuilder(verifiedAccessGroups);
        }

        @Override
        public final Builder verifiedAccessGroups(Collection<VerifiedAccessGroup> verifiedAccessGroups) {
            this.verifiedAccessGroups = VerifiedAccessGroupListCopier.copy(verifiedAccessGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessGroups(VerifiedAccessGroup... verifiedAccessGroups) {
            verifiedAccessGroups(Arrays.asList(verifiedAccessGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessGroups(Consumer<VerifiedAccessGroup.Builder>... verifiedAccessGroups) {
            verifiedAccessGroups(Stream.of(verifiedAccessGroups).map(c -> VerifiedAccessGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVerifiedAccessGroupsResponse build() {
            return new DescribeVerifiedAccessGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
