/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkInterfaceRequest extends Ec2Request implements
        ToCopyableBuilder<CreateNetworkInterfaceRequest.Builder, CreateNetworkInterfaceRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateNetworkInterfaceRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(CreateNetworkInterfaceRequest::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount")
            .getter(getter(CreateNetworkInterfaceRequest::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount")
                    .unmarshallLocationName("ipv6AddressCount").build()).build();

    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<InstanceIpv6Address>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(CreateNetworkInterfaceRequest::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses")
                    .unmarshallLocationName("ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceIpv6Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceIpv6Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(CreateNetworkInterfaceRequest::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIpAddressSpecification>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(CreateNetworkInterfaceRequest::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses")
                    .unmarshallLocationName("privateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PrivateIpAddressSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIpAddressSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(CreateNetworkInterfaceRequest::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .unmarshallLocationName("secondaryPrivateIpAddressCount").build()).build();

    private static final SdkField<List<Ipv4PrefixSpecificationRequest>> IPV4_PREFIXES_FIELD = SdkField
            .<List<Ipv4PrefixSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(CreateNetworkInterfaceRequest::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix")
                    .unmarshallLocationName("Ipv4Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv4PrefixSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv4PrefixSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4PrefixCount")
            .getter(getter(CreateNetworkInterfaceRequest::ipv4PrefixCount))
            .setter(setter(Builder::ipv4PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount")
                    .unmarshallLocationName("Ipv4PrefixCount").build()).build();

    private static final SdkField<List<Ipv6PrefixSpecificationRequest>> IPV6_PREFIXES_FIELD = SdkField
            .<List<Ipv6PrefixSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("Ipv6Prefixes")
            .getter(getter(CreateNetworkInterfaceRequest::ipv6Prefixes))
            .setter(setter(Builder::ipv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix")
                    .unmarshallLocationName("Ipv6Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6PrefixSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6PrefixSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6PrefixCount")
            .getter(getter(CreateNetworkInterfaceRequest::ipv6PrefixCount))
            .setter(setter(Builder::ipv6PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount")
                    .unmarshallLocationName("Ipv6PrefixCount").build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType")
            .getter(getter(CreateNetworkInterfaceRequest::interfaceTypeAsString))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType")
                    .unmarshallLocationName("InterfaceType").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(CreateNetworkInterfaceRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateNetworkInterfaceRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateNetworkInterfaceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> ENABLE_PRIMARY_IPV6_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePrimaryIpv6")
            .getter(getter(CreateNetworkInterfaceRequest::enablePrimaryIpv6))
            .setter(setter(Builder::enablePrimaryIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrimaryIpv6")
                    .unmarshallLocationName("EnablePrimaryIpv6").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            GROUPS_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD,
            SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, IPV4_PREFIXES_FIELD, IPV4_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD,
            IPV6_PREFIX_COUNT_FIELD, INTERFACE_TYPE_FIELD, SUBNET_ID_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD,
            ENABLE_PRIMARY_IPV6_FIELD));

    private final String description;

    private final List<String> groups;

    private final Integer ipv6AddressCount;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final String privateIpAddress;

    private final List<PrivateIpAddressSpecification> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes;

    private final Integer ipv4PrefixCount;

    private final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes;

    private final Integer ipv6PrefixCount;

    private final String interfaceType;

    private final String subnetId;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private final Boolean enablePrimaryIpv6;

    private CreateNetworkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
        this.interfaceType = builder.interfaceType;
        this.subnetId = builder.subnetId;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.enablePrimaryIpv6 = builder.enablePrimaryIpv6;
    }

    /**
     * <p>
     * A description for the network interface.
     * </p>
     * 
     * @return A description for the network interface.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The IDs of one or more security groups.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
     * addresses from the subnet range.
     * </p>
     * <p>
     * You can't specify a count of IPv6 addresses using this parameter if you've specified one of the following:
     * specific IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
     * </p>
     * <p>
     * If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set, you can override that setting by
     * specifying 0 as the IPv6 address count.
     * </p>
     * 
     * @return The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
     *         addresses from the subnet range.</p>
     *         <p>
     *         You can't specify a count of IPv6 addresses using this parameter if you've specified one of the
     *         following: specific IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
     *         </p>
     *         <p>
     *         If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set, you can override that
     *         setting by specifying 0 as the IPv6 address count.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses from the IPv6 CIDR block range of your subnet.
     * </p>
     * <p>
     * You can't specify IPv6 addresses using this parameter if you've specified one of the following: a count of IPv6
     * addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return The IPv6 addresses from the IPv6 CIDR block range of your subnet.</p>
     *         <p>
     *         You can't specify IPv6 addresses using this parameter if you've specified one of the following: a count
     *         of IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
     */
    public final List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2
     * selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP
     * addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated as
     * primary).
     * </p>
     * 
     * @return The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon
     *         EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot
     *         indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address
     *         can be designated as primary).
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private IPv4 addresses.
     * </p>
     * <p>
     * You can't specify private IPv4 addresses if you've specified one of the following: a count of private IPv4
     * addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return The private IPv4 addresses.</p>
     *         <p>
     *         You can't specify private IPv4 addresses if you've specified one of the following: a count of private
     *         IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
     */
    public final List<PrivateIpAddressSpecification> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of
     * secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't
     * specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.
     * </p>
     * <p>
     * You can't specify a count of private IPv4 addresses if you've specified one of the following: specific private
     * IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
     * </p>
     * 
     * @return The number of secondary private IPv4 addresses to assign to a network interface. When you specify a
     *         number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR
     *         range. You can't specify this option and specify more than one private IP address using
     *         <code>privateIpAddresses</code>.</p>
     *         <p>
     *         You can't specify a count of private IPv4 addresses if you've specified one of the following: specific
     *         private IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
     */
    public final Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 prefixes assigned to the network interface.
     * </p>
     * <p>
     * You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific
     * private IPv4 addresses, or a count of private IPv4 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4Prefixes} method.
     * </p>
     * 
     * @return The IPv4 prefixes assigned to the network interface.</p>
     *         <p>
     *         You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes,
     *         specific private IPv4 addresses, or a count of private IPv4 addresses.
     */
    public final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * <p>
     * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface.
     * </p>
     * <p>
     * You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4 prefixes,
     * specific private IPv4 addresses, or a count of private IPv4 addresses.
     * </p>
     * 
     * @return The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface.</p>
     *         <p>
     *         You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4
     *         prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
     */
    public final Integer ipv4PrefixCount() {
        return ipv4PrefixCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Prefixes() {
        return ipv6Prefixes != null && !(ipv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 prefixes assigned to the network interface.
     * </p>
     * <p>
     * You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific IPv6
     * addresses, or a count of IPv6 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Prefixes} method.
     * </p>
     * 
     * @return The IPv6 prefixes assigned to the network interface.</p>
     *         <p>
     *         You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes,
     *         specific IPv6 addresses, or a count of IPv6 addresses.
     */
    public final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes() {
        return ipv6Prefixes;
    }

    /**
     * <p>
     * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface.
     * </p>
     * <p>
     * You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6 prefixes,
     * specific IPv6 addresses, or a count of IPv6 addresses.
     * </p>
     * 
     * @return The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface.</p>
     *         <p>
     *         You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6
     *         prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
     */
    public final Integer ipv6PrefixCount() {
        return ipv6PrefixCount;
    }

    /**
     * <p>
     * The type of network interface. The default is <code>interface</code>.
     * </p>
     * <p>
     * The only supported values are <code>interface</code>, <code>efa</code>, and <code>trunk</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link NetworkInterfaceCreationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of network interface. The default is <code>interface</code>.</p>
     *         <p>
     *         The only supported values are <code>interface</code>, <code>efa</code>, and <code>trunk</code>.
     * @see NetworkInterfaceCreationType
     */
    public final NetworkInterfaceCreationType interfaceType() {
        return NetworkInterfaceCreationType.fromValue(interfaceType);
    }

    /**
     * <p>
     * The type of network interface. The default is <code>interface</code>.
     * </p>
     * <p>
     * The only supported values are <code>interface</code>, <code>efa</code>, and <code>trunk</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link NetworkInterfaceCreationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of network interface. The default is <code>interface</code>.</p>
     *         <p>
     *         The only supported values are <code>interface</code>, <code>efa</code>, and <code>trunk</code>.
     * @see NetworkInterfaceCreationType
     */
    public final String interfaceTypeAsString() {
        return interfaceType;
    }

    /**
     * <p>
     * The ID of the subnet to associate with the network interface.
     * </p>
     * 
     * @return The ID of the subnet to associate with the network interface.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the new network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the new network interface.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * If you’re creating a network interface in a dual-stack or IPv6-only subnet, you have the option to assign a
     * primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI that you have
     * enabled to use a primary IPv6 address. Use this option if the instance that this ENI will be attached to relies
     * on its IPv6 address not changing. Amazon Web Services will automatically assign an IPv6 address associated with
     * the ENI attached to your instance to be the primary IPv6 address. Once you enable an IPv6 GUA address to be a
     * primary IPv6, you cannot disable it. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA
     * will be made the primary IPv6 address until the instance is terminated or the network interface is detached. If
     * you have multiple IPv6 addresses associated with an ENI attached to your instance and you enable a primary IPv6
     * address, the first IPv6 GUA address associated with the ENI becomes the primary IPv6 address.
     * </p>
     * 
     * @return If you’re creating a network interface in a dual-stack or IPv6-only subnet, you have the option to assign
     *         a primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI that you
     *         have enabled to use a primary IPv6 address. Use this option if the instance that this ENI will be
     *         attached to relies on its IPv6 address not changing. Amazon Web Services will automatically assign an
     *         IPv6 address associated with the ENI attached to your instance to be the primary IPv6 address. Once you
     *         enable an IPv6 GUA address to be a primary IPv6, you cannot disable it. When you enable an IPv6 GUA
     *         address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance
     *         is terminated or the network interface is detached. If you have multiple IPv6 addresses associated with
     *         an ENI attached to your instance and you enable a primary IPv6 address, the first IPv6 GUA address
     *         associated with the ENI becomes the primary IPv6 address.
     */
    public final Boolean enablePrimaryIpv6() {
        return enablePrimaryIpv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Prefixes() ? ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(enablePrimaryIpv6());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfaceRequest)) {
            return false;
        }
        CreateNetworkInterfaceRequest other = (CreateNetworkInterfaceRequest) obj;
        return Objects.equals(description(), other.description()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount())
                && hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount())
                && hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && Objects.equals(ipv4PrefixCount(), other.ipv4PrefixCount()) && hasIpv6Prefixes() == other.hasIpv6Prefixes()
                && Objects.equals(ipv6Prefixes(), other.ipv6Prefixes())
                && Objects.equals(ipv6PrefixCount(), other.ipv6PrefixCount())
                && Objects.equals(interfaceTypeAsString(), other.interfaceTypeAsString())
                && Objects.equals(subnetId(), other.subnetId()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(enablePrimaryIpv6(), other.enablePrimaryIpv6());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkInterfaceRequest").add("Description", description())
                .add("Groups", hasGroups() ? groups() : null).add("Ipv6AddressCount", ipv6AddressCount())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount())
                .add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null).add("Ipv4PrefixCount", ipv4PrefixCount())
                .add("Ipv6Prefixes", hasIpv6Prefixes() ? ipv6Prefixes() : null).add("Ipv6PrefixCount", ipv6PrefixCount())
                .add("InterfaceType", interfaceTypeAsString()).add("SubnetId", subnetId())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("ClientToken", clientToken())
                .add("EnablePrimaryIpv6", enablePrimaryIpv6()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "Ipv4PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv4PrefixCount()));
        case "Ipv6Prefixes":
            return Optional.ofNullable(clazz.cast(ipv6Prefixes()));
        case "Ipv6PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv6PrefixCount()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceTypeAsString()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "EnablePrimaryIpv6":
            return Optional.ofNullable(clazz.cast(enablePrimaryIpv6()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInterfaceRequest, T> g) {
        return obj -> g.apply((CreateNetworkInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkInterfaceRequest> {
        /**
         * <p>
         * A description for the network interface.
         * </p>
         * 
         * @param description
         *        A description for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
         * addresses from the subnet range.
         * </p>
         * <p>
         * You can't specify a count of IPv6 addresses using this parameter if you've specified one of the following:
         * specific IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
         * </p>
         * <p>
         * If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set, you can override that setting
         * by specifying 0 as the IPv6 address count.
         * </p>
         * 
         * @param ipv6AddressCount
         *        The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the
         *        IPv6 addresses from the subnet range.</p>
         *        <p>
         *        You can't specify a count of IPv6 addresses using this parameter if you've specified one of the
         *        following: specific IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
         *        </p>
         *        <p>
         *        If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set, you can override that
         *        setting by specifying 0 as the IPv6 address count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * The IPv6 addresses from the IPv6 CIDR block range of your subnet.
         * </p>
         * <p>
         * You can't specify IPv6 addresses using this parameter if you've specified one of the following: a count of
         * IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses from the IPv6 CIDR block range of your subnet.</p>
         *        <p>
         *        You can't specify IPv6 addresses using this parameter if you've specified one of the following: a
         *        count of IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses from the IPv6 CIDR block range of your subnet.
         * </p>
         * <p>
         * You can't specify IPv6 addresses using this parameter if you've specified one of the following: a count of
         * IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses from the IPv6 CIDR block range of your subnet.</p>
         *        <p>
         *        You can't specify IPv6 addresses using this parameter if you've specified one of the following: a
         *        count of IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses from the IPv6 CIDR block range of your subnet.
         * </p>
         * <p>
         * You can't specify IPv6 addresses using this parameter if you've specified one of the following: a count of
         * IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceIpv6Address.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.InstanceIpv6Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceIpv6Address.Builder#build()} is called immediately
         * and its result is passed to {@link #ipv6Addresses(List<InstanceIpv6Address>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceIpv6Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(java.util.Collection<InstanceIpv6Address>)
         */
        Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses);

        /**
         * <p>
         * The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2
         * selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any
         * IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated
         * as primary).
         * </p>
         * 
         * @param privateIpAddress
         *        The primary private IPv4 address of the network interface. If you don't specify an IPv4 address,
         *        Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you
         *        cannot indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP
         *        address can be designated as primary).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The private IPv4 addresses.
         * </p>
         * <p>
         * You can't specify private IPv4 addresses if you've specified one of the following: a count of private IPv4
         * addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses.</p>
         *        <p>
         *        You can't specify private IPv4 addresses if you've specified one of the following: a count of private
         *        IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses.
         * </p>
         * <p>
         * You can't specify private IPv4 addresses if you've specified one of the following: a count of private IPv4
         * addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses.</p>
         *        <p>
         *        You can't specify private IPv4 addresses if you've specified one of the following: a count of private
         *        IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses.
         * </p>
         * <p>
         * You can't specify private IPv4 addresses if you've specified one of the following: a count of private IPv4
         * addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<PrivateIpAddressSpecification>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(java.util.Collection<PrivateIpAddressSpecification>)
         */
        Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses);

        /**
         * <p>
         * The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of
         * secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You
         * can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.
         * </p>
         * <p>
         * You can't specify a count of private IPv4 addresses if you've specified one of the following: specific
         * private IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary private IPv4 addresses to assign to a network interface. When you specify a
         *        number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4
         *        CIDR range. You can't specify this option and specify more than one private IP address using
         *        <code>privateIpAddresses</code>.</p>
         *        <p>
         *        You can't specify a count of private IPv4 addresses if you've specified one of the following: specific
         *        private IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * The IPv4 prefixes assigned to the network interface.
         * </p>
         * <p>
         * You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific
         * private IPv4 addresses, or a count of private IPv4 addresses.
         * </p>
         * 
         * @param ipv4Prefixes
         *        The IPv4 prefixes assigned to the network interface.</p>
         *        <p>
         *        You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes,
         *        specific private IPv4 addresses, or a count of private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes);

        /**
         * <p>
         * The IPv4 prefixes assigned to the network interface.
         * </p>
         * <p>
         * You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific
         * private IPv4 addresses, or a count of private IPv4 addresses.
         * </p>
         * 
         * @param ipv4Prefixes
         *        The IPv4 prefixes assigned to the network interface.</p>
         *        <p>
         *        You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes,
         *        specific private IPv4 addresses, or a count of private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest... ipv4Prefixes);

        /**
         * <p>
         * The IPv4 prefixes assigned to the network interface.
         * </p>
         * <p>
         * You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific
         * private IPv4 addresses, or a count of private IPv4 addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv4Prefixes(List<Ipv4PrefixSpecificationRequest>)}.
         * 
         * @param ipv4Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4Prefixes(java.util.Collection<Ipv4PrefixSpecificationRequest>)
         */
        Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder>... ipv4Prefixes);

        /**
         * <p>
         * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface.
         * </p>
         * <p>
         * You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4 prefixes,
         * specific private IPv4 addresses, or a count of private IPv4 addresses.
         * </p>
         * 
         * @param ipv4PrefixCount
         *        The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network
         *        interface.</p>
         *        <p>
         *        You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4
         *        prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4PrefixCount(Integer ipv4PrefixCount);

        /**
         * <p>
         * The IPv6 prefixes assigned to the network interface.
         * </p>
         * <p>
         * You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific
         * IPv6 addresses, or a count of IPv6 addresses.
         * </p>
         * 
         * @param ipv6Prefixes
         *        The IPv6 prefixes assigned to the network interface.</p>
         *        <p>
         *        You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes,
         *        specific IPv6 addresses, or a count of IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes);

        /**
         * <p>
         * The IPv6 prefixes assigned to the network interface.
         * </p>
         * <p>
         * You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific
         * IPv6 addresses, or a count of IPv6 addresses.
         * </p>
         * 
         * @param ipv6Prefixes
         *        The IPv6 prefixes assigned to the network interface.</p>
         *        <p>
         *        You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes,
         *        specific IPv6 addresses, or a count of IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest... ipv6Prefixes);

        /**
         * <p>
         * The IPv6 prefixes assigned to the network interface.
         * </p>
         * <p>
         * You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific
         * IPv6 addresses, or a count of IPv6 addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Prefixes(List<Ipv6PrefixSpecificationRequest>)}.
         * 
         * @param ipv6Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Prefixes(java.util.Collection<Ipv6PrefixSpecificationRequest>)
         */
        Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder>... ipv6Prefixes);

        /**
         * <p>
         * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface.
         * </p>
         * <p>
         * You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6 prefixes,
         * specific IPv6 addresses, or a count of IPv6 addresses.
         * </p>
         * 
         * @param ipv6PrefixCount
         *        The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network
         *        interface.</p>
         *        <p>
         *        You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6
         *        prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6PrefixCount(Integer ipv6PrefixCount);

        /**
         * <p>
         * The type of network interface. The default is <code>interface</code>.
         * </p>
         * <p>
         * The only supported values are <code>interface</code>, <code>efa</code>, and <code>trunk</code>.
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface. The default is <code>interface</code>.</p>
         *        <p>
         *        The only supported values are <code>interface</code>, <code>efa</code>, and <code>trunk</code>.
         * @see NetworkInterfaceCreationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceCreationType
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The type of network interface. The default is <code>interface</code>.
         * </p>
         * <p>
         * The only supported values are <code>interface</code>, <code>efa</code>, and <code>trunk</code>.
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface. The default is <code>interface</code>.</p>
         *        <p>
         *        The only supported values are <code>interface</code>, <code>efa</code>, and <code>trunk</code>.
         * @see NetworkInterfaceCreationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceCreationType
         */
        Builder interfaceType(NetworkInterfaceCreationType interfaceType);

        /**
         * <p>
         * The ID of the subnet to associate with the network interface.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet to associate with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The tags to apply to the new network interface.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the new network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the new network interface.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the new network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the new network interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * If you’re creating a network interface in a dual-stack or IPv6-only subnet, you have the option to assign a
         * primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI that you have
         * enabled to use a primary IPv6 address. Use this option if the instance that this ENI will be attached to
         * relies on its IPv6 address not changing. Amazon Web Services will automatically assign an IPv6 address
         * associated with the ENI attached to your instance to be the primary IPv6 address. Once you enable an IPv6 GUA
         * address to be a primary IPv6, you cannot disable it. When you enable an IPv6 GUA address to be a primary
         * IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the
         * network interface is detached. If you have multiple IPv6 addresses associated with an ENI attached to your
         * instance and you enable a primary IPv6 address, the first IPv6 GUA address associated with the ENI becomes
         * the primary IPv6 address.
         * </p>
         * 
         * @param enablePrimaryIpv6
         *        If you’re creating a network interface in a dual-stack or IPv6-only subnet, you have the option to
         *        assign a primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI
         *        that you have enabled to use a primary IPv6 address. Use this option if the instance that this ENI
         *        will be attached to relies on its IPv6 address not changing. Amazon Web Services will automatically
         *        assign an IPv6 address associated with the ENI attached to your instance to be the primary IPv6
         *        address. Once you enable an IPv6 GUA address to be a primary IPv6, you cannot disable it. When you
         *        enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6
         *        address until the instance is terminated or the network interface is detached. If you have multiple
         *        IPv6 addresses associated with an ENI attached to your instance and you enable a primary IPv6 address,
         *        the first IPv6 GUA address associated with the ENI becomes the primary IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String description;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6AddressCount;

        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String privateIpAddress;

        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private List<Ipv4PrefixSpecificationRequest> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv4PrefixCount;

        private List<Ipv6PrefixSpecificationRequest> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6PrefixCount;

        private String interfaceType;

        private String subnetId;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private Boolean enablePrimaryIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfaceRequest model) {
            super(model);
            description(model.description);
            groups(model.groups);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            ipv4Prefixes(model.ipv4Prefixes);
            ipv4PrefixCount(model.ipv4PrefixCount);
            ipv6Prefixes(model.ipv6Prefixes);
            ipv6PrefixCount(model.ipv6PrefixCount);
            interfaceType(model.interfaceType);
            subnetId(model.subnetId);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
            enablePrimaryIpv6(model.enablePrimaryIpv6);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> InstanceIpv6Address.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressSpecification.Builder> result = PrivateIpAddressSpecificationListCopier
                    .copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> PrivateIpAddressSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final List<Ipv4PrefixSpecificationRequest.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecificationRequest.Builder> result = Ipv4PrefixListCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecificationRequest.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder>... ipv4Prefixes) {
            ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> Ipv4PrefixSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final List<Ipv6PrefixSpecificationRequest.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecificationRequest.Builder> result = Ipv6PrefixListCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecificationRequest.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest... ipv6Prefixes) {
            ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder>... ipv6Prefixes) {
            ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> Ipv6PrefixSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6PrefixCount() {
            return ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(NetworkInterfaceCreationType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getEnablePrimaryIpv6() {
            return enablePrimaryIpv6;
        }

        public final void setEnablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
        }

        @Override
        public final Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkInterfaceRequest build() {
            return new CreateNetworkInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
