/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubnetCidrReservationRequest extends Ec2Request implements
        ToCopyableBuilder<CreateSubnetCidrReservationRequest.Builder, CreateSubnetCidrReservationRequest> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(CreateSubnetCidrReservationRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(CreateSubnetCidrReservationRequest::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<String> RESERVATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservationType")
            .getter(getter(CreateSubnetCidrReservationRequest::reservationTypeAsString))
            .setter(setter(Builder::reservationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationType")
                    .unmarshallLocationName("ReservationType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateSubnetCidrReservationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateSubnetCidrReservationRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, CIDR_FIELD,
            RESERVATION_TYPE_FIELD, DESCRIPTION_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String subnetId;

    private final String cidr;

    private final String reservationType;

    private final String description;

    private final List<TagSpecification> tagSpecifications;

    private CreateSubnetCidrReservationRequest(BuilderImpl builder) {
        super(builder);
        this.subnetId = builder.subnetId;
        this.cidr = builder.cidr;
        this.reservationType = builder.reservationType;
        this.description = builder.description;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The IPv4 or IPV6 CIDR range to reserve.
     * </p>
     * 
     * @return The IPv4 or IPV6 CIDR range to reserve.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The type of reservation. The reservation type determines how the reserved IP addresses are assigned to resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>prefix</code> - Amazon Web Services assigns the reserved IP addresses to network interfaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>explicit</code> - You assign the reserved IP addresses to network interfaces.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reservationType}
     * will return {@link SubnetCidrReservationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reservationTypeAsString}.
     * </p>
     * 
     * @return The type of reservation. The reservation type determines how the reserved IP addresses are assigned to
     *         resources.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>prefix</code> - Amazon Web Services assigns the reserved IP addresses to network interfaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>explicit</code> - You assign the reserved IP addresses to network interfaces.
     *         </p>
     *         </li>
     * @see SubnetCidrReservationType
     */
    public final SubnetCidrReservationType reservationType() {
        return SubnetCidrReservationType.fromValue(reservationType);
    }

    /**
     * <p>
     * The type of reservation. The reservation type determines how the reserved IP addresses are assigned to resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>prefix</code> - Amazon Web Services assigns the reserved IP addresses to network interfaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>explicit</code> - You assign the reserved IP addresses to network interfaces.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reservationType}
     * will return {@link SubnetCidrReservationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reservationTypeAsString}.
     * </p>
     * 
     * @return The type of reservation. The reservation type determines how the reserved IP addresses are assigned to
     *         resources.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>prefix</code> - Amazon Web Services assigns the reserved IP addresses to network interfaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>explicit</code> - You assign the reserved IP addresses to network interfaces.
     *         </p>
     *         </li>
     * @see SubnetCidrReservationType
     */
    public final String reservationTypeAsString() {
        return reservationType;
    }

    /**
     * <p>
     * The description to assign to the subnet CIDR reservation.
     * </p>
     * 
     * @return The description to assign to the subnet CIDR reservation.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the subnet CIDR reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to assign to the subnet CIDR reservation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(reservationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetCidrReservationRequest)) {
            return false;
        }
        CreateSubnetCidrReservationRequest other = (CreateSubnetCidrReservationRequest) obj;
        return Objects.equals(subnetId(), other.subnetId()) && Objects.equals(cidr(), other.cidr())
                && Objects.equals(reservationTypeAsString(), other.reservationTypeAsString())
                && Objects.equals(description(), other.description()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubnetCidrReservationRequest").add("SubnetId", subnetId()).add("Cidr", cidr())
                .add("ReservationType", reservationTypeAsString()).add("Description", description())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "ReservationType":
            return Optional.ofNullable(clazz.cast(reservationTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetCidrReservationRequest, T> g) {
        return obj -> g.apply((CreateSubnetCidrReservationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubnetCidrReservationRequest> {
        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The IPv4 or IPV6 CIDR range to reserve.
         * </p>
         * 
         * @param cidr
         *        The IPv4 or IPV6 CIDR range to reserve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The type of reservation. The reservation type determines how the reserved IP addresses are assigned to
         * resources.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>prefix</code> - Amazon Web Services assigns the reserved IP addresses to network interfaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>explicit</code> - You assign the reserved IP addresses to network interfaces.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reservationType
         *        The type of reservation. The reservation type determines how the reserved IP addresses are assigned to
         *        resources.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>prefix</code> - Amazon Web Services assigns the reserved IP addresses to network interfaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>explicit</code> - You assign the reserved IP addresses to network interfaces.
         *        </p>
         *        </li>
         * @see SubnetCidrReservationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetCidrReservationType
         */
        Builder reservationType(String reservationType);

        /**
         * <p>
         * The type of reservation. The reservation type determines how the reserved IP addresses are assigned to
         * resources.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>prefix</code> - Amazon Web Services assigns the reserved IP addresses to network interfaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>explicit</code> - You assign the reserved IP addresses to network interfaces.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reservationType
         *        The type of reservation. The reservation type determines how the reserved IP addresses are assigned to
         *        resources.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>prefix</code> - Amazon Web Services assigns the reserved IP addresses to network interfaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>explicit</code> - You assign the reserved IP addresses to network interfaces.
         *        </p>
         *        </li>
         * @see SubnetCidrReservationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetCidrReservationType
         */
        Builder reservationType(SubnetCidrReservationType reservationType);

        /**
         * <p>
         * The description to assign to the subnet CIDR reservation.
         * </p>
         * 
         * @param description
         *        The description to assign to the subnet CIDR reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags to assign to the subnet CIDR reservation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the subnet CIDR reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to assign to the subnet CIDR reservation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the subnet CIDR reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to assign to the subnet CIDR reservation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String subnetId;

        private String cidr;

        private String reservationType;

        private String description;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetCidrReservationRequest model) {
            super(model);
            subnetId(model.subnetId);
            cidr(model.cidr);
            reservationType(model.reservationType);
            description(model.description);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getReservationType() {
            return reservationType;
        }

        public final void setReservationType(String reservationType) {
            this.reservationType = reservationType;
        }

        @Override
        public final Builder reservationType(String reservationType) {
            this.reservationType = reservationType;
            return this;
        }

        @Override
        public final Builder reservationType(SubnetCidrReservationType reservationType) {
            this.reservationType(reservationType == null ? null : reservationType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubnetCidrReservationRequest build() {
            return new CreateSubnetCidrReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
