/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateNatGatewayAddressRequest extends Ec2Request implements
        ToCopyableBuilder<DisassociateNatGatewayAddressRequest.Builder, DisassociateNatGatewayAddressRequest> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId")
            .getter(getter(DisassociateNatGatewayAddressRequest::natGatewayId))
            .setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId")
                    .unmarshallLocationName("NatGatewayId").build()).build();

    private static final SdkField<List<String>> ASSOCIATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociationIds")
            .getter(getter(DisassociateNatGatewayAddressRequest::associationIds))
            .setter(setter(Builder::associationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("AssociationId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_DRAIN_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxDrainDurationSeconds")
            .getter(getter(DisassociateNatGatewayAddressRequest::maxDrainDurationSeconds))
            .setter(setter(Builder::maxDrainDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDrainDurationSeconds")
                    .unmarshallLocationName("MaxDrainDurationSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD,
            ASSOCIATION_IDS_FIELD, MAX_DRAIN_DURATION_SECONDS_FIELD));

    private final String natGatewayId;

    private final List<String> associationIds;

    private final Integer maxDrainDurationSeconds;

    private DisassociateNatGatewayAddressRequest(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.associationIds = builder.associationIds;
        this.maxDrainDurationSeconds = builder.maxDrainDurationSeconds;
    }

    /**
     * <p>
     * The ID of the NAT gateway.
     * </p>
     * 
     * @return The ID of the NAT gateway.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociationIds() {
        return associationIds != null && !(associationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The association IDs of EIPs that have been associated with the NAT gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationIds} method.
     * </p>
     * 
     * @return The association IDs of EIPs that have been associated with the NAT gateway.
     */
    public final List<String> associationIds() {
        return associationIds;
    }

    /**
     * <p>
     * The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are
     * still in progress. Default value is 350 seconds.
     * </p>
     * 
     * @return The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections
     *         are still in progress. Default value is 350 seconds.
     */
    public final Integer maxDrainDurationSeconds() {
        return maxDrainDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationIds() ? associationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxDrainDurationSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateNatGatewayAddressRequest)) {
            return false;
        }
        DisassociateNatGatewayAddressRequest other = (DisassociateNatGatewayAddressRequest) obj;
        return Objects.equals(natGatewayId(), other.natGatewayId()) && hasAssociationIds() == other.hasAssociationIds()
                && Objects.equals(associationIds(), other.associationIds())
                && Objects.equals(maxDrainDurationSeconds(), other.maxDrainDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateNatGatewayAddressRequest").add("NatGatewayId", natGatewayId())
                .add("AssociationIds", hasAssociationIds() ? associationIds() : null)
                .add("MaxDrainDurationSeconds", maxDrainDurationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "AssociationIds":
            return Optional.ofNullable(clazz.cast(associationIds()));
        case "MaxDrainDurationSeconds":
            return Optional.ofNullable(clazz.cast(maxDrainDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateNatGatewayAddressRequest, T> g) {
        return obj -> g.apply((DisassociateNatGatewayAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateNatGatewayAddressRequest> {
        /**
         * <p>
         * The ID of the NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The association IDs of EIPs that have been associated with the NAT gateway.
         * </p>
         * 
         * @param associationIds
         *        The association IDs of EIPs that have been associated with the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationIds(Collection<String> associationIds);

        /**
         * <p>
         * The association IDs of EIPs that have been associated with the NAT gateway.
         * </p>
         * 
         * @param associationIds
         *        The association IDs of EIPs that have been associated with the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationIds(String... associationIds);

        /**
         * <p>
         * The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are
         * still in progress. Default value is 350 seconds.
         * </p>
         * 
         * @param maxDrainDurationSeconds
         *        The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if
         *        connections are still in progress. Default value is 350 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDrainDurationSeconds(Integer maxDrainDurationSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String natGatewayId;

        private List<String> associationIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxDrainDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateNatGatewayAddressRequest model) {
            super(model);
            natGatewayId(model.natGatewayId);
            associationIds(model.associationIds);
            maxDrainDurationSeconds(model.maxDrainDurationSeconds);
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final Collection<String> getAssociationIds() {
            if (associationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return associationIds;
        }

        public final void setAssociationIds(Collection<String> associationIds) {
            this.associationIds = EipAssociationIdListCopier.copy(associationIds);
        }

        @Override
        public final Builder associationIds(Collection<String> associationIds) {
            this.associationIds = EipAssociationIdListCopier.copy(associationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationIds(String... associationIds) {
            associationIds(Arrays.asList(associationIds));
            return this;
        }

        public final Integer getMaxDrainDurationSeconds() {
            return maxDrainDurationSeconds;
        }

        public final void setMaxDrainDurationSeconds(Integer maxDrainDurationSeconds) {
            this.maxDrainDurationSeconds = maxDrainDurationSeconds;
        }

        @Override
        public final Builder maxDrainDurationSeconds(Integer maxDrainDurationSeconds) {
            this.maxDrainDurationSeconds = maxDrainDurationSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateNatGatewayAddressRequest build() {
            return new DisassociateNatGatewayAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
