/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an AMI that is currently in the Recycle Bin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageRecycleBinInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageRecycleBinInfo.Builder, ImageRecycleBinInfo> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ImageRecycleBinInfo::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ImageRecycleBinInfo::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImageRecycleBinInfo::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Instant> RECYCLE_BIN_ENTER_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecycleBinEnterTime")
            .getter(getter(ImageRecycleBinInfo::recycleBinEnterTime))
            .setter(setter(Builder::recycleBinEnterTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinEnterTime")
                    .unmarshallLocationName("recycleBinEnterTime").build()).build();

    private static final SdkField<Instant> RECYCLE_BIN_EXIT_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecycleBinExitTime")
            .getter(getter(ImageRecycleBinInfo::recycleBinExitTime))
            .setter(setter(Builder::recycleBinExitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinExitTime")
                    .unmarshallLocationName("recycleBinExitTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, RECYCLE_BIN_ENTER_TIME_FIELD, RECYCLE_BIN_EXIT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String imageId;

    private final String name;

    private final String description;

    private final Instant recycleBinEnterTime;

    private final Instant recycleBinExitTime;

    private ImageRecycleBinInfo(BuilderImpl builder) {
        this.imageId = builder.imageId;
        this.name = builder.name;
        this.description = builder.description;
        this.recycleBinEnterTime = builder.recycleBinEnterTime;
        this.recycleBinExitTime = builder.recycleBinExitTime;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the AMI.
     * </p>
     * 
     * @return The name of the AMI.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the AMI.
     * </p>
     * 
     * @return The description of the AMI.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time when the AMI entered the Recycle Bin.
     * </p>
     * 
     * @return The date and time when the AMI entered the Recycle Bin.
     */
    public final Instant recycleBinEnterTime() {
        return recycleBinEnterTime;
    }

    /**
     * <p>
     * The date and time when the AMI is to be permanently deleted from the Recycle Bin.
     * </p>
     * 
     * @return The date and time when the AMI is to be permanently deleted from the Recycle Bin.
     */
    public final Instant recycleBinExitTime() {
        return recycleBinExitTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(recycleBinEnterTime());
        hashCode = 31 * hashCode + Objects.hashCode(recycleBinExitTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageRecycleBinInfo)) {
            return false;
        }
        ImageRecycleBinInfo other = (ImageRecycleBinInfo) obj;
        return Objects.equals(imageId(), other.imageId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(recycleBinEnterTime(), other.recycleBinEnterTime())
                && Objects.equals(recycleBinExitTime(), other.recycleBinExitTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageRecycleBinInfo").add("ImageId", imageId()).add("Name", name())
                .add("Description", description()).add("RecycleBinEnterTime", recycleBinEnterTime())
                .add("RecycleBinExitTime", recycleBinExitTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RecycleBinEnterTime":
            return Optional.ofNullable(clazz.cast(recycleBinEnterTime()));
        case "RecycleBinExitTime":
            return Optional.ofNullable(clazz.cast(recycleBinExitTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageRecycleBinInfo, T> g) {
        return obj -> g.apply((ImageRecycleBinInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageRecycleBinInfo> {
        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the AMI.
         * </p>
         * 
         * @param name
         *        The name of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the AMI.
         * </p>
         * 
         * @param description
         *        The description of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time when the AMI entered the Recycle Bin.
         * </p>
         * 
         * @param recycleBinEnterTime
         *        The date and time when the AMI entered the Recycle Bin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recycleBinEnterTime(Instant recycleBinEnterTime);

        /**
         * <p>
         * The date and time when the AMI is to be permanently deleted from the Recycle Bin.
         * </p>
         * 
         * @param recycleBinExitTime
         *        The date and time when the AMI is to be permanently deleted from the Recycle Bin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recycleBinExitTime(Instant recycleBinExitTime);
    }

    static final class BuilderImpl implements Builder {
        private String imageId;

        private String name;

        private String description;

        private Instant recycleBinEnterTime;

        private Instant recycleBinExitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageRecycleBinInfo model) {
            imageId(model.imageId);
            name(model.name);
            description(model.description);
            recycleBinEnterTime(model.recycleBinEnterTime);
            recycleBinExitTime(model.recycleBinExitTime);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getRecycleBinEnterTime() {
            return recycleBinEnterTime;
        }

        public final void setRecycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
        }

        @Override
        public final Builder recycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
            return this;
        }

        public final Instant getRecycleBinExitTime() {
            return recycleBinExitTime;
        }

        public final void setRecycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
        }

        @Override
        public final Builder recycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
            return this;
        }

        @Override
        public ImageRecycleBinInfo build() {
            return new ImageRecycleBinInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
