/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The VPN tunnel options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TunnelOption implements SdkPojo, Serializable, ToCopyableBuilder<TunnelOption.Builder, TunnelOption> {
    private static final SdkField<String> OUTSIDE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutsideIpAddress")
            .getter(getter(TunnelOption::outsideIpAddress))
            .setter(setter(Builder::outsideIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddress")
                    .unmarshallLocationName("outsideIpAddress").build()).build();

    private static final SdkField<String> TUNNEL_INSIDE_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TunnelInsideCidr")
            .getter(getter(TunnelOption::tunnelInsideCidr))
            .setter(setter(Builder::tunnelInsideCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideCidr")
                    .unmarshallLocationName("tunnelInsideCidr").build()).build();

    private static final SdkField<String> TUNNEL_INSIDE_IPV6_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TunnelInsideIpv6Cidr")
            .getter(getter(TunnelOption::tunnelInsideIpv6Cidr))
            .setter(setter(Builder::tunnelInsideIpv6Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideIpv6Cidr")
                    .unmarshallLocationName("tunnelInsideIpv6Cidr").build()).build();

    private static final SdkField<String> PRE_SHARED_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreSharedKey")
            .getter(getter(TunnelOption::preSharedKey))
            .setter(setter(Builder::preSharedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSharedKey")
                    .unmarshallLocationName("preSharedKey").build()).build();

    private static final SdkField<Integer> PHASE1_LIFETIME_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Phase1LifetimeSeconds")
            .getter(getter(TunnelOption::phase1LifetimeSeconds))
            .setter(setter(Builder::phase1LifetimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1LifetimeSeconds")
                    .unmarshallLocationName("phase1LifetimeSeconds").build()).build();

    private static final SdkField<Integer> PHASE2_LIFETIME_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Phase2LifetimeSeconds")
            .getter(getter(TunnelOption::phase2LifetimeSeconds))
            .setter(setter(Builder::phase2LifetimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2LifetimeSeconds")
                    .unmarshallLocationName("phase2LifetimeSeconds").build()).build();

    private static final SdkField<Integer> REKEY_MARGIN_TIME_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RekeyMarginTimeSeconds")
            .getter(getter(TunnelOption::rekeyMarginTimeSeconds))
            .setter(setter(Builder::rekeyMarginTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyMarginTimeSeconds")
                    .unmarshallLocationName("rekeyMarginTimeSeconds").build()).build();

    private static final SdkField<Integer> REKEY_FUZZ_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RekeyFuzzPercentage")
            .getter(getter(TunnelOption::rekeyFuzzPercentage))
            .setter(setter(Builder::rekeyFuzzPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyFuzzPercentage")
                    .unmarshallLocationName("rekeyFuzzPercentage").build()).build();

    private static final SdkField<Integer> REPLAY_WINDOW_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplayWindowSize")
            .getter(getter(TunnelOption::replayWindowSize))
            .setter(setter(Builder::replayWindowSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayWindowSize")
                    .unmarshallLocationName("replayWindowSize").build()).build();

    private static final SdkField<Integer> DPD_TIMEOUT_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DpdTimeoutSeconds")
            .getter(getter(TunnelOption::dpdTimeoutSeconds))
            .setter(setter(Builder::dpdTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpdTimeoutSeconds")
                    .unmarshallLocationName("dpdTimeoutSeconds").build()).build();

    private static final SdkField<String> DPD_TIMEOUT_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DpdTimeoutAction")
            .getter(getter(TunnelOption::dpdTimeoutAction))
            .setter(setter(Builder::dpdTimeoutAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpdTimeoutAction")
                    .unmarshallLocationName("dpdTimeoutAction").build()).build();

    private static final SdkField<List<Phase1EncryptionAlgorithmsListValue>> PHASE1_ENCRYPTION_ALGORITHMS_FIELD = SdkField
            .<List<Phase1EncryptionAlgorithmsListValue>> builder(MarshallingType.LIST)
            .memberName("Phase1EncryptionAlgorithms")
            .getter(getter(TunnelOption::phase1EncryptionAlgorithms))
            .setter(setter(Builder::phase1EncryptionAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1EncryptionAlgorithmSet")
                    .unmarshallLocationName("phase1EncryptionAlgorithmSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase1EncryptionAlgorithmsListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase1EncryptionAlgorithmsListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase2EncryptionAlgorithmsListValue>> PHASE2_ENCRYPTION_ALGORITHMS_FIELD = SdkField
            .<List<Phase2EncryptionAlgorithmsListValue>> builder(MarshallingType.LIST)
            .memberName("Phase2EncryptionAlgorithms")
            .getter(getter(TunnelOption::phase2EncryptionAlgorithms))
            .setter(setter(Builder::phase2EncryptionAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2EncryptionAlgorithmSet")
                    .unmarshallLocationName("phase2EncryptionAlgorithmSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase2EncryptionAlgorithmsListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase2EncryptionAlgorithmsListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase1IntegrityAlgorithmsListValue>> PHASE1_INTEGRITY_ALGORITHMS_FIELD = SdkField
            .<List<Phase1IntegrityAlgorithmsListValue>> builder(MarshallingType.LIST)
            .memberName("Phase1IntegrityAlgorithms")
            .getter(getter(TunnelOption::phase1IntegrityAlgorithms))
            .setter(setter(Builder::phase1IntegrityAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1IntegrityAlgorithmSet")
                    .unmarshallLocationName("phase1IntegrityAlgorithmSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase1IntegrityAlgorithmsListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase1IntegrityAlgorithmsListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase2IntegrityAlgorithmsListValue>> PHASE2_INTEGRITY_ALGORITHMS_FIELD = SdkField
            .<List<Phase2IntegrityAlgorithmsListValue>> builder(MarshallingType.LIST)
            .memberName("Phase2IntegrityAlgorithms")
            .getter(getter(TunnelOption::phase2IntegrityAlgorithms))
            .setter(setter(Builder::phase2IntegrityAlgorithms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2IntegrityAlgorithmSet")
                    .unmarshallLocationName("phase2IntegrityAlgorithmSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase2IntegrityAlgorithmsListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase2IntegrityAlgorithmsListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase1DHGroupNumbersListValue>> PHASE1_DH_GROUP_NUMBERS_FIELD = SdkField
            .<List<Phase1DHGroupNumbersListValue>> builder(MarshallingType.LIST)
            .memberName("Phase1DHGroupNumbers")
            .getter(getter(TunnelOption::phase1DHGroupNumbers))
            .setter(setter(Builder::phase1DHGroupNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1DHGroupNumberSet")
                    .unmarshallLocationName("phase1DHGroupNumberSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase1DHGroupNumbersListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase1DHGroupNumbersListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Phase2DHGroupNumbersListValue>> PHASE2_DH_GROUP_NUMBERS_FIELD = SdkField
            .<List<Phase2DHGroupNumbersListValue>> builder(MarshallingType.LIST)
            .memberName("Phase2DHGroupNumbers")
            .getter(getter(TunnelOption::phase2DHGroupNumbers))
            .setter(setter(Builder::phase2DHGroupNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2DHGroupNumberSet")
                    .unmarshallLocationName("phase2DHGroupNumberSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Phase2DHGroupNumbersListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase2DHGroupNumbersListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<IKEVersionsListValue>> IKE_VERSIONS_FIELD = SdkField
            .<List<IKEVersionsListValue>> builder(MarshallingType.LIST)
            .memberName("IkeVersions")
            .getter(getter(TunnelOption::ikeVersions))
            .setter(setter(Builder::ikeVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IkeVersionSet")
                    .unmarshallLocationName("ikeVersionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IKEVersionsListValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(IKEVersionsListValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STARTUP_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartupAction")
            .getter(getter(TunnelOption::startupAction))
            .setter(setter(Builder::startupAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupAction")
                    .unmarshallLocationName("startupAction").build()).build();

    private static final SdkField<VpnTunnelLogOptions> LOG_OPTIONS_FIELD = SdkField
            .<VpnTunnelLogOptions> builder(MarshallingType.SDK_POJO)
            .memberName("LogOptions")
            .getter(getter(TunnelOption::logOptions))
            .setter(setter(Builder::logOptions))
            .constructor(VpnTunnelLogOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogOptions")
                    .unmarshallLocationName("logOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTSIDE_IP_ADDRESS_FIELD,
            TUNNEL_INSIDE_CIDR_FIELD, TUNNEL_INSIDE_IPV6_CIDR_FIELD, PRE_SHARED_KEY_FIELD, PHASE1_LIFETIME_SECONDS_FIELD,
            PHASE2_LIFETIME_SECONDS_FIELD, REKEY_MARGIN_TIME_SECONDS_FIELD, REKEY_FUZZ_PERCENTAGE_FIELD,
            REPLAY_WINDOW_SIZE_FIELD, DPD_TIMEOUT_SECONDS_FIELD, DPD_TIMEOUT_ACTION_FIELD, PHASE1_ENCRYPTION_ALGORITHMS_FIELD,
            PHASE2_ENCRYPTION_ALGORITHMS_FIELD, PHASE1_INTEGRITY_ALGORITHMS_FIELD, PHASE2_INTEGRITY_ALGORITHMS_FIELD,
            PHASE1_DH_GROUP_NUMBERS_FIELD, PHASE2_DH_GROUP_NUMBERS_FIELD, IKE_VERSIONS_FIELD, STARTUP_ACTION_FIELD,
            LOG_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outsideIpAddress;

    private final String tunnelInsideCidr;

    private final String tunnelInsideIpv6Cidr;

    private final String preSharedKey;

    private final Integer phase1LifetimeSeconds;

    private final Integer phase2LifetimeSeconds;

    private final Integer rekeyMarginTimeSeconds;

    private final Integer rekeyFuzzPercentage;

    private final Integer replayWindowSize;

    private final Integer dpdTimeoutSeconds;

    private final String dpdTimeoutAction;

    private final List<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms;

    private final List<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms;

    private final List<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms;

    private final List<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms;

    private final List<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers;

    private final List<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers;

    private final List<IKEVersionsListValue> ikeVersions;

    private final String startupAction;

    private final VpnTunnelLogOptions logOptions;

    private TunnelOption(BuilderImpl builder) {
        this.outsideIpAddress = builder.outsideIpAddress;
        this.tunnelInsideCidr = builder.tunnelInsideCidr;
        this.tunnelInsideIpv6Cidr = builder.tunnelInsideIpv6Cidr;
        this.preSharedKey = builder.preSharedKey;
        this.phase1LifetimeSeconds = builder.phase1LifetimeSeconds;
        this.phase2LifetimeSeconds = builder.phase2LifetimeSeconds;
        this.rekeyMarginTimeSeconds = builder.rekeyMarginTimeSeconds;
        this.rekeyFuzzPercentage = builder.rekeyFuzzPercentage;
        this.replayWindowSize = builder.replayWindowSize;
        this.dpdTimeoutSeconds = builder.dpdTimeoutSeconds;
        this.dpdTimeoutAction = builder.dpdTimeoutAction;
        this.phase1EncryptionAlgorithms = builder.phase1EncryptionAlgorithms;
        this.phase2EncryptionAlgorithms = builder.phase2EncryptionAlgorithms;
        this.phase1IntegrityAlgorithms = builder.phase1IntegrityAlgorithms;
        this.phase2IntegrityAlgorithms = builder.phase2IntegrityAlgorithms;
        this.phase1DHGroupNumbers = builder.phase1DHGroupNumbers;
        this.phase2DHGroupNumbers = builder.phase2DHGroupNumbers;
        this.ikeVersions = builder.ikeVersions;
        this.startupAction = builder.startupAction;
        this.logOptions = builder.logOptions;
    }

    /**
     * <p>
     * The external IP address of the VPN tunnel.
     * </p>
     * 
     * @return The external IP address of the VPN tunnel.
     */
    public final String outsideIpAddress() {
        return outsideIpAddress;
    }

    /**
     * <p>
     * The range of inside IPv4 addresses for the tunnel.
     * </p>
     * 
     * @return The range of inside IPv4 addresses for the tunnel.
     */
    public final String tunnelInsideCidr() {
        return tunnelInsideCidr;
    }

    /**
     * <p>
     * The range of inside IPv6 addresses for the tunnel.
     * </p>
     * 
     * @return The range of inside IPv6 addresses for the tunnel.
     */
    public final String tunnelInsideIpv6Cidr() {
        return tunnelInsideIpv6Cidr;
    }

    /**
     * <p>
     * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and the customer
     * gateway.
     * </p>
     * 
     * @return The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and the
     *         customer gateway.
     */
    public final String preSharedKey() {
        return preSharedKey;
    }

    /**
     * <p>
     * The lifetime for phase 1 of the IKE negotiation, in seconds.
     * </p>
     * 
     * @return The lifetime for phase 1 of the IKE negotiation, in seconds.
     */
    public final Integer phase1LifetimeSeconds() {
        return phase1LifetimeSeconds;
    }

    /**
     * <p>
     * The lifetime for phase 2 of the IKE negotiation, in seconds.
     * </p>
     * 
     * @return The lifetime for phase 2 of the IKE negotiation, in seconds.
     */
    public final Integer phase2LifetimeSeconds() {
        return phase2LifetimeSeconds;
    }

    /**
     * <p>
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services side of
     * the VPN connection performs an IKE rekey.
     * </p>
     * 
     * @return The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services
     *         side of the VPN connection performs an IKE rekey.
     */
    public final Integer rekeyMarginTimeSeconds() {
        return rekeyMarginTimeSeconds;
    }

    /**
     * <p>
     * The percentage of the rekey window determined by <code>RekeyMarginTimeSeconds</code> during which the rekey time
     * is randomly selected.
     * </p>
     * 
     * @return The percentage of the rekey window determined by <code>RekeyMarginTimeSeconds</code> during which the
     *         rekey time is randomly selected.
     */
    public final Integer rekeyFuzzPercentage() {
        return rekeyFuzzPercentage;
    }

    /**
     * <p>
     * The number of packets in an IKE replay window.
     * </p>
     * 
     * @return The number of packets in an IKE replay window.
     */
    public final Integer replayWindowSize() {
        return replayWindowSize;
    }

    /**
     * <p>
     * The number of seconds after which a DPD timeout occurs.
     * </p>
     * 
     * @return The number of seconds after which a DPD timeout occurs.
     */
    public final Integer dpdTimeoutSeconds() {
        return dpdTimeoutSeconds;
    }

    /**
     * <p>
     * The action to take after a DPD timeout occurs.
     * </p>
     * 
     * @return The action to take after a DPD timeout occurs.
     */
    public final String dpdTimeoutAction() {
        return dpdTimeoutAction;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase1EncryptionAlgorithms property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhase1EncryptionAlgorithms() {
        return phase1EncryptionAlgorithms != null && !(phase1EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase1EncryptionAlgorithms} method.
     * </p>
     * 
     * @return The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
     */
    public final List<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms() {
        return phase1EncryptionAlgorithms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase2EncryptionAlgorithms property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhase2EncryptionAlgorithms() {
        return phase2EncryptionAlgorithms != null && !(phase2EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase2EncryptionAlgorithms} method.
     * </p>
     * 
     * @return The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
     */
    public final List<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms() {
        return phase2EncryptionAlgorithms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase1IntegrityAlgorithms property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhase1IntegrityAlgorithms() {
        return phase1IntegrityAlgorithms != null && !(phase1IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase1IntegrityAlgorithms} method.
     * </p>
     * 
     * @return The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
     */
    public final List<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms() {
        return phase1IntegrityAlgorithms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase2IntegrityAlgorithms property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhase2IntegrityAlgorithms() {
        return phase2IntegrityAlgorithms != null && !(phase2IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase2IntegrityAlgorithms} method.
     * </p>
     * 
     * @return The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
     */
    public final List<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms() {
        return phase2IntegrityAlgorithms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase1DHGroupNumbers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhase1DHGroupNumbers() {
        return phase1DHGroupNumbers != null && !(phase1DHGroupNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase1DHGroupNumbers} method.
     * </p>
     * 
     * @return The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
     */
    public final List<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers() {
        return phase1DHGroupNumbers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phase2DHGroupNumbers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhase2DHGroupNumbers() {
        return phase2DHGroupNumbers != null && !(phase2DHGroupNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhase2DHGroupNumbers} method.
     * </p>
     * 
     * @return The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
     */
    public final List<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers() {
        return phase2DHGroupNumbers;
    }

    /**
     * For responses, this returns true if the service returned a value for the IkeVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIkeVersions() {
        return ikeVersions != null && !(ikeVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IKE versions that are permitted for the VPN tunnel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIkeVersions} method.
     * </p>
     * 
     * @return The IKE versions that are permitted for the VPN tunnel.
     */
    public final List<IKEVersionsListValue> ikeVersions() {
        return ikeVersions;
    }

    /**
     * <p>
     * The action to take when the establishing the VPN tunnels for a VPN connection.
     * </p>
     * 
     * @return The action to take when the establishing the VPN tunnels for a VPN connection.
     */
    public final String startupAction() {
        return startupAction;
    }

    /**
     * <p>
     * Options for logging VPN tunnel activity.
     * </p>
     * 
     * @return Options for logging VPN tunnel activity.
     */
    public final VpnTunnelLogOptions logOptions() {
        return logOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelInsideCidr());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelInsideIpv6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(preSharedKey());
        hashCode = 31 * hashCode + Objects.hashCode(phase1LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(phase2LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(rekeyMarginTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(rekeyFuzzPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(replayWindowSize());
        hashCode = 31 * hashCode + Objects.hashCode(dpdTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(dpdTimeoutAction());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1EncryptionAlgorithms() ? phase1EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2EncryptionAlgorithms() ? phase2EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1IntegrityAlgorithms() ? phase1IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2IntegrityAlgorithms() ? phase2IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase1DHGroupNumbers() ? phase1DHGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhase2DHGroupNumbers() ? phase2DHGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIkeVersions() ? ikeVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startupAction());
        hashCode = 31 * hashCode + Objects.hashCode(logOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TunnelOption)) {
            return false;
        }
        TunnelOption other = (TunnelOption) obj;
        return Objects.equals(outsideIpAddress(), other.outsideIpAddress())
                && Objects.equals(tunnelInsideCidr(), other.tunnelInsideCidr())
                && Objects.equals(tunnelInsideIpv6Cidr(), other.tunnelInsideIpv6Cidr())
                && Objects.equals(preSharedKey(), other.preSharedKey())
                && Objects.equals(phase1LifetimeSeconds(), other.phase1LifetimeSeconds())
                && Objects.equals(phase2LifetimeSeconds(), other.phase2LifetimeSeconds())
                && Objects.equals(rekeyMarginTimeSeconds(), other.rekeyMarginTimeSeconds())
                && Objects.equals(rekeyFuzzPercentage(), other.rekeyFuzzPercentage())
                && Objects.equals(replayWindowSize(), other.replayWindowSize())
                && Objects.equals(dpdTimeoutSeconds(), other.dpdTimeoutSeconds())
                && Objects.equals(dpdTimeoutAction(), other.dpdTimeoutAction())
                && hasPhase1EncryptionAlgorithms() == other.hasPhase1EncryptionAlgorithms()
                && Objects.equals(phase1EncryptionAlgorithms(), other.phase1EncryptionAlgorithms())
                && hasPhase2EncryptionAlgorithms() == other.hasPhase2EncryptionAlgorithms()
                && Objects.equals(phase2EncryptionAlgorithms(), other.phase2EncryptionAlgorithms())
                && hasPhase1IntegrityAlgorithms() == other.hasPhase1IntegrityAlgorithms()
                && Objects.equals(phase1IntegrityAlgorithms(), other.phase1IntegrityAlgorithms())
                && hasPhase2IntegrityAlgorithms() == other.hasPhase2IntegrityAlgorithms()
                && Objects.equals(phase2IntegrityAlgorithms(), other.phase2IntegrityAlgorithms())
                && hasPhase1DHGroupNumbers() == other.hasPhase1DHGroupNumbers()
                && Objects.equals(phase1DHGroupNumbers(), other.phase1DHGroupNumbers())
                && hasPhase2DHGroupNumbers() == other.hasPhase2DHGroupNumbers()
                && Objects.equals(phase2DHGroupNumbers(), other.phase2DHGroupNumbers())
                && hasIkeVersions() == other.hasIkeVersions() && Objects.equals(ikeVersions(), other.ikeVersions())
                && Objects.equals(startupAction(), other.startupAction()) && Objects.equals(logOptions(), other.logOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TunnelOption").add("OutsideIpAddress", outsideIpAddress())
                .add("TunnelInsideCidr", tunnelInsideCidr()).add("TunnelInsideIpv6Cidr", tunnelInsideIpv6Cidr())
                .add("PreSharedKey", preSharedKey()).add("Phase1LifetimeSeconds", phase1LifetimeSeconds())
                .add("Phase2LifetimeSeconds", phase2LifetimeSeconds()).add("RekeyMarginTimeSeconds", rekeyMarginTimeSeconds())
                .add("RekeyFuzzPercentage", rekeyFuzzPercentage()).add("ReplayWindowSize", replayWindowSize())
                .add("DpdTimeoutSeconds", dpdTimeoutSeconds()).add("DpdTimeoutAction", dpdTimeoutAction())
                .add("Phase1EncryptionAlgorithms", hasPhase1EncryptionAlgorithms() ? phase1EncryptionAlgorithms() : null)
                .add("Phase2EncryptionAlgorithms", hasPhase2EncryptionAlgorithms() ? phase2EncryptionAlgorithms() : null)
                .add("Phase1IntegrityAlgorithms", hasPhase1IntegrityAlgorithms() ? phase1IntegrityAlgorithms() : null)
                .add("Phase2IntegrityAlgorithms", hasPhase2IntegrityAlgorithms() ? phase2IntegrityAlgorithms() : null)
                .add("Phase1DHGroupNumbers", hasPhase1DHGroupNumbers() ? phase1DHGroupNumbers() : null)
                .add("Phase2DHGroupNumbers", hasPhase2DHGroupNumbers() ? phase2DHGroupNumbers() : null)
                .add("IkeVersions", hasIkeVersions() ? ikeVersions() : null).add("StartupAction", startupAction())
                .add("LogOptions", logOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutsideIpAddress":
            return Optional.ofNullable(clazz.cast(outsideIpAddress()));
        case "TunnelInsideCidr":
            return Optional.ofNullable(clazz.cast(tunnelInsideCidr()));
        case "TunnelInsideIpv6Cidr":
            return Optional.ofNullable(clazz.cast(tunnelInsideIpv6Cidr()));
        case "PreSharedKey":
            return Optional.ofNullable(clazz.cast(preSharedKey()));
        case "Phase1LifetimeSeconds":
            return Optional.ofNullable(clazz.cast(phase1LifetimeSeconds()));
        case "Phase2LifetimeSeconds":
            return Optional.ofNullable(clazz.cast(phase2LifetimeSeconds()));
        case "RekeyMarginTimeSeconds":
            return Optional.ofNullable(clazz.cast(rekeyMarginTimeSeconds()));
        case "RekeyFuzzPercentage":
            return Optional.ofNullable(clazz.cast(rekeyFuzzPercentage()));
        case "ReplayWindowSize":
            return Optional.ofNullable(clazz.cast(replayWindowSize()));
        case "DpdTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(dpdTimeoutSeconds()));
        case "DpdTimeoutAction":
            return Optional.ofNullable(clazz.cast(dpdTimeoutAction()));
        case "Phase1EncryptionAlgorithms":
            return Optional.ofNullable(clazz.cast(phase1EncryptionAlgorithms()));
        case "Phase2EncryptionAlgorithms":
            return Optional.ofNullable(clazz.cast(phase2EncryptionAlgorithms()));
        case "Phase1IntegrityAlgorithms":
            return Optional.ofNullable(clazz.cast(phase1IntegrityAlgorithms()));
        case "Phase2IntegrityAlgorithms":
            return Optional.ofNullable(clazz.cast(phase2IntegrityAlgorithms()));
        case "Phase1DHGroupNumbers":
            return Optional.ofNullable(clazz.cast(phase1DHGroupNumbers()));
        case "Phase2DHGroupNumbers":
            return Optional.ofNullable(clazz.cast(phase2DHGroupNumbers()));
        case "IkeVersions":
            return Optional.ofNullable(clazz.cast(ikeVersions()));
        case "StartupAction":
            return Optional.ofNullable(clazz.cast(startupAction()));
        case "LogOptions":
            return Optional.ofNullable(clazz.cast(logOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TunnelOption, T> g) {
        return obj -> g.apply((TunnelOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TunnelOption> {
        /**
         * <p>
         * The external IP address of the VPN tunnel.
         * </p>
         * 
         * @param outsideIpAddress
         *        The external IP address of the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outsideIpAddress(String outsideIpAddress);

        /**
         * <p>
         * The range of inside IPv4 addresses for the tunnel.
         * </p>
         * 
         * @param tunnelInsideCidr
         *        The range of inside IPv4 addresses for the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelInsideCidr(String tunnelInsideCidr);

        /**
         * <p>
         * The range of inside IPv6 addresses for the tunnel.
         * </p>
         * 
         * @param tunnelInsideIpv6Cidr
         *        The range of inside IPv6 addresses for the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr);

        /**
         * <p>
         * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and the
         * customer gateway.
         * </p>
         * 
         * @param preSharedKey
         *        The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and
         *        the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSharedKey(String preSharedKey);

        /**
         * <p>
         * The lifetime for phase 1 of the IKE negotiation, in seconds.
         * </p>
         * 
         * @param phase1LifetimeSeconds
         *        The lifetime for phase 1 of the IKE negotiation, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds);

        /**
         * <p>
         * The lifetime for phase 2 of the IKE negotiation, in seconds.
         * </p>
         * 
         * @param phase2LifetimeSeconds
         *        The lifetime for phase 2 of the IKE negotiation, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds);

        /**
         * <p>
         * The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services side
         * of the VPN connection performs an IKE rekey.
         * </p>
         * 
         * @param rekeyMarginTimeSeconds
         *        The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services
         *        side of the VPN connection performs an IKE rekey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds);

        /**
         * <p>
         * The percentage of the rekey window determined by <code>RekeyMarginTimeSeconds</code> during which the rekey
         * time is randomly selected.
         * </p>
         * 
         * @param rekeyFuzzPercentage
         *        The percentage of the rekey window determined by <code>RekeyMarginTimeSeconds</code> during which the
         *        rekey time is randomly selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage);

        /**
         * <p>
         * The number of packets in an IKE replay window.
         * </p>
         * 
         * @param replayWindowSize
         *        The number of packets in an IKE replay window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayWindowSize(Integer replayWindowSize);

        /**
         * <p>
         * The number of seconds after which a DPD timeout occurs.
         * </p>
         * 
         * @param dpdTimeoutSeconds
         *        The number of seconds after which a DPD timeout occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds);

        /**
         * <p>
         * The action to take after a DPD timeout occurs.
         * </p>
         * 
         * @param dpdTimeoutAction
         *        The action to take after a DPD timeout occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpdTimeoutAction(String dpdTimeoutAction);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1EncryptionAlgorithms
         *        The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1EncryptionAlgorithms
         *        The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsListValue... phase1EncryptionAlgorithms);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #phase1EncryptionAlgorithms(List<Phase1EncryptionAlgorithmsListValue>)}.
         * 
         * @param phase1EncryptionAlgorithms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase1EncryptionAlgorithms(java.util.Collection<Phase1EncryptionAlgorithmsListValue>)
         */
        Builder phase1EncryptionAlgorithms(Consumer<Phase1EncryptionAlgorithmsListValue.Builder>... phase1EncryptionAlgorithms);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2EncryptionAlgorithms
         *        The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2EncryptionAlgorithms
         *        The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsListValue... phase2EncryptionAlgorithms);

        /**
         * <p>
         * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsListValue.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsListValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsListValue.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #phase2EncryptionAlgorithms(List<Phase2EncryptionAlgorithmsListValue>)}.
         * 
         * @param phase2EncryptionAlgorithms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsListValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase2EncryptionAlgorithms(java.util.Collection<Phase2EncryptionAlgorithmsListValue>)
         */
        Builder phase2EncryptionAlgorithms(Consumer<Phase2EncryptionAlgorithmsListValue.Builder>... phase2EncryptionAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1IntegrityAlgorithms
         *        The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1IntegrityAlgorithms
         *        The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsListValue... phase1IntegrityAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #phase1IntegrityAlgorithms(List<Phase1IntegrityAlgorithmsListValue>)}.
         * 
         * @param phase1IntegrityAlgorithms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase1IntegrityAlgorithms(java.util.Collection<Phase1IntegrityAlgorithmsListValue>)
         */
        Builder phase1IntegrityAlgorithms(Consumer<Phase1IntegrityAlgorithmsListValue.Builder>... phase1IntegrityAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2IntegrityAlgorithms
         *        The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2IntegrityAlgorithms
         *        The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsListValue... phase2IntegrityAlgorithms);

        /**
         * <p>
         * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsListValue.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsListValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsListValue.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #phase2IntegrityAlgorithms(List<Phase2IntegrityAlgorithmsListValue>)}.
         * 
         * @param phase2IntegrityAlgorithms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsListValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase2IntegrityAlgorithms(java.util.Collection<Phase2IntegrityAlgorithmsListValue>)
         */
        Builder phase2IntegrityAlgorithms(Consumer<Phase2IntegrityAlgorithmsListValue.Builder>... phase2IntegrityAlgorithms);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1DHGroupNumbers
         *        The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1DHGroupNumbers(Collection<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1DHGroupNumbers
         *        The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1DHGroupNumbers(Phase1DHGroupNumbersListValue... phase1DHGroupNumbers);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue.Builder#build()} is called
         * immediately and its result is passed to {@link #phase1DHGroupNumbers(List<Phase1DHGroupNumbersListValue>)}.
         * 
         * @param phase1DHGroupNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase1DHGroupNumbers(java.util.Collection<Phase1DHGroupNumbersListValue>)
         */
        Builder phase1DHGroupNumbers(Consumer<Phase1DHGroupNumbersListValue.Builder>... phase1DHGroupNumbers);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2DHGroupNumbers
         *        The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2DHGroupNumbers(Collection<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2DHGroupNumbers
         *        The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2DHGroupNumbers(Phase2DHGroupNumbersListValue... phase2DHGroupNumbers);

        /**
         * <p>
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue.Builder#build()} is called
         * immediately and its result is passed to {@link #phase2DHGroupNumbers(List<Phase2DHGroupNumbersListValue>)}.
         * 
         * @param phase2DHGroupNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phase2DHGroupNumbers(java.util.Collection<Phase2DHGroupNumbersListValue>)
         */
        Builder phase2DHGroupNumbers(Consumer<Phase2DHGroupNumbersListValue.Builder>... phase2DHGroupNumbers);

        /**
         * <p>
         * The IKE versions that are permitted for the VPN tunnel.
         * </p>
         * 
         * @param ikeVersions
         *        The IKE versions that are permitted for the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ikeVersions(Collection<IKEVersionsListValue> ikeVersions);

        /**
         * <p>
         * The IKE versions that are permitted for the VPN tunnel.
         * </p>
         * 
         * @param ikeVersions
         *        The IKE versions that are permitted for the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ikeVersions(IKEVersionsListValue... ikeVersions);

        /**
         * <p>
         * The IKE versions that are permitted for the VPN tunnel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IKEVersionsListValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.IKEVersionsListValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IKEVersionsListValue.Builder#build()} is called immediately
         * and its result is passed to {@link #ikeVersions(List<IKEVersionsListValue>)}.
         * 
         * @param ikeVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IKEVersionsListValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ikeVersions(java.util.Collection<IKEVersionsListValue>)
         */
        Builder ikeVersions(Consumer<IKEVersionsListValue.Builder>... ikeVersions);

        /**
         * <p>
         * The action to take when the establishing the VPN tunnels for a VPN connection.
         * </p>
         * 
         * @param startupAction
         *        The action to take when the establishing the VPN tunnels for a VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startupAction(String startupAction);

        /**
         * <p>
         * Options for logging VPN tunnel activity.
         * </p>
         * 
         * @param logOptions
         *        Options for logging VPN tunnel activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logOptions(VpnTunnelLogOptions logOptions);

        /**
         * <p>
         * Options for logging VPN tunnel activity.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpnTunnelLogOptions.Builder} avoiding the
         * need to create one manually via {@link VpnTunnelLogOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpnTunnelLogOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #logOptions(VpnTunnelLogOptions)}.
         * 
         * @param logOptions
         *        a consumer that will call methods on {@link VpnTunnelLogOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logOptions(VpnTunnelLogOptions)
         */
        default Builder logOptions(Consumer<VpnTunnelLogOptions.Builder> logOptions) {
            return logOptions(VpnTunnelLogOptions.builder().applyMutation(logOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String outsideIpAddress;

        private String tunnelInsideCidr;

        private String tunnelInsideIpv6Cidr;

        private String preSharedKey;

        private Integer phase1LifetimeSeconds;

        private Integer phase2LifetimeSeconds;

        private Integer rekeyMarginTimeSeconds;

        private Integer rekeyFuzzPercentage;

        private Integer replayWindowSize;

        private Integer dpdTimeoutSeconds;

        private String dpdTimeoutAction;

        private List<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private List<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private List<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private List<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private List<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<IKEVersionsListValue> ikeVersions = DefaultSdkAutoConstructList.getInstance();

        private String startupAction;

        private VpnTunnelLogOptions logOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TunnelOption model) {
            outsideIpAddress(model.outsideIpAddress);
            tunnelInsideCidr(model.tunnelInsideCidr);
            tunnelInsideIpv6Cidr(model.tunnelInsideIpv6Cidr);
            preSharedKey(model.preSharedKey);
            phase1LifetimeSeconds(model.phase1LifetimeSeconds);
            phase2LifetimeSeconds(model.phase2LifetimeSeconds);
            rekeyMarginTimeSeconds(model.rekeyMarginTimeSeconds);
            rekeyFuzzPercentage(model.rekeyFuzzPercentage);
            replayWindowSize(model.replayWindowSize);
            dpdTimeoutSeconds(model.dpdTimeoutSeconds);
            dpdTimeoutAction(model.dpdTimeoutAction);
            phase1EncryptionAlgorithms(model.phase1EncryptionAlgorithms);
            phase2EncryptionAlgorithms(model.phase2EncryptionAlgorithms);
            phase1IntegrityAlgorithms(model.phase1IntegrityAlgorithms);
            phase2IntegrityAlgorithms(model.phase2IntegrityAlgorithms);
            phase1DHGroupNumbers(model.phase1DHGroupNumbers);
            phase2DHGroupNumbers(model.phase2DHGroupNumbers);
            ikeVersions(model.ikeVersions);
            startupAction(model.startupAction);
            logOptions(model.logOptions);
        }

        public final String getOutsideIpAddress() {
            return outsideIpAddress;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final String getTunnelInsideCidr() {
            return tunnelInsideCidr;
        }

        public final void setTunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        @Override
        public final Builder tunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        public final String getTunnelInsideIpv6Cidr() {
            return tunnelInsideIpv6Cidr;
        }

        public final void setTunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr) {
            this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
        }

        @Override
        public final Builder tunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr) {
            this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
            return this;
        }

        public final String getPreSharedKey() {
            return preSharedKey;
        }

        public final void setPreSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
        }

        @Override
        public final Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        public final Integer getPhase1LifetimeSeconds() {
            return phase1LifetimeSeconds;
        }

        public final void setPhase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
        }

        @Override
        public final Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
            return this;
        }

        public final Integer getPhase2LifetimeSeconds() {
            return phase2LifetimeSeconds;
        }

        public final void setPhase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
        }

        @Override
        public final Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
            return this;
        }

        public final Integer getRekeyMarginTimeSeconds() {
            return rekeyMarginTimeSeconds;
        }

        public final void setRekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
        }

        @Override
        public final Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
            return this;
        }

        public final Integer getRekeyFuzzPercentage() {
            return rekeyFuzzPercentage;
        }

        public final void setRekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
        }

        @Override
        public final Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
            return this;
        }

        public final Integer getReplayWindowSize() {
            return replayWindowSize;
        }

        public final void setReplayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
        }

        @Override
        public final Builder replayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
            return this;
        }

        public final Integer getDpdTimeoutSeconds() {
            return dpdTimeoutSeconds;
        }

        public final void setDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        }

        @Override
        public final Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
            return this;
        }

        public final String getDpdTimeoutAction() {
            return dpdTimeoutAction;
        }

        public final void setDpdTimeoutAction(String dpdTimeoutAction) {
            this.dpdTimeoutAction = dpdTimeoutAction;
        }

        @Override
        public final Builder dpdTimeoutAction(String dpdTimeoutAction) {
            this.dpdTimeoutAction = dpdTimeoutAction;
            return this;
        }

        public final List<Phase1EncryptionAlgorithmsListValue.Builder> getPhase1EncryptionAlgorithms() {
            List<Phase1EncryptionAlgorithmsListValue.Builder> result = Phase1EncryptionAlgorithmsListCopier
                    .copyToBuilder(this.phase1EncryptionAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1EncryptionAlgorithms(
                Collection<Phase1EncryptionAlgorithmsListValue.BuilderImpl> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = Phase1EncryptionAlgorithmsListCopier.copyFromBuilder(phase1EncryptionAlgorithms);
        }

        @Override
        public final Builder phase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = Phase1EncryptionAlgorithmsListCopier.copy(phase1EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsListValue... phase1EncryptionAlgorithms) {
            phase1EncryptionAlgorithms(Arrays.asList(phase1EncryptionAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(
                Consumer<Phase1EncryptionAlgorithmsListValue.Builder>... phase1EncryptionAlgorithms) {
            phase1EncryptionAlgorithms(Stream.of(phase1EncryptionAlgorithms)
                    .map(c -> Phase1EncryptionAlgorithmsListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2EncryptionAlgorithmsListValue.Builder> getPhase2EncryptionAlgorithms() {
            List<Phase2EncryptionAlgorithmsListValue.Builder> result = Phase2EncryptionAlgorithmsListCopier
                    .copyToBuilder(this.phase2EncryptionAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2EncryptionAlgorithms(
                Collection<Phase2EncryptionAlgorithmsListValue.BuilderImpl> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = Phase2EncryptionAlgorithmsListCopier.copyFromBuilder(phase2EncryptionAlgorithms);
        }

        @Override
        public final Builder phase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = Phase2EncryptionAlgorithmsListCopier.copy(phase2EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsListValue... phase2EncryptionAlgorithms) {
            phase2EncryptionAlgorithms(Arrays.asList(phase2EncryptionAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(
                Consumer<Phase2EncryptionAlgorithmsListValue.Builder>... phase2EncryptionAlgorithms) {
            phase2EncryptionAlgorithms(Stream.of(phase2EncryptionAlgorithms)
                    .map(c -> Phase2EncryptionAlgorithmsListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Phase1IntegrityAlgorithmsListValue.Builder> getPhase1IntegrityAlgorithms() {
            List<Phase1IntegrityAlgorithmsListValue.Builder> result = Phase1IntegrityAlgorithmsListCopier
                    .copyToBuilder(this.phase1IntegrityAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1IntegrityAlgorithms(
                Collection<Phase1IntegrityAlgorithmsListValue.BuilderImpl> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = Phase1IntegrityAlgorithmsListCopier.copyFromBuilder(phase1IntegrityAlgorithms);
        }

        @Override
        public final Builder phase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = Phase1IntegrityAlgorithmsListCopier.copy(phase1IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsListValue... phase1IntegrityAlgorithms) {
            phase1IntegrityAlgorithms(Arrays.asList(phase1IntegrityAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(
                Consumer<Phase1IntegrityAlgorithmsListValue.Builder>... phase1IntegrityAlgorithms) {
            phase1IntegrityAlgorithms(Stream.of(phase1IntegrityAlgorithms)
                    .map(c -> Phase1IntegrityAlgorithmsListValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2IntegrityAlgorithmsListValue.Builder> getPhase2IntegrityAlgorithms() {
            List<Phase2IntegrityAlgorithmsListValue.Builder> result = Phase2IntegrityAlgorithmsListCopier
                    .copyToBuilder(this.phase2IntegrityAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2IntegrityAlgorithms(
                Collection<Phase2IntegrityAlgorithmsListValue.BuilderImpl> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = Phase2IntegrityAlgorithmsListCopier.copyFromBuilder(phase2IntegrityAlgorithms);
        }

        @Override
        public final Builder phase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = Phase2IntegrityAlgorithmsListCopier.copy(phase2IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsListValue... phase2IntegrityAlgorithms) {
            phase2IntegrityAlgorithms(Arrays.asList(phase2IntegrityAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(
                Consumer<Phase2IntegrityAlgorithmsListValue.Builder>... phase2IntegrityAlgorithms) {
            phase2IntegrityAlgorithms(Stream.of(phase2IntegrityAlgorithms)
                    .map(c -> Phase2IntegrityAlgorithmsListValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase1DHGroupNumbersListValue.Builder> getPhase1DHGroupNumbers() {
            List<Phase1DHGroupNumbersListValue.Builder> result = Phase1DHGroupNumbersListCopier
                    .copyToBuilder(this.phase1DHGroupNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1DHGroupNumbers(Collection<Phase1DHGroupNumbersListValue.BuilderImpl> phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers = Phase1DHGroupNumbersListCopier.copyFromBuilder(phase1DHGroupNumbers);
        }

        @Override
        public final Builder phase1DHGroupNumbers(Collection<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers = Phase1DHGroupNumbersListCopier.copy(phase1DHGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DHGroupNumbers(Phase1DHGroupNumbersListValue... phase1DHGroupNumbers) {
            phase1DHGroupNumbers(Arrays.asList(phase1DHGroupNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DHGroupNumbers(Consumer<Phase1DHGroupNumbersListValue.Builder>... phase1DHGroupNumbers) {
            phase1DHGroupNumbers(Stream.of(phase1DHGroupNumbers)
                    .map(c -> Phase1DHGroupNumbersListValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2DHGroupNumbersListValue.Builder> getPhase2DHGroupNumbers() {
            List<Phase2DHGroupNumbersListValue.Builder> result = Phase2DHGroupNumbersListCopier
                    .copyToBuilder(this.phase2DHGroupNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2DHGroupNumbers(Collection<Phase2DHGroupNumbersListValue.BuilderImpl> phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers = Phase2DHGroupNumbersListCopier.copyFromBuilder(phase2DHGroupNumbers);
        }

        @Override
        public final Builder phase2DHGroupNumbers(Collection<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers = Phase2DHGroupNumbersListCopier.copy(phase2DHGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DHGroupNumbers(Phase2DHGroupNumbersListValue... phase2DHGroupNumbers) {
            phase2DHGroupNumbers(Arrays.asList(phase2DHGroupNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DHGroupNumbers(Consumer<Phase2DHGroupNumbersListValue.Builder>... phase2DHGroupNumbers) {
            phase2DHGroupNumbers(Stream.of(phase2DHGroupNumbers)
                    .map(c -> Phase2DHGroupNumbersListValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IKEVersionsListValue.Builder> getIkeVersions() {
            List<IKEVersionsListValue.Builder> result = IKEVersionsListCopier.copyToBuilder(this.ikeVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIkeVersions(Collection<IKEVersionsListValue.BuilderImpl> ikeVersions) {
            this.ikeVersions = IKEVersionsListCopier.copyFromBuilder(ikeVersions);
        }

        @Override
        public final Builder ikeVersions(Collection<IKEVersionsListValue> ikeVersions) {
            this.ikeVersions = IKEVersionsListCopier.copy(ikeVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(IKEVersionsListValue... ikeVersions) {
            ikeVersions(Arrays.asList(ikeVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(Consumer<IKEVersionsListValue.Builder>... ikeVersions) {
            ikeVersions(Stream.of(ikeVersions).map(c -> IKEVersionsListValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStartupAction() {
            return startupAction;
        }

        public final void setStartupAction(String startupAction) {
            this.startupAction = startupAction;
        }

        @Override
        public final Builder startupAction(String startupAction) {
            this.startupAction = startupAction;
            return this;
        }

        public final VpnTunnelLogOptions.Builder getLogOptions() {
            return logOptions != null ? logOptions.toBuilder() : null;
        }

        public final void setLogOptions(VpnTunnelLogOptions.BuilderImpl logOptions) {
            this.logOptions = logOptions != null ? logOptions.build() : null;
        }

        @Override
        public final Builder logOptions(VpnTunnelLogOptions logOptions) {
            this.logOptions = logOptions;
            return this;
        }

        @Override
        public TunnelOption build() {
            return new TunnelOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
