/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVolumeAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVolumeAttributeRequest> {
    private static final SdkField<AttributeBooleanValue> AUTO_ENABLE_IO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoEnableIO").getter(ModifyVolumeAttributeRequest.getter(ModifyVolumeAttributeRequest::autoEnableIO)).setter(ModifyVolumeAttributeRequest.setter(Builder::autoEnableIO)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableIO").unmarshallLocationName("AutoEnableIO").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(ModifyVolumeAttributeRequest.getter(ModifyVolumeAttributeRequest::volumeId)).setter(ModifyVolumeAttributeRequest.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("VolumeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_IO_FIELD, VOLUME_ID_FIELD));
    private final AttributeBooleanValue autoEnableIO;
    private final String volumeId;

    private ModifyVolumeAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableIO = builder.autoEnableIO;
        this.volumeId = builder.volumeId;
    }

    public final AttributeBooleanValue autoEnableIO() {
        return this.autoEnableIO;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableIO());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeAttributeRequest)) {
            return false;
        }
        ModifyVolumeAttributeRequest other = (ModifyVolumeAttributeRequest)((Object)obj);
        return Objects.equals(this.autoEnableIO(), other.autoEnableIO()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVolumeAttributeRequest").add("AutoEnableIO", (Object)this.autoEnableIO()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnableIO": {
                return Optional.ofNullable(clazz.cast(this.autoEnableIO()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVolumeAttributeRequest, T> g) {
        return obj -> g.apply((ModifyVolumeAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private AttributeBooleanValue autoEnableIO;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeAttributeRequest model) {
            super(model);
            this.autoEnableIO(model.autoEnableIO);
            this.volumeId(model.volumeId);
        }

        public final AttributeBooleanValue.Builder getAutoEnableIO() {
            return this.autoEnableIO != null ? this.autoEnableIO.toBuilder() : null;
        }

        public final void setAutoEnableIO(AttributeBooleanValue.BuilderImpl autoEnableIO) {
            this.autoEnableIO = autoEnableIO != null ? autoEnableIO.build() : null;
        }

        @Override
        public final Builder autoEnableIO(AttributeBooleanValue autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVolumeAttributeRequest build() {
            return new ModifyVolumeAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVolumeAttributeRequest> {
        public Builder autoEnableIO(AttributeBooleanValue var1);

        default public Builder autoEnableIO(Consumer<AttributeBooleanValue.Builder> autoEnableIO) {
            return this.autoEnableIO((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(autoEnableIO)).build());
        }

        public Builder volumeId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

