/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportClientVpnClientConfigurationResponse extends Ec2Response implements
        ToCopyableBuilder<ExportClientVpnClientConfigurationResponse.Builder, ExportClientVpnClientConfigurationResponse> {
    private static final SdkField<String> CLIENT_CONFIGURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientConfiguration")
            .getter(getter(ExportClientVpnClientConfigurationResponse::clientConfiguration))
            .setter(setter(Builder::clientConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConfiguration")
                    .unmarshallLocationName("clientConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CONFIGURATION_FIELD));

    private final String clientConfiguration;

    private ExportClientVpnClientConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.clientConfiguration = builder.clientConfiguration;
    }

    /**
     * <p>
     * The contents of the Client VPN endpoint configuration file.
     * </p>
     * 
     * @return The contents of the Client VPN endpoint configuration file.
     */
    public final String clientConfiguration() {
        return clientConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportClientVpnClientConfigurationResponse)) {
            return false;
        }
        ExportClientVpnClientConfigurationResponse other = (ExportClientVpnClientConfigurationResponse) obj;
        return Objects.equals(clientConfiguration(), other.clientConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportClientVpnClientConfigurationResponse").add("ClientConfiguration", clientConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientConfiguration":
            return Optional.ofNullable(clazz.cast(clientConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportClientVpnClientConfigurationResponse, T> g) {
        return obj -> g.apply((ExportClientVpnClientConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportClientVpnClientConfigurationResponse> {
        /**
         * <p>
         * The contents of the Client VPN endpoint configuration file.
         * </p>
         * 
         * @param clientConfiguration
         *        The contents of the Client VPN endpoint configuration file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientConfiguration(String clientConfiguration);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String clientConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportClientVpnClientConfigurationResponse model) {
            super(model);
            clientConfiguration(model.clientConfiguration);
        }

        public final String getClientConfiguration() {
            return clientConfiguration;
        }

        public final void setClientConfiguration(String clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
        }

        @Override
        public final Builder clientConfiguration(String clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        @Override
        public ExportClientVpnClientConfigurationResponse build() {
            return new ExportClientVpnClientConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
